/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsserver.data;

import com.sun.messaging.jmq.jmsserver.Broker;
import com.sun.messaging.jmq.jmsserver.BrokerStateHandler;
import com.sun.messaging.jmq.jmsserver.Globals;
import com.sun.messaging.jmq.jmsserver.core.BrokerAddress;
import com.sun.messaging.jmq.jmsserver.data.TransactionBroker;
import com.sun.messaging.jmq.jmsserver.data.TransactionList;
import com.sun.messaging.jmq.jmsserver.data.TransactionState;
import com.sun.messaging.jmq.jmsserver.data.TransactionUID;
import com.sun.messaging.jmq.jmsserver.util.BrokerException;
import com.sun.messaging.jmq.jmsservice.BrokerEvent;
import com.sun.messaging.jmq.util.log.Logger;
import com.sun.messaging.jmq.util.timer.TimerEventHandler;
import com.sun.messaging.jmq.util.timer.WakeupableTimer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Hashtable;
import java.util.List;
import java.util.concurrent.TimeUnit;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class TransactionReaper
implements Runnable,
TimerEventHandler {
    TransactionList translist = null;
    Logger logger = Globals.getLogger();
    List<TIDEntry> committed = Collections.synchronizedList(new ArrayList());
    List<TIDEntry> noremoves = Collections.synchronizedList(new ArrayList());
    List<TIDEntry> clusterPCommitted = Collections.synchronizedList(new ArrayList());
    List<TIDEntry> remoteCommitted = Collections.synchronizedList(new ArrayList());
    List<TIDEntry> remoteRCommitted = Collections.synchronizedList(new ArrayList());
    WakeupableTimer reapTimer = null;

    public TransactionReaper(TransactionList transactionList) {
        this.translist = transactionList;
    }

    private boolean needReapOne(List list) {
        if (TransactionList.TXN_REAPLIMIT == 0) {
            return true;
        }
        int n = list.size();
        return (double)n > (double)TransactionList.TXN_REAPLIMIT * (1.0 + (double)((float)TransactionList.TXN_REAPLIMIT_OVERTHRESHOLD / 100.0f));
    }

    public void addLocalTransaction(TransactionUID transactionUID, boolean bl) {
        TIDEntry tIDEntry = new TIDEntry(transactionUID);
        if (bl) {
            this.noremoves.add(tIDEntry);
        }
        this.committed.add(tIDEntry);
        this.createTimer();
        if (this.committed.size() > TransactionList.TXN_REAPLIMIT) {
            this.reapTimer.wakeup();
        }
        if (this.needReapOne(this.committed)) {
            this.run(true);
        }
    }

    public void addClusterTransaction(TransactionUID transactionUID, boolean bl) {
        this.addClusterTransaction(transactionUID, bl, false);
    }

    public void addClusterTransaction(TransactionUID transactionUID, boolean bl, boolean bl2) {
        TIDEntry tIDEntry = null;
        tIDEntry = !bl2 ? new TIDEntry(transactionUID, ClusterPCommittedState.UNPROCCESSED) : new TIDEntry(transactionUID, ClusterPCommittedState.TAKEOVER);
        this.clusterPCommitted.add(tIDEntry);
        if (bl) {
            this.noremoves.add(tIDEntry);
        }
        this.createTimer();
        this.reapTimer.wakeup();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clusterTransactionCompleted(TransactionUID transactionUID) {
        this.createTimer();
        this.reapTimer.wakeup();
        if (!this.needReapOne(this.clusterPCommitted) && !this.needReapOne(this.committed)) {
            return;
        }
        TransactionBroker[] transactionBrokerArray = null;
        try {
            transactionBrokerArray = this.translist.getClusterTransactionBrokers(transactionUID);
        }
        catch (Exception exception) {
            this.logger.logStack(16, exception.getMessage(), (Throwable)exception);
        }
        boolean bl = true;
        if (transactionBrokerArray == null) {
            bl = false;
        } else {
            for (int i = 0; i < transactionBrokerArray.length; ++i) {
                if (transactionBrokerArray[i].isCompleted()) continue;
                bl = false;
            }
        }
        if (bl) {
            TIDEntry tIDEntry = null;
            TIDEntry tIDEntry2 = new TIDEntry(transactionUID);
            List<TIDEntry> list = this.clusterPCommitted;
            synchronized (list) {
                int n = this.clusterPCommitted.indexOf(tIDEntry2);
                if (n >= 0) {
                    tIDEntry = this.clusterPCommitted.get(n);
                }
                if (tIDEntry != null && tIDEntry.inprocessing) {
                    tIDEntry = null;
                }
                if (tIDEntry != null) {
                    tIDEntry.inprocessing = true;
                }
            }
            if (tIDEntry != null) {
                if (tIDEntry.pstate == ClusterPCommittedState.UNPROCCESSED) {
                    Globals.getConnectionManager().removeFromClientDataList("transaction", tIDEntry.tid);
                }
                tIDEntry.pstate = ClusterPCommittedState.PROCCESSED;
                this.clusterPCommitted.remove(tIDEntry);
                tIDEntry.inprocessing = false;
                this.committed.add(tIDEntry);
            }
        }
        if (this.needReapOne(this.committed)) {
            this.run(true);
        }
    }

    public void addRemoteTransaction(TransactionUID transactionUID, boolean bl) {
        TIDEntry tIDEntry = new TIDEntry(transactionUID);
        if (!bl) {
            this.remoteCommitted.add(tIDEntry);
        } else {
            this.remoteRCommitted.add(tIDEntry);
        }
        this.createTimer();
        if (this.remoteCommitted.size() > TransactionList.TXN_REAPLIMIT || this.remoteRCommitted.size() > TransactionList.TXN_REAPLIMIT) {
            this.reapTimer.wakeup();
        }
        if (this.needReapOne(this.remoteCommitted) || this.needReapOne(this.remoteRCommitted)) {
            this.run(true);
        }
    }

    public boolean hasRemoteTransaction(TransactionUID transactionUID) {
        TIDEntry tIDEntry = new TIDEntry(transactionUID);
        if (this.remoteCommitted.contains(tIDEntry)) {
            return true;
        }
        return this.remoteRCommitted.contains(tIDEntry);
    }

    public synchronized void wakeupReaperTimer() {
        if (this.reapTimer != null) {
            this.reapTimer.wakeup();
        }
    }

    private synchronized void createTimer() {
        if (this.reapTimer == null) {
            try {
                String string = Globals.getBrokerResources().getKString("B1285", TransactionList.TXN_REAPLIMIT, TransactionList.TXN_REAPINTERVAL / 1000L);
                String string2 = Globals.getBrokerResources().getKString("B1286");
                this.reapTimer = new WakeupableTimer("TransactionReaper", (Runnable)this, TransactionList.TXN_REAPINTERVAL, TransactionList.TXN_REAPINTERVAL, string, string2, (TimerEventHandler)this);
            }
            catch (Throwable throwable) {
                String string = Globals.getBrokerResources().getKString("B3278", throwable.getMessage());
                this.logger.logStack(32, string, throwable);
                Broker broker = Broker.getBroker();
                Globals.getBrokerStateHandler();
                broker.exit(BrokerStateHandler.getRestartCode(), string, BrokerEvent.Type.RESTART, throwable, false, true, false);
            }
        }
    }

    public void handleOOMError(Throwable throwable) {
        Globals.handleGlobalError(throwable, "OOM:TransactionReaper");
    }

    public void handleLogInfo(String string) {
        this.logger.log(8, string);
    }

    public void handleLogWarn(String string, Throwable throwable) {
        if (throwable == null) {
            this.logger.log(16, string);
        } else {
            this.logger.logStack(16, string, throwable);
        }
    }

    public void handleLogError(String string, Throwable throwable) {
        if (throwable == null) {
            this.logger.log(32, string);
        } else {
            this.logger.logStack(32, string, throwable);
        }
    }

    public void handleTimerExit(Throwable throwable) {
        if (BrokerStateHandler.shuttingDown || this.reapTimer == null) {
            return;
        }
        String string = Globals.getBrokerResources().getKString("B3279", throwable.getMessage());
        Broker broker = Broker.getBroker();
        Globals.getBrokerStateHandler();
        broker.exit(BrokerStateHandler.getRestartCode(), string, BrokerEvent.Type.RESTART, throwable, false, true, false);
    }

    public synchronized void destroy() {
        if (this.reapTimer != null) {
            this.reapTimer.cancel();
            this.reapTimer = null;
        }
        this.committed.clear();
        this.remoteCommitted.clear();
        this.remoteRCommitted.clear();
    }

    public Hashtable getDebugState(TransactionUID transactionUID) {
        TIDEntry tIDEntry = new TIDEntry(transactionUID);
        Hashtable<String, String> hashtable = new Hashtable<String, String>();
        if (this.committed.contains(tIDEntry)) {
            hashtable.put(transactionUID.toString(), TransactionState.toString(6));
            return hashtable;
        }
        if (this.clusterPCommitted.contains(tIDEntry)) {
            hashtable.put(transactionUID.toString() + "(cluster)", TransactionState.toString(6));
            return hashtable;
        }
        if (this.remoteCommitted.contains(tIDEntry)) {
            hashtable.put(transactionUID.toString() + "(remote)", TransactionState.toString(6));
            return hashtable;
        }
        if (this.remoteRCommitted.contains(tIDEntry)) {
            hashtable.put(transactionUID.toString() + "(remote-r)", TransactionState.toString(6));
            return hashtable;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Hashtable getDebugState() {
        Hashtable<String, Object> hashtable = new Hashtable<String, Object>();
        ArrayList<TIDEntry> arrayList = null;
        hashtable.put("committedCount", this.committed.size());
        List<TIDEntry> object2 = this.committed;
        synchronized (object2) {
            arrayList = new ArrayList<TIDEntry>(this.committed);
        }
        Object var3_4 = null;
        for (TIDEntry tIDEntry : arrayList) {
            hashtable.put(tIDEntry.tid.toString(), TransactionState.toString(6) + ":" + tIDEntry.inprocessing);
        }
        arrayList.clear();
        hashtable.put("clusterPCommittedCount", this.clusterPCommitted.size());
        List<TIDEntry> list = this.clusterPCommitted;
        synchronized (list) {
            arrayList = new ArrayList<TIDEntry>(this.clusterPCommitted);
        }
        for (TIDEntry tIDEntry : arrayList) {
            hashtable.put(tIDEntry.tid.toString() + "(cluster)", TransactionState.toString(6) + ":" + tIDEntry.inprocessing + ":" + (Object)((Object)tIDEntry.pstate));
        }
        arrayList.clear();
        hashtable.put("noremovesCount", this.noremoves.size());
        list = this.noremoves;
        synchronized (list) {
            arrayList = new ArrayList<TIDEntry>(this.noremoves);
        }
        for (TIDEntry tIDEntry : arrayList) {
            hashtable.put(tIDEntry.tid.toString(), TransactionState.toString(6));
        }
        arrayList.clear();
        hashtable.put("remoteCommittedCount", this.remoteCommitted.size());
        list = this.remoteCommitted;
        synchronized (list) {
            arrayList = new ArrayList<TIDEntry>(this.remoteCommitted);
        }
        for (TIDEntry tIDEntry : arrayList) {
            hashtable.put(tIDEntry.tid.toString() + "(remote)", TransactionState.toString(6) + ":" + tIDEntry.inprocessing);
        }
        arrayList.clear();
        hashtable.put("remoteRCommittedCount", this.remoteRCommitted.size());
        list = this.remoteRCommitted;
        synchronized (list) {
            arrayList = new ArrayList<TIDEntry>(this.remoteRCommitted);
        }
        for (TIDEntry tIDEntry : arrayList) {
            hashtable.put(tIDEntry.tid.toString() + "(remote-r)", TransactionState.toString(6) + ":" + tIDEntry.inprocessing);
        }
        arrayList.clear();
        return hashtable;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean clusterPCommittedHasUnprocessed() {
        ArrayList<TIDEntry> arrayList = null;
        List<TIDEntry> object2 = this.clusterPCommitted;
        synchronized (object2) {
            arrayList = new ArrayList<TIDEntry>(this.clusterPCommitted);
        }
        Object var2_3 = null;
        for (TIDEntry tIDEntry : arrayList) {
            if (tIDEntry.pstate != ClusterPCommittedState.UNPROCCESSED && tIDEntry.pstate != ClusterPCommittedState.TAKEOVER) continue;
            return true;
        }
        arrayList.clear();
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void clearSwipeMark(List<TIDEntry> list) {
        ArrayList<TIDEntry> arrayList = null;
        List<TIDEntry> object2 = list;
        synchronized (object2) {
            arrayList = new ArrayList<TIDEntry>(list);
        }
        Object var3_4 = null;
        for (TIDEntry tIDEntry : arrayList) {
            tIDEntry.swipemark = false;
        }
        arrayList.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private TIDEntry getNextEntry(List<TIDEntry> list, int n, boolean bl) {
        TIDEntry tIDEntry = null;
        int n2 = 0;
        int n3 = 0;
        List<TIDEntry> list2 = list;
        synchronized (list2) {
            n3 = list.size();
            while (n3 > n) {
                tIDEntry = list.get(n2++);
                if (tIDEntry.inprocessing) {
                    --n3;
                    tIDEntry = null;
                    continue;
                }
                if (!bl && (tIDEntry.swipeonly || tIDEntry.swipemark)) {
                    --n3;
                    tIDEntry = null;
                    continue;
                }
                if (bl && tIDEntry.swipemark) {
                    --n3;
                    tIDEntry = null;
                    continue;
                }
                tIDEntry.inprocessing = true;
                if (!bl) break;
                tIDEntry.swipemark = true;
                break;
            }
        }
        return tIDEntry;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void releaseNextEntry(List<TIDEntry> list, TIDEntry tIDEntry) {
        if (list == null) {
            tIDEntry.inprocessing = false;
            return;
        }
        List<TIDEntry> list2 = list;
        synchronized (list2) {
            tIDEntry.inprocessing = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        try {
            this.run(false);
            Object var2_1 = null;
            this.clearSwipeMark(this.clusterPCommitted);
            this.clearSwipeMark(this.committed);
        }
        catch (Throwable throwable) {
            Object var2_2 = null;
            this.clearSwipeMark(this.clusterPCommitted);
            this.clearSwipeMark(this.committed);
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run(boolean bl) {
        Object object;
        if (!this.translist.isLoadComplete()) {
            if (bl) {
                return;
            }
            try {
                this.logger.log(8, Globals.getBrokerResources().getString("B1327"));
                this.translist.loadCompleteLatch.await(TransactionList.TXN_REAPINTERVAL, TimeUnit.MILLISECONDS);
                if (!this.translist.isLoadComplete()) {
                    return;
                }
            }
            catch (InterruptedException interruptedException) {
                this.logger.log(16, "Transaction reaper thread is interrupted in waiting for transaction loading completion");
                return;
            }
        }
        ArrayList arrayList = null;
        if (!bl) {
            object = this.translist.newlyActivatedBrokers;
            synchronized (object) {
                arrayList = new ArrayList(this.translist.newlyActivatedBrokers);
                this.translist.newlyActivatedBrokers.clear();
            }
        }
        object = null;
        TIDEntry tIDEntry = null;
        int n = 0;
        while (this.reapTimer != null && (n <= 0 || object != null && !bl)) {
            object = null;
            ++n;
            if (!bl && (arrayList.size() > 0 || this.clusterPCommittedHasUnprocessed()) && (tIDEntry = this.getNextEntry(this.clusterPCommitted, 0, !bl)) != null) {
                object = tIDEntry;
                TransactionUID transactionUID = ((TIDEntry)object).tid;
                ClusterPCommittedState clusterPCommittedState = ((TIDEntry)object).pstate;
                if (clusterPCommittedState != null && clusterPCommittedState == ClusterPCommittedState.UNPROCCESSED) {
                    Globals.getConnectionManager().removeFromClientDataList("transaction", transactionUID);
                }
                try {
                    TransactionBroker[] transactionBrokerArray = this.translist.getClusterTransactionBrokers(transactionUID);
                    boolean bl2 = true;
                    if (transactionBrokerArray != null) {
                        BrokerAddress brokerAddress = null;
                        for (int i = 0; i < transactionBrokerArray.length; ++i) {
                            if (transactionBrokerArray[i].isCompleted()) continue;
                            bl2 = false;
                            brokerAddress = transactionBrokerArray[i].getCurrentBrokerAddress();
                            if (brokerAddress != null) {
                                if (brokerAddress.equals(Globals.getMyAddress()) && brokerAddress.equals(transactionBrokerArray[i].getBrokerAddress())) {
                                    try {
                                        this.translist.completeClusterTransactionBrokerState(transactionUID, 6, brokerAddress, true);
                                    }
                                    catch (Exception exception) {
                                        this.logger.logStack(16, "Unable to update transaction broker state for " + brokerAddress + ", TUID=" + transactionUID, (Throwable)exception);
                                    }
                                    if (!Globals.getHAEnabled()) continue;
                                }
                                if (arrayList.size() == 0 && clusterPCommittedState != null && clusterPCommittedState == ClusterPCommittedState.PROCCESSED || arrayList.size() == 0 && !brokerAddress.equals(Globals.getMyAddress()) && clusterPCommittedState != null && clusterPCommittedState != ClusterPCommittedState.TAKEOVER || arrayList.size() > 0 && !arrayList.contains((Object)brokerAddress.getMQAddress()) && !brokerAddress.equals(Globals.getMyAddress()) && clusterPCommittedState != null && clusterPCommittedState != ClusterPCommittedState.TAKEOVER) continue;
                                if (TransactionList.DEBUG_CLUSTER_TXN) {
                                    this.logger.log(8, "txnReaperThread: sendClusterTransactionInfo for TID=" + transactionUID + " to " + brokerAddress);
                                }
                                Globals.getClusterBroadcast().sendClusterTransactionInfo(transactionUID.longValue(), brokerAddress);
                                continue;
                            }
                            if (clusterPCommittedState == null || clusterPCommittedState == ClusterPCommittedState.PROCCESSED) continue;
                            this.logger.log(8, Globals.getBrokerResources().getKString("B2205", transactionUID.toString(), transactionBrokerArray[i].toString()));
                        }
                    }
                    ((TIDEntry)object).pstate = ClusterPCommittedState.PROCCESSED;
                    if (!bl2) {
                        this.releaseNextEntry(this.clusterPCommitted, (TIDEntry)object);
                    } else {
                        this.clusterPCommitted.remove(object);
                        this.releaseNextEntry(null, (TIDEntry)object);
                        this.committed.add((TIDEntry)object);
                    }
                }
                catch (Throwable throwable) {
                    this.logger.logStack(16, throwable.getMessage(), throwable);
                }
            }
            if ((tIDEntry = this.getNextEntry(this.committed, TransactionList.TXN_REAPLIMIT, !bl)) != null) {
                object = tIDEntry;
                if (TransactionList.DEBUG_CLUSTER_TXN) {
                    this.logger.log(8, "Cleaning up committed transaction " + ((TIDEntry)object).tid);
                }
                try {
                    try {
                        this.translist.reapTransactionID(((TIDEntry)object).tid, this.noremoves.contains(object));
                    }
                    catch (BrokerException brokerException) {
                        if (brokerException.getStatusCode() != 404) {
                            this.releaseNextEntry(this.committed, (TIDEntry)object);
                            ((TIDEntry)object).swipeonly = true;
                            throw brokerException;
                        }
                        this.logger.logStack(16, "Cleanup committed transaction: " + brokerException.getMessage(), (Throwable)brokerException);
                    }
                    this.committed.remove(object);
                    this.noremoves.remove(object);
                }
                catch (Exception exception) {
                    this.logger.logStack(16, "Failed to cleanup committed transaction " + ((TIDEntry)object).tid, (Throwable)exception);
                }
            }
            if ((tIDEntry = this.getNextEntry(this.remoteCommitted, TransactionList.TXN_REAPLIMIT, !bl)) != null) {
                object = tIDEntry;
                this.remoteCommitted.remove(object);
                if (TransactionList.DEBUG_CLUSTER_TXN) {
                    this.logger.log(8, "Cleaned up committed remote transaction " + ((TIDEntry)object).tid);
                }
            }
            if ((tIDEntry = this.getNextEntry(this.remoteRCommitted, TransactionList.TXN_REAPLIMIT, !bl)) == null) continue;
            object = tIDEntry;
            this.remoteRCommitted.remove(object);
            if (!TransactionList.DEBUG_CLUSTER_TXN) continue;
            this.logger.log(8, "Cleaned up committed remote transaction " + ((TIDEntry)object).tid);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum ClusterPCommittedState {
        UNPROCCESSED,
        PROCCESSED,
        TAKEOVER;

    }

    class TIDEntry {
        TransactionUID tid = null;
        boolean inprocessing = false;
        ClusterPCommittedState pstate = ClusterPCommittedState.UNPROCCESSED;
        boolean swipemark = false;
        boolean swipeonly = false;

        public TIDEntry(TransactionUID transactionUID) {
            this.tid = transactionUID;
        }

        public TIDEntry(TransactionUID transactionUID, ClusterPCommittedState clusterPCommittedState) {
            this.tid = transactionUID;
            this.pstate = clusterPCommittedState;
        }

        public int hashcode() {
            return this.tid.hashCode();
        }

        public boolean equals(Object object) {
            if (object instanceof TIDEntry) {
                return this.tid.equals(((TIDEntry)object).tid);
            }
            return false;
        }
    }
}

