/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsserver.data;

import com.sun.messaging.jmq.io.Packet;
import com.sun.messaging.jmq.io.SysMessageID;
import com.sun.messaging.jmq.jmsserver.Globals;
import com.sun.messaging.jmq.jmsserver.core.BrokerAddress;
import com.sun.messaging.jmq.jmsserver.core.ConsumerUID;
import com.sun.messaging.jmq.jmsserver.core.Destination;
import com.sun.messaging.jmq.jmsserver.core.DestinationUID;
import com.sun.messaging.jmq.jmsserver.core.PacketReference;
import com.sun.messaging.jmq.jmsserver.data.BaseTransaction;
import com.sun.messaging.jmq.jmsserver.data.ClusterTransaction;
import com.sun.messaging.jmq.jmsserver.data.RemoteTransaction;
import com.sun.messaging.jmq.jmsserver.data.TransactionAcknowledgement;
import com.sun.messaging.jmq.jmsserver.data.TransactionBroker;
import com.sun.messaging.jmq.jmsserver.data.TransactionList;
import com.sun.messaging.jmq.jmsserver.data.TransactionState;
import com.sun.messaging.jmq.jmsserver.data.TransactionUID;
import com.sun.messaging.jmq.jmsserver.data.TransactionWork;
import com.sun.messaging.jmq.jmsserver.data.TransactionWorkMessage;
import com.sun.messaging.jmq.jmsserver.data.TransactionWorkMessageAck;
import com.sun.messaging.jmq.jmsserver.persist.Store;
import com.sun.messaging.jmq.jmsserver.util.BrokerException;
import com.sun.messaging.jmq.util.log.Logger;
import java.io.IOException;
import java.util.Iterator;
import java.util.List;

public class TransactionListLoader {
    static Logger logger = Globals.getLogger();
    static boolean loaded = false;

    public static void loadTransactions(Store store, TransactionList transactionList) throws BrokerException, IOException {
        logger.log(8, "B1136");
        TransactionListLoader.loadLocalTransactions(store, transactionList);
        TransactionListLoader.loadClusterTransactions(store, transactionList);
        TransactionListLoader.loadRemoteTransactions(store, transactionList);
    }

    public static void rollbackAllTransactions(Store store) {
        logger.log(8, "rolling back all transactions");
        store.rollbackAllTransactions();
    }

    private static void loadDestinations() throws BrokerException {
        if (!loaded) {
            loaded = true;
            Destination.loadDestinations();
            Iterator iterator = Destination.getAllDestinations();
            while (iterator.hasNext()) {
                Destination destination = (Destination)iterator.next();
                destination.load();
            }
        }
    }

    private static void loadLocalTransactions(Store store, TransactionList transactionList) throws BrokerException, IOException {
        List<BaseTransaction> list = store.getIncompleteTransactions(1);
        String string = " loading " + list.size() + " incomplete Local transactions:  ";
        logger.log(4, string);
        for (BaseTransaction baseTransaction : list) {
            TransactionUID transactionUID = baseTransaction.getTid();
            string = " loadTransactions: processing local transaction " + transactionUID;
            logger.log(4, string);
            TransactionState transactionState = baseTransaction.getTransactionState();
            transactionList.addTransactionID(transactionUID, transactionState, false);
            TransactionWork transactionWork = baseTransaction.getTransactionWork();
            TransactionListLoader.handleTransactionWork(transactionList, transactionUID, transactionWork);
            if (transactionState.getState() != 5 || !transactionState.getOnephasePrepare()) continue;
            transactionList.addDetachedTransactionID(transactionUID);
        }
    }

    private static void loadClusterTransactions(Store store, TransactionList transactionList) throws BrokerException, IOException {
        List<BaseTransaction> list = store.getIncompleteTransactions(3);
        String string = " loading " + list.size() + " incomplete cluster transactions:  ";
        if (TransactionList.DEBUG_CLUSTER_TXN) {
            logger.log(8, string);
        }
        for (ClusterTransaction clusterTransaction : list) {
            TransactionUID transactionUID = clusterTransaction.getTid();
            string = " loadTransactions: processing cluster transaction " + transactionUID;
            logger.log(4, string);
            TransactionState transactionState = clusterTransaction.getTransactionState();
            transactionList.addTransactionID(transactionUID, transactionState, false);
            TransactionBroker[] transactionBrokerArray = clusterTransaction.getTransactionBrokers();
            transactionList.logClusterTransaction(transactionUID, transactionState, transactionBrokerArray, true, false);
            TransactionWork transactionWork = clusterTransaction.getTransactionWork();
            if (transactionState.getState() == 5) {
                if (TransactionList.DEBUG_CLUSTER_TXN) {
                    logger.log(8, "Loading cluster transaction " + transactionUID + "[" + transactionState + "]");
                }
                TransactionListLoader.handleTransactionWork(transactionList, transactionUID, transactionWork);
                if (!transactionState.getOnephasePrepare()) continue;
                transactionList.addDetachedTransactionID(transactionUID);
                continue;
            }
            if (transactionState.getState() != 6) continue;
            transactionList.removeTransaction(transactionUID, false);
        }
    }

    private static void loadRemoteTransactions(Store store, TransactionList transactionList) throws BrokerException, IOException {
        List<BaseTransaction> list = store.getIncompleteTransactions(2);
        String string = " loading " + list.size() + " incomplete remote transactions:  ";
        logger.log(4, string);
        for (RemoteTransaction remoteTransaction : list) {
            TransactionUID transactionUID = remoteTransaction.getTid();
            TransactionState transactionState = remoteTransaction.getTransactionState();
            TransactionAcknowledgement[] transactionAcknowledgementArray = remoteTransaction.getTxnAcks();
            DestinationUID[] destinationUIDArray = remoteTransaction.getDestIds();
            string = " loadTransactions: processing remote transaction " + transactionUID + " state= " + transactionState;
            logger.log(4, string);
            BrokerAddress brokerAddress = remoteTransaction.getTxnHomeBroker();
            transactionList.logRemoteTransaction(transactionUID, transactionState, transactionAcknowledgementArray, brokerAddress, true, true, false);
            for (int i = 0; i < transactionAcknowledgementArray.length; ++i) {
                TransactionAcknowledgement transactionAcknowledgement = transactionAcknowledgementArray[i];
                DestinationUID destinationUID = destinationUIDArray[i];
                TransactionListLoader.unrouteLoadedTransactionAckMessage(destinationUID, transactionAcknowledgement.getSysMessageID(), transactionAcknowledgement.getStoredConsumerUID());
            }
        }
    }

    static void handleTransactionWork(TransactionList transactionList, TransactionUID transactionUID, TransactionWork transactionWork) throws BrokerException {
        TransactionListLoader.handleSentMessages(transactionList, transactionWork);
        TransactionListLoader.handleMessageAcks(transactionList, transactionUID, transactionWork);
    }

    static void handleSentMessages(TransactionList transactionList, TransactionWork transactionWork) throws BrokerException {
        for (int i = 0; i < transactionWork.numSentMessages(); ++i) {
            int n;
            TransactionWorkMessage transactionWorkMessage = transactionWork.getSentMessages().get(i);
            Packet packet = transactionWorkMessage.getMessage();
            DestinationUID destinationUID = transactionWorkMessage.getDestUID();
            logger.log(4, " handleSentMessages: duid= " + destinationUID);
            PacketReference packetReference = PacketReference.createReference(packet, destinationUID, null);
            Destination destination = Destination.getDestination(destinationUID);
            if (destination == null) {
                try {
                    n = destinationUID.isQueue() ? 1 : 2;
                    destination = Destination.getDestination(destinationUID.getName(), n, true, true);
                }
                catch (IOException iOException) {
                    throw new BrokerException("Could not recreate destination " + destinationUID, iOException);
                }
            }
            destination.load();
            logger.log(4, " loadTransactions: processing prepared sent message " + packet.getMessageID());
            n = destination.queueMessage(packetReference, true) ? 1 : 0;
            transactionList.addMessage(packetReference.getTransactionID(), packetReference.getSysMessageID(), true);
        }
    }

    static void handleMessageAcks(TransactionList transactionList, TransactionUID transactionUID, TransactionWork transactionWork) throws BrokerException {
        for (int i = 0; i < transactionWork.numMessageAcknowledgments(); ++i) {
            TransactionWorkMessageAck transactionWorkMessageAck = transactionWork.getMessageAcknowledgments().get(i);
            DestinationUID destinationUID = transactionWorkMessageAck.getDestUID();
            TransactionListLoader.handleAck(transactionList, transactionUID, destinationUID, transactionWorkMessageAck.getSysMessageID(), transactionWorkMessageAck.getConsumerID());
        }
    }

    static void handleAck(TransactionList transactionList, TransactionUID transactionUID, DestinationUID destinationUID, SysMessageID sysMessageID, ConsumerUID consumerUID) throws BrokerException {
        logger.log(4, " loadTransactions: processing prepared acknowledged message " + sysMessageID);
        transactionList.addAcknowledgement(transactionUID, sysMessageID, consumerUID, consumerUID, true, false);
        transactionList.addOrphanAck(transactionUID, sysMessageID, consumerUID, consumerUID);
        TransactionListLoader.unrouteLoadedTransactionAckMessage(destinationUID, sysMessageID, consumerUID);
    }

    /*
     * Enabled aggressive block sorting
     */
    static void unrouteLoadedTransactionAckMessage(DestinationUID destinationUID, SysMessageID sysMessageID, ConsumerUID consumerUID) throws BrokerException {
        logger.log(4, " trying to unroute prepared acknowledged message: destID =  " + destinationUID + " ackedMsgId=" + sysMessageID);
        Destination destination = null;
        PacketReference packetReference = null;
        if (destinationUID != null) {
            destination = Destination.getDestination(destinationUID);
            if (destination == null) {
                String string = "Could not find destination for " + destinationUID;
                logger.log(16, string);
                return;
            }
            destination.load();
            packetReference = destination.getMessage(sysMessageID);
            if (packetReference == null) {
                String string = "Could not find packet for " + sysMessageID + "in dest " + destination;
                logger.log(16, string);
                return;
            }
        } else {
            logger.log(16, "No dest ID for acked message. Will need to load all dests " + sysMessageID);
            TransactionListLoader.loadDestinations();
            packetReference = Destination.get(sysMessageID);
            destination = packetReference.getDestination();
        }
        destination.unrouteLoadedTransactionAckMessage(packetReference, consumerUID);
    }
}

