/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsserver.core.cluster;

import com.sun.messaging.jmq.io.Packet;
import com.sun.messaging.jmq.io.SysMessageID;
import com.sun.messaging.jmq.jmsserver.Globals;
import com.sun.messaging.jmq.jmsserver.core.BrokerAddress;
import com.sun.messaging.jmq.jmsserver.core.ClusterBroadcast;
import com.sun.messaging.jmq.jmsserver.core.ClusterRouter;
import com.sun.messaging.jmq.jmsserver.core.Consumer;
import com.sun.messaging.jmq.jmsserver.core.ConsumerUID;
import com.sun.messaging.jmq.jmsserver.core.Destination;
import com.sun.messaging.jmq.jmsserver.core.DestinationUID;
import com.sun.messaging.jmq.jmsserver.core.PacketReference;
import com.sun.messaging.jmq.jmsserver.core.cluster.BrokerConsumers;
import com.sun.messaging.jmq.jmsserver.multibroker.Protocol;
import com.sun.messaging.jmq.jmsserver.service.ConnectionUID;
import com.sun.messaging.jmq.jmsserver.util.BrokerException;
import com.sun.messaging.jmq.jmsserver.util.lists.RemoveReason;
import com.sun.messaging.jmq.util.log.Logger;
import com.sun.messaging.jmq.util.selector.SelectorFormatException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class MultibrokerRouter
implements ClusterRouter {
    private static boolean DEBUG = false;
    private static Logger logger = Globals.getLogger();
    private static final String ENFORCE_REMOTE_DEST_LIMIT_PROP = "imq.cluster.enforceRemoteDestinationLimit";
    private static boolean ENFORCE_REMOTE_DEST_LIMIT = Globals.getConfig().getBooleanProperty("imq.cluster.enforceRemoteDestinationLimit", false);
    private static String ROUTE_REJECTED_REMOTE_MSG = "imq.cluster.routeRejectedRemoteMsg";
    private ArrayList loggedFullDestsOnHandleJMSMsg = new ArrayList();
    ClusterBroadcast cb = null;
    Protocol p = null;
    BrokerConsumers bc = null;

    public MultibrokerRouter(ClusterBroadcast clusterBroadcast) {
        this.cb = clusterBroadcast;
        this.p = clusterBroadcast.getProtocol();
        this.bc = new BrokerConsumers(this.p);
    }

    public static String msgToString(int n) {
        switch (n) {
            case 0: {
                return "MSG_DELIVERED";
            }
            case 1: {
                return "MSG_ACKNOWLEDGED";
            }
            case 8: {
                return "MSG_PREPARE";
            }
            case 9: {
                return "MSG_ROLLEDBACK";
            }
            case 5: {
                return "MSG_IGNORED";
            }
            case 6: {
                return "MSG_UNDELIVERABLE";
            }
            case 7: {
                return "MSG_DEAD";
            }
        }
        return "UNKNOWN";
    }

    public void addConsumer(Consumer consumer) throws BrokerException, IOException, SelectorFormatException {
        this.bc.addConsumer(consumer);
    }

    public void removeConsumer(ConsumerUID consumerUID, Set set, boolean bl) throws BrokerException, IOException {
        this.bc.removeConsumer(consumerUID, set, bl);
    }

    public void removeConsumers(ConnectionUID connectionUID) throws BrokerException, IOException {
        this.bc.removeConsumers(connectionUID);
    }

    public void brokerDown(BrokerAddress brokerAddress) throws BrokerException, IOException {
        this.bc.brokerDown(brokerAddress);
    }

    public void forwardMessage(PacketReference packetReference, Collection collection) {
        this.bc.forwardMessageToRemote(packetReference, collection);
    }

    public void shutdown() {
        this.bc.destroy();
    }

    /*
     * Could not resolve type clashes
     * Unable to fully structure code
     */
    public void handleJMSMsg(Packet var1_1, List var2_2, BrokerAddress var3_3, boolean var4_4) throws BrokerException {
        var5_5 = true;
        var6_6 = new ArrayList<Object>();
        var7_7 = new ArrayList<Object>();
        for (ConsumerUID var9_9 : var2_2) {
            var10_11 = Consumer.getConsumer(var9_9);
            if (var10_11 != null && var10_11.isValid()) {
                var6_6.add(var10_11);
                var11_12 /* !! */  = var10_11.getStoredConsumerUID();
                if (var11_12 /* !! */  != null && !var11_12 /* !! */ .equals(var9_9) || var10_11.getSubscription() != null) continue;
                var5_5 = false;
                continue;
            }
            var7_7.add(var9_9);
        }
        var9_10 = false;
        var10_11 = Destination.get(var1_1.getSysMessageID());
        if (!(var10_11 == null || (var11_12 /* !! */  = var10_11.getAddress()) != null && var11_12 /* !! */ .equals(var3_3))) {
            if (MultibrokerRouter.DEBUG) {
                MultibrokerRouter.logger.log(8, "Remote message " + var10_11.getSysMessageID() + " home broker " + var11_12 /* !! */  + " changed to " + var3_3);
            }
            Destination.remoteCheckMessageHomeChange((PacketReference)var10_11, var3_3);
        }
        if ((var10_11 = Destination.get(var1_1.getSysMessageID())) != null) {
            var9_10 = true;
            var10_11.setBrokerAddress(var3_3);
            if (var1_1.getRedelivered()) {
                var10_11.overrideRedeliver();
            }
        } else {
            var10_11 = PacketReference.createReference(var1_1, null);
            var10_11.setBrokerAddress(var3_3);
        }
        if (var4_4) {
            for (var11_13 = 0; var11_13 < var6_6.size(); ++var11_13) {
                var12_15 = (Consumer)var6_6.get(var11_13);
                var10_11.addMessageDeliveredAck(var12_15.getConsumerUID());
            }
        }
        var11_14 = null;
        try {
            if (var10_11 == null) {
                return;
            }
            if (var10_11.getDestinationUID().isWildcard()) {
                var11_14 = Destination.findMatchingIDs(var10_11.getDestinationUID());
            } else {
                var12_15 = Destination.getDestination(var10_11.getDestinationUID().getName(), var10_11.getDestinationUID().isQueue() != false ? 1 : 2, true, true);
                if (var12_15 != null) {
                    var11_14 = new ArrayList<DestinationUID>();
                    var11_14.add(var12_15.getDestinationUID());
                }
            }
            if (var11_14 == null || var11_14.isEmpty()) {
                var7_7.addAll(var6_6);
                var6_6.clear();
            } else if (!var9_10 && !var6_6.isEmpty()) {
                var10_11.setNeverStore(true);
                var10_11.store(var6_6);
                for (Object var12_15 : var11_14) {
                    var13_17 = Destination.getDestination((DestinationUID)var12_15);
                    if (MultibrokerRouter.DEBUG) {
                        MultibrokerRouter.logger.log(8, "Route remote message " + var10_11 + " sent from " + var3_3 + " to destination(s) " + var12_15 + " for consumer(s) " + var6_6 + " hasflowcontrol=" + var5_5 + ", enforcelimit=" + MultibrokerRouter.ENFORCE_REMOTE_DEST_LIMIT);
                    }
                    var13_17.queueMessage((PacketReference)var10_11, false, MultibrokerRouter.ENFORCE_REMOTE_DEST_LIMIT);
                }
            } else if (var9_10) {
                var10_11.add(var6_6);
            }
        }
        catch (Exception var12_16) {
            var13_17 = new Object[]{var10_11 == null ? "null" : var10_11, var3_3, var6_6};
            var14_19 = Globals.getBrokerResources().getKString("B2256", (Object[])var13_17);
            if (!(var12_16 instanceof BrokerException)) {
                MultibrokerRouter.logger.logStack(16, (String)var14_19, (Throwable)var12_16);
            }
            var15_20 /* !! */  = (BrokerException)var12_16;
            var16_22 = var15_20 /* !! */ .getStatusCode();
            if (var16_22 != 414 && var16_22 != 423) {
                MultibrokerRouter.logger.logStack(16, (String)var14_19, (Throwable)var12_16);
            }
            var17_25 = new Object[]{var3_3, var6_6};
            var14_19 = Globals.getBrokerResources().getKString("B2257", var17_25);
            var18_27 = 4;
            if (var10_11 == null || !this.loggedFullDestsOnHandleJMSMsg.contains(var10_11.getDestinationUID())) {
                var18_27 = 16;
                this.loggedFullDestsOnHandleJMSMsg.add(var10_11.getDestinationUID());
            }
            MultibrokerRouter.logger.log(var18_27, (String)var14_19 + (var18_27 == 4 ? ": " + var12_16.getMessage() : ""));
        }
        var12_15 = "\n";
        for (var13_18 = 0; var13_18 < var6_6.size(); ++var13_18) {
            var14_19 = (Consumer)var6_6.get(var13_18);
            if (!var14_19.routeMessage((PacketReference)var10_11, false)) {
                try {
                    if (!var10_11.acknowledged(var14_19.getConsumerUID(), var14_19.getStoredConsumerUID(), true, false)) ** GOTO lbl106
                    if (var11_14 == null) continue;
                    for (BrokerException var15_20 : var11_14) {
                        var16_23 = Destination.getDestination((DestinationUID)var15_20 /* !! */ );
                        var16_23.removeRemoteMessage(var10_11.getSysMessageID(), RemoveReason.ACKNOWLEDGED, (PacketReference)var10_11);
                    }
                }
                catch (Exception var15_21) {
                    MultibrokerRouter.logger.log(8, "Internal error processing ack", (Throwable)var15_21);
                }
            } else {
                var10_11.addRemoteConsumerUID(var14_19.getConsumerUID(), var14_19.getConsumerUID().getConnectionUID());
            }
lbl106:
            // 4 sources

            if (!MultibrokerRouter.DEBUG) continue;
            var12_15 = (String)var12_15 + "\t" + var14_19.getConsumerUID() + "\n";
        }
        if (MultibrokerRouter.DEBUG) {
            MultibrokerRouter.logger.log(1, "MessageBus: Delivering message to : {0}", var12_15);
        }
        var12_15 = "\n";
        var14_19 = null;
        var15_20 /* !! */  = null;
        var16_24 = null;
        for (var13_18 = 0; var13_18 < var7_7.size(); ++var13_18) {
            try {
                var14_19 = var7_7.get(var13_18);
                var15_20 /* !! */  = var14_19 instanceof Consumer != false ? ((Consumer)var14_19).getConsumerUID() : (ConsumerUID)var14_19;
                this.cb.acknowledgeMessage(var3_3, var10_11.getSysMessageID(), (ConsumerUID)var15_20 /* !! */ , 5, null, false);
            }
            catch (Exception var17_26) {
                MultibrokerRouter.logger.logStack(16, "sendMessageAck IGNORE failed to " + var3_3, (Throwable)var17_26);
            }
            if (!MultibrokerRouter.DEBUG) continue;
            var12_15 = (String)var12_15 + "\t" + var7_7.get(var13_18) + "\n";
        }
        if (MultibrokerRouter.DEBUG && var7_7.size() > 0) {
            MultibrokerRouter.logger.log(1, "MessageBus: Invalid targets : {0}", var12_15);
        }
    }

    public void handleAck(int n, SysMessageID sysMessageID, ConsumerUID consumerUID, Map map) throws BrokerException {
        this.bc.acknowledgeMessageFromRemote(n, sysMessageID, consumerUID, map);
    }

    public void handleAck2P(int n, SysMessageID[] sysMessageIDArray, ConsumerUID[] consumerUIDArray, Map map, Long l, BrokerAddress brokerAddress) throws BrokerException {
        this.bc.acknowledgeMessageFromRemote2P(n, sysMessageIDArray, consumerUIDArray, map, l, brokerAddress);
    }

    public void handleCtrlMsg(int n, HashMap hashMap) throws BrokerException {
    }

    public Hashtable getDebugState() {
        return this.bc.getDebugState();
    }
}

