/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsserver.core;

import com.sun.messaging.jmq.io.Packet;
import com.sun.messaging.jmq.jmsserver.Globals;
import com.sun.messaging.jmq.jmsserver.core.BrokerAddress;
import com.sun.messaging.jmq.jmsserver.core.ConsumerUID;
import com.sun.messaging.jmq.jmsserver.core.Destination;
import com.sun.messaging.jmq.jmsserver.core.DestinationUID;
import com.sun.messaging.jmq.jmsserver.core.PacketReference;
import com.sun.messaging.jmq.jmsserver.core.Session;
import com.sun.messaging.jmq.jmsserver.core.SessionUID;
import com.sun.messaging.jmq.jmsserver.core.Subscription;
import com.sun.messaging.jmq.jmsserver.resources.BrokerResources;
import com.sun.messaging.jmq.jmsserver.service.Connection;
import com.sun.messaging.jmq.jmsserver.service.ConnectionUID;
import com.sun.messaging.jmq.jmsserver.service.imq.IMQConnection;
import com.sun.messaging.jmq.jmsserver.util.BrokerException;
import com.sun.messaging.jmq.jmsserver.util.ConsumerAlreadyAddedException;
import com.sun.messaging.jmq.jmsserver.util.lists.RemoveReason;
import com.sun.messaging.jmq.util.lists.EventBroadcastHelper;
import com.sun.messaging.jmq.util.lists.EventBroadcaster;
import com.sun.messaging.jmq.util.lists.EventListener;
import com.sun.messaging.jmq.util.lists.EventType;
import com.sun.messaging.jmq.util.lists.Filter;
import com.sun.messaging.jmq.util.lists.NFLPriorityFifoSet;
import com.sun.messaging.jmq.util.lists.Prioritized;
import com.sun.messaging.jmq.util.lists.Reason;
import com.sun.messaging.jmq.util.lists.SubSet;
import com.sun.messaging.jmq.util.log.Logger;
import com.sun.messaging.jmq.util.selector.Selector;
import com.sun.messaging.jmq.util.selector.SelectorFormatException;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Vector;

public class Consumer
implements EventBroadcaster,
Serializable {
    transient Logger logger = Globals.getLogger();
    static final long serialVersionUID = 3353669107150988952L;
    public static final String PREFETCH = "prefetch";
    private static boolean DEBUG = false;
    protected static final boolean DEBUG_CLUSTER_TXN = Globals.getConfig().getBooleanProperty("imq.cluster.debug.txn") || DEBUG;
    protected static final boolean DEBUG_CLUSTER_MSG = Globals.getConfig().getBooleanProperty("imq.cluster.debug.msg") || DEBUG_CLUSTER_TXN || DEBUG;
    private transient boolean useConsumerFlowControl = false;
    private transient int msgsToConsumer = 0;
    transient Set destinations = null;
    protected transient BrokerResources br = Globals.getBrokerResources();
    private static boolean C_FLOW_CONTROL_ALLOWED = Globals.getConfig().getBooleanProperty("imq.destination.flowControlAllowed", true);
    long lastAckTime = 0L;
    SessionUID sessionuid = null;
    DestinationUID dest;
    ConsumerUID uid;
    transient ConsumerUID stored_uid;
    ConnectionUID conuid = null;
    transient boolean valid = true;
    transient boolean active = true;
    transient boolean paused = false;
    transient int pauseCnt = 0;
    transient int pauseFlowCnt = 0;
    transient int resumeFlowCnt = 0;
    boolean noLocal = false;
    transient boolean busy = false;
    transient Subscription parent = null;
    transient boolean isSpecialRemote = false;
    transient boolean isFailover = false;
    transient int position = 0;
    transient int lockPosition = -1;
    transient EventBroadcastHelper evb = null;
    boolean ackMsgsOnDestroy = true;
    transient int flowCount = 0;
    transient boolean flowPaused = false;
    transient int msgsOut = 0;
    transient int prefetch = -1;
    transient int remotePrefetch = -1;
    transient String creator = null;
    transient boolean requestedRecreation = false;
    protected String selstr = null;
    protected transient Selector selector = null;
    transient NFLPriorityFifoSet msgs;
    protected transient SubSet parentList = null;
    private transient Object plistener = null;
    private transient Object mlistener = null;
    private transient boolean localConsumerCreationReady = false;
    transient EventListener busylistener = null;
    transient EventListener removeListener = null;
    private transient Object expiredID = null;
    private transient Object purgedID = null;
    private transient Object removedID1 = null;
    private transient Object removedID2 = null;
    private transient Object removedID3 = null;
    private transient Object removedID4 = null;
    transient Object destroyLock = new Object();
    transient Object plock = new Object();
    HashSet remotePendingDelivered = new HashSet();
    private transient ArrayList remotePendingResumes = new ArrayList();
    private transient Hashtable lastDestMetrics = new Hashtable();
    private static Map consumers = Collections.synchronizedMap(new HashMap());
    protected static Set wildcardConsumers = Collections.synchronizedSet(new HashSet());

    public void addRemoveListener(EventBroadcaster eventBroadcaster) {
        this.expiredID = eventBroadcaster.addEventListener(this.removeListener, EventType.SET_CHANGED_REQUEST, (Reason)RemoveReason.EXPIRED, null);
        this.purgedID = eventBroadcaster.addEventListener(this.removeListener, EventType.SET_CHANGED_REQUEST, (Reason)RemoveReason.PURGED, null);
        this.removedID1 = eventBroadcaster.addEventListener(this.removeListener, EventType.SET_CHANGED_REQUEST, (Reason)RemoveReason.REMOVED_OLDEST, null);
        this.removedID2 = eventBroadcaster.addEventListener(this.removeListener, EventType.SET_CHANGED_REQUEST, (Reason)RemoveReason.REMOVED_LOW_PRIORITY, null);
        this.removedID3 = eventBroadcaster.addEventListener(this.removeListener, EventType.SET_CHANGED_REQUEST, (Reason)RemoveReason.REMOVED_REJECTED, null);
        this.removedID4 = eventBroadcaster.addEventListener(this.removeListener, EventType.SET_CHANGED_REQUEST, (Reason)RemoveReason.REMOVED_OTHER, null);
    }

    public void removeRemoveListener(EventBroadcaster eventBroadcaster) {
        eventBroadcaster.removeEventListener(this.expiredID);
        eventBroadcaster.removeEventListener(this.purgedID);
        eventBroadcaster.removeEventListener(this.removedID1);
        eventBroadcaster.removeEventListener(this.removedID2);
        eventBroadcaster.removeEventListener(this.removedID3);
        eventBroadcaster.removeEventListener(this.removedID4);
    }

    private boolean getParentBusy() {
        return this.parentList != null && !this.parentList.isEmpty() || this.parent != null && this.parent.isBusy();
    }

    public void setPrefetch(int n) {
        this.prefetch = n;
        this.useConsumerFlowControl = C_FLOW_CONTROL_ALLOWED;
    }

    public void setPrefetch(int n, boolean bl) {
        this.prefetch = n;
        this.useConsumerFlowControl = bl;
    }

    public void setRemotePrefetch(int n) {
        this.remotePrefetch = n;
    }

    public int getRemotePrefetch() {
        return this.remotePrefetch;
    }

    public static int calcPrefetch(Consumer consumer, int n) {
        Destination destination = consumer.getFirstDestination();
        Subscription subscription = consumer.getSubscription();
        int n2 = -1;
        if (destination != null) {
            int n3 = n2 = subscription == null || !subscription.getShared() ? destination.getMaxPrefetch() : destination.getSharedConsumerFlowLimit();
        }
        int n4 = n2 == -1 ? n : (n == -1 ? n : (n > n2 ? n2 : n));
        return n4;
    }

    public long getLastAckTime() {
        return this.lastAckTime;
    }

    public void setLastAckTime(long l) {
        this.lastAckTime = l;
        if (this.parent != null) {
            this.parent.setLastAckTime(l);
        }
    }

    public int getPrefetch() {
        return this.prefetch;
    }

    public int getPrefetchForRemote() {
        long l;
        int n = this.prefetch;
        if (Destination.getMaxMessages() > 0L) {
            l = Destination.getMaxMessages() - (long)Destination.totalCount();
            if (l <= 0L) {
                l = 1L;
            }
            if ((long)n > l) {
                n = (int)l;
            }
        }
        l = -1L;
        long l2 = -1L;
        Destination destination2 = null;
        for (Destination destination2 : this.getDestinations()) {
            l2 = destination2.checkDestinationCapacity(null);
            if (l2 < 0L || l >= 0L && l <= l2) continue;
            l = l2;
        }
        if (l == 0L) {
            l = 1L;
        }
        if (l > 0L && (long)n > l) {
            n = (int)l;
        }
        return n;
    }

    public void setSubscription(Subscription subscription) {
        this.ackMsgsOnDestroy = false;
        this.parent = subscription;
    }

    public void load() {
        for (Destination destination : this.getDestinations()) {
            try {
                destination.load();
            }
            catch (Exception exception) {}
        }
    }

    public String getCreator() {
        return this.creator;
    }

    public void setCreator(String string) {
        this.creator = string;
    }

    public String getClientID() {
        ConnectionUID connectionUID = this.getConnectionUID();
        if (connectionUID == null) {
            return "<unknown>";
        }
        Connection connection = Globals.getConnectionManager().getConnection(connectionUID);
        return (String)connection.getClientData("client id");
    }

    public boolean isDurableSubscriber() {
        if (this.parent != null) {
            return this.parent.isDurable();
        }
        if (this instanceof Subscription) {
            return ((Subscription)this).isDurable();
        }
        return false;
    }

    public boolean getIsFlowPaused() {
        return this.flowPaused;
    }

    public void msgRetrieved() {
        ++this.msgsOut;
    }

    public int totalMsgsDelivered() {
        return this.msgsOut;
    }

    public int numPendingAcks() {
        Session session = Session.getSession(this.sessionuid);
        if (session == null) {
            return 0;
        }
        return session.getNumPendingAcks(this.getConsumerUID());
    }

    public Subscription getSubscription() {
        return this.parent;
    }

    protected static Selector getSelector(String string) throws SelectorFormatException {
        return Selector.compile((String)string);
    }

    public SubSet getParentList() {
        return this.parentList;
    }

    public void destroyConsumer(Set set, boolean bl) {
        this.destroyConsumer(set, null, false, bl, true);
    }

    public void destroyConsumer(Set set, boolean bl, boolean bl2) {
        this.destroyConsumer(set, null, false, bl, bl2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroyConsumer(Set set, Map map, boolean bl, boolean bl2, boolean bl3) {
        Object object;
        if (DEBUG) {
            this.logger.log(4, "destroyConsumer : " + this + ", delivered size=" + set.size());
        }
        Object object2 = this.destroyLock;
        synchronized (object2) {
            if (!this.valid) {
                return;
            }
            this.valid = false;
        }
        object2 = this.parent;
        if (object2 != null) {
            ((Consumer)object2).pause("Consumer.java: destroy " + this);
        }
        this.pause("Consumer.java: destroy ");
        if (this.parentList != null && this.plistener != null) {
            this.parentList.removeEventListener(this.plistener);
            this.plistener = null;
        }
        Set set2 = this.getDestinations();
        SubSet subSet = null;
        Object object3 = this.plock;
        synchronized (object3) {
            subSet = this.parentList;
            this.parentList = null;
        }
        if (this.parent != null) {
            this.parent.releaseConsumer(this.uid);
            this.parent = null;
            if (bl3) {
                try {
                    this.sendDestroyConsumerNotification(map, bl);
                }
                catch (Exception exception) {
                    this.logger.log(8, "Internal Error: sending detach notification for " + this.uid + " from " + this.parent, (Throwable)exception);
                }
            }
        } else if ((set2 == null || set2.isEmpty()) && !bl2) {
            this.logger.log(4, "Removing consumer from non-existant destination" + this.dest);
        } else if (!bl2) {
            object3 = set2.iterator();
            while (object3.hasNext()) {
                object = null;
                try {
                    object = (Destination)object3.next();
                    ((Destination)object).removeConsumer(this.uid, map, bl, bl3);
                }
                catch (Exception exception) {
                    this.logger.logStack(8, "Internal Error: removing consumer " + this.uid + " from " + object, (Throwable)exception);
                }
            }
        }
        if (DEBUG) {
            this.logger.log(4, "Destroying consumer " + this + "[" + set.size() + ":" + this.msgs.size() + "]");
        }
        object3 = new LinkedHashSet(this.msgs);
        object = this.ackMsgsOnDestroy ? RemoveReason.ACKNOWLEDGED : RemoveReason.UNLOADED;
        set.addAll(object3);
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            PacketReference packetReference = (PacketReference)iterator.next();
            if (packetReference == null || !this.ackMsgsOnDestroy && packetReference.isLocal()) continue;
            iterator.remove();
            try {
                Destination destination;
                if (!packetReference.acknowledged(this.getConsumerUID(), this.getStoredConsumerUID(), !this.uid.isUnsafeAck(), packetReference.isLocal()) || (destination = Destination.getDestination(packetReference.getDestinationUID())) == null) continue;
                if (packetReference.isLocal()) {
                    destination.removeMessage(packetReference.getSysMessageID(), RemoveReason.ACKNOWLEDGED);
                    continue;
                }
                destination.removeRemoteMessage(packetReference.getSysMessageID(), RemoveReason.ACKNOWLEDGED, packetReference);
            }
            catch (Exception exception) {
                this.logger.log(4, "Broker down Unable to acknowlege" + packetReference.getSysMessageID() + ":" + this.uid, (Throwable)exception);
            }
        }
        this.msgs.removeAll((Collection)object3, (Reason)object);
        if (!this.ackMsgsOnDestroy && subSet != null) {
            ((Prioritized)subSet).addAllOrdered((Collection)set);
            set.clear();
        }
        this.destroy();
        if (this.msgs != null && this.mlistener != null) {
            this.msgs.removeEventListener(this.mlistener);
            this.mlistener = null;
        }
        if (object2 != null) {
            ((Consumer)object2).resume("Consumer.java: destroyConsumer " + this);
        }
        this.selstr = null;
        this.selector = null;
    }

    public void sendCreateConsumerNotification() throws BrokerException {
        Destination destination = this.getFirstDestination();
        if ((this.dest.isWildcard() || !destination.getIsLocal() && !destination.isInternal() && !destination.isAdmin()) && Globals.getClusterBroadcast() != null) {
            Globals.getClusterBroadcast().createConsumer(this);
        }
    }

    public void sendDestroyConsumerNotification(Map map, boolean bl) throws BrokerException {
        Destination destination = this.getFirstDestination();
        if (this.dest.isWildcard() || destination != null && !destination.getIsLocal() && !destination.isInternal() && !destination.isAdmin() && Globals.getClusterBroadcast() != null) {
            Globals.getClusterBroadcast().destroyConsumer(this, map, bl);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void destroy() {
        this.valid = false;
        this.pause("Consumer.java: destroy()");
        Object object = consumers;
        synchronized (object) {
            consumers.remove(this.uid);
        }
        wildcardConsumers.remove(this.uid);
        this.selector = null;
        object = RemoveReason.UNLOADED;
        if (this.ackMsgsOnDestroy) {
            object = RemoveReason.ACKNOWLEDGED;
        }
        HashSet hashSet = new HashSet(this.msgs);
        try {
            HashSet hashSet2 = hashSet;
            synchronized (hashSet2) {
                for (PacketReference packetReference : hashSet) {
                    if (!this.ackMsgsOnDestroy || !packetReference.acknowledged(this.getConsumerUID(), this.getStoredConsumerUID(), !this.uid.isUnsafeAck(), true)) continue;
                    Destination destination = Destination.getDestination(packetReference.getDestinationUID());
                    destination.removeMessage(packetReference.getSysMessageID(), (Reason)object);
                }
            }
            this.msgs.removeAll(hashSet, (Reason)object);
        }
        catch (Exception exception) {
            this.logger.log(16, "Internal Error: Problem cleaning consumer " + this, (Throwable)exception);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setParentList(SubSet subSet) {
        this.ackMsgsOnDestroy = false;
        if (this.parentList != null) {
            if (this.plistener != null) {
                this.parentList.removeEventListener(this.plistener);
            }
            this.plistener = null;
        }
        assert (this.plistener == null);
        Object object = this.plock;
        synchronized (object) {
            this.parentList = subSet;
            if (this.parentList != null) {
                this.plistener = this.parentList.addEventListener(this.busylistener, EventType.EMPTY, null);
            } else assert (this.plistener == null);
        }
        this.checkState(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void getMoreMessages(int n) {
        SubSet subSet = null;
        Object object = this.plock;
        synchronized (object) {
            subSet = this.parentList;
        }
        if (this.paused || subSet == null || subSet.isEmpty() || this.parent != null && this.parent.isPaused()) {
            return;
        }
        int n2 = 0;
        if (subSet.isEmpty()) {
            return;
        }
        while (!(this.isFailover || !this.isActive() || this.isPaused() || !this.isValid() || subSet == null || subSet.isEmpty() || n2 >= n || this.parent != null && this.parent.isPaused())) {
            PacketReference packetReference = (PacketReference)subSet.removeNext();
            if (packetReference == null) continue;
            this.msgs.add(11 - packetReference.getPriority(), (Object)packetReference);
            ++n2;
            this.busy = true;
        }
    }

    void setIsActiveConsumer(boolean bl) {
        this.isFailover = !bl;
        this.checkState(null);
    }

    public boolean getIsFailoverConsumer() {
        return this.isFailover;
    }

    public boolean getIsActiveConsumer() {
        return !this.isFailover;
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        this.logger = Globals.getLogger();
        this.remotePendingResumes = new ArrayList();
        this.lastDestMetrics = new Hashtable();
        this.localConsumerCreationReady = false;
        this.parent = null;
        this.busy = false;
        this.paused = false;
        this.flowPaused = false;
        this.flowCount = 0;
        this.active = true;
        this.valid = true;
        this.destroyLock = new Object();
        this.plock = new Object();
        this.plistener = null;
        this.mlistener = null;
        this.parentList = null;
        this.prefetch = -1;
        this.isFailover = false;
        this.position = 0;
        this.isSpecialRemote = false;
        this.parent = null;
        this.useConsumerFlowControl = false;
        this.stored_uid = null;
        this.active = true;
        this.pauseCnt = 0;
        try {
            this.selector = Consumer.getSelector(this.selstr);
        }
        catch (Exception exception) {
            this.logger.log(32, "Internal Error: bad stored selector[" + this.selstr + "], ignoring", (Throwable)exception);
            this.selector = null;
        }
        this.initInterest();
    }

    public boolean isBusy() {
        return this.busy;
    }

    public DestinationUID getDestinationUID() {
        return this.dest;
    }

    protected Consumer(ConsumerUID consumerUID) {
        this.uid = consumerUID;
    }

    public static Consumer newInstance(ConsumerUID consumerUID) {
        return new Consumer(consumerUID);
    }

    public Consumer(DestinationUID destinationUID, String string, boolean bl, ConnectionUID connectionUID) throws IOException, SelectorFormatException {
        this.dest = destinationUID;
        this.noLocal = bl;
        this.uid = new ConsumerUID();
        this.uid.setConnectionUID(connectionUID);
        this.selstr = string;
        this.selector = Consumer.getSelector(string);
        this.initInterest();
        this.logger.log(4, "Created new consumer " + this.uid + " on destination " + destinationUID + " with selector " + string);
    }

    public Consumer(DestinationUID destinationUID, String string, boolean bl, ConsumerUID consumerUID) throws IOException, SelectorFormatException {
        this.dest = destinationUID;
        this.noLocal = bl;
        this.uid = consumerUID;
        if (consumerUID == null) {
            this.uid = new ConsumerUID();
        }
        this.selstr = string;
        this.selector = Consumer.getSelector(string);
        this.initInterest();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Consumer newConsumer(DestinationUID destinationUID, String string, boolean bl, ConsumerUID consumerUID) throws IOException, SelectorFormatException, ConsumerAlreadyAddedException {
        Map map = consumers;
        synchronized (map) {
            if (consumers.get(consumerUID) != null) {
                throw new ConsumerAlreadyAddedException(Globals.getBrokerResources().getKString("B1331", consumerUID, destinationUID));
            }
            return new Consumer(destinationUID, string, bl, consumerUID);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void localConsumerCreationReady() {
        Map map = consumers;
        synchronized (map) {
            this.localConsumerCreationReady = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isLocalConsumerCreationReady() {
        Map map = consumers;
        synchronized (map) {
            return this.localConsumerCreationReady;
        }
    }

    public boolean isValid() {
        return this.valid;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void initInterest() {
        this.removeListener = new RemoveListener();
        this.busylistener = new BusyListener();
        this.evb = new EventBroadcastHelper();
        this.msgs = new NFLPriorityFifoSet(12, false);
        this.mlistener = this.msgs.addEventListener(this.busylistener, EventType.EMPTY, null);
        Map map = consumers;
        synchronized (map) {
            consumers.put(this.uid, this);
        }
        if (this.dest.isWildcard()) {
            wildcardConsumers.add(this.uid);
        }
    }

    public PacketReference peekNext() {
        PacketReference packetReference = (PacketReference)this.msgs.peekNext();
        if (packetReference == null && this.parentList != null) {
            packetReference = (PacketReference)this.parentList.peekNext();
        }
        return packetReference;
    }

    public void setAckMsgsOnDestroy(boolean bl) {
        this.ackMsgsOnDestroy = bl;
    }

    public ConsumerUID getConsumerUID() {
        return this.uid;
    }

    public void setStoredConsumerUID(ConsumerUID consumerUID) {
        this.stored_uid = consumerUID;
    }

    public ConsumerUID getStoredConsumerUID() {
        if (this.stored_uid == null) {
            return this.uid;
        }
        return this.stored_uid;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean routeMessages(Collection collection, boolean bl) {
        if (bl) {
            if (!this.valid) {
                return false;
            }
            this.msgs.addAllToFront(collection, 0);
            Object object = this.destroyLock;
            synchronized (object) {
                this.msgsToConsumer += collection.size();
            }
            this.checkState(null);
        } else {
            Iterator iterator = collection.iterator();
            while (iterator.hasNext()) {
                this.routeMessage((PacketReference)iterator.next(), false);
            }
        }
        return this.valid;
    }

    public boolean unrouteMessage(PacketReference packetReference) {
        boolean bl = this.msgs.remove((Object)packetReference);
        if (bl) {
            --this.msgsToConsumer;
        }
        return bl;
    }

    public boolean routeMessage(PacketReference packetReference, boolean bl) {
        return this.routeMessage(packetReference, bl, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean routeMessage(PacketReference packetReference, boolean bl, boolean bl2) {
        int n = 0;
        if (!bl && !bl2) {
            n = 11 - packetReference.getPriority();
        }
        ArrayList<PacketReference> arrayList = null;
        if (bl2) {
            arrayList = new ArrayList<PacketReference>();
            arrayList.add(packetReference);
        }
        Object object = this.destroyLock;
        synchronized (object) {
            if (!this.valid) {
                return false;
            }
            if (bl2) {
                this.msgs.addAllOrdered(arrayList);
            } else {
                this.msgs.add(n, (Object)packetReference);
            }
            ++this.msgsToConsumer;
        }
        this.checkState(null);
        if (arrayList != null) {
            arrayList.clear();
            arrayList = null;
        }
        return true;
    }

    public int size() {
        return this.msgs.size();
    }

    public int numInProcessMsgs() {
        int n = this.size();
        return n += this.numPendingAcks();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unloadMessages() {
        this.msgs.clear();
        Object object = this.destroyLock;
        synchronized (object) {
            this.msgsToConsumer = 0;
        }
    }

    public void attachToConnection(ConnectionUID connectionUID) {
        this.conuid = connectionUID;
        this.uid.setConnectionUID(connectionUID);
    }

    public void attachToSession(SessionUID sessionUID) {
        this.sessionuid = sessionUID;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void attachToDestination(Destination destination) {
        if (this.destinations == null) {
            this.destinations = new HashSet();
        }
        Set set = this.destinations;
        synchronized (set) {
            this.destinations.add(destination);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set getDestinations() {
        HashSet hashSet = null;
        if (this.destinations == null) {
            this.destinations = new HashSet();
            Set set = this.destinations;
            synchronized (set) {
                if (!this.dest.isWildcard()) {
                    this.destinations.add(Destination.getDestination(this.dest));
                } else {
                    List list = Destination.findMatchingIDs(this.dest);
                    for (DestinationUID destinationUID : list) {
                        this.destinations.add(Destination.getDestination(destinationUID));
                    }
                }
                hashSet = new HashSet(this.destinations);
            }
        }
        Set set = this.destinations;
        synchronized (set) {
            hashSet = new HashSet(this.destinations);
        }
        return hashSet;
    }

    public Destination getFirstDestination() {
        Iterator iterator = this.getDestinations().iterator();
        Destination destination = iterator.hasNext() ? iterator.next() : null;
        return destination;
    }

    public SessionUID getSessionUID() {
        return this.sessionuid;
    }

    public ConnectionUID getConnectionUID() {
        return this.conuid;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PacketReference getAndFillNextPacket(Packet packet) {
        Object object;
        Object object2;
        PacketReference packetReference = null;
        if (this.flowPaused || this.paused) {
            this.checkState(null);
            return null;
        }
        if (!this.valid) {
            return null;
        }
        if (!this.paused && this.msgs.isEmpty()) {
            this.getMoreMessages(this.prefetch <= 0 ? 1000 : this.prefetch);
        }
        Packet packet2 = null;
        while (this.valid && !this.paused && !this.msgs.isEmpty()) {
            block40: {
                int n;
                packetReference = (PacketReference)this.msgs.removeNext();
                if (packetReference == null || packetReference.isOverrided()) {
                    n = DEBUG_CLUSTER_MSG ? 8 : 4;
                    this.logger.log(n, packetReference == null ? "Consumer [" + this.getConsumerUID() + "] get message null reference" : "Consumer [" + this.getConsumerUID() + "] message requened: " + packetReference);
                    continue;
                }
                packet2 = packetReference.getPacket();
                if (packet2 != null && packetReference.checkRemovalAndSetInDelivery(this.getStoredConsumerUID())) break;
                try {
                    n = packetReference.isExpired() ? 1 : 0;
                    object2 = this.br.getKString("B1385", packetReference.getSysMessageID(), "[" + this.uid + ", " + this.uid.getAckMode() + "]" + this.dest);
                    object = this.br.getKString("B1386", packetReference.getSysMessageID(), "[" + this.uid + ", " + this.uid.getAckMode() + "]" + this.dest);
                    boolean bl = packetReference.isLocal();
                    if (packetReference.markDead(this.uid, this.getStoredConsumerUID(), (String)(bl ? object2 : object), null, n != 0 ? RemoveReason.EXPIRED_ON_DELIVERY : RemoveReason.REMOVED_OTHER, -1, null)) {
                        boolean bl2 = false;
                        Destination destination = Destination.getDestination(packetReference.getDestinationUID());
                        if (destination != null && (bl2 = packetReference.isDead() ? destination.removeDeadMessage(packetReference) : destination.removeMessage(packetReference.getSysMessageID(), (Reason)RemoveReason.REMOVED_OTHER, n == 0)) && n != 0) {
                            if (destination.getVerbose()) {
                                this.logger.log(8, (String)(bl ? object2 : object));
                            }
                        }
                    }
                }
                catch (Exception exception) {
                    if (packet2 == null || !DEBUG) break block40;
                    this.logger.logStack(8, "Unable to cleanup removed message " + packetReference + " for consumer " + this, (Throwable)exception);
                }
            }
            packetReference = null;
            packet2 = null;
        }
        if (!this.valid) {
            if (DEBUG_CLUSTER_MSG) {
                this.logger.log(8, "getAndFillNextPacket(): consumer " + this + " closed, discard ref " + packetReference);
            }
            return null;
        }
        if (packetReference == null) {
            this.checkState(null);
            return null;
        }
        packet2 = packetReference.getPacket();
        if (packet2 == null) {
            assert (false);
            return null;
        }
        if (packet != null) {
            try {
                packet.fill(packet2);
            }
            catch (IOException iOException) {
                this.logger.logStack(8, "Internal Exception processing packet ", (Throwable)iOException);
                return null;
            }
            packet.setConsumerID(this.uid.longValue());
            packet.setRedelivered(packetReference.getRedeliverFlag(this.getStoredConsumerUID()));
            if (packetReference.isLast(this.uid)) {
                packetReference.removeIsLast(this.uid);
                packet.setIsLast(true);
            }
            this.msgRetrieved();
            if (this.parent != null) {
                this.parent.msgRetrieved();
            }
        } else {
            packet2.setRedelivered(packetReference.getRedeliverFlag(this.getStoredConsumerUID()));
        }
        if (this.useConsumerFlowControl) {
            if (this.prefetch != -1) {
                ++this.flowCount;
            }
            if (!this.flowPaused && packetReference.getMessageDeliveredAck(this.uid)) {
                BrokerAddress brokerAddress = packetReference.getAddress();
                if (brokerAddress != null) {
                    object2 = this.remotePendingResumes;
                    synchronized (object2) {
                        this.remotePendingResumes.add(packetReference);
                    }
                }
                if (packet != null) {
                    packet.setConsumerFlow(true);
                }
            }
            if (this.prefetch > 0 && this.flowCount >= this.prefetch) {
                if (packet != null) {
                    packet.setConsumerFlow(true);
                }
                packetReference.addMessageDeliveredAck(this.uid);
                BrokerAddress brokerAddress = packetReference.getAddress();
                if (brokerAddress != null) {
                    object2 = this.remotePendingResumes;
                    synchronized (object2) {
                        this.remotePendingResumes.add(packetReference);
                    }
                }
                ++this.pauseFlowCnt;
                this.flowPaused = true;
            }
        } else if (packetReference.getMessageDeliveredAck(this.uid)) {
            HashMap<String, Integer> hashMap = null;
            object2 = this.getConnectionUID();
            if (object2 != null && (object = (IMQConnection)Globals.getConnectionManager().getConnection((ConnectionUID)((Object)object2))) != null) {
                hashMap = new HashMap<String, Integer>();
                hashMap.put(PREFETCH, new Integer(((IMQConnection)object).getFlowCount()));
            }
            try {
                Globals.getClusterBroadcast().acknowledgeMessage(packetReference.getAddress(), packetReference.getSysMessageID(), this.uid, 0, hashMap, false);
            }
            catch (BrokerException brokerException) {
                this.logger.log(4, "Can not send DELIVERED ack  received ", (Throwable)brokerException);
            }
            packetReference.removeMessageDeliveredAck(this.uid);
        }
        return packetReference;
    }

    public void purgeConsumer() throws BrokerException {
        RemoveReason removeReason = RemoveReason.ACKNOWLEDGED;
        HashSet hashSet = new HashSet(this.msgs);
        if (hashSet.isEmpty()) {
            return;
        }
        this.msgs.removeAll(hashSet, (Reason)removeReason);
        Iterator iterator = hashSet.iterator();
        while (iterator.hasNext()) {
            try {
                PacketReference packetReference = (PacketReference)iterator.next();
                if (!packetReference.acknowledged(this.getConsumerUID(), this.getStoredConsumerUID(), !this.uid.isUnsafeAck(), true)) continue;
                Destination destination = Destination.getDestination(packetReference.getDestinationUID());
                destination.removeMessage(packetReference.getSysMessageID(), removeReason);
            }
            catch (IOException iOException) {
                this.logger.log(16, "Internal Error: purging consumer " + this, (Throwable)iOException);
            }
        }
    }

    public boolean isWildcard() {
        return this.dest.isWildcard();
    }

    public void purgeConsumer(Filter filter) throws BrokerException {
        RemoveReason removeReason = RemoveReason.ACKNOWLEDGED;
        Set set = this.msgs.getAll(filter);
        this.msgs.removeAll((Collection)set, (Reason)removeReason);
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            try {
                PacketReference packetReference = (PacketReference)iterator.next();
                if (!packetReference.acknowledged(this.getConsumerUID(), this.getStoredConsumerUID(), !this.uid.isUnsafeAck(), true)) continue;
                Destination destination = Destination.getDestination(packetReference.getDestinationUID());
                destination.removeMessage(packetReference.getSysMessageID(), removeReason);
            }
            catch (IOException iOException) {
                this.logger.log(16, "Internal Error: Problem purging consumer " + this, (Throwable)iOException);
            }
        }
    }

    public void activate() {
        this.active = true;
        this.checkState(null);
    }

    public void deactive() {
        this.active = false;
        this.checkState(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void pause(String string) {
        NFLPriorityFifoSet nFLPriorityFifoSet = this.msgs;
        synchronized (nFLPriorityFifoSet) {
            this.paused = true;
            ++this.pauseCnt;
            if (DEBUG) {
                this.logger.log(4, "Pausing consumer " + this + "[" + this.pauseCnt + "] " + string);
            }
        }
        this.checkState(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resume(String string) {
        NFLPriorityFifoSet nFLPriorityFifoSet = this.msgs;
        synchronized (nFLPriorityFifoSet) {
            --this.pauseCnt;
            if (this.pauseCnt <= 0) {
                this.paused = false;
            }
            if (DEBUG) {
                this.logger.log(4, "Pausing consumer " + this + "[" + this.pauseCnt + "] " + string);
            }
        }
        this.checkState(null);
    }

    public void setFalconRemote(boolean bl) {
        this.isSpecialRemote = bl;
    }

    public boolean isFalconRemote() {
        return this.isSpecialRemote;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int checkIfMsgsInRateGTOutRate(Destination destination) {
        Subscription subscription = this.getSubscription();
        if (!(Destination.CHECK_MSGS_RATE_FOR_ALL || subscription != null && subscription.getShared() && !subscription.isDurable())) {
            return 2;
        }
        if (Destination.CHECK_MSGS_RATE_AT_DEST_CAPACITY_RATIO < 0) {
            return 2;
        }
        float f = Math.max(Destination.totalCountPercent(), destination.destMessagesSizePercent());
        if (f < (float)Destination.CHECK_MSGS_RATE_AT_DEST_CAPACITY_RATIO) {
            return 2;
        }
        Hashtable hashtable = this.lastDestMetrics;
        synchronized (hashtable) {
            DestinationUID destinationUID = destination.getDestinationUID();
            long[] lArray = (long[])this.lastDestMetrics.get(destinationUID);
            if (lArray == null) {
                lArray = new long[6];
                destination.checkIfMsgsInRateGTOutRate(lArray, true);
                this.lastDestMetrics.put(destinationUID, lArray);
                return 1;
            }
            return destination.checkIfMsgsInRateGTOutRate(lArray, false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getMsgOutTimeMillis(Destination destination) {
        Hashtable hashtable = this.lastDestMetrics;
        synchronized (hashtable) {
            DestinationUID destinationUID = destination.getDestinationUID();
            long[] lArray = (long[])this.lastDestMetrics.get(destinationUID);
            if (lArray == null) {
                lArray = new long[6];
                destination.checkIfMsgsInRateGTOutRate(lArray, true);
                this.lastDestMetrics.put(destinationUID, lArray);
                return -1L;
            }
            destination.checkIfMsgsInRateGTOutRate(lArray, false);
            return lArray[5];
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resumeFlow() {
        ArrayList arrayList = this.remotePendingResumes;
        synchronized (arrayList) {
            if (!this.remotePendingResumes.isEmpty()) {
                Iterator iterator = this.remotePendingResumes.iterator();
                while (iterator.hasNext()) {
                    PacketReference packetReference = (PacketReference)iterator.next();
                    try {
                        Globals.getClusterBroadcast().acknowledgeMessage(packetReference.getAddress(), packetReference.getSysMessageID(), this.uid, 0, null, false);
                    }
                    catch (BrokerException brokerException) {
                        this.logger.log(4, "Can not send DELIVERED ack  received ", (Throwable)brokerException);
                    }
                    iterator.remove();
                }
            }
        }
        if (this.flowPaused) {
            ++this.resumeFlowCnt;
            this.flowCount = 0;
            this.flowPaused = false;
            this.checkState(null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void resumeRemoteFlow(int n) {
        ArrayList arrayList = this.remotePendingResumes;
        synchronized (arrayList) {
            if (!this.remotePendingResumes.isEmpty()) {
                SubSet subSet = this.parentList;
                boolean bl = subSet == null || subSet.isEmpty();
                int n2 = this.remotePendingResumes.size();
                int n3 = n;
                if (n > 0 && n3 != 1 && (n3 = n / (n2 + (bl ? 0 : 1))) == 0) {
                    n3 = 1;
                }
                int n4 = n3;
                int n5 = 0;
                BrokerAddress brokerAddress = null;
                ArrayList<BrokerAddress> arrayList2 = new ArrayList<BrokerAddress>();
                Destination destination = null;
                PacketReference packetReference = null;
                HashMap<String, Integer> hashMap = null;
                long l = -1L;
                long l2 = -1L;
                long l3 = -1L;
                Iterator iterator = this.remotePendingResumes.iterator();
                while (iterator.hasNext()) {
                    packetReference = (PacketReference)iterator.next();
                    brokerAddress = packetReference.getAddress();
                    if (arrayList2.contains(brokerAddress)) {
                        iterator.remove();
                        continue;
                    }
                    n4 = n3;
                    l3 = -1L;
                    l2 = -1L;
                    l = -1L;
                    hashMap = new HashMap<String, Integer>();
                    destination = Destination.findDestination(packetReference.getDestinationUID());
                    try {
                        l = Destination.checkSystemLimit(packetReference);
                    }
                    catch (Throwable throwable) {
                        l = 0L;
                    }
                    if (destination != null) {
                        l2 = destination.checkDestinationCapacity(packetReference);
                    }
                    if ((l3 = l >= 0L && l2 >= 0L ? Math.min(l, l2) : (l >= 0L ? l : l2)) == 0L) {
                        l3 = 1L;
                    }
                    n4 = n3;
                    if (l3 > 0L) {
                        n4 = (int)(l3 - (long)n5);
                        if (n4 <= 0) {
                            n4 = 1;
                        } else {
                            int n6 = this.checkIfMsgsInRateGTOutRate(destination);
                            if (n6 == 0) {
                                n4 = 1;
                            } else if (n6 == 1) {
                                n4 = 1;
                            }
                        }
                        if (n3 > 0 && (n4 = Math.min(n3, n4)) <= 0) {
                            n4 = 1;
                        }
                    }
                    try {
                        hashMap.put(PREFETCH, new Integer(n4));
                        Globals.getClusterBroadcast().acknowledgeMessage(brokerAddress, packetReference.getSysMessageID(), this.uid, 0, hashMap, false);
                        if (brokerAddress != null) {
                            arrayList2.add(brokerAddress);
                        }
                        n5 += n4;
                        iterator.remove();
                    }
                    catch (BrokerException brokerException) {
                        this.logger.log(4, "Can not send DELIVERED ack  received ", (Throwable)brokerException);
                    }
                }
            }
        }
    }

    public void resumeFlow(int n) {
        this.resumeRemoteFlow(n);
        this.setPrefetch(n);
        if (this.flowPaused) {
            ++this.resumeFlowCnt;
            this.flowCount = 0;
            this.flowPaused = false;
            this.checkState(null);
        }
    }

    public boolean isActive() {
        return this.active;
    }

    public boolean isPaused() {
        return this.paused;
    }

    public String getSelectorStr() {
        return this.selstr;
    }

    public Selector getSelector() {
        return this.selector;
    }

    public boolean getNoLocal() {
        return this.noLocal;
    }

    public Object addEventListener(EventListener eventListener, EventType eventType, Object object) throws UnsupportedOperationException {
        if (eventType != EventType.BUSY_STATE_CHANGED) {
            throw new UnsupportedOperationException("Only Busy State Changed notifications supported on this class");
        }
        return this.evb.addEventListener(eventListener, eventType, object);
    }

    public Object addEventListener(EventListener eventListener, EventType eventType, Reason reason, Object object) throws UnsupportedOperationException {
        if (eventType != EventType.BUSY_STATE_CHANGED) {
            throw new UnsupportedOperationException("Only Busy State Changed notifications supported on this class");
        }
        return this.evb.addEventListener(eventListener, eventType, reason, object);
    }

    public Object removeEventListener(Object object) {
        return this.evb.removeEventListener(object);
    }

    private void notifyChange(EventType eventType, Reason reason, Object object, Object object2, Object object3) {
        this.evb.notifyChange(eventType, reason, object, object2, object3);
    }

    public void dump(String string) {
        if (string == null) {
            string = "";
        }
        this.logger.log(8, string + "Consumer: " + this.uid + " [paused, active," + "flowPaused, parentBusy, hasMessages, parentSize ] = [" + this.paused + "," + this.active + "," + this.flowPaused + "," + this.getParentBusy() + "," + (this.msgs == null || !this.msgs.isEmpty()) + "," + (this.parentList == null ? 0 : this.parentList.size()) + "]");
        this.logger.log(8, string + "Busy state [" + this.uid + "] is " + this.busy);
        if (this.msgs == null) {
            this.logger.log(8, "msgs is null");
        } else {
            this.logger.log(8, this.msgs.toDebugString());
        }
        if (this.parentList == null) {
            this.logger.log(8, "parentList is null");
        } else {
            this.logger.log(8, this.parentList.toDebugString());
        }
    }

    public static Hashtable getAllDebugState() {
        Hashtable<String, Object> hashtable = new Hashtable<String, Object>();
        hashtable.put("FlowControlAllowed", String.valueOf(C_FLOW_CONTROL_ALLOWED));
        hashtable.put("ConsumerCnt", String.valueOf(consumers.size()));
        Iterator iterator = Consumer.getAllConsumers();
        while (iterator.hasNext()) {
            Consumer consumer = (Consumer)iterator.next();
            hashtable.put("Consumer[" + consumer.getConsumerUID().longValue() + "]", consumer.getDebugState());
        }
        return hashtable;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Hashtable getDebugState() {
        Object object;
        Object object22;
        Hashtable<String, Object> hashtable = new Hashtable<String, Object>();
        hashtable.put("ConsumerUID", String.valueOf(this.uid.longValue()));
        hashtable.put("Broker", this.uid.getBrokerAddress() == null ? "NONE" : this.uid.getBrokerAddress().toString());
        hashtable.put("msgsToConsumer", String.valueOf(this.msgsToConsumer));
        hashtable.put("StoredConsumerUID", String.valueOf(this.getStoredConsumerUID().longValue()));
        hashtable.put("ConnectionUID", this.conuid == null ? "none" : String.valueOf(this.conuid.longValue()));
        hashtable.put("type", "CONSUMER");
        hashtable.put("valid", String.valueOf(this.valid));
        hashtable.put("paused", String.valueOf(this.paused));
        hashtable.put("pauseCnt", String.valueOf(this.pauseCnt));
        hashtable.put("noLocal", String.valueOf(this.noLocal));
        hashtable.put("destinationUID", this.dest.toString());
        hashtable.put("busy", String.valueOf(this.busy));
        if (this.parent != null) {
            hashtable.put("Subscription", String.valueOf(this.parent.getConsumerUID().longValue()));
        }
        hashtable.put("isSpecialRemote", String.valueOf(this.isSpecialRemote));
        hashtable.put("ackMsgsOnDestroy", String.valueOf(this.ackMsgsOnDestroy));
        hashtable.put("position", String.valueOf(this.position));
        hashtable.put("active", String.valueOf(this.active));
        hashtable.put("flowCount", String.valueOf(this.flowCount));
        hashtable.put("flowPaused", String.valueOf(this.flowPaused));
        hashtable.put("pauseFlowCnt", String.valueOf(this.pauseFlowCnt));
        hashtable.put("resumeFlowCnt", String.valueOf(this.resumeFlowCnt));
        hashtable.put("useConsumerFlowControl", String.valueOf(this.useConsumerFlowControl));
        hashtable.put("selstr", this.selstr == null ? "none" : this.selstr);
        SubSet subSet = null;
        Object object3 = null;
        Vector<Object> vector = this.plock;
        synchronized (vector) {
            subSet = this.parentList;
            object3 = this.plistener;
        }
        if (subSet == null) {
            hashtable.put("parentList", "null");
        } else {
            hashtable.put("parentList.isEmpty", subSet.isEmpty());
            if (Destination.DEBUG_LISTS) {
                hashtable.put("parentList.size", subSet.size());
                hashtable.put("parentList", subSet.toDebugString());
            }
        }
        if (object3 == null) {
            hashtable.put("plistener", "null");
        } else {
            hashtable.put("plistener", object3.toString());
        }
        hashtable.put(PREFETCH, String.valueOf(this.prefetch));
        hashtable.put("remotePrefetch", String.valueOf(this.remotePrefetch));
        hashtable.put("parentBusy", String.valueOf(this.getParentBusy()));
        hashtable.put("hasMessages", String.valueOf(!this.msgs.isEmpty()));
        hashtable.put("msgsSize", String.valueOf(this.msgs.size()));
        if (Destination.DEBUG_LISTS) {
            hashtable.put("msgs", this.msgs.toDebugString());
        }
        hashtable.put("isFailover", String.valueOf(this.isFailover));
        hashtable.put("localConsumerCreationReady", String.valueOf(this.localConsumerCreationReady));
        vector = new Vector<Object>();
        ArrayList arrayList = null;
        Iterator iterator = this.remotePendingResumes;
        synchronized (iterator) {
            arrayList = new ArrayList(this.remotePendingResumes);
        }
        for (Object object22 : arrayList) {
            object = ((PacketReference)object22).getAddress() + ": " + object22;
            vector.add(object);
        }
        hashtable.put("remotePendingResumes", vector);
        object22 = new Vector();
        object = this.lastDestMetrics;
        synchronized (object) {
            for (DestinationUID destinationUID : this.lastDestMetrics.keySet()) {
                long[] lArray = (long[])this.lastDestMetrics.get(destinationUID);
                String string = destinationUID + ": " + "ins=" + lArray[0] + "|outs=" + lArray[1] + "|time=" + lArray[2] + "|inr=" + lArray[3] + "|outr=" + lArray[4] + "|outt=" + lArray[5];
                ((Vector)object22).add(string);
            }
        }
        hashtable.put("lastDestMetrics", object22);
        return hashtable;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Vector getDebugMessages(boolean bl) {
        Vector<String> vector = new Vector<String>();
        NFLPriorityFifoSet nFLPriorityFifoSet = this.msgs;
        synchronized (nFLPriorityFifoSet) {
            for (PacketReference packetReference : this.msgs) {
                vector.add(bl ? packetReference.getPacket().dumpPacketString() : packetReference.getPacket().toString());
            }
        }
        return vector;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkState(Reason reason) {
        boolean bl = false;
        boolean bl2 = false;
        NFLPriorityFifoSet nFLPriorityFifoSet = this.msgs;
        synchronized (nFLPriorityFifoSet) {
            bl = !this.paused && this.active && !this.flowPaused && (this.getParentBusy() && !this.isFailover || !this.msgs.isEmpty());
            bl2 = bl != this.busy;
            this.busy = bl;
        }
        if (bl2) {
            this.notifyChange(EventType.BUSY_STATE_CHANGED, reason, this, !bl, bl);
        }
    }

    public String toString() {
        String string = "Consumer - " + this.dest + ":" + this.getConsumerUID();
        return string;
    }

    public void debug(String string) {
        if (string == null) {
            string = "";
        }
        this.logger.log(8, string + this.toString());
        String string2 = string + "\t";
        this.logger.log(8, string2 + "Selector = " + this.selector);
        this.logger.log(8, string2 + "msgs = " + this.msgs.size());
        this.logger.log(8, string2 + "parentList = " + (this.parentList == null ? 0 : this.parentList.size()));
        this.logger.log(8, string2 + "parent = " + this.parent);
        this.logger.log(8, string2 + "valid = " + this.valid);
        this.logger.log(8, string2 + "active = " + this.active);
        this.logger.log(8, string2 + "paused = " + this.paused);
        this.logger.log(8, string2 + "pauseCnt = " + this.pauseCnt);
        this.logger.log(8, string2 + "noLocal = " + this.noLocal);
        this.logger.log(8, string2 + "busy = " + this.busy);
        this.logger.log(8, string2 + "flowPaused = " + this.flowPaused);
        this.logger.log(8, string2 + "prefetch = " + this.prefetch);
        this.logger.log(8, string2 + this.msgs.toDebugString());
    }

    public void setCapacity(int n) {
        this.msgs.setCapacity(n);
    }

    public void setByteCapacity(long l) {
        this.msgs.setByteCapacity(l);
    }

    public int capacity() {
        return this.msgs.capacity();
    }

    public long byteCapacity() {
        return this.msgs.byteCapacity();
    }

    public static void clearAllConsumers() {
        consumers.clear();
        wildcardConsumers.clear();
    }

    public static Iterator getAllConsumers() {
        return Consumer.getAllConsumers(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Iterator getAllConsumers(boolean bl) {
        Map map = consumers;
        synchronized (map) {
            HashSet hashSet = new HashSet(consumers.values());
            if (bl) {
                return hashSet.iterator();
            }
            Consumer consumer = null;
            Iterator iterator = hashSet.iterator();
            while (iterator.hasNext()) {
                consumer = (Consumer)iterator.next();
                if (consumer instanceof Subscription || consumer.isLocalConsumerCreationReady()) continue;
                iterator.remove();
            }
            return hashSet.iterator();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Iterator getWildcardConsumers() {
        Map map = consumers;
        synchronized (map) {
            return new HashSet(wildcardConsumers).iterator();
        }
    }

    public static int getNumConsumers() {
        return consumers.size();
    }

    public static int getNumWildcardConsumers() {
        return wildcardConsumers.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Consumer getConsumer(ConsumerUID consumerUID) {
        Map map = consumers;
        synchronized (map) {
            Consumer consumer = (Consumer)consumers.get(consumerUID);
            return consumer;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Consumer getConsumer(String string) {
        if (string == null) {
            return null;
        }
        Map map = consumers;
        synchronized (map) {
            for (Consumer consumer : consumers.values()) {
                if (!string.equals(consumer.getCreator())) continue;
                return consumer;
            }
        }
        return null;
    }

    public void setLockPosition(int n) {
        this.lockPosition = n;
    }

    public int getLockPosition() {
        return this.lockPosition;
    }

    public void recreationRequested() {
        this.requestedRecreation = true;
    }

    protected boolean tobeRecreated() {
        return this.requestedRecreation;
    }

    class BusyListener
    implements EventListener {
        BusyListener() {
        }

        public void eventOccured(EventType eventType, Reason reason, Object object, Object object2, Object object3, Object object4) {
            assert (eventType == EventType.EMPTY);
            assert (object3 instanceof Boolean);
            Consumer.this.checkState(null);
        }
    }

    class RemoveListener
    implements EventListener {
        RemoveListener() {
        }

        public void eventOccured(EventType eventType, Reason reason, Object object, Object object2, Object object3, Object object4) {
            assert (eventType == EventType.SET_CHANGED_REQUEST);
            if (!(reason instanceof RemoveReason)) {
                return;
            }
            assert (reason != RemoveReason.UNLOADED);
            assert (reason != RemoveReason.ROLLBACK);
            assert (reason != RemoveReason.DELIVERED);
            assert (reason != RemoveReason.ACKNOWLEDGED);
            assert (reason != RemoveReason.ROLLBACK);
            assert (reason != RemoveReason.OVERFLOW);
            assert (reason != RemoveReason.ERROR);
            PacketReference packetReference = (PacketReference)object2;
            Consumer.this.msgs.remove((Object)packetReference);
        }
    }
}

