/*
 * Decompiled with CFR 0.152.
 */
package org.nbheaven.sqe.core.ui.components.toolbar;

import java.awt.Component;
import java.util.logging.Logger;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.JButton;
import javax.swing.JToolBar;
import org.openide.awt.Actions;
import org.openide.util.ContextAwareAction;
import org.openide.util.Lookup;
import org.openide.util.LookupEvent;
import org.openide.util.LookupListener;
import org.openide.util.Mutex;
import org.openide.util.actions.Presenter;
import org.openide.util.lookup.Lookups;

public class ToolBarFromLayer {
    private ToolBarFromLayer() {
    }

    public static void connect(final JToolBar toolBar, String path, final Lookup context, final boolean largeIcons) {
        final Lookup.Result actions = Lookups.forPath((String)path).lookupResult(Object.class);
        LookupListener listener = new LookupListener(){

            public void resultChanged(LookupEvent ev) {
                Mutex.EVENT.readAccess(new Runnable(){

                    public void run() {
                        toolBar.removeAll();
                        for (Object item : actions.allInstances()) {
                            Component c;
                            if (context != null && item instanceof ContextAwareAction) {
                                item = ((ContextAwareAction)item).createContextAwareInstance(context);
                            }
                            if (item instanceof Presenter.Toolbar) {
                                c = ((Presenter.Toolbar)item).getToolbarPresenter();
                            } else if (item instanceof Action) {
                                JButton button = new JButton();
                                Actions.connect((AbstractButton)button, (Action)((Action)item));
                                if (largeIcons) {
                                    button.putClientProperty("PreferredIconSize", 24);
                                }
                                c = button;
                            } else if (item instanceof Component) {
                                c = (Component)item;
                            } else {
                                if (item == null) continue;
                                Logger.getLogger(ToolBarFromLayer.class.getName()).warning("Unknown object: " + item);
                                continue;
                            }
                            toolBar.add(c);
                        }
                    }
                });
            }
        };
        actions.addLookupListener(listener);
        toolBar.putClientProperty("actionsLookupResult", actions);
        listener.resultChanged(null);
    }
}

