/*
 * Decompiled with CFR 0.152.
 */
package org.nbheaven.sqe.core.ui.components.filter;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.text.MessageFormat;
import java.util.ResourceBundle;
import java.util.Vector;
import java.util.regex.PatternSyntaxException;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JSeparator;
import javax.swing.MenuElement;
import javax.swing.MenuSelectionManager;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.JTextComponent;
import org.nbheaven.sqe.core.ui.components.filter.ArrowSignIcon;
import org.nbheaven.sqe.core.ui.components.filter.ButtonBorderIcon;
import org.nbheaven.sqe.core.ui.components.filter.FilterChangedListener;
import org.nbheaven.sqe.core.ui.components.filter.FilterType;
import org.nbheaven.sqe.core.ui.components.filter.StringComboBox;

public class JFilter
extends JPanel {
    private static final ResourceBundle messages = ResourceBundle.getBundle("org.nbheaven.sqe.core.ui.components.filter.Bundle");
    private static final String DEFAULT_TEXTFIELD_STRING = messages.getString("FilterComponent_DefaultTextFieldString");
    private static final String INVALID_REGEXP_STRING = messages.getString("FilterComponent_InvalidRegExpString");
    private static final String FILTER_TYPE_TOOLTIP = messages.getString("FilterComponent_FilterTypeToolTip");
    private static final String FILTER_VALUE_TOOLTIP = messages.getString("FilterComponent_FilterValueToolTip");
    private static final String SET_FILTER_BUTTON_TOOLTIP = messages.getString("FilterComponent_SetFilterButtonToolTip");
    private static final String CLEAR_FILTER_BUTTON_TOOLTIP = messages.getString("FilterComponent_ClearFilterButtonToolTip");
    private static final String FILTER_STRING_COMBO_ACCESS_NAME = messages.getString("FilterComponent_FilterStringComboAccessName");
    private static final String FILTER_STRING_COMBO_ACCESS_DESCR = messages.getString("FilterComponent_FilterStringComboAccessDescr");
    private static final String ACCESS_NAME = messages.getString("FilterComponent_AccessName");
    private static final String ACCESS_DESCR = messages.getString("FilterComponent_AccessDescr");
    private static final Color DEFAULT_TEXTFIELD_FOREGROUND = Color.GRAY;
    private static final String EMPTY_STRING = "";
    private final ImageIcon setFilterIcon = new ImageIcon(this.getClass().getResource("/org/nbheaven/sqe/core/ui/components/resources/setFilter.png"));
    private final Icon setFilterRolloverIcon = new ButtonBorderIcon(this.setFilterIcon);
    private final ImageIcon clearFilterIcon = new ImageIcon(this.getClass().getResource("/org/nbheaven/sqe/core/ui/components/resources/clearFilter.png"));
    private final Icon clearFilterRolloverIcon = new ButtonBorderIcon(this.clearFilterIcon);
    private Color textFieldForeground;
    private JButton clearFilterButton;
    private JButton filterTypeButton;
    private JButton setFilterButton;
    private StringComboBox filterStringCombo;
    private JLabel incorrectRegExpLabel;
    private JMenuItem activeFilterItem;
    private JPanel setClearFilterButtonsPanel;
    private JPanel textFieldRegExpWarningPanel;
    private JPopupMenu filterTypePopup;
    private PopupItemsListener popupItemsListener;
    private String filterString = "";
    private String textFieldEmptyText = DEFAULT_TEXTFIELD_STRING;
    private Vector<String> filterNames;
    private Vector<String> filterStringsBuffer;
    private Vector<FilterType> filterTypes;
    private Vector<FilterChangedListener> listeners;
    private Vector<Icon> rolloverIcons;
    private Vector<Icon> standardIcons;
    private boolean internalChange = false;
    private boolean textFieldEmptyFlag = true;
    private boolean validRegExpFlag = true;
    private FilterType defaultFilterType = FilterType.NONE;
    private FilterType filterType = FilterType.NONE;
    private FilterType lastFilterType;
    private int nOwnComboItems = 0;

    public JFilter() {
        this.listeners = new Vector();
        this.popupItemsListener = new PopupItemsListener();
        this.standardIcons = new Vector();
        this.rolloverIcons = new Vector();
        this.filterNames = new Vector();
        this.filterTypes = new Vector();
        this.filterStringsBuffer = new Vector();
        this.lastFilterType = FilterType.UNDEFINED;
        this.initComponents();
        this.checkRegExp();
        this.updateSetClearButtons();
    }

    public FilterType getDefaultFilterType() {
        return this.defaultFilterType;
    }

    public void setEmptyFilterText(String text) {
        if (text.length() == 0) {
            return;
        }
        String oldTextFieldEmptyText = this.textFieldEmptyText;
        this.textFieldEmptyText = text;
        if (this.filterStringCombo.getText().equals(oldTextFieldEmptyText)) {
            this.filterStringCombo.setText(this.textFieldEmptyText);
        }
    }

    public void setFilterString(String string) {
        this.setFilterString(string, true);
    }

    public String getFilterString() {
        return this.filterString;
    }

    public String[] getFilterStrings() {
        return JFilter.getFilterStrings(this.filterString);
    }

    public static String[] getFilterStrings(String string) {
        if (string == null) {
            return null;
        }
        return string.trim().split(" +");
    }

    public void setDefaultFilterType(FilterType filterType) {
        this.defaultFilterType = filterType;
        this.performClearFilterButtonAction();
    }

    public void setFilterType(FilterType filterType) {
        this.setFilterType(filterType, false);
    }

    public FilterType getFilterType() {
        return this.filterType;
    }

    public void setFilterValues(String string, FilterType filterType) {
        this.setFilterString(string, false);
        this.setFilterType(filterType, false);
        this.fireFilterChanged();
        this.updateSetClearButtons();
    }

    public void addFilterItem(FilterType ... filterTypes) {
        for (FilterType filterType : filterTypes) {
            this.addFilterItem(filterType.getIcon(), filterType.getDisplayName(), filterType);
        }
    }

    public void addFilterItem(ImageIcon icon, String filterName, FilterType filterType) {
        ImageIcon standardIcon = icon;
        ButtonBorderIcon rolloverIcon = new ButtonBorderIcon(icon);
        this.standardIcons.add(standardIcon);
        this.rolloverIcons.add(rolloverIcon);
        this.filterNames.add(filterName);
        this.filterTypes.add(filterType);
        JMenuItem menuItem = new JMenuItem();
        menuItem.setText(filterName);
        menuItem.setIcon(standardIcon);
        menuItem.setBackground(Color.WHITE);
        menuItem.addActionListener(this.popupItemsListener);
        this.filterTypePopup.add(menuItem);
        this.filterTypePopup.pack();
        this.setFilterTypePopupItemActive(menuItem, false);
    }

    public void addFilterListener(FilterChangedListener listener) {
        if (!this.listeners.contains(listener)) {
            this.listeners.add(listener);
        }
    }

    public JSeparator addSeparatorItem() {
        this.standardIcons.add(null);
        this.rolloverIcons.add(null);
        this.filterNames.add(null);
        this.filterTypes.add(null);
        JPopupMenu.Separator separator = new JPopupMenu.Separator();
        separator.setForeground(Color.BLACK);
        separator.setBackground(Color.WHITE);
        this.filterTypePopup.add(separator);
        this.filterTypePopup.pack();
        return separator;
    }

    public void removeFilterListener(FilterChangedListener listener) {
        if (this.listeners.contains(listener)) {
            this.listeners.remove(listener);
        }
    }

    private JMenuItem getFilterMenuItemByIndex(int index) {
        if (index < this.filterTypePopup.getComponentCount()) {
            return (JMenuItem)this.filterTypePopup.getComponent(index);
        }
        return null;
    }

    private void setFilterString(String string, boolean fireChange) {
        if (string == null) {
            return;
        }
        if (!this.filterString.equals(string = string.trim())) {
            this.filterString = string;
            this.filterStringCombo.setText(this.filterString);
            this.internalChange = true;
            this.addComboBoxItem(this.filterString);
            this.internalChange = false;
            if (fireChange) {
                boolean textFieldEmptyFlagBkp = this.textFieldEmptyFlag;
                this.textFieldEmptyFlag = false;
                this.fireFilterChanged();
                this.checkRegExp();
                this.updateSetClearButtons();
                this.textFieldEmptyFlag = textFieldEmptyFlagBkp;
            }
            if (this.filterString.length() > 0) {
                this.doFocusGained();
            } else {
                this.doFocusLost();
            }
        }
    }

    private void setFilterType(FilterType filterType, boolean fireChange) {
        if (this.filterType != filterType) {
            for (int i = 0; i < this.filterTypes.size(); ++i) {
                FilterType t = this.filterTypes.get(i);
                if (t == null || t != filterType) continue;
                this.setFilterTypePopupItemActive(i, fireChange);
                return;
            }
        }
    }

    private void setFilterTypePopupItemActive(JMenuItem menuItem, boolean fireChange) {
        int index = this.filterTypePopup.getComponentIndex(menuItem);
        if (index != -1) {
            this.setFilterTypePopupItemActive(index, fireChange);
        }
    }

    private void setFilterTypePopupItemActive(int index, boolean fireChange) {
        FilterType newFilterType = this.filterTypes.get(index);
        if (newFilterType != this.filterType) {
            this.activeFilterItem = this.getFilterMenuItemByIndex(index);
            this.filterType = newFilterType;
            ArrowSignIcon standardIcon = new ArrowSignIcon((ImageIcon)this.standardIcons.get(index));
            ButtonBorderIcon rolloverIcon = new ButtonBorderIcon(standardIcon);
            String filterName = this.filterNames.get(index);
            this.filterTypeButton.setIcon(standardIcon);
            this.filterTypeButton.setRolloverIcon(rolloverIcon);
            this.filterTypeButton.setToolTipText(MessageFormat.format(FILTER_TYPE_TOOLTIP, filterName));
            this.checkRegExp();
            if (fireChange) {
                this.fireFilterChanged();
            }
            this.updateSetClearButtons();
            this.updateComboItems();
        }
    }

    private int getIndexByCurrentFilterType() {
        return this.getIndexByFilterType(this.filterType);
    }

    private int getIndexByFilterType(FilterType type) {
        for (int i = 0; i < this.filterTypes.size(); ++i) {
            FilterType filterType = this.filterTypes.get(i);
            if (filterType == null || filterType != type) continue;
            return i;
        }
        return -1;
    }

    private void addComboBoxItem(String string) {
        if (string == null || string.length() == 0) {
            return;
        }
        if (this.filterStringsBuffer.contains(string)) {
            this.filterStringsBuffer.remove(string);
        }
        this.filterStringsBuffer.add(string);
        this.updateComboItems();
    }

    private void checkRegExp() {
        if (this.filterType != FilterType.REGEXP || this.textFieldEmptyFlag) {
            this.validRegExpFlag = true;
        } else {
            try {
                String[] filters;
                for (String filter : filters = JFilter.getFilterStrings(this.filterStringCombo.getText())) {
                    EMPTY_STRING.matches(filter);
                }
                this.validRegExpFlag = true;
            }
            catch (PatternSyntaxException e) {
                this.validRegExpFlag = false;
            }
        }
    }

    private void doFocusGained() {
        this.textFieldEmptyFlag = false;
        this.filterStringCombo.comboEditor.setForeground(this.textFieldForeground);
        if (this.filterStringCombo.getText().equals(this.textFieldEmptyText)) {
            this.filterStringCombo.setText(EMPTY_STRING);
        }
    }

    private void doFocusLost() {
        if (this.filterStringCombo.getText().length() == 0 && this.filterString.length() == 0) {
            this.textFieldEmptyFlag = true;
            this.filterStringCombo.setText(this.textFieldEmptyText);
            this.filterStringCombo.comboEditor.setForeground(DEFAULT_TEXTFIELD_FOREGROUND);
        }
    }

    private void fireFilterChanged() {
        if (this.validRegExpFlag) {
            for (int i = 0; i < this.listeners.size(); ++i) {
                this.listeners.elementAt(i).filterChanged();
            }
        }
        this.lastFilterType = this.filterType;
    }

    private void initComponents() {
        SetClearButtonsActionListener setClearButtonsActionListner = new SetClearButtonsActionListener();
        this.filterStringCombo = new StringComboBox();
        this.filterStringCombo.setEditable(true);
        this.filterStringCombo.setMaximumRowCount(7);
        this.filterStringCombo.addActionListener(new FilterStringComboActionListener());
        this.filterStringCombo.getAccessibleContext().setAccessibleName(FILTER_STRING_COMBO_ACCESS_NAME);
        this.filterStringCombo.getAccessibleContext().setAccessibleDescription(FILTER_STRING_COMBO_ACCESS_DESCR);
        this.filterStringCombo.setToolTipText(FILTER_VALUE_TOOLTIP);
        JTextComponent filterStringComboEditor = this.filterStringCombo.comboEditor;
        Color textFieldBackground = filterStringComboEditor.getBackground();
        this.textFieldForeground = filterStringComboEditor.getForeground();
        this.filterStringCombo.setBackground(textFieldBackground);
        filterStringComboEditor.setForeground(DEFAULT_TEXTFIELD_FOREGROUND);
        filterStringComboEditor.setText(this.textFieldEmptyText);
        filterStringComboEditor.getDocument().addDocumentListener(new FilterTextFieldDocumentListener());
        filterStringComboEditor.addKeyListener(new FilterTextFieldKeyListener());
        filterStringComboEditor.addFocusListener(new FilterTextFieldFocusListener());
        this.filterTypeButton = new JButton(EMPTY_STRING);
        this.filterTypeButton.setFocusable(false);
        this.filterTypeButton.setBorder(BorderFactory.createEmptyBorder());
        this.filterTypeButton.setBackground(textFieldBackground);
        this.filterTypeButton.setContentAreaFilled(false);
        this.filterTypeButton.addMouseListener(new FilterTypeButtonMouseListener());
        this.incorrectRegExpLabel = new JLabel(INVALID_REGEXP_STRING);
        this.incorrectRegExpLabel.setBorder(BorderFactory.createEmptyBorder(0, 3, 0, 0));
        this.incorrectRegExpLabel.setBackground(textFieldBackground);
        this.incorrectRegExpLabel.setForeground(Color.RED);
        this.textFieldRegExpWarningPanel = new JPanel(new BorderLayout(0, 0));
        this.textFieldRegExpWarningPanel.setBackground(textFieldBackground);
        this.textFieldRegExpWarningPanel.add((Component)this.filterStringCombo, "Center");
        this.textFieldRegExpWarningPanel.add((Component)this.incorrectRegExpLabel, "East");
        this.setFilterButton = new JButton(EMPTY_STRING);
        this.setFilterButton.setIcon(this.setFilterIcon);
        this.setFilterButton.setRolloverIcon(this.setFilterRolloverIcon);
        this.setFilterButton.setFocusable(false);
        this.setFilterButton.setBorder(BorderFactory.createEmptyBorder());
        this.setFilterButton.setBackground(textFieldBackground);
        this.setFilterButton.setContentAreaFilled(false);
        this.setFilterButton.addActionListener(setClearButtonsActionListner);
        this.setFilterButton.setToolTipText(SET_FILTER_BUTTON_TOOLTIP);
        this.clearFilterButton = new JButton(EMPTY_STRING);
        this.clearFilterButton.setIcon(this.clearFilterIcon);
        this.clearFilterButton.setRolloverIcon(this.clearFilterRolloverIcon);
        this.clearFilterButton.setFocusable(false);
        this.clearFilterButton.setBorder(BorderFactory.createEmptyBorder());
        this.clearFilterButton.setBackground(textFieldBackground);
        this.clearFilterButton.setContentAreaFilled(false);
        this.clearFilterButton.addActionListener(setClearButtonsActionListner);
        this.clearFilterButton.setToolTipText(CLEAR_FILTER_BUTTON_TOOLTIP);
        this.setClearFilterButtonsPanel = new JPanel(new BorderLayout(0, 0));
        this.setClearFilterButtonsPanel.setBackground(textFieldBackground);
        this.setClearFilterButtonsPanel.add((Component)this.setFilterButton, "West");
        this.setClearFilterButtonsPanel.add((Component)this.clearFilterButton, "East");
        this.filterTypePopup = new JPopupMenu(){

            public void setVisible(boolean visible) {
                super.setVisible(visible);
                if (visible) {
                    MenuElement[] me = JFilter.this.activeFilterItem != null ? new MenuElement[]{this, JFilter.this.activeFilterItem} : new MenuElement[]{this};
                    MenuSelectionManager.defaultManager().setSelectedPath(me);
                }
            }
        };
        this.filterTypePopup.setBorder(BorderFactory.createLineBorder(Color.BLACK));
        this.filterTypePopup.setBackground(Color.WHITE);
        this.setLayout(new BorderLayout());
        this.setBackground(textFieldBackground);
        this.add((Component)this.filterTypeButton, "West");
        this.add((Component)this.textFieldRegExpWarningPanel, "Center");
        this.add((Component)this.setClearFilterButtonsPanel, "East");
        this.getAccessibleContext().setAccessibleName(ACCESS_NAME);
        this.getAccessibleContext().setAccessibleDescription(ACCESS_DESCR);
    }

    private void performClearFilterButtonAction() {
        this.filterString = EMPTY_STRING;
        this.filterStringCombo.setText(this.filterString);
        this.setFilterType(this.defaultFilterType, false);
        this.fireFilterChanged();
        this.updateSetClearButtons();
    }

    private void performSetFilterButtonAction() {
        this.filterStringCombo.setText(this.filterStringCombo.getText().trim());
        String newFilterString = this.filterStringCombo.getText();
        if (!newFilterString.equals(this.filterString) || this.lastFilterType != this.filterType) {
            this.filterString = newFilterString;
            this.addComboBoxItem(this.filterString);
            this.fireFilterChanged();
            this.updateSetClearButtons();
        }
    }

    private void updateComboItems() {
        String currentFilterString = this.filterStringCombo.getText();
        this.filterStringCombo.removeAllItems();
        for (int i = this.filterStringsBuffer.size() - 1; i >= 0; --i) {
            this.filterStringCombo.addItem(this.filterStringsBuffer.get(i));
        }
        this.filterStringCombo.setText(currentFilterString);
    }

    private void updateSetClearButtons() {
        if (this.validRegExpFlag) {
            if (this.incorrectRegExpLabel.isVisible()) {
                this.incorrectRegExpLabel.setVisible(false);
            }
        } else {
            if (!this.incorrectRegExpLabel.isVisible()) {
                this.incorrectRegExpLabel.setVisible(true);
            }
            if (this.clearFilterButton.isVisible()) {
                this.clearFilterButton.setVisible(false);
            }
            if (this.setFilterButton.isVisible()) {
                this.setFilterButton.setVisible(false);
            }
            this.updateSetClearFilterButtonsPanelBorder();
            return;
        }
        if (this.textFieldEmptyFlag) {
            if (this.clearFilterButton.isVisible()) {
                this.clearFilterButton.setVisible(false);
            }
            if (this.setFilterButton.isVisible()) {
                this.setFilterButton.setVisible(false);
            }
            this.updateSetClearFilterButtonsPanelBorder();
            return;
        }
        if (this.filterString.length() == 0) {
            if (this.clearFilterButton.isVisible()) {
                this.clearFilterButton.setVisible(false);
            }
        } else if (!this.clearFilterButton.isVisible()) {
            this.clearFilterButton.setVisible(true);
        }
        if (this.filterStringCombo.getText().equals(this.filterString) && this.lastFilterType == this.filterType || this.filterStringCombo.getText().length() == 0) {
            if (this.setFilterButton.isVisible()) {
                this.setFilterButton.setVisible(false);
            }
        } else if (!this.setFilterButton.isVisible()) {
            if (this.clearFilterButton.isVisible()) {
                ((BorderLayout)this.setClearFilterButtonsPanel.getLayout()).setHgap(1);
            } else {
                ((BorderLayout)this.setClearFilterButtonsPanel.getLayout()).setHgap(0);
            }
            this.setFilterButton.setVisible(true);
        }
        this.updateSetClearFilterButtonsPanelBorder();
    }

    private void updateSetClearFilterButtonsPanelBorder() {
        if (this.clearFilterButton.isVisible() || this.setFilterButton.isVisible()) {
            this.setClearFilterButtonsPanel.setBorder(BorderFactory.createEmptyBorder(0, 3, 0, 0));
        } else {
            this.setClearFilterButtonsPanel.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        }
    }

    private class FilterStringComboActionListener
    implements ActionListener {
        private FilterStringComboActionListener() {
        }

        public void actionPerformed(ActionEvent e) {
            if (JFilter.this.internalChange) {
                return;
            }
            String string = (String)JFilter.this.filterStringCombo.getSelectedItem();
            if (string == null || string.equals(JFilter.EMPTY_STRING)) {
                return;
            }
            if (((JFilter)JFilter.this).filterStringCombo.comboPopupKeyFlag || !((JFilter)JFilter.this).filterStringCombo.comboPopupActionFlag) {
                return;
            }
            JFilter.this.setFilterString(string);
            JFilter.this.updateSetClearButtons();
        }
    }

    private class FilterTextFieldDocumentListener
    implements DocumentListener {
        private FilterTextFieldDocumentListener() {
        }

        public void changedUpdate(DocumentEvent e) {
            if (((JFilter)JFilter.this).filterStringCombo.comboPopupActionFlag) {
                return;
            }
            JFilter.this.checkRegExp();
            JFilter.this.updateSetClearButtons();
        }

        public void insertUpdate(DocumentEvent e) {
            if (((JFilter)JFilter.this).filterStringCombo.comboPopupActionFlag) {
                return;
            }
            JFilter.this.checkRegExp();
            JFilter.this.updateSetClearButtons();
        }

        public void removeUpdate(DocumentEvent e) {
            if (((JFilter)JFilter.this).filterStringCombo.comboPopupActionFlag) {
                return;
            }
            JFilter.this.checkRegExp();
            JFilter.this.updateSetClearButtons();
        }
    }

    private class FilterTextFieldFocusListener
    implements FocusListener {
        private FilterTextFieldFocusListener() {
        }

        public void focusGained(FocusEvent e) {
            JFilter.this.doFocusGained();
        }

        public void focusLost(FocusEvent e) {
            JFilter.this.doFocusLost();
        }
    }

    private class FilterTextFieldKeyListener
    extends KeyAdapter {
        private FilterTextFieldKeyListener() {
        }

        public void keyPressed(KeyEvent e) {
            ((JFilter)JFilter.this).filterStringCombo.comboPopupKeyFlag = true;
            if (e.getKeyCode() == 10) {
                JFilter.this.performSetFilterButtonAction();
                JFilter.this.filterStringCombo.clearSelection();
                return;
            }
            if (e.getKeyCode() == 27) {
                JFilter.this.filterStringCombo.setText(JFilter.this.filterString);
                JFilter.this.updateSetClearButtons();
                return;
            }
            if (e.getModifiers() == 1 && (e.getKeyCode() == 38 || e.getKeyCode() == 40)) {
                JFilter.this.filterTypePopup.show(JFilter.this, 1, JFilter.this.getHeight() - 2);
                return;
            }
        }

        public void keyReleased(KeyEvent e) {
            ((JFilter)JFilter.this).filterStringCombo.comboPopupKeyFlag = false;
        }
    }

    private class FilterTypeButtonMouseListener
    extends MouseAdapter {
        private FilterTypeButtonMouseListener() {
        }

        public void mousePressed(MouseEvent e) {
            JFilter.this.filterTypePopup.show(JFilter.this, 1, JFilter.this.getHeight() - 2);
        }
    }

    private class PopupItemsListener
    implements ActionListener {
        private PopupItemsListener() {
        }

        public void actionPerformed(ActionEvent e) {
            JFilter.this.setFilterTypePopupItemActive((JMenuItem)e.getSource(), false);
            JFilter.this.filterStringCombo.requestFocus();
        }
    }

    private class SetClearButtonsActionListener
    implements ActionListener {
        private SetClearButtonsActionListener() {
        }

        public void actionPerformed(ActionEvent e) {
            if (e.getSource() == JFilter.this.setFilterButton) {
                JFilter.this.performSetFilterButtonAction();
                JFilter.this.filterStringCombo.requestFocus();
                return;
            }
            if (e.getSource() == JFilter.this.clearFilterButton) {
                JFilter.this.performClearFilterButtonAction();
                JFilter.this.filterStringCombo.requestFocus();
                return;
            }
        }
    }
}

