/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.profiler.ui.panels;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Pattern;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import org.netbeans.api.progress.ProgressHandle;
import org.netbeans.api.progress.ProgressHandleFactory;
import org.netbeans.lib.profiler.client.ClientUtils;
import org.netbeans.lib.profiler.common.CommonUtils;
import org.netbeans.lib.profiler.ui.UIUtils;
import org.netbeans.modules.profiler.api.ProgressDisplayer;
import org.netbeans.modules.profiler.api.java.ExternalPackages;
import org.netbeans.modules.profiler.api.java.SourceClassInfo;
import org.netbeans.modules.profiler.api.java.SourcePackageInfo;
import org.netbeans.modules.profiler.selector.api.SelectionTreeBuilderFactory;
import org.netbeans.modules.profiler.selector.api.SelectionTreeBuilderType;
import org.netbeans.modules.profiler.selector.spi.SelectionTreeBuilder;
import org.netbeans.modules.profiler.selector.ui.RootSelectorTree;
import org.netbeans.modules.profiler.selector.ui.TreePathSearch;
import org.netbeans.modules.profiler.ui.ProfilerProgressDisplayer;
import org.netbeans.modules.profiler.ui.panels.Bundle;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.Cancellable;
import org.openide.util.HelpCtx;
import org.openide.util.Lookup;
import org.openide.util.lookup.Lookups;

public final class FileSelectRootMethodsPanel
extends JPanel {
    private static final String HELP_CTX_KEY = "ClassSelectRootMethodsPanel.HelpCtx";
    private static final HelpCtx HELP_CTX = new HelpCtx("ClassSelectRootMethodsPanel.HelpCtx");
    private static final Dimension PREFERRED_TOPTREE_DIMENSION = new Dimension(500, 250);
    private JButton okButton;
    private RootSelectorTree fileTreeView;

    public static final FileSelectRootMethodsPanel getDefault() {
        return Singleton.INSTANCE;
    }

    private FileSelectRootMethodsPanel() {
        this.init(this);
    }

    private void init(Container container) {
        this.okButton = new JButton(Bundle.SelectRootMethodsPanel_OkButtonText());
        ProfilerProgressDisplayer pd = ProfilerProgressDisplayer.getDefault();
        this.fileTreeView = new RootSelectorTree((ProgressDisplayer)pd, new TreePathSearch.ClassIndex(){

            public List<SourceClassInfo> getClasses(String pattern, Lookup context) {
                Pattern p = Pattern.compile(pattern, 2);
                ArrayList<SourceClassInfo> rslt = new ArrayList<SourceClassInfo>();
                SourceClassInfo clz = (SourceClassInfo)context.lookup(SourceClassInfo.class);
                if (clz != null) {
                    this.addClassRecursively(clz, rslt);
                } else {
                    FileObject fo = (FileObject)context.lookup(FileObject.class);
                    if (FileUtil.isArchiveFile((FileObject)fo) || fo.isFolder()) {
                        for (SourcePackageInfo spi : ExternalPackages.forPath((FileObject)fo)) {
                            this.addPackageRecursively(spi, rslt);
                        }
                    }
                }
                Iterator iter = rslt.iterator();
                while (iter.hasNext()) {
                    clz = (SourceClassInfo)iter.next();
                    if (p.matcher(clz.getSimpleName()).matches()) continue;
                    iter.remove();
                }
                Collections.sort(rslt, SourceClassInfo.COMPARATOR);
                return rslt;
            }

            private void addPackageRecursively(SourcePackageInfo spi, List<SourceClassInfo> clzs) {
                for (SourcePackageInfo sub : spi.getSubpackages()) {
                    this.addPackageRecursively(sub, clzs);
                }
                for (SourceClassInfo sci : spi.getClasses()) {
                    this.addClassRecursively(sci, clzs);
                }
            }

            private void addClassRecursively(SourceClassInfo sc, List<SourceClassInfo> clzs) {
                clzs.add(sc);
                for (SourceClassInfo scInner : sc.getInnerClases()) {
                    this.addClassRecursively(scInner, clzs);
                }
            }
        });
        container.setLayout(new GridBagLayout());
        this.fileTreeView.setRowHeight(UIUtils.getDefaultRowHeight() + 2);
        JScrollPane advancedLogicalPackageTreeScrollPane = new JScrollPane((Component)this.fileTreeView);
        advancedLogicalPackageTreeScrollPane.setPreferredSize(PREFERRED_TOPTREE_DIMENSION);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(10, 10, 0, 10);
        container.add((Component)advancedLogicalPackageTreeScrollPane, gridBagConstraints);
    }

    public ClientUtils.SourceCodeSelection[] getRootMethods(final FileObject javaFile, final ClientUtils.SourceCodeSelection[] currentSelection) {
        this.fileTreeView.reset();
        this.updateSelector(new Runnable(){

            @Override
            public void run() {
                List builders = SelectionTreeBuilderFactory.buildersFor((FileObject)javaFile);
                FileSelectRootMethodsPanel.this.fileTreeView.setSelection(currentSelection, Lookups.fixed((Object[])builders.toArray(new SelectionTreeBuilder[builders.size()])));
                List builderTypes = FileSelectRootMethodsPanel.this.fileTreeView.getBuilderTypes();
                if (builderTypes.size() > 0) {
                    FileSelectRootMethodsPanel.this.fileTreeView.setBuilderType((SelectionTreeBuilderType)builderTypes.get(0));
                }
            }
        });
        final DialogDescriptor dd = new DialogDescriptor((Object)this, Bundle.SelectRootMethodsPanel_Title(), true, new Object[]{this.okButton, DialogDescriptor.CANCEL_OPTION}, (Object)this.okButton, 0, null, null);
        final Dialog d = DialogDisplayer.getDefault().createDialog(dd);
        Cancellable c = new Cancellable(){

            public boolean cancel() {
                dd.setValue(DialogDescriptor.CANCEL_OPTION);
                d.setVisible(false);
                FileSelectRootMethodsPanel.this.fileTreeView.setCancelHandler(null);
                return true;
            }
        };
        this.fileTreeView.setCancelHandler(c);
        d.pack();
        d.setVisible(true);
        if (dd.getValue().equals(this.okButton)) {
            ClientUtils.SourceCodeSelection[] selection = this.fileTreeView.getSelection();
            return selection;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateSelector(Runnable updater) {
        final ProgressHandle ph = ProgressHandleFactory.createHandle((String)Bundle.SelectRootMethodsPanel_ParsingProjectStructureMessage());
        CommonUtils.runInEventDispatchThreadAndWait((Runnable)new Runnable(){

            @Override
            public void run() {
                ph.setInitialDelay(500);
                ph.start();
            }
        });
        try {
            this.fileTreeView.setEnabled(false);
            this.okButton.setEnabled(false);
            updater.run();
        }
        finally {
            ph.finish();
            this.okButton.setEnabled(true);
            this.fileTreeView.setEnabled(true);
        }
    }

    private static final class Singleton {
        private static final FileSelectRootMethodsPanel INSTANCE = new FileSelectRootMethodsPanel();

        private Singleton() {
        }
    }
}

