/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.profiler.actions;

import org.netbeans.lib.profiler.common.Profiler;
import org.netbeans.modules.profiler.actions.Bundle;
import org.netbeans.modules.profiler.actions.ProfilingAwareAction;
import org.netbeans.modules.profiler.api.ProfilerDialogs;
import org.netbeans.modules.profiler.api.icons.Icons;
import org.openide.util.HelpCtx;

public final class RerunAction
extends ProfilingAwareAction {
    private static final int[] ENABLED_STATES = new int[]{16, 8, 1};

    public RerunAction() {
        this.setIcon(Icons.getIcon((String)"GeneralIcons.Rerun"));
        this.putValue("iconBase", Icons.getResource((String)"GeneralIcons.Rerun"));
        this.putProperty("ShortDescription", Bundle.HINT_RerunAction());
    }

    @Override
    public boolean isEnabled() {
        return super.isEnabled() && Profiler.getDefault().rerunAvailable();
    }

    @Override
    protected int[] enabledStates() {
        return ENABLED_STATES;
    }

    public HelpCtx getHelpCtx() {
        return HelpCtx.DEFAULT_HELP;
    }

    public String getName() {
        return Bundle.LBL_RerunAction();
    }

    public void performAction() {
        int state = Profiler.getDefault().getProfilingState();
        int mode = Profiler.getDefault().getProfilingMode();
        if (state == 8 || state == 4) {
            if (mode == 1) {
                if (!ProfilerDialogs.displayConfirmation((String)Bundle.MSG_ReRunOnProfile(), (String)Bundle.CAPTION_Question())) {
                    return;
                }
                Profiler.getDefault().stopApp();
            } else {
                if (!ProfilerDialogs.displayConfirmation((String)Bundle.MSG_ReRunOnAttach(), (String)Bundle.CAPTION_Question())) {
                    return;
                }
                Profiler.getDefault().detachFromApp();
            }
        }
        Profiler.getDefault().rerunLastProfiling();
    }
}

