/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.profiler.actions;

import org.netbeans.lib.profiler.common.Profiler;
import org.netbeans.lib.profiler.common.event.ProfilingStateEvent;
import org.netbeans.lib.profiler.common.event.ProfilingStateListener;
import org.openide.util.actions.CallableSystemAction;

public abstract class ProfilingAwareAction
extends CallableSystemAction
implements ProfilingStateListener {
    private int lastInstrumentation = 0;
    private int lastProfilingState = 1;

    protected ProfilingAwareAction() {
        Profiler.getDefault().addProfilingStateListener((ProfilingStateListener)this);
    }

    public boolean isEnabled() {
        boolean shouldBeEnabled = false;
        this.lastProfilingState = Profiler.getDefault().getProfilingState();
        this.lastInstrumentation = this.lastProfilingState != 1 ? Profiler.getDefault().getTargetAppRunner().getProfilerClient().getCurrentInstrType() : 0;
        int[] enabledStates = this.enabledStates();
        for (int i = 0; i < enabledStates.length; ++i) {
            if (this.lastProfilingState != enabledStates[i]) continue;
            shouldBeEnabled = true;
            break;
        }
        if (shouldBeEnabled && this.requiresInstrumentation()) {
            shouldBeEnabled = this.lastInstrumentation != 0;
        }
        return shouldBeEnabled;
    }

    public final void instrumentationChanged(int oldInstrType, int currentInstrType) {
        this.updateAction();
    }

    public final void profilingStateChanged(ProfilingStateEvent e) {
        this.updateAction();
    }

    public final void threadsMonitoringChanged() {
        this.updateAction();
    }

    protected abstract int[] enabledStates();

    protected final boolean asynchronous() {
        return false;
    }

    protected boolean requiresInstrumentation() {
        return false;
    }

    protected void updateAction() {
        if (this.lastProfilingState != Profiler.getDefault().getProfilingState()) {
            boolean shouldBeEnabled = this.isEnabled();
            this.firePropertyChange("enabled", !shouldBeEnabled, shouldBeEnabled);
        } else if (this.lastProfilingState != 1 && this.lastInstrumentation != Profiler.getDefault().getTargetAppRunner().getProfilerClient().getCurrentInstrType()) {
            boolean shouldBeEnabled = this.isEnabled();
            this.firePropertyChange("enabled", !shouldBeEnabled, shouldBeEnabled);
        }
    }
}

