/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.profiler.categorization.ui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.FlowLayout;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import org.netbeans.lib.profiler.marker.Mark;
import org.netbeans.lib.profiler.results.RuntimeCCTNode;
import org.netbeans.lib.profiler.results.RuntimeCCTNodeProcessor;
import org.netbeans.lib.profiler.results.cpu.TimingAdjusterOld;
import org.netbeans.lib.profiler.results.cpu.cct.nodes.MarkedCPUCCTNode;
import org.netbeans.lib.profiler.results.cpu.cct.nodes.MethodCPUCCTNode;
import org.netbeans.lib.profiler.results.cpu.cct.nodes.RuntimeCPUCCTNode;
import org.netbeans.lib.profiler.utils.StringUtils;
import org.netbeans.modules.profiler.categorization.api.Category;
import org.netbeans.modules.profiler.categorization.api.ProjectAwareStatisticalModule;
import org.netbeans.modules.profiler.categorization.api.ProjectCategorization;
import org.netbeans.modules.profiler.categorization.ui.Bundle;
import org.openide.util.Lookup;

public class ForwardCategoryDistributionPanel
extends ProjectAwareStatisticalModule {
    private static final Logger LOG = Logger.getLogger(ForwardCategoryDistributionPanel.class.getName());
    private JLabel noData = new JLabel(Bundle.ForwardCategoryDistributionPanel_NoDataLabelText());
    private JLabel noMethods = new JLabel(Bundle.ForwardCategoryDistributionPanel_NoMethodLabelText());
    private Model model;
    private RuntimeCPUCCTNode lastAppNode;
    private ProjectCategorization categorization;
    private List<MarkTime> slots = Collections.EMPTY_LIST;
    private Map<Mark, Integer> slotMap = Collections.EMPTY_MAP;
    private Set<Mark> forwardMarks = Collections.EMPTY_SET;

    public ForwardCategoryDistributionPanel() {
        this.initComponents();
        this.model = new Model();
    }

    @Override
    protected void onProjectChange(Lookup.Provider oldValue, Lookup.Provider newValue) {
        if (oldValue != null && newValue == null) {
            this.categorization = null;
            return;
        }
        if (newValue != null) {
            this.categorization = new ProjectCategorization(newValue);
            this.setupSlots(this.categorization.getRoot().getAssignedMark());
        }
    }

    @Override
    public boolean supportsProject(Lookup.Provider project) {
        return ProjectCategorization.isAvailable(project);
    }

    protected void onMethodSelectionChange(int oldMethodId, int newMethodId) {
        this.refresh(this.lastAppNode);
    }

    protected void onMarkSelectionChange(Mark oldMark, Mark newMark) {
        this.refresh(this.lastAppNode);
    }

    private void setupSlots(Mark catMark) {
        if (this.categorization == null) {
            return;
        }
        Category cat = this.categorization.getCategoryForMark(catMark);
        Set<Category> subs = cat.getSubcategories();
        ArrayList<Category> subsList = new ArrayList<Category>(subs);
        this.slots = new ArrayList<MarkTime>(subsList.size());
        this.slotMap = new HashMap<Mark, Integer>();
        this.forwardMarks = new HashSet<Mark>();
        for (int i = 0; i < subsList.size(); ++i) {
            Category thisCat = (Category)subsList.get(i);
            Set<Mark> marks = this.getMarks(thisCat);
            for (Mark m : marks) {
                this.slotMap.put(m, i);
            }
            Mark assignedMark = thisCat.getAssignedMark();
            this.slots.add(new MarkTime(assignedMark, 0L));
            this.forwardMarks.addAll(marks);
        }
        this.forwardMarks.add(catMark);
    }

    private Set<Mark> getMarks(Category cat) {
        HashSet<Mark> marks = new HashSet<Mark>();
        ArrayDeque<Category> stack = new ArrayDeque<Category>();
        stack.push(cat);
        while (!stack.isEmpty()) {
            cat = (Category)stack.pop();
            marks.add(cat.getAssignedMark());
            for (Category sub : cat.getSubcategories()) {
                stack.push(sub);
            }
        }
        return marks;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void refresh(RuntimeCPUCCTNode appNode) {
        if (appNode != null) {
            try {
                this.setupSlots(this.getSelectedMark());
                RuntimeCCTNodeProcessor.process((RuntimeCCTNode)appNode, (RuntimeCCTNodeProcessor.Plugin[])new RuntimeCCTNodeProcessor.Plugin[]{this.model});
            }
            catch (Exception e) {
                LOG.log(Level.SEVERE, null, e);
            }
            finally {
                this.lastAppNode = appNode;
            }
        }
    }

    private void initComponents() {
        BoxLayout layout = new BoxLayout((Container)((Object)this), 1);
        this.setLayout(layout);
        this.setOpaque(false);
        this.setBorder(BorderFactory.createEmptyBorder(8, 8, 8, 8));
        this.noMethods.setOpaque(false);
        this.noMethods.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(0, 7, 0, 0), this.noMethods.getBorder()));
        this.noData.setOpaque(false);
        this.noData.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(0, 7, 0, 0), this.noData.getBorder()));
        this.add(this.noMethods);
        this.setName(Bundle.ForwardCategoryDistributionPanel_MethodCategoriesString());
        this.setToolTipText(Bundle.ForwardCategoryDistributionPanel_DescrString());
    }

    private void refreshData() {
        if (this.model == null) {
            return;
        }
        Runnable uiUpdater = null;
        if (this.getSelectedMethodId() == -1) {
            uiUpdater = new Runnable(){

                @Override
                public void run() {
                    ForwardCategoryDistributionPanel.this.removeAll();
                    ForwardCategoryDistributionPanel.this.add(ForwardCategoryDistributionPanel.this.noMethods);
                    ForwardCategoryDistributionPanel.this.revalidate();
                    ForwardCategoryDistributionPanel.this.repaint();
                }
            };
        } else {
            Map<Mark, Long> catTimes = this.model.getDistribution();
            if (catTimes == null || catTimes.isEmpty()) {
                uiUpdater = new Runnable(){

                    @Override
                    public void run() {
                        ForwardCategoryDistributionPanel.this.removeAll();
                        ForwardCategoryDistributionPanel.this.add(ForwardCategoryDistributionPanel.this.noData);
                        ForwardCategoryDistributionPanel.this.revalidate();
                        ForwardCategoryDistributionPanel.this.repaint();
                    }
                };
            } else {
                final long[] shownTime = new long[1];
                for (Map.Entry<Mark, Long> entry : catTimes.entrySet()) {
                    long time = entry.getValue();
                    Integer index = this.slotMap.get(entry.getKey());
                    if (index == null) continue;
                    MarkTime mt = this.slots.get(index);
                    assert (mt != null);
                    mt.time += time;
                }
                final ArrayList<MarkTime> shownCats = new ArrayList<MarkTime>();
                for (MarkTime mt : this.slots) {
                    if (mt.time <= 0L) continue;
                    shownCats.add(mt);
                    shownTime[0] = shownTime[0] + mt.time;
                }
                if (shownCats.isEmpty()) {
                    shownCats.add(new MarkTime(this.getSelectedMark(), 1L));
                    shownTime[0] = 1L;
                } else {
                    Collections.sort(shownCats, MarkTime.COMPARATOR);
                }
                uiUpdater = new Runnable(){

                    @Override
                    public void run() {
                        ForwardCategoryDistributionPanel.this.removeAll();
                        for (MarkTime cat : shownCats) {
                            float ratio = (float)cat.time / (float)shownTime[0];
                            float percent = 100.0f * ratio;
                            JPanel panel = new JPanel(new BorderLayout());
                            panel.setOpaque(false);
                            Category displayedCat = ForwardCategoryDistributionPanel.this.categorization.getCategoryForMark(cat.mark);
                            StringBuilder labelBuilder = new StringBuilder();
                            if (displayedCat != null) {
                                labelBuilder.append(displayedCat.getLabel());
                            } else {
                                labelBuilder.append("Not categorized");
                            }
                            JLabel data = new JLabel(labelBuilder.toString() + " (" + StringUtils.floatPerCentToString((float)percent) + "%)");
                            data.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(0, 7, 0, 0), data.getBorder()));
                            data.setOpaque(false);
                            panel.add((Component)data, "West");
                            JProgressBar prgbar = new JProgressBar(0, 0, 100);
                            prgbar.setOpaque(false);
                            prgbar.setPreferredSize(new Dimension(120, data.getPreferredSize().height + 2));
                            prgbar.setMaximumSize(prgbar.getPreferredSize());
                            prgbar.setMinimumSize(prgbar.getPreferredSize());
                            prgbar.setForeground(new Color(Color.HSBtoRGB(100.0f, ratio, 0.7f)));
                            prgbar.setString("");
                            prgbar.setStringPainted(true);
                            prgbar.setValue((int)percent);
                            JPanel prgbarContainer = new JPanel(new FlowLayout(0, 2, 3));
                            prgbarContainer.setOpaque(false);
                            prgbarContainer.add(prgbar);
                            panel.add((Component)prgbarContainer, "East");
                            ForwardCategoryDistributionPanel.this.add(panel);
                        }
                        ForwardCategoryDistributionPanel.this.revalidate();
                        ForwardCategoryDistributionPanel.this.repaint();
                    }
                };
            }
        }
        if (EventQueue.isDispatchThread()) {
            uiUpdater.run();
        } else {
            EventQueue.invokeLater(uiUpdater);
        }
    }

    private static class MarkTime {
        public static final Comparator COMPARATOR = new Comparator(){

            public int compare(Object o1, Object o2) {
                if (o1 == null || o2 == null) {
                    return 0;
                }
                if (!(o1 instanceof MarkTime) || !(o2 instanceof MarkTime)) {
                    return 0;
                }
                if (((MarkTime)o1).time < ((MarkTime)o2).time) {
                    return 1;
                }
                if (((MarkTime)o1).time > ((MarkTime)o2).time) {
                    return -1;
                }
                return 0;
            }
        };
        public Mark mark;
        public long time;

        public MarkTime(Mark mark, long time) {
            this.mark = mark;
            this.time = time;
        }
    }

    private class Model
    extends RuntimeCCTNodeProcessor.PluginAdapter {
        private Map<Mark, Long> markMap = new HashMap<Mark, Long>();
        private Mark usedMark;
        private Stack<Mark> markStack = new Stack();
        private int inCalls;
        private int lastCalls;
        private int outCalls;
        private long time0;
        private long time1;

        private Model() {
        }

        public Map<Mark, Long> getDistribution() {
            return new HashMap<Mark, Long>(this.markMap);
        }

        public void onBackout(MarkedCPUCCTNode node) {
            if (this.time0 > 0L && this.isMarkEligible(this.usedMark)) {
                long cleansedTime;
                Long markTime = this.markMap.get(this.usedMark);
                if (markTime == null) {
                    markTime = 0L;
                }
                if ((cleansedTime = (long)TimingAdjusterOld.getDefault().adjustTime(this.time0, this.inCalls, this.outCalls - this.lastCalls, false)) > 0L || this.inCalls > 0) {
                    this.markMap.put(this.usedMark, markTime + (cleansedTime > 0L ? cleansedTime : (long)this.inCalls));
                }
            }
            this.outCalls = 0;
            this.inCalls = 0;
            this.lastCalls = 0;
            this.time0 = 0L;
            this.time1 = 0L;
            this.usedMark = this.markStack.pop();
        }

        protected void onNode(MarkedCPUCCTNode node) {
            if (this.time0 > 0L && this.isMarkEligible(this.usedMark)) {
                long cleansedTime;
                Long markTime = this.markMap.get(this.usedMark);
                if (markTime == null) {
                    markTime = 0L;
                }
                if ((cleansedTime = (long)TimingAdjusterOld.getDefault().adjustTime(this.time0, this.inCalls - this.lastCalls, this.outCalls, false)) > 0L || this.inCalls > 0) {
                    this.markMap.put(this.usedMark, markTime + (cleansedTime > 0L ? cleansedTime : (long)this.inCalls));
                }
            }
            this.outCalls = 0;
            this.inCalls = 0;
            this.lastCalls = 0;
            this.time0 = 0L;
            this.time1 = 0L;
            this.markStack.push(this.usedMark);
            this.usedMark = node.getMark();
        }

        public void onNode(MethodCPUCCTNode node) {
            if (node.getMethodId() != ForwardCategoryDistributionPanel.this.getSelectedMethodId()) {
                return;
            }
            this.time0 += node.getNetTime0();
            this.time1 += node.getNetTime1();
            this.inCalls += node.getNCalls();
            this.outCalls += node.getNCalls();
            this.lastCalls = node.getNCalls();
        }

        public void onStart() {
            this.markStack.clear();
            this.markMap.clear();
            this.usedMark = Mark.DEFAULT;
        }

        public void onStop() {
            ForwardCategoryDistributionPanel.this.refreshData();
        }

        private boolean isMarkEligible(Mark mark) {
            return ForwardCategoryDistributionPanel.this.forwardMarks.contains(mark != null ? mark : Mark.DEFAULT);
        }
    }
}

