/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.profiler.categorization.api;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.netbeans.lib.profiler.marker.Mark;
import org.netbeans.modules.profiler.categorization.spi.CategoryDefinition;
import org.netbeans.modules.profiler.categorization.spi.CategoryDefinitionProcessor;
import org.netbeans.modules.profiler.utilities.Visitable;
import org.netbeans.modules.profiler.utilities.Visitor;

public abstract class Category
implements Visitable<Category> {
    private String id;
    private String label;
    private Set<CategoryDefinition> definitions;
    private Mark assignedMark;
    public static final Category DEFAULT = new Category("DEFAULT", "Default Category", new Mark(0)){

        public <R, P> R accept(Visitor<Visitable<Category>, R, P> visitor, P parameter) {
            return null;
        }

        @Override
        public Set<Category> getSubcategories() {
            return Collections.EMPTY_SET;
        }
    };

    public Category(String id, String label, Mark mark) {
        this.id = id;
        this.label = label;
        this.definitions = new HashSet<CategoryDefinition>();
        this.assignedMark = mark;
    }

    public Category(String id, String label) {
        this(id, label, new Mark());
    }

    public String getLabel() {
        return this.label;
    }

    public String getId() {
        return this.id;
    }

    public Mark getAssignedMark() {
        return this.assignedMark;
    }

    public Set<CategoryDefinition> getDefinitions() {
        return this.definitions;
    }

    public Category getValue() {
        return this;
    }

    public abstract Set<Category> getSubcategories();

    void processDefinitionsWith(CategoryDefinitionProcessor processor) {
        for (CategoryDefinition def : this.definitions) {
            def.processWith(processor);
        }
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Category other = (Category)obj;
        if (this.id == null ? other.id != null : !this.id.equals(other.id)) {
            return false;
        }
        return this.assignedMark == other.assignedMark || this.assignedMark != null && this.assignedMark.equals((Object)other.assignedMark);
    }

    public int hashCode() {
        int hash = 5;
        hash = 53 * hash + (this.id != null ? this.id.hashCode() : 0);
        hash = 53 * hash + (this.assignedMark != null ? this.assignedMark.hashCode() : 0);
        return hash;
    }
}

