/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.visualvm.core.ui.components;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Stroke;
import java.awt.Toolkit;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.image.FilteredImageSource;
import javax.swing.BorderFactory;
import javax.swing.DefaultButtonModel;
import javax.swing.GrayFilter;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.UIManager;
import javax.swing.border.BevelBorder;
import javax.swing.border.Border;

class DisplayAreaSupport {
    static final Color BORDER_COLOR_NORMAL = new Color(192, 192, 192);
    static final Color BORDER_COLOR_HIGHLIGHT = new Color(128, 128, 128);
    static final Color BACKGROUND_COLOR_NORMAL = new Color(245, 245, 245);
    static final Color BACKGROUND_COLOR_HIGHLIGHT = new Color(235, 235, 235);
    static final Color COLOR_NONE = new Color(0, 0, 0);
    static final Color TABS_SEPARATOR = new Color(UIManager.getColor("Label.foreground").getRGB());
    static final int TABBUTTON_MARGIN_TOP = 3;
    static final int TABBUTTON_MARGIN_LEFT = 8;
    static final int TABBUTTON_MARGIN_BOTTOM = 3;
    static final int TABBUTTON_MARGIN_RIGHT = 8;
    private static final Color TABBUTTON_FOCUS_COLOR = Color.BLACK;
    private static final Stroke TABBUTTON_FOCUS_STROKE = new BasicStroke(1.0f, 2, 2, 0.0f, new float[]{0.0f, 2.0f}, 0.0f);

    DisplayAreaSupport() {
    }

    static class ImageIconButton
    extends JButton
    implements MouseListener {
        private Border emptyBorder = BorderFactory.createEmptyBorder(1, 1, 1, 1);
        private Border loweredBorder = new ThinBevelBorder(1, Color.WHITE, Color.GRAY);
        private Border raisedBorder = new ThinBevelBorder(0, Color.WHITE, Color.GRAY);
        private boolean rollover = false;
        private boolean pressed = false;

        public ImageIconButton(ImageIcon icon) {
            GrayFilter enabledFilter = new GrayFilter(true, 35);
            FilteredImageSource prod = new FilteredImageSource(icon.getImage().getSource(), enabledFilter);
            ImageIcon grayIcon = new ImageIcon(Toolkit.getDefaultToolkit().createImage(prod));
            GrayFilter disabledFilter = new GrayFilter(true, 60);
            prod = new FilteredImageSource(icon.getImage().getSource(), disabledFilter);
            ImageIcon disabledIcon = new ImageIcon(Toolkit.getDefaultToolkit().createImage(prod));
            this.setIcon(grayIcon);
            this.setRolloverIcon(icon);
            this.setPressedIcon(icon);
            this.setDisabledIcon(disabledIcon);
            this.setIconTextGap(0);
            this.setBorder(this.emptyBorder);
            this.setFocusPainted(false);
            this.setContentAreaFilled(false);
            this.addMouseListener(this);
        }

        public void mouseClicked(MouseEvent e) {
        }

        public void mouseEntered(MouseEvent e) {
            this.rollover = true;
            if (this.pressed) {
                this.setBorder(this.loweredBorder);
            } else {
                this.setBorder(this.raisedBorder);
            }
        }

        public void mouseExited(MouseEvent e) {
            this.rollover = false;
            this.setBorder(this.emptyBorder);
        }

        public void mousePressed(MouseEvent e) {
            this.pressed = true;
            this.setBorder(this.loweredBorder);
        }

        public void mouseReleased(MouseEvent e) {
            this.pressed = false;
            if (this.rollover) {
                this.setBorder(this.raisedBorder);
            } else {
                this.setBorder(this.emptyBorder);
            }
        }

        public Dimension getPreferredSize() {
            return new Dimension(16, 16);
        }

        protected void paintComponent(Graphics g) {
            super.paintComponent(g);
            Dimension size = this.getSize();
            Graphics2D g2 = (Graphics2D)g;
            if (this.hasFocus() && this.isEnabled()) {
                g2.setStroke(TABBUTTON_FOCUS_STROKE);
                g2.setColor(TABBUTTON_FOCUS_COLOR);
                g2.drawRect(2, 2, size.width - 5, size.height - 5);
            }
        }
    }

    private static class ThinBevelBorder
    extends BevelBorder {
        public ThinBevelBorder(int bevelType, Color highlight, Color shadow) {
            super(bevelType, highlight.brighter(), highlight, shadow, shadow.brighter());
        }

        public Insets getBorderInsets(Component c) {
            return new Insets(1, 1, 1, 1);
        }

        public Insets getBorderInsets(Component c, Insets insets) {
            insets.bottom = 1;
            insets.right = 1;
            insets.top = 1;
            insets.left = 1;
            return insets;
        }

        protected void paintLoweredBevel(Component c, Graphics g, int x, int y, int width, int height) {
            if (!c.isEnabled()) {
                return;
            }
            Color oldColor = g.getColor();
            int h = height;
            int w = width;
            g.translate(x, y);
            g.setColor(this.getShadowOuterColor(c));
            g.drawLine(0, 0, 0, h - 1);
            g.drawLine(1, 0, w - 1, 0);
            g.setColor(this.getHighlightInnerColor(c));
            g.drawLine(1, h - 1, w - 1, h - 1);
            g.drawLine(w - 1, 1, w - 1, h - 2);
            g.translate(-x, -y);
            g.setColor(oldColor);
        }

        protected void paintRaisedBevel(Component c, Graphics g, int x, int y, int width, int height) {
            if (!c.isEnabled()) {
                return;
            }
            Color oldColor = g.getColor();
            int h = height;
            int w = width;
            g.translate(x, y);
            g.setColor(this.getHighlightInnerColor(c));
            g.drawLine(0, 0, 0, h - 1);
            g.drawLine(1, 0, w - 1, 0);
            g.setColor(this.getShadowOuterColor(c));
            g.drawLine(0, h - 1, w - 1, h - 1);
            g.drawLine(w - 1, 0, w - 1, h - 2);
            g.translate(-x, -y);
            g.setColor(oldColor);
        }
    }

    static class TabbedCaptionBorder
    implements Border {
        private Color COLOR_TOP;
        private Color COLOR_LEFT;
        private Color COLOR_BOTTOM;
        private Color COLOR_RIGHT;
        private Insets insets;

        public TabbedCaptionBorder(Color colorTop, Color colorLeft, Color colorBottom, Color colorRight) {
            this.COLOR_TOP = colorTop;
            this.COLOR_LEFT = colorLeft;
            this.COLOR_BOTTOM = colorBottom;
            this.COLOR_RIGHT = colorRight;
            this.insets = new Insets(this.COLOR_TOP == null ? 0 : 1, this.COLOR_LEFT == null ? 0 : 1, this.COLOR_BOTTOM == null ? 0 : 1, this.COLOR_RIGHT == null ? 0 : 1);
        }

        public Insets getBorderInsets(Component c) {
            return this.insets;
        }

        public boolean isBorderOpaque() {
            return true;
        }

        public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
            if (this.COLOR_LEFT != null && this.COLOR_LEFT != COLOR_NONE) {
                g.setColor(this.COLOR_LEFT);
                if (this.COLOR_LEFT == TABS_SEPARATOR) {
                    g.drawLine(x, y + 3 + 2, x, y + height - 3 - 4);
                } else {
                    g.drawLine(x, y, x, y + height - 1);
                }
            }
            if (this.COLOR_RIGHT != null && this.COLOR_RIGHT != COLOR_NONE) {
                g.setColor(this.COLOR_RIGHT);
                if (this.COLOR_RIGHT == TABS_SEPARATOR) {
                    g.drawLine(x + width - 1, y + 3 + 2, x + width - 1, y + height - 3 - 4);
                } else {
                    g.drawLine(x + width - 1, y, x + width - 1, y + height - 1);
                }
            }
            if (this.COLOR_TOP != null && this.COLOR_TOP != COLOR_NONE) {
                g.setColor(this.COLOR_TOP);
                g.drawLine(x, y, x + width - 1, y);
            }
            if (this.COLOR_BOTTOM != null && this.COLOR_BOTTOM != COLOR_NONE) {
                g.setColor(this.COLOR_BOTTOM);
                g.drawLine(x, y + height - 1, x + width - 1, y + height - 1);
            }
        }
    }

    static class TabButtonContainer
    extends JPanel {
        private TabButton tabButton;

        public TabButtonContainer(TabButton tabButton) {
            this.tabButton = tabButton;
            this.setOpaque(true);
            this.setLayout(new FlowLayout(3, 0, 0));
            this.setBackground(BACKGROUND_COLOR_NORMAL);
            this.setBorder(new TabbedCaptionBorder(null, null, null, null));
            this.add((Component)tabButton, "Center");
        }

        public void setEnabled(boolean enabled) {
            super.setEnabled(enabled);
            this.tabButton.setEnabled(enabled);
        }

        public void updateTabButton(int index, int selectedIndex, int buttonsCount) {
            if (buttonsCount == 1) {
                this.tabButton.setFocusable(false);
                this.tabButton.setCursor(Cursor.getDefaultCursor());
                this.setBackground(BACKGROUND_COLOR_NORMAL);
                this.setBorder(new TabbedCaptionBorder(BORDER_COLOR_NORMAL, BORDER_COLOR_NORMAL, COLOR_NONE, COLOR_NONE));
            } else if (index == selectedIndex) {
                this.tabButton.setFocusable(true);
                this.tabButton.setCursor(Cursor.getDefaultCursor());
                this.setBackground(BACKGROUND_COLOR_HIGHLIGHT);
                this.setBorder(new TabbedCaptionBorder(BORDER_COLOR_HIGHLIGHT, BORDER_COLOR_HIGHLIGHT, COLOR_NONE, BORDER_COLOR_HIGHLIGHT));
            } else {
                this.tabButton.setFocusable(true);
                this.tabButton.setCursor(Cursor.getPredefinedCursor(12));
                this.setBackground(BACKGROUND_COLOR_NORMAL);
                Color topColor = BORDER_COLOR_NORMAL;
                Color leftColor = index == 0 ? BORDER_COLOR_NORMAL : null;
                Color bottomColor = BORDER_COLOR_HIGHLIGHT;
                Color rightColor = index == selectedIndex - 1 ? null : (index == buttonsCount - 1 ? COLOR_NONE : TABS_SEPARATOR);
                this.setBorder(new TabbedCaptionBorder(topColor, leftColor, bottomColor, rightColor));
            }
        }
    }

    static class TabButton
    extends JButton {
        public TabButton(String text, String description) {
            super(text);
            this.setModel(new DefaultButtonModel(){

                public boolean isPressed() {
                    return false;
                }
            });
            this.setOpaque(false);
            this.setFocusPainted(false);
            this.setBorderPainted(false);
            this.setContentAreaFilled(false);
            this.setBorder(BorderFactory.createEmptyBorder(3, 8, 3, 8));
            this.setToolTipText(description);
        }

        protected void paintComponent(Graphics g) {
            super.paintComponent(g);
            Dimension size = this.getSize();
            Graphics2D g2 = (Graphics2D)g;
            if (this.hasFocus() && this.isEnabled()) {
                g2.setStroke(TABBUTTON_FOCUS_STROKE);
                g2.setColor(TABBUTTON_FOCUS_COLOR);
                g2.drawRect(2, 2, size.width - 5, size.height - 5);
            }
        }
    }
}

