/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.jboss4.config.mdb;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.util.HashSet;
import java.util.Set;
import org.netbeans.modules.j2ee.deployment.common.api.ConfigurationException;
import org.netbeans.modules.j2ee.deployment.common.api.MessageDestination;
import org.netbeans.modules.j2ee.deployment.plugins.api.InstanceProperties;
import org.netbeans.modules.j2ee.deployment.plugins.spi.MessageDestinationDeployment;
import org.netbeans.modules.j2ee.jboss4.config.mdb.JBossMessageDestination;
import org.netbeans.modules.schema2beans.BaseBean;
import org.openide.filesystems.FileLock;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.FileUtil;

public final class JBossMessageDestinationDeployment
implements MessageDestinationDeployment {
    private FileObject deployDir;

    public JBossMessageDestinationDeployment(String serverUrl) {
        String serverDirPath = InstanceProperties.getInstanceProperties((String)serverUrl).getProperty("deploy-dir");
        this.deployDir = FileUtil.toFileObject((File)new File(serverDirPath));
    }

    public Set<MessageDestination> getMessageDestinations() throws ConfigurationException {
        HashSet<MessageDestination> destinations = new HashSet<MessageDestination>();
        destinations.add(new JBossMessageDestination("SampleServerQueue", MessageDestination.Type.QUEUE));
        destinations.add(new JBossMessageDestination("SampleServerTopic", MessageDestination.Type.TOPIC));
        return destinations;
    }

    public void deployMessageDestinations(Set<MessageDestination> destinations) throws ConfigurationException {
    }

    private void writeFile(final File file, final BaseBean bean) throws ConfigurationException {
        try {
            FileSystem fs = this.deployDir.getFileSystem();
            fs.runAtomicAction(new FileSystem.AtomicAction(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void run() throws IOException {
                    OutputStream os = null;
                    FileLock lock = null;
                    try {
                        String name = file.getName();
                        FileObject configFO = JBossMessageDestinationDeployment.this.deployDir.getFileObject(name);
                        if (configFO == null) {
                            configFO = JBossMessageDestinationDeployment.this.deployDir.createData(name);
                        }
                        lock = configFO.lock();
                        os = new BufferedOutputStream(configFO.getOutputStream(lock), 4096);
                        if (bean != null) {
                            bean.write(os);
                        }
                    }
                    finally {
                        if (os != null) {
                            try {
                                os.close();
                            }
                            catch (IOException iOException) {}
                        }
                        if (lock != null) {
                            lock.releaseLock();
                        }
                    }
                }
            });
        }
        catch (IOException e) {
            throw new ConfigurationException(e.getLocalizedMessage());
        }
    }
}

