/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.jboss4;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.WeakHashMap;
import java.util.concurrent.ExecutionException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.enterprise.deploy.model.DeployableObject;
import javax.enterprise.deploy.shared.DConfigBeanVersionType;
import javax.enterprise.deploy.shared.ModuleType;
import javax.enterprise.deploy.spi.DeploymentConfiguration;
import javax.enterprise.deploy.spi.DeploymentManager;
import javax.enterprise.deploy.spi.Target;
import javax.enterprise.deploy.spi.TargetModuleID;
import javax.enterprise.deploy.spi.exceptions.DConfigBeanVersionUnsupportedException;
import javax.enterprise.deploy.spi.exceptions.InvalidModuleException;
import javax.enterprise.deploy.spi.exceptions.TargetException;
import javax.enterprise.deploy.spi.status.ProgressObject;
import javax.management.MBeanServerConnection;
import javax.management.remote.JMXConnector;
import javax.management.remote.JMXConnectorFactory;
import javax.management.remote.JMXServiceURL;
import javax.naming.InitialContext;
import javax.naming.NameNotFoundException;
import javax.naming.NamingException;
import org.netbeans.modules.j2ee.deployment.plugins.api.InstanceProperties;
import org.netbeans.modules.j2ee.jboss4.JBDeployer;
import org.netbeans.modules.j2ee.jboss4.JBDeploymentFactory;
import org.netbeans.modules.j2ee.jboss4.JBRemoteAction;
import org.netbeans.modules.j2ee.jboss4.JBoss5ProfileServiceProxy;
import org.netbeans.modules.j2ee.jboss4.ide.JBJ2eePlatformFactory;
import org.netbeans.modules.j2ee.jboss4.ide.ui.JBPluginUtils;
import org.netbeans.modules.j2ee.jboss4.util.JBProperties;

public class JBDeploymentManager
implements DeploymentManager {
    private static final Logger LOGGER = Logger.getLogger(JBDeploymentManager.class.getName());
    private final DeploymentManager dm;
    private final String realUri;
    private int debuggingPort = 8787;
    private InstanceProperties instanceProperties;
    private boolean needsRestart;
    private static final Map<InstanceProperties, Boolean> propertiesToIsRunning = Collections.synchronizedMap(new WeakHashMap());
    private JBJ2eePlatformFactory.J2eePlatformImplImpl jbPlatform;

    public JBDeploymentManager(DeploymentManager dm, String uri, String username, String password) {
        this.realUri = uri;
        this.dm = dm;
    }

    public String getHost() {
        String host = InstanceProperties.getInstanceProperties((String)this.realUri).getProperty("host");
        return host;
    }

    public int getPort() {
        String port = InstanceProperties.getInstanceProperties((String)this.realUri).getProperty("port");
        return new Integer(port);
    }

    public int getDebuggingPort() {
        return this.debuggingPort;
    }

    public String getUrl() {
        return this.realUri;
    }

    public InstanceProperties getInstanceProperties() {
        if (this.instanceProperties == null) {
            this.instanceProperties = InstanceProperties.getInstanceProperties((String)this.realUri);
        }
        return this.instanceProperties;
    }

    public <T> T invokeRemoteAction(JBRemoteAction<T> action) throws ExecutionException {
        ClassLoader oldLoader = Thread.currentThread().getContextClassLoader();
        InitialContext ctx = null;
        JMXConnector conn = null;
        try {
            InstanceProperties ip = this.getInstanceProperties();
            JBDeploymentFactory.JBClassLoader loader = JBDeploymentFactory.getJBClassLoader(ip);
            Thread.currentThread().setContextClassLoader(loader);
            JBProperties props = this.getProperties();
            Properties env = new Properties();
            String jnpPort = Integer.toString(JBPluginUtils.getJnpPortNumber(ip.getProperty("server-dir")));
            env.put("java.naming.factory.initial", "org.jboss.naming.NamingContextFactory");
            env.put("java.naming.provider.url", "jnp://localhost:" + jnpPort);
            env.put("java.naming.factory.object", "org.jboss.naming");
            env.put("java.naming.factory.url.pkgs", "org.jboss.naming:org.jnp.interfaces");
            env.put("jnp.disableDiscovery", Boolean.TRUE);
            String JAVA_SEC_AUTH_LOGIN_CONF = "java.security.auth.login.config";
            String oldAuthConf = System.getProperty("java.security.auth.login.config");
            env.put("java.naming.security.principal", props.getUsername());
            env.put("java.naming.security.credentials", props.getPassword());
            env.put("jmx.remote.credentials", new String[]{props.getUsername(), props.getPassword()});
            File securityConf = new File(props.getRootDir(), "/client/auth.conf");
            if (securityConf.exists()) {
                env.put("java.naming.factory.initial", "org.jboss.security.jndi.LoginInitialContextFactory");
                System.setProperty("java.security.auth.login.config", securityConf.getAbsolutePath());
            }
            ctx = new InitialContext(env);
            if (oldAuthConf != null) {
                System.setProperty("java.security.auth.login.config", oldAuthConf);
            } else {
                System.clearProperty("java.security.auth.login.config");
            }
            MBeanServerConnection rmiServer = null;
            try {
                conn = JMXConnectorFactory.connect(new JMXServiceURL("service:jmx:rmi:///jndi/rmi://localhost:1090/jmxrmi"));
                rmiServer = conn.getMBeanServerConnection();
            }
            catch (IOException ex) {
                LOGGER.log(Level.FINE, null, ex);
            }
            if (rmiServer == null) {
                rmiServer = (MBeanServerConnection)ctx.lookup("/jmx/invoker/RMIAdaptor");
            }
            JBoss5ProfileServiceProxy profileService = null;
            try {
                Object service = ctx.lookup("ProfileService");
                if (service != null) {
                    profileService = new JBoss5ProfileServiceProxy(service);
                }
            }
            catch (NameNotFoundException ex) {
                LOGGER.log(Level.FINE, null, ex);
            }
            T t = action.action(rmiServer, profileService);
            return t;
        }
        catch (NameNotFoundException ex) {
            LOGGER.log(Level.FINE, null, ex);
            throw new ExecutionException(ex);
        }
        catch (NamingException ex) {
            LOGGER.log(Level.FINE, null, ex);
            throw new ExecutionException(ex);
        }
        catch (Exception ex) {
            LOGGER.log(Level.FINE, null, ex);
            throw new ExecutionException(ex);
        }
        finally {
            try {
                if (ctx != null) {
                    ctx.close();
                }
            }
            catch (NamingException ex) {
                LOGGER.log(Level.FINE, null, ex);
            }
            try {
                if (conn != null) {
                    conn.close();
                }
            }
            catch (IOException ex) {
                LOGGER.log(Level.FINE, null, ex);
            }
            Thread.currentThread().setContextClassLoader(oldLoader);
        }
    }

    public static boolean isRunningLastCheck(InstanceProperties ip) {
        boolean isRunning = propertiesToIsRunning.containsKey(ip) && propertiesToIsRunning.get(ip).equals(Boolean.TRUE);
        return isRunning;
    }

    public static void setRunningLastCheck(InstanceProperties ip, Boolean isRunning) {
        assert (ip != null);
        propertiesToIsRunning.put(ip, isRunning);
    }

    public ProgressObject distribute(Target[] target, File file, File file2) throws IllegalStateException {
        return new JBDeployer(this.realUri, this).deploy(target, file, file2, this.getHost(), this.getPort());
    }

    public DeploymentConfiguration createConfiguration(DeployableObject deployableObject) throws InvalidModuleException {
        throw new RuntimeException("This method should never be called.");
    }

    public ProgressObject redeploy(TargetModuleID[] targetModuleID, InputStream inputStream, InputStream inputStream2) throws UnsupportedOperationException, IllegalStateException {
        return this.dm.redeploy(targetModuleID, inputStream, inputStream2);
    }

    public ProgressObject distribute(Target[] target, InputStream inputStream, InputStream inputStream2) throws IllegalStateException {
        return this.dm.distribute(target, inputStream, inputStream2);
    }

    public ProgressObject distribute(Target[] target, ModuleType moduleType, InputStream inputStream, InputStream inputStream0) throws IllegalStateException {
        return this.distribute(target, inputStream, inputStream0);
    }

    public ProgressObject undeploy(TargetModuleID[] targetModuleID) throws IllegalStateException {
        return this.dm.undeploy(targetModuleID);
    }

    public ProgressObject stop(TargetModuleID[] targetModuleID) throws IllegalStateException {
        return this.dm.stop(targetModuleID);
    }

    public ProgressObject start(TargetModuleID[] targetModuleID) throws IllegalStateException {
        return this.dm.start(targetModuleID);
    }

    public void setLocale(Locale locale) throws UnsupportedOperationException {
        this.dm.setLocale(locale);
    }

    public boolean isLocaleSupported(Locale locale) {
        return this.dm.isLocaleSupported(locale);
    }

    public TargetModuleID[] getAvailableModules(ModuleType moduleType, Target[] target) throws TargetException, IllegalStateException {
        return new TargetModuleID[0];
    }

    public TargetModuleID[] getNonRunningModules(ModuleType moduleType, Target[] target) throws TargetException, IllegalStateException {
        return new TargetModuleID[0];
    }

    public TargetModuleID[] getRunningModules(ModuleType moduleType, Target[] target) throws TargetException, IllegalStateException {
        return this.dm.getRunningModules(moduleType, target);
    }

    public ProgressObject redeploy(TargetModuleID[] targetModuleID, File file, File file2) throws UnsupportedOperationException, IllegalStateException {
        return new JBDeployer(this.realUri, this).redeploy(targetModuleID, file, file2);
    }

    public void setDConfigBeanVersion(DConfigBeanVersionType dConfigBeanVersionType) throws DConfigBeanVersionUnsupportedException {
        this.dm.setDConfigBeanVersion(dConfigBeanVersionType);
    }

    public boolean isDConfigBeanVersionSupported(DConfigBeanVersionType dConfigBeanVersionType) {
        return this.dm.isDConfigBeanVersionSupported(dConfigBeanVersionType);
    }

    public void release() {
        if (this.dm != null) {
            this.dm.release();
        }
    }

    public boolean isRedeploySupported() {
        return this.dm.isRedeploySupported();
    }

    public Locale getCurrentLocale() {
        return this.dm.getCurrentLocale();
    }

    public DConfigBeanVersionType getDConfigBeanVersion() {
        return this.dm.getDConfigBeanVersion();
    }

    public Locale getDefaultLocale() {
        return this.dm.getDefaultLocale();
    }

    public Locale[] getSupportedLocales() {
        return this.dm.getSupportedLocales();
    }

    public Target[] getTargets() throws IllegalStateException {
        return this.dm.getTargets();
    }

    public JBJ2eePlatformFactory.J2eePlatformImplImpl getJBPlatform() {
        if (this.jbPlatform == null) {
            this.jbPlatform = (JBJ2eePlatformFactory.J2eePlatformImplImpl)new JBJ2eePlatformFactory().getJ2eePlatformImpl(this);
        }
        return this.jbPlatform;
    }

    public JBProperties getProperties() {
        return new JBProperties(this);
    }

    public synchronized void setNeedsRestart(boolean needsRestart) {
        this.needsRestart = needsRestart;
    }

    public synchronized boolean getNeedsRestart() {
        return this.needsRestart;
    }
}

