/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.hibernate.wizards.support;

import java.awt.Component;
import java.util.List;
import javax.swing.AbstractListModel;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JComboBox;
import javax.swing.JList;
import org.netbeans.modules.hibernate.wizards.support.DBSchemaFileList;
import org.openide.filesystems.FileObject;
import org.openide.util.NbBundle;

public class DBSchemaUISupport {
    private DBSchemaUISupport() {
    }

    public static void connect(JComboBox comboBox, DBSchemaFileList dbschemaFileList) {
        comboBox.setModel(new DBSchemaModel(dbschemaFileList));
        comboBox.setRenderer(new DBSchemaRenderer(comboBox));
    }

    private static final class DBSchemaModel
    extends AbstractListModel
    implements ComboBoxModel {
        private final DBSchemaFileList dbschemaFileList;
        private Object selectedItem;

        public DBSchemaModel(DBSchemaFileList dbschemaFileList) {
            this.dbschemaFileList = dbschemaFileList;
        }

        @Override
        public void setSelectedItem(Object anItem) {
            if (this.dbschemaFileList.getFileList().size() > 0) {
                this.selectedItem = anItem;
            }
        }

        @Override
        public Object getElementAt(int index) {
            List<FileObject> dbschemaFiles = this.dbschemaFileList.getFileList();
            if (dbschemaFiles.size() > 0) {
                return dbschemaFiles.get(index);
            }
            return NbBundle.getMessage(DBSchemaUISupport.class, (String)"LBL_NoSchemas");
        }

        @Override
        public int getSize() {
            int dbschemaCount = this.dbschemaFileList.getFileList().size();
            return dbschemaCount > 0 ? dbschemaCount : 1;
        }

        @Override
        public Object getSelectedItem() {
            return this.dbschemaFileList.getFileList().size() > 0 ? this.selectedItem : NbBundle.getMessage(DBSchemaUISupport.class, (String)"LBL_NoSchemas");
        }
    }

    private static final class DBSchemaRenderer
    extends DefaultListCellRenderer {
        private JComboBox comboBox;

        public DBSchemaRenderer(JComboBox comboBox) {
            this.comboBox = comboBox;
        }

        @Override
        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            Object displayName = null;
            ComboBoxModel model = this.comboBox.getModel();
            displayName = model instanceof DBSchemaModel && value instanceof FileObject ? ((DBSchemaModel)model).dbschemaFileList.getDisplayName((FileObject)value) : value;
            return super.getListCellRendererComponent((JList<?>)list, displayName, index, isSelected, cellHasFocus);
        }
    }
}

