/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.hibernate.service.spi;

import java.io.File;
import java.io.IOException;
import java.lang.ref.WeakReference;
import java.net.MalformedURLException;
import java.net.URL;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.hibernate.HibernateException;
import org.netbeans.api.db.explorer.DatabaseConnection;
import org.netbeans.api.db.explorer.DatabaseException;
import org.netbeans.api.db.explorer.JDBCDriver;
import org.netbeans.api.db.explorer.JDBCDriverManager;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.java.project.classpath.ProjectClassPathModifier;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.api.project.libraries.Library;
import org.netbeans.api.project.libraries.LibraryManager;
import org.netbeans.modules.hibernate.cfg.model.HibernateConfiguration;
import org.netbeans.modules.hibernate.cfg.model.SessionFactory;
import org.netbeans.modules.hibernate.loaders.cfg.HibernateCfgDataObject;
import org.netbeans.modules.hibernate.loaders.mapping.HibernateMappingDataObject;
import org.netbeans.modules.hibernate.mapping.model.MyClass;
import org.netbeans.modules.hibernate.service.TableColumn;
import org.netbeans.modules.hibernate.service.api.HibernateEnvironment;
import org.netbeans.modules.hibernate.util.CustomClassLoader;
import org.netbeans.modules.hibernate.util.HibernateUtil;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.modules.InstalledFileLocator;
import org.openide.util.Exceptions;

public class HibernateEnvironmentImpl
implements HibernateEnvironment {
    private Project project;
    private Logger logger = Logger.getLogger(HibernateEnvironmentImpl.class.getName());
    private WeakReference<CustomClassLoader> loaderRef;

    public HibernateEnvironmentImpl(Project project) {
        this.project = project;
    }

    @Override
    public boolean canLoadDBDriver(HibernateConfiguration hibernateConfiguration) {
        String string = HibernateUtil.getDbConnectionDetails(hibernateConfiguration, "hibernate.connection.driver_class");
        if (string == null || "".equals(string)) {
            string = HibernateUtil.getDbConnectionDetails(hibernateConfiguration, "connection.driver_class");
        }
        if (string == null || "".equals(string)) {
            this.logger.info("dbDriver class could not be found from the config.");
            return false;
        }
        try {
            ClassLoader classLoader = this.getProjectClassLoader(this.getProjectClassPath().toArray(new URL[0]));
            classLoader.loadClass(string);
            this.logger.info("dbDriver loaded.");
            return true;
        }
        catch (Exception exception) {
            this.logger.info("Could not load dbDriver class. CNFE");
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean canDirectlyConnectToDB(HibernateConfiguration hibernateConfiguration) {
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        ClassLoader classLoader2 = null;
        try {
            DatabaseConnection databaseConnection = HibernateUtil.getDBConnection(hibernateConfiguration);
            if (databaseConnection != null) {
                databaseConnection.getJDBCConnection();
            }
            classLoader2 = this.getProjectClassLoader(this.getProjectClassPath().toArray(new URL[0]));
            Thread.currentThread().setContextClassLoader(classLoader2);
            HibernateUtil.getDirectDBConnection(hibernateConfiguration);
            this.logger.info("Direct Database connection established.");
            Thread.currentThread().setContextClassLoader(classLoader);
            boolean bl = true;
            return bl;
        }
        catch (Exception exception) {
            this.logger.log(Level.INFO, "Cannot establish direct database connection", exception);
        }
        finally {
            if (classLoader2 != null) {
                Thread.currentThread().setContextClassLoader(classLoader);
            }
        }
        return false;
    }

    @Override
    public FileObject getSourceLocation() {
        SourceGroup[] sourceGroupArray = HibernateUtil.getSourceGroups(this.project);
        if (sourceGroupArray != null && sourceGroupArray.length != 0) {
            return sourceGroupArray[0].getRootFolder();
        }
        return null;
    }

    @Override
    public List<String> getAllDatabaseTablesForProject() {
        return this.getAllDatabaseTables(HibernateUtil.getAllHibernateConfigurations(this.project).toArray(new HibernateConfiguration[0]));
    }

    @Override
    public List<String> getDatabaseTables(FileObject fileObject) {
        ArrayList<String> arrayList = new ArrayList<String>();
        try {
            List<HibernateConfiguration> list = this.getHibernateConfigurationForMappingFile(fileObject);
            if (list.size() == 0) {
                return arrayList;
            }
            arrayList.addAll(HibernateUtil.getAllDatabaseTables(list.toArray(new HibernateConfiguration[0])));
        }
        catch (SQLException sQLException) {
            Exceptions.printStackTrace((Throwable)sQLException);
        }
        catch (HibernateException hibernateException) {
            Exceptions.printStackTrace((Throwable)hibernateException);
        }
        return arrayList;
    }

    @Override
    public List<HibernateConfiguration> getAllHibernateConfigurationsFromProject() {
        return HibernateUtil.getAllHibernateConfigurations(this.project);
    }

    @Override
    public List<FileObject> getAllHibernateConfigFileObjects() {
        return HibernateUtil.getAllHibernateConfigFileObjects(this.project);
    }

    @Override
    public List<FileObject> getDefaultHibernateConfigFileObjects() {
        return HibernateUtil.getDefaultHibernateConfigFileObjects(this.project);
    }

    @Override
    public List<FileObject> getAllHibernateMappingFileObjects() {
        return HibernateUtil.getAllHibernateMappingFileObjects(this.project);
    }

    @Override
    public List<String> getAllHibernateMappings() {
        return HibernateUtil.getAllHibernateMappingsRelativeToSourcePath(this.project);
    }

    @Override
    public List<FileObject> getAllHibernateReverseEnggFileObjects() {
        return HibernateUtil.getAllHibernateReverseEnggFileObjects(this.project);
    }

    @Override
    public List<String> getAllDatabaseTables(HibernateConfiguration ... hibernateConfigurationArray) {
        try {
            return HibernateUtil.getAllDatabaseTables(hibernateConfigurationArray);
        }
        catch (SQLException sQLException) {
            Exceptions.printStackTrace((Throwable)sQLException);
        }
        catch (HibernateException hibernateException) {
            Exceptions.printStackTrace((Throwable)hibernateException);
        }
        return null;
    }

    @Override
    public List<String> getAllDatabaseTablesOnEventThread(FileObject fileObject) throws DataObjectNotFoundException, DatabaseException, SQLException {
        return HibernateUtil.getAllDatabaseTablesOnEventThread(fileObject);
    }

    @Override
    public List<TableColumn> getColumnsForTable(String string, FileObject fileObject) {
        ArrayList<TableColumn> arrayList = new ArrayList<TableColumn>();
        List<HibernateConfiguration> list = this.getHibernateConfigurationForMappingFile(fileObject);
        if (list.size() == 0) {
            return arrayList;
        }
        for (HibernateConfiguration hibernateConfiguration : list) {
            arrayList.addAll(HibernateUtil.getColumnsForTable(string, hibernateConfiguration));
        }
        return arrayList;
    }

    @Override
    public boolean addHibernateLibraryToProject(FileObject fileObject) {
        boolean bl = false;
        try {
            LibraryManager libraryManager = LibraryManager.getDefault();
            Library library = libraryManager.getLibrary("hibernate-support");
            Library library2 = libraryManager.getLibrary("ejb3-persistence");
            Library[] libraryArray = null;
            this.project.getProjectDirectory().getFileSystem().refresh(true);
            ClassPath classPath = ClassPath.getClassPath((FileObject)fileObject, (String)"classpath/execute");
            if (classPath == null) {
                this.logger.info("Cannot register libraries because cannot get the classpath for created file : " + fileObject);
                return false;
            }
            libraryArray = !this.containsClass(classPath, "javax.persistence.EntityManager") ? new Library[]{library, library2} : new Library[]{library};
            bl = ProjectClassPathModifier.addLibraries((Library[])libraryArray, (FileObject)fileObject, (String)"classpath/compile");
        }
        catch (IOException iOException) {
            Exceptions.printStackTrace((Throwable)iOException);
            bl = false;
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            this.logger.info("Library registration not possible : " + this.project);
        }
        return bl;
    }

    @Override
    public List<String> getAllHibernateMappingsFromConfiguration(HibernateConfiguration hibernateConfiguration) {
        ArrayList<String> arrayList = new ArrayList<String>();
        SessionFactory sessionFactory = hibernateConfiguration.getSessionFactory();
        ArrayList<String> arrayList2 = new ArrayList<String>();
        int n = 0;
        for (boolean bl : sessionFactory.getMapping()) {
            String string2 = sessionFactory.getAttributeValue("Mapping", n, "resource");
            if (string2 != null) {
                arrayList.add(string2);
            }
            if ((string2 = sessionFactory.getAttributeValue("Mapping", n, "file")) != null) {
                arrayList.add(string2);
            }
            if ((string2 = sessionFactory.getAttributeValue("Mapping", n, "package")) != null) {
                arrayList2.add(string2);
            }
            ++n;
        }
        if (arrayList2.size() != 0) {
            Object object = HibernateUtil.getAllHibernateMappingsRelativeToSourcePath(this.project);
            Iterator iterator = object.iterator();
            while (iterator.hasNext()) {
                String string = (String)iterator.next();
                for (String string2 : arrayList2) {
                    if (!string.startsWith(string2 = string2.replace(".", "/"))) continue;
                    arrayList.add(string);
                }
            }
        }
        return arrayList;
    }

    private List<HibernateConfiguration> getHibernateConfigurationForMappingFile(FileObject fileObject) {
        ArrayList<HibernateConfiguration> arrayList = new ArrayList<HibernateConfiguration>();
        for (HibernateConfiguration hibernateConfiguration : this.getAllHibernateConfigurationsFromProject()) {
            for (String string : this.getAllHibernateMappingsFromConfiguration(hibernateConfiguration)) {
                if (string.trim().equals("") || !fileObject.getPath().contains(string)) continue;
                arrayList.add(hibernateConfiguration);
            }
        }
        return arrayList;
    }

    @Override
    public List<URL> getProjectClassPath(FileObject fileObject) {
        return HibernateUtil.getProjectClassPathEntries(fileObject);
    }

    @Override
    public List<URL> getProjectClassPath() {
        return HibernateUtil.getProjectClassPath(this.project);
    }

    @Override
    public Project getProject() {
        return this.project;
    }

    @Override
    public List<String> getAnnotatedPOJOClassNames(FileObject fileObject) {
        ArrayList<String> arrayList = new ArrayList<String>();
        try {
            HibernateCfgDataObject hibernateCfgDataObject = (HibernateCfgDataObject)DataObject.find((FileObject)fileObject);
            HibernateConfiguration hibernateConfiguration = hibernateCfgDataObject.getHibernateConfiguration();
            SessionFactory sessionFactory = hibernateConfiguration.getSessionFactory();
            int n = 0;
            for (boolean bl : sessionFactory.getMapping()) {
                String string;
                if ((string = sessionFactory.getAttributeValue("Mapping", n++, "class")) == null) continue;
                arrayList.add(string);
            }
        }
        catch (DataObjectNotFoundException dataObjectNotFoundException) {
            this.logger.log(Level.INFO, "DataObject not found during Annototated POJO procesing.", dataObjectNotFoundException);
        }
        return arrayList;
    }

    @Override
    public Map<FileObject, List<String>> getAllPOJONamesFromConfiguration(FileObject fileObject) {
        HashMap<FileObject, List<String>> hashMap = new HashMap<FileObject, List<String>>();
        try {
            HibernateCfgDataObject hibernateCfgDataObject = (HibernateCfgDataObject)DataObject.find((FileObject)fileObject);
            for (String string : this.getAllHibernateMappingsFromConfiguration(hibernateCfgDataObject.getHibernateConfiguration())) {
                for (FileObject fileObject2 : this.getAllHibernateMappingFileObjects()) {
                    if (!string.contains(fileObject2.getName())) continue;
                    List<String> list = this.getPOJONameFromMapping(fileObject2);
                    hashMap.put(fileObject2, list);
                }
            }
        }
        catch (DataObjectNotFoundException dataObjectNotFoundException) {
            Exceptions.printStackTrace((Throwable)dataObjectNotFoundException);
        }
        return hashMap;
    }

    private List<String> getPOJONameFromMapping(FileObject fileObject) {
        ArrayList<String> arrayList = new ArrayList<String>();
        try {
            HibernateMappingDataObject hibernateMappingDataObject = (HibernateMappingDataObject)DataObject.find((FileObject)fileObject);
            for (MyClass myClass : hibernateMappingDataObject.getHibernateMapping().getMyClass()) {
                String string = myClass.getAttributeValue("name");
                arrayList.add(string);
            }
        }
        catch (DataObjectNotFoundException dataObjectNotFoundException) {
            Exceptions.printStackTrace((Throwable)dataObjectNotFoundException);
        }
        return arrayList;
    }

    private boolean containsClass(ClassPath classPath, String string) {
        String string2 = string.replace('.', '/') + ".class";
        return classPath.findResource(string2) != null;
    }

    @Override
    public boolean registerDBDriver(String string, FileObject fileObject) {
        boolean bl = false;
        JDBCDriver[] jDBCDriverArray = JDBCDriverManager.getDefault().getDrivers(string);
        ArrayList<URL> arrayList = new ArrayList<URL>();
        for (JDBCDriver jDBCDriver : jDBCDriverArray) {
            for (URL uRL : jDBCDriver.getURLs()) {
                File file = null;
                if (uRL.getProtocol().equals("nbinst")) {
                    try {
                        file = InstalledFileLocator.getDefault().locate(uRL.getFile().substring(1), null, false);
                        this.logger.info("Bundled DB Driver Jar : " + file);
                        if (file == null) continue;
                        uRL = file.toURI().toURL();
                    }
                    catch (MalformedURLException malformedURLException) {
                        Exceptions.printStackTrace((Throwable)malformedURLException);
                    }
                } else {
                    this.logger.info("User provided DB Driver Jar : " + uRL);
                }
                if (FileUtil.isArchiveFile((URL)uRL)) {
                    arrayList.add(FileUtil.getArchiveRoot((URL)uRL));
                    continue;
                }
                arrayList.add(uRL);
            }
        }
        try {
            bl = ProjectClassPathModifier.addRoots((URL[])arrayList.toArray(new URL[0]), (FileObject)fileObject, (String)"classpath/compile");
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            this.logger.info("DB Driver registration not possible : " + this.project);
            bl = false;
        }
        catch (Exception exception) {
            bl = false;
            this.logger.log(Level.INFO, "Problem in registering db driver.", exception);
        }
        return bl;
    }

    @Override
    public ClassLoader getProjectClassLoader(URL[] uRLArray) {
        Object[] objectArray;
        CustomClassLoader customClassLoader;
        CustomClassLoader customClassLoader2 = new CustomClassLoader(uRLArray, this.getClass().getClassLoader());
        if (this.loaderRef != null && (customClassLoader = (CustomClassLoader)this.loaderRef.get()) != null && Arrays.equals(objectArray = customClassLoader.getURLs(), uRLArray = customClassLoader2.getURLs())) {
            return customClassLoader;
        }
        this.loaderRef = new WeakReference<CustomClassLoader>(customClassLoader2);
        return customClassLoader2;
    }
}

