/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.hibernate.loaders.cfg.multiview;

import java.awt.Dialog;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.Action;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.modules.hibernate.cfg.model.Event;
import org.netbeans.modules.hibernate.cfg.model.HibernateConfiguration;
import org.netbeans.modules.hibernate.cfg.model.SessionFactory;
import org.netbeans.modules.hibernate.loaders.cfg.HibernateCfgDataObject;
import org.netbeans.modules.hibernate.loaders.cfg.multiview.HibernateCfgPanelFactory;
import org.netbeans.modules.hibernate.loaders.cfg.multiview.NewEventPanel;
import org.netbeans.modules.xml.multiview.Error;
import org.netbeans.modules.xml.multiview.ToolBarMultiViewElement;
import org.netbeans.modules.xml.multiview.XmlMultiViewDataObject;
import org.netbeans.modules.xml.multiview.ui.ConfirmDialog;
import org.netbeans.modules.xml.multiview.ui.EditDialog;
import org.netbeans.modules.xml.multiview.ui.InnerPanelFactory;
import org.netbeans.modules.xml.multiview.ui.NodeSectionPanel;
import org.netbeans.modules.xml.multiview.ui.PanelView;
import org.netbeans.modules.xml.multiview.ui.SectionContainer;
import org.netbeans.modules.xml.multiview.ui.SectionContainerNode;
import org.netbeans.modules.xml.multiview.ui.SectionPanel;
import org.netbeans.modules.xml.multiview.ui.SectionView;
import org.netbeans.modules.xml.multiview.ui.ToolBarDesignEditor;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.filesystems.FileObject;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.util.HelpCtx;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;

public class HibernateCfgToolBarMVElement
extends ToolBarMultiViewElement {
    public static final String PROPERTIES = "Properties";
    public static final String JDBC_PROPS = "JDBC Properties";
    public static final String DATASOURCE_PROPS = "Datasource Properties";
    public static final String OPTIONAL_PROPS = "Optional Properties";
    public static final String CONFIGURATION_PROPS = "Configuration Properties";
    public static final String JDBC_CONNECTION_PROPS = "JDBC and Connection Properties";
    public static final String CACHE_PROPS = "Cache Properties";
    public static final String TRANSACTION_PROPS = "Transaction Properties";
    public static final String MISCELLANEOUS_PROPS = "Miscellaneous Properties";
    public static final String MAPPINGS = "Mappings";
    public static final String CLASS_CACHE = "Class Cache";
    public static final String COLLECTION_CACHE = "Collection Cache";
    public static final String CACHE = "Cache";
    public static final String EVENTS = "Events";
    public static final String EVENT = "Event";
    public static final String SECURITY = "Security";
    private ConfigurationView view;
    private ToolBarDesignEditor comp;
    private HibernateCfgDataObject configDataObject;
    private HibernateCfgPanelFactory factory;
    private Project project;
    private Action addEvent;
    private Action removeEventAction;

    public HibernateCfgToolBarMVElement(Lookup lookup) {
        this((HibernateCfgDataObject)((Object)lookup.lookup(HibernateCfgDataObject.class)));
    }

    public HibernateCfgToolBarMVElement(HibernateCfgDataObject dObj) {
        super((XmlMultiViewDataObject)dObj);
        this.configDataObject = dObj;
        this.project = FileOwnerQuery.getOwner((FileObject)dObj.getPrimaryFile());
        this.addEvent = new AddEventAction(NbBundle.getMessage(HibernateCfgToolBarMVElement.class, (String)"LBL_Add"));
        this.removeEventAction = new RemoveEventAction(NbBundle.getMessage(HibernateCfgToolBarMVElement.class, (String)"LBL_Remove"));
        this.comp = new ToolBarDesignEditor();
        this.factory = new HibernateCfgPanelFactory(this.comp, dObj);
        this.setVisualEditor(this.comp);
    }

    public SectionView getSectionView() {
        return this.view;
    }

    public void componentOpened() {
        super.componentOpened();
    }

    public void componentClosed() {
        super.componentClosed();
    }

    public void componentShowing() {
        super.componentShowing();
        this.view = new ConfigurationView(this.configDataObject);
        if (!this.configDataObject.viewCanBeDisplayed()) {
            this.view.setRoot(Node.EMPTY);
            this.comp.setContentView((PanelView)this.view);
            return;
        }
        this.view.initialize();
        this.comp.setContentView((PanelView)this.view);
        Object lastActive = this.comp.getLastActive();
        if (lastActive != null) {
            this.view.openPanel(lastActive);
        } else {
            Node[] childrenNodes = this.view.getSessionFactoryContainerNode().getChildren().getNodes();
            if (childrenNodes.length > 0) {
                this.view.selectNode(childrenNodes[0]);
            }
        }
        this.view.checkValidity();
    }

    private class AddEventAction
    extends AbstractAction {
        AddEventAction(String actionName) {
            super(actionName);
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            NewEventPanel dialogPanel = new NewEventPanel();
            EditDialog dialog = new EditDialog(dialogPanel, NbBundle.getMessage(HibernateCfgToolBarMVElement.class, (String)"LBL_Event"), true){

                protected String validate() {
                    return null;
                }
            };
            Dialog d = DialogDisplayer.getDefault().createDialog((DialogDescriptor)dialog);
            d.setVisible(true);
            if (dialog.getValue().equals(EditDialog.OK_OPTION)) {
                String eventType = dialogPanel.getEventType();
                Event event = new Event();
                event.setAttributeValue("Type", eventType);
                HibernateCfgToolBarMVElement.this.configDataObject.getHibernateConfiguration().getSessionFactory().addEvent(event);
                HibernateCfgToolBarMVElement.this.configDataObject.modelUpdatedFromUI();
                ConfigurationView view = (ConfigurationView)HibernateCfgToolBarMVElement.this.comp.getContentView();
                ElementLeafNode eventNode = new ElementLeafNode(eventType);
                view.getEventsContainerNode().getChildren().add(new Node[]{eventNode});
                SectionPanel pan = new SectionPanel((SectionView)view, (Node)eventNode, eventNode.getDisplayName(), (Object)event, false, false);
                pan.setHeaderActions(new Action[]{HibernateCfgToolBarMVElement.this.removeEventAction});
                view.getEventsContainer().addSection((NodeSectionPanel)pan, true);
            }
        }
    }

    private class ConfigurationView
    extends SectionView {
        private HibernateCfgDataObject configDataObject;
        private Node securityNode;
        private Node sessionFactoryContainerNode;
        private Node eventsContainerNode;
        private SectionContainer eventsCont;

        ConfigurationView(HibernateCfgDataObject dObj) {
            super((InnerPanelFactory)HibernateCfgToolBarMVElement.this.factory);
            this.configDataObject = dObj;
        }

        public Node getSessionFactoryContainerNode() {
            return this.sessionFactoryContainerNode;
        }

        public Node getEventsContainerNode() {
            return this.eventsContainerNode;
        }

        public SectionContainer getEventsContainer() {
            return this.eventsCont;
        }

        public Node getSecurityNode() {
            return this.securityNode;
        }

        void initialize() {
            HibernateConfiguration configuration = this.configDataObject.getHibernateConfiguration();
            if (configuration == null) {
                return;
            }
            ElementLeafNode jdbcPropsNode = new ElementLeafNode(NbBundle.getMessage(HibernateCfgToolBarMVElement.class, (String)"LBL_Jdbc_Properties"));
            ElementLeafNode datasourcePropsNode = new ElementLeafNode(NbBundle.getMessage(HibernateCfgToolBarMVElement.class, (String)"LBL_Datasource_Properties"));
            ElementLeafNode configPropsNode = new ElementLeafNode(NbBundle.getMessage(HibernateCfgToolBarMVElement.class, (String)"LBL_Hibernate_Configuration_properties"));
            ElementLeafNode jdbcConnPropsNode = new ElementLeafNode(NbBundle.getMessage(HibernateCfgToolBarMVElement.class, (String)"LBL_Jdbc_Connection_Properties"));
            ElementLeafNode cachePropsNode = new ElementLeafNode(NbBundle.getMessage(HibernateCfgToolBarMVElement.class, (String)"LBL_Cache_Properties"));
            ElementLeafNode transactionPropsNode = new ElementLeafNode(NbBundle.getMessage(HibernateCfgToolBarMVElement.class, (String)"LBL_Transaction_Properties"));
            ElementLeafNode miscPropsNode = new ElementLeafNode(NbBundle.getMessage(HibernateCfgToolBarMVElement.class, (String)"LBL_Miscellaneous_Properties"));
            Children.Array optionalPropsCh = new Children.Array();
            optionalPropsCh.add(new Node[]{configPropsNode, jdbcConnPropsNode, cachePropsNode, transactionPropsNode, miscPropsNode});
            SectionContainerNode optionalPropsContainerNode = new SectionContainerNode((Children)optionalPropsCh);
            optionalPropsContainerNode.setDisplayName(NbBundle.getMessage(HibernateCfgToolBarMVElement.class, (String)"LBL_Optional_Properties"));
            SectionContainer optionalPropsContainer = new SectionContainer((SectionView)this, (Node)optionalPropsContainerNode, NbBundle.getMessage(HibernateCfgToolBarMVElement.class, (String)"LBL_Optional_Properties"));
            optionalPropsContainer.addSection((NodeSectionPanel)new SectionPanel((SectionView)this, (Node)configPropsNode, configPropsNode.getDisplayName(), (Object)HibernateCfgToolBarMVElement.CONFIGURATION_PROPS, false, false));
            optionalPropsContainer.addSection((NodeSectionPanel)new SectionPanel((SectionView)this, (Node)jdbcConnPropsNode, jdbcConnPropsNode.getDisplayName(), (Object)HibernateCfgToolBarMVElement.JDBC_CONNECTION_PROPS, false, false));
            optionalPropsContainer.addSection((NodeSectionPanel)new SectionPanel((SectionView)this, (Node)cachePropsNode, cachePropsNode.getDisplayName(), (Object)HibernateCfgToolBarMVElement.CACHE_PROPS, false, false));
            optionalPropsContainer.addSection((NodeSectionPanel)new SectionPanel((SectionView)this, (Node)transactionPropsNode, transactionPropsNode.getDisplayName(), (Object)HibernateCfgToolBarMVElement.TRANSACTION_PROPS, false, false));
            optionalPropsContainer.addSection((NodeSectionPanel)new SectionPanel((SectionView)this, (Node)miscPropsNode, miscPropsNode.getDisplayName(), (Object)HibernateCfgToolBarMVElement.MISCELLANEOUS_PROPS, false, false));
            ElementLeafNode mappingsNode = new ElementLeafNode(NbBundle.getMessage(HibernateCfgToolBarMVElement.class, (String)"LBL_Mappings"));
            ElementLeafNode classCacheNode = new ElementLeafNode(NbBundle.getMessage(HibernateCfgToolBarMVElement.class, (String)"LBL_Class_Cache"));
            ElementLeafNode collectionCacheNode = new ElementLeafNode(NbBundle.getMessage(HibernateCfgToolBarMVElement.class, (String)"LBL_Collection_Cache"));
            Children.Array cacheCh = new Children.Array();
            cacheCh.add(new Node[]{classCacheNode, collectionCacheNode});
            SectionContainerNode cacheContainerNode = new SectionContainerNode((Children)cacheCh);
            cacheContainerNode.setDisplayName(NbBundle.getMessage(HibernateCfgToolBarMVElement.class, (String)"LBL_Cache"));
            SectionContainer cacheCont = new SectionContainer((SectionView)this, (Node)cacheContainerNode, NbBundle.getMessage(HibernateCfgToolBarMVElement.class, (String)"LBL_Cache"));
            cacheCont.addSection((NodeSectionPanel)new SectionPanel((SectionView)this, (Node)classCacheNode, classCacheNode.getDisplayName(), (Object)HibernateCfgToolBarMVElement.CLASS_CACHE, false, false));
            cacheCont.addSection((NodeSectionPanel)new SectionPanel((SectionView)this, (Node)collectionCacheNode, collectionCacheNode.getDisplayName(), (Object)HibernateCfgToolBarMVElement.COLLECTION_CACHE, false, false));
            if (configuration.getSessionFactory() == null) {
                configuration.setSessionFactory(new SessionFactory());
            }
            Event[] events = configuration.getSessionFactory().getEvent();
            Node[] eventNodes = new Node[events.length];
            for (int i = 0; i < events.length; ++i) {
                String type = events[i].getAttributeValue("Type");
                eventNodes[i] = new ElementLeafNode(type);
            }
            Children.Array eventsCh = new Children.Array();
            eventsCh.add(eventNodes);
            this.eventsContainerNode = new SectionContainerNode((Children)eventsCh);
            this.eventsContainerNode.setDisplayName(NbBundle.getMessage(HibernateCfgToolBarMVElement.class, (String)"LBL_Events"));
            this.eventsCont = new SectionContainer((SectionView)this, this.eventsContainerNode, NbBundle.getMessage(HibernateCfgToolBarMVElement.class, (String)"LBL_Events"));
            this.eventsCont.setHeaderActions(new Action[]{HibernateCfgToolBarMVElement.this.addEvent});
            SectionPanel[] panels = new SectionPanel[events.length];
            for (int i = 0; i < events.length; ++i) {
                panels[i] = new SectionPanel((SectionView)this, eventNodes[i], eventNodes[i].getDisplayName(), (Object)events[i], false, false);
                panels[i].setHeaderActions(new Action[]{HibernateCfgToolBarMVElement.this.removeEventAction});
                this.eventsCont.addSection((NodeSectionPanel)panels[i]);
            }
            Children.Array sessionFactoryCh = new Children.Array();
            sessionFactoryCh.add(new Node[]{jdbcPropsNode, datasourcePropsNode, mappingsNode, cacheContainerNode, this.eventsContainerNode, optionalPropsContainerNode});
            this.sessionFactoryContainerNode = new SectionContainerNode((Children)sessionFactoryCh);
            this.sessionFactoryContainerNode.setDisplayName(NbBundle.getMessage(HibernateCfgToolBarMVElement.class, (String)"LBL_SessionFactory"));
            SectionContainer sessionFactoryCont = new SectionContainer((SectionView)this, this.sessionFactoryContainerNode, NbBundle.getMessage(HibernateCfgToolBarMVElement.class, (String)"LBL_SessionFactory"));
            sessionFactoryCont.addSection((NodeSectionPanel)new SectionPanel((SectionView)this, (Node)jdbcPropsNode, jdbcPropsNode.getDisplayName(), (Object)HibernateCfgToolBarMVElement.JDBC_PROPS, false, false));
            sessionFactoryCont.addSection((NodeSectionPanel)new SectionPanel((SectionView)this, (Node)datasourcePropsNode, datasourcePropsNode.getDisplayName(), (Object)HibernateCfgToolBarMVElement.DATASOURCE_PROPS, false, false));
            sessionFactoryCont.addSection((NodeSectionPanel)new SectionPanel((SectionView)this, (Node)mappingsNode, mappingsNode.getDisplayName(), (Object)HibernateCfgToolBarMVElement.MAPPINGS, false, false));
            sessionFactoryCont.addSection((NodeSectionPanel)cacheCont);
            sessionFactoryCont.addSection((NodeSectionPanel)this.eventsCont);
            sessionFactoryCont.addSection((NodeSectionPanel)optionalPropsContainer);
            this.securityNode = new ElementLeafNode(NbBundle.getMessage(HibernateCfgToolBarMVElement.class, (String)"LBL_Security"));
            Children.Array rootChildren = new Children.Array();
            rootChildren.add(new Node[]{this.sessionFactoryContainerNode, this.securityNode});
            AbstractNode root = new AbstractNode((Children)rootChildren);
            this.addSection((NodeSectionPanel)sessionFactoryCont);
            this.addSection((NodeSectionPanel)new SectionPanel((SectionView)this, this.securityNode, this.securityNode.getDisplayName(), (Object)HibernateCfgToolBarMVElement.SECURITY, false, false));
            this.setRoot((Node)root);
        }

        public Error validateView() {
            return null;
        }
    }

    private class ElementLeafNode
    extends AbstractNode {
        ElementLeafNode(String displayName) {
            super(Children.LEAF);
            this.setDisplayName(displayName);
        }

        public HelpCtx getHelpCtx() {
            return null;
        }
    }

    private class RemoveEventAction
    extends AbstractAction {
        RemoveEventAction(String actionName) {
            super(actionName);
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            SectionPanel sectionPanel = ((SectionPanel.HeaderButton)evt.getSource()).getSectionPanel();
            Event event = (Event)((Object)sectionPanel.getKey());
            ConfirmDialog desc = new ConfirmDialog(NbBundle.getMessage(HibernateCfgToolBarMVElement.class, (String)"TXT_Remove_Event", (Object)event.getAttributeValue("Type")));
            Dialog dialog = DialogDisplayer.getDefault().createDialog((DialogDescriptor)desc);
            dialog.setVisible(true);
            if (DialogDescriptor.OK_OPTION.equals(desc.getValue())) {
                sectionPanel.getSectionView().removeSection(sectionPanel.getNode());
                HibernateCfgToolBarMVElement.this.configDataObject.getHibernateConfiguration().getSessionFactory().removeEvent(event);
                HibernateCfgToolBarMVElement.this.configDataObject.modelUpdatedFromUI();
            }
        }
    }
}

