/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.hibernate.loaders.cfg.multiview;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import org.netbeans.api.project.SourceGroup;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.explorer.ExplorerManager;
import org.openide.explorer.view.BeanTreeView;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.nodes.FilterNode;
import org.openide.nodes.Node;
import org.openide.util.NbBundle;
import org.openide.util.actions.SystemAction;

public class BrowseFolders
extends JPanel
implements ExplorerManager.Provider {
    private ExplorerManager manager;
    private SourceGroup[] folders;
    private static JScrollPane SAMPLE_SCROLL_PANE = new JScrollPane();
    private JPanel folderPanel;
    private JLabel jLabel1;

    public BrowseFolders(SourceGroup[] folders) {
        this.initComponents();
        this.folders = folders;
        this.manager = new ExplorerManager();
        AbstractNode rootNode = new AbstractNode((Children)new SourceGroupsChildren(folders));
        this.manager.setRootContext((Node)rootNode);
        BeanTreeView btv = new BeanTreeView();
        btv.setRootVisible(false);
        btv.setSelectionMode(1);
        btv.setBorder(SAMPLE_SCROLL_PANE.getBorder());
        this.folderPanel.add((Component)btv, "Center");
    }

    public ExplorerManager getExplorerManager() {
        return this.manager;
    }

    public static FileObject showDialog(SourceGroup[] folders) {
        BrowseFolders bf = new BrowseFolders(folders);
        Object[] options = new JButton[]{new JButton(NbBundle.getMessage(BrowseFolders.class, (String)"LBL_SelectFile")), new JButton(NbBundle.getMessage(BrowseFolders.class, (String)"LBL_Cancel"))};
        OptionsListener optionsListener = new OptionsListener(bf);
        options[0].setActionCommand("SELECT");
        options[0].addActionListener(optionsListener);
        options[0].getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(BrowseFolders.class, (String)"ACSD_SelectFile"));
        options[1].setActionCommand("CANCEL");
        options[1].addActionListener(optionsListener);
        options[1].getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(BrowseFolders.class, (String)"ACSD_Cancel"));
        DialogDescriptor dialogDescriptor = new DialogDescriptor((Object)bf, NbBundle.getMessage(BrowseFolders.class, (String)"LBL_BrowseFiles"), true, options, (Object)options[0], 0, null, null);
        dialogDescriptor.setClosingOptions(new Object[]{options[0], options[1]});
        Dialog dialog = DialogDisplayer.getDefault().createDialog(dialogDescriptor);
        dialog.setVisible(true);
        return optionsListener.getResult();
    }

    private void initComponents() {
        this.jLabel1 = new JLabel();
        this.folderPanel = new JPanel();
        this.setBorder(BorderFactory.createEmptyBorder(12, 12, 12, 12));
        this.setLayout(new GridBagLayout());
        this.jLabel1.setText(NbBundle.getMessage(BrowseFolders.class, (String)"LBL_Folders"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 0, 2, 0);
        this.add((Component)this.jLabel1, gridBagConstraints);
        this.folderPanel.setLayout(new BorderLayout());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.gridheight = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.add((Component)this.folderPanel, gridBagConstraints);
        this.getAccessibleContext().setAccessibleDescription("null");
    }

    private static final class OptionsListener
    implements ActionListener {
        public static final String COMMAND_SELECT = "SELECT";
        public static final String COMMAND_CANCEL = "CANCEL";
        private BrowseFolders browsePanel;
        private FileObject result;

        public OptionsListener(BrowseFolders browsePanel) {
            this.browsePanel = browsePanel;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Node[] selection;
            String command = e.getActionCommand();
            if (COMMAND_SELECT.equals(command) && (selection = this.browsePanel.getExplorerManager().getSelectedNodes()) != null && selection.length > 0) {
                DataObject dobj = (DataObject)selection[0].getLookup().lookup(DataObject.class);
                this.result = dobj.getPrimaryFile();
            }
        }

        public FileObject getResult() {
            return this.result;
        }
    }

    class SimpleFilterNode
    extends FilterNode {
        public SimpleFilterNode(Node node, Children children) {
            super(node, children);
        }

        public SystemAction[] getActions(boolean context) {
            return new SystemAction[0];
        }
    }

    private final class SourceGroupsChildren
    extends Children.Keys {
        private SourceGroup[] groups;
        private SourceGroup group;
        private FileObject fo;

        public SourceGroupsChildren(SourceGroup[] groups) {
            this.groups = groups;
        }

        public SourceGroupsChildren(FileObject fo, SourceGroup group) {
            this.fo = fo;
            this.group = group;
        }

        protected void addNotify() {
            super.addNotify();
            this.setKeys(this.getKeys());
        }

        protected void removeNotify() {
            this.setKeys(Collections.EMPTY_SET);
            super.removeNotify();
        }

        protected Node[] createNodes(Object key) {
            FileObject fObj = null;
            SourceGroup grp = null;
            boolean isFile = false;
            if (key instanceof SourceGroup) {
                fObj = ((SourceGroup)key).getRootFolder();
                grp = (SourceGroup)key;
            } else if (key instanceof Key) {
                fObj = ((Key)key).folder;
                grp = ((Key)key).group;
                if (!fObj.isFolder()) {
                    isFile = true;
                }
            }
            try {
                SimpleFilterNode fn;
                DataObject dobj = DataObject.find((FileObject)fObj);
                SimpleFilterNode simpleFilterNode = fn = isFile ? new SimpleFilterNode(dobj.getNodeDelegate(), Children.LEAF) : new SimpleFilterNode(dobj.getNodeDelegate(), (Children)new SourceGroupsChildren(fObj, grp));
                if (key instanceof SourceGroup) {
                    fn.setDisplayName(grp.getDisplayName());
                }
                return new Node[]{fn};
            }
            catch (DataObjectNotFoundException e) {
                return null;
            }
        }

        private Collection getKeys() {
            int i;
            if (this.groups != null) {
                return Arrays.asList(this.groups);
            }
            FileObject[] files = this.fo.getChildren();
            Arrays.sort(files, new Comparator<FileObject>(){

                @Override
                public int compare(FileObject f1, FileObject f2) {
                    return f1.getName().compareTo(f2.getName());
                }
            });
            ArrayList<Key> children = new ArrayList<Key>(files.length);
            for (i = 0; i < files.length; ++i) {
                if (!this.group.contains(files[i]) || !files[i].isFolder()) continue;
                children.add(new Key(files[i], this.group));
            }
            for (i = 0; i < files.length; ++i) {
                if (!this.group.contains(files[i]) || files[i].isFolder()) continue;
                children.add(new Key(files[i], this.group));
            }
            return children;
        }

        private class Key {
            private FileObject folder;
            private SourceGroup group;

            private Key(FileObject folder, SourceGroup group) {
                this.folder = folder;
                this.group = group;
            }
        }
    }
}

