/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.ddloaders.web.multiview;

import java.awt.Dialog;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.event.DocumentListener;
import javax.swing.table.AbstractTableModel;
import org.netbeans.modules.j2ee.dd.api.common.CommonDDBean;
import org.netbeans.modules.j2ee.dd.api.web.SecurityConstraint;
import org.netbeans.modules.j2ee.dd.api.web.WebApp;
import org.netbeans.modules.j2ee.dd.api.web.WebResourceCollection;
import org.netbeans.modules.j2ee.ddloaders.web.DDDataObject;
import org.netbeans.modules.j2ee.ddloaders.web.multiview.EjbRefsTablePanel;
import org.netbeans.modules.j2ee.ddloaders.web.multiview.WebResourceCollectionPanel;
import org.netbeans.modules.j2ee.ddloaders.web.multiview.WebResourceCollectionTableModel;
import org.netbeans.modules.xml.multiview.ui.DefaultTablePanel;
import org.netbeans.modules.xml.multiview.ui.EditDialog;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.util.NbBundle;

public class WebResourceCollectionTablePanel
extends DefaultTablePanel {
    private DDDataObject dObj;
    private WebResourceCollectionTableModel model;
    private SecurityConstraint constraint;

    public WebResourceCollectionTablePanel(final DDDataObject dObj, final WebResourceCollectionTableModel model) {
        super((AbstractTableModel)model);
        this.dObj = dObj;
        this.model = model;
        this.removeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                dObj.modelUpdatedFromUI();
                dObj.setChangedFromUI(true);
                int row = WebResourceCollectionTablePanel.this.getTable().getSelectedRow();
                model.removeRow(row);
                dObj.setChangedFromUI(false);
            }
        });
        this.editButton.addActionListener(new TableActionListener(false));
        this.addButton.addActionListener(new TableActionListener(true));
    }

    void setModel(WebApp webApp, SecurityConstraint constraint, WebResourceCollection[] collections) {
        this.model.setData((CommonDDBean)constraint, (CommonDDBean[])collections);
        this.model.setWebApp(webApp);
        this.constraint = constraint;
    }

    private void initComponents() {
        this.setLayout(new GridBagLayout());
    }

    private class TableActionListener
    implements ActionListener {
        private boolean add;

        TableActionListener(boolean add) {
            this.add = add;
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            final int row = this.add ? -1 : WebResourceCollectionTablePanel.this.getTable().getSelectedRow();
            final WebResourceCollectionPanel dialogPanel = new WebResourceCollectionPanel();
            if (!this.add) {
                WebResourceCollection col = WebResourceCollectionTablePanel.this.model.getWebResourceCollection(row);
                dialogPanel.setResourceName(col.getWebResourceName());
                dialogPanel.setDescription(col.getDefaultDescription());
                dialogPanel.setUrlPatterns(col.getUrlPattern());
                dialogPanel.setHttpMethods(col.getHttpMethod());
            }
            EditDialog dialog = new EditDialog(dialogPanel, NbBundle.getMessage(EjbRefsTablePanel.class, (String)"TTL_WebResource"), this.add){

                protected String validate() {
                    String name = dialogPanel.getResourceName().trim();
                    WebResourceCollection webResource = null;
                    if (row != -1) {
                        webResource = WebResourceCollectionTablePanel.this.model.getWebResourceCollection(row);
                    }
                    if (name.length() == 0) {
                        return NbBundle.getMessage(WebResourceCollectionTablePanel.class, (String)"TXT_EmptyWebResourceName");
                    }
                    WebResourceCollection[] col = WebResourceCollectionTablePanel.this.constraint.getWebResourceCollection();
                    for (int i = 0; i < col.length; ++i) {
                        if (col[i] == webResource || !name.equals(col[i].getWebResourceName())) continue;
                        return NbBundle.getMessage(WebResourceCollectionTablePanel.class, (String)"TXT_WebResourceNameExists", (Object)name);
                    }
                    String[] urlPatterns = dialogPanel.getUrlPatterns();
                    if (urlPatterns.length == 0) {
                        return NbBundle.getMessage(WebResourceCollectionTablePanel.class, (String)"TXT_EmptyUrlPatterns", (Object)name);
                    }
                    return null;
                }
            };
            if (this.add) {
                dialog.setValid(false);
            }
            EditDialog.DocListener docListener = new EditDialog.DocListener(dialog);
            dialogPanel.getResourceNameTF().getDocument().addDocumentListener((DocumentListener)docListener);
            dialogPanel.getDescriptionTF().getDocument().addDocumentListener((DocumentListener)docListener);
            dialogPanel.getUrlPatternsTF().getDocument().addDocumentListener((DocumentListener)docListener);
            Dialog d = DialogDisplayer.getDefault().createDialog((DialogDescriptor)dialog);
            d.setVisible(true);
            dialogPanel.getResourceNameTF().getDocument().removeDocumentListener((DocumentListener)docListener);
            dialogPanel.getDescriptionTF().getDocument().removeDocumentListener((DocumentListener)docListener);
            dialogPanel.getUrlPatternsTF().getDocument().removeDocumentListener((DocumentListener)docListener);
            if (dialog.getValue().equals(EditDialog.OK_OPTION)) {
                WebResourceCollectionTablePanel.this.dObj.modelUpdatedFromUI();
                WebResourceCollectionTablePanel.this.dObj.setChangedFromUI(true);
                String resourceName = dialogPanel.getResourceName();
                String[] urlPatterns = dialogPanel.getUrlPatterns();
                String[] httpMethods = dialogPanel.getSelectedHttpMethods();
                String description = dialogPanel.getDescription();
                if (this.add) {
                    WebResourceCollectionTablePanel.this.model.addRow(new Object[]{resourceName, urlPatterns, httpMethods, description});
                } else {
                    WebResourceCollectionTablePanel.this.model.editRow(row, new Object[]{resourceName, urlPatterns, httpMethods, description});
                }
                WebResourceCollectionTablePanel.this.dObj.setChangedFromUI(false);
            }
        }
    }
}

