/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.junit.output;

import java.io.File;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.TreeMap;
import javax.swing.event.ChangeListener;
import org.apache.tools.ant.module.api.AntTargetExecutor;
import org.apache.tools.ant.module.api.support.AntScriptUtils;
import org.apache.tools.ant.module.spi.AntSession;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.java.platform.JavaPlatform;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.modules.gsf.testrunner.api.RerunHandler;
import org.netbeans.modules.gsf.testrunner.api.RerunType;
import org.netbeans.modules.gsf.testrunner.api.TestSession;
import org.netbeans.modules.gsf.testrunner.api.Testcase;
import org.netbeans.modules.junit.output.JUnitTestcase;
import org.netbeans.spi.project.ActionProvider;
import org.netbeans.spi.project.SingleMethod;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataObject;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;
import org.openide.util.lookup.Lookups;

public class JUnitExecutionManager
implements RerunHandler {
    public static final String JUNIT_CUSTOM_FILENAME = "junit-custom";
    public static final String JUNIT_CUSTOM_TARGET = "test-custom";
    private File scriptFile = null;
    private String[] targets = null;
    private Properties properties;
    private TestSession testSession;
    private Lookup lookup = Lookup.EMPTY;

    public JUnitExecutionManager(AntSession session, TestSession testSession, Properties props) {
        this.testSession = testSession;
        this.properties = props;
        try {
            this.scriptFile = session.getOriginatingScript();
            this.targets = session.getOriginatingTargets();
            for (int i = 0; i < this.targets.length; ++i) {
                if (this.targets[i].equals("test-single")) {
                    this.targets[i] = "test.single";
                    continue;
                }
                if (!this.targets[i].equals("debug-test")) continue;
                this.targets[i] = "debug.test.single";
            }
            String javacIncludes = this.properties.getProperty("javac.includes");
            if (javacIncludes != null) {
                FileObject testFO = testSession.getFileLocator().find(javacIncludes);
                this.lookup = Lookups.fixed((Object[])new Object[]{DataObject.find((FileObject)testFO)});
            }
            if (this.targets.length == 0) {
                String className = this.properties.getProperty("classname");
                String methodName = this.properties.getProperty("methodname");
                if (className != null) {
                    FileObject testFO = testSession.getFileLocator().find(className.replace('.', '/') + ".java");
                    if (methodName != null) {
                        SingleMethod methodSpec = new SingleMethod(testFO, methodName);
                        this.lookup = Lookups.singleton((Object)methodSpec);
                    } else {
                        this.lookup = Lookups.fixed((Object[])new Object[]{DataObject.find((FileObject)testFO)});
                    }
                }
                if (this.scriptFile.getName().equals("junit.xml")) {
                    this.targets = methodName != null ? new String[]{"run.single.method"} : new String[]{"test.single"};
                } else if (this.scriptFile.getName().equals("junit-debug.xml")) {
                    this.targets = methodName != null ? new String[]{"debug.single.method"} : new String[]{"debug.test.single"};
                }
            }
        }
        catch (Exception e) {
            // empty catch block
        }
    }

    public void rerun() {
        if (this.scriptFile.getName().equals("junit-custom.xml")) {
            try {
                JUnitExecutionManager.runAnt(FileUtil.toFileObject((File)this.scriptFile), this.targets, this.properties);
            }
            catch (IOException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        } else {
            ActionProvider actionProvider;
            Project project = this.testSession.getProject();
            if (ProjectManager.getDefault().isValid(project) && (actionProvider = (ActionProvider)project.getLookup().lookup(ActionProvider.class)) != null && Arrays.asList(actionProvider.getSupportedActions()).contains(this.targets[0]) && actionProvider.isActionEnabled(this.targets[0], this.lookup)) {
                actionProvider.invokeAction(this.targets[0], this.lookup);
            }
        }
    }

    public void rerun(Set<Testcase> tests) {
        TreeMap<String, String> toTest = new TreeMap<String, String>();
        FileObject someTestFO = null;
        for (Testcase test : tests) {
            String className = test.getClassName();
            String prev = className == null ? null : (String)toTest.get(className);
            toTest.put(test.getClassName(), prev == null ? test.getName() : prev + "," + test.getName());
            if (someTestFO != null || !(test instanceof JUnitTestcase)) continue;
            someTestFO = ((JUnitTestcase)test).getClassFileObject();
        }
        SimpleDateFormat dateFormat = new SimpleDateFormat("HHmmssSSS");
        String id = dateFormat.format(new Date());
        try {
            FileObject templateFO = FileUtil.getConfigFile((String)"Templates/UnitTests/junit-custom.xml");
            DataObject templateDO = DataObject.find((FileObject)templateFO);
            FileObject tmpDir = FileUtil.toFileObject((File)new File(System.getProperty("java.io.tmpdir")).getCanonicalFile());
            FileObject targetFO = tmpDir.createFolder("junit-custom-" + id);
            DataFolder targetDF = DataFolder.findFolder((FileObject)targetFO);
            HashMap<String, String> params = new HashMap<String, String>();
            String testStr = "";
            for (String testClass : toTest.keySet()) {
                testStr = testStr + "<test name=\"" + testClass + "\" methods=\"" + (String)toTest.get(testClass) + "\" todir=\"${test.result.dir.custom}\"/>\n";
            }
            params.put("tests", testStr);
            DataObject junitCustomDO = templateDO.createFromTemplate(targetDF, JUNIT_CUSTOM_FILENAME, params);
            Properties props = new Properties();
            props.put("work.dir", this.testSession.getProject().getProjectDirectory().getPath());
            ClassPath cp = ClassPath.getClassPath((FileObject)someTestFO, (String)"classpath/execute");
            props.put("classpath", cp != null ? cp.toString(ClassPath.PathConversionMode.FAIL) : "");
            props.put("platform.java", JavaPlatform.getDefault().findTool("java").getPath());
            JUnitExecutionManager.runAnt(junitCustomDO.getPrimaryFile(), new String[]{JUNIT_CUSTOM_TARGET}, props);
        }
        catch (IOException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        catch (IllegalArgumentException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
    }

    private static void runAnt(FileObject antScript, String[] antTargets, Properties antProps) throws IOException {
        AntTargetExecutor.Env execenv = new AntTargetExecutor.Env();
        Properties props = execenv.getProperties();
        props.putAll((Map<?, ?>)antProps);
        execenv.setProperties(props);
        AntTargetExecutor.createTargetExecutor((AntTargetExecutor.Env)execenv).execute(AntScriptUtils.antProjectCookieFor((FileObject)antScript), antTargets);
    }

    public boolean enabled(RerunType type) {
        if (this.scriptFile == null || this.targets == null || this.targets.length == 0) {
            return false;
        }
        if (this.scriptFile.getName().equals("junit-custom.xml")) {
            return true;
        }
        Project project = this.testSession.getProject();
        ActionProvider actionProvider = (ActionProvider)project.getLookup().lookup(ActionProvider.class);
        if (actionProvider != null) {
            boolean runSupported = false;
            for (String action : actionProvider.getSupportedActions()) {
                if (!action.equals(this.targets[0])) continue;
                runSupported = true;
                break;
            }
            if (runSupported && actionProvider.isActionEnabled(this.targets[0], this.lookup)) {
                return true;
            }
        }
        return false;
    }

    public void addChangeListener(ChangeListener listener) {
    }

    public void removeChangeListener(ChangeListener listener) {
    }
}

