/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.junit;

import java.io.IOException;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import org.netbeans.api.java.source.CompilationController;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.ElementHandle;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.ModificationResult;
import org.netbeans.api.java.source.Task;
import org.netbeans.modules.gsf.testrunner.plugin.CommonPlugin;
import org.netbeans.modules.junit.AbstractTestGenerator;
import org.netbeans.modules.junit.JUnit3TestGenerator;
import org.netbeans.modules.junit.JUnit4TestGenerator;
import org.netbeans.modules.junit.JUnitVersion;
import org.netbeans.modules.junit.TestGeneratorSetup;
import org.netbeans.modules.junit.TestUtil;
import org.netbeans.modules.junit.TestabilityJudge;
import org.netbeans.modules.junit.TestabilityResult;
import org.openide.filesystems.FileObject;

public final class TestCreator
implements TestabilityJudge {
    static final Set<Modifier> ACCESS_MODIFIERS = EnumSet.of(Modifier.PUBLIC, Modifier.PROTECTED, Modifier.PRIVATE);
    private final TestGeneratorSetup setup;
    private final JUnitVersion junitVersion;

    TestCreator(boolean loadDefaults, JUnitVersion junitVersion) {
        this.setup = new TestGeneratorSetup(loadDefaults);
        this.junitVersion = junitVersion;
    }

    TestCreator(Map<CommonPlugin.CreateTestParam, Object> params, JUnitVersion junitVersion) {
        this.setup = new TestGeneratorSetup(params);
        this.junitVersion = junitVersion;
    }

    public void createEmptyTest(FileObject testFileObj) throws IOException {
        AbstractTestGenerator testGenerator;
        switch (this.junitVersion) {
            case JUNIT3: {
                testGenerator = new JUnit3TestGenerator(this.setup, TestUtil.getSourceLevel(testFileObj));
                break;
            }
            case JUNIT4: {
                testGenerator = new JUnit4TestGenerator(this.setup);
                break;
            }
            default: {
                throw new IllegalStateException("junit version not set");
            }
        }
        this.doModifications(testFileObj, testGenerator);
    }

    public void createSimpleTest(ElementHandle<TypeElement> topClassToTest, FileObject testFileObj, boolean isNewTestClass) throws IOException {
        AbstractTestGenerator testGenerator;
        switch (this.junitVersion) {
            case JUNIT3: {
                testGenerator = new JUnit3TestGenerator(this.setup, Collections.singletonList(topClassToTest), null, isNewTestClass, TestUtil.getSourceLevel(testFileObj));
                break;
            }
            case JUNIT4: {
                testGenerator = new JUnit4TestGenerator(this.setup, Collections.singletonList(topClassToTest), null, isNewTestClass);
                break;
            }
            default: {
                throw new IllegalStateException("junit version not set");
            }
        }
        this.doModifications(testFileObj, testGenerator);
    }

    public List<String> createTestSuite(List<String> suiteMembers, FileObject testFileObj, boolean isNewTestClass) throws IOException {
        AbstractTestGenerator testGenerator;
        switch (this.junitVersion) {
            case JUNIT3: {
                testGenerator = new JUnit3TestGenerator(this.setup, null, suiteMembers, isNewTestClass, TestUtil.getSourceLevel(testFileObj));
                break;
            }
            case JUNIT4: {
                testGenerator = new JUnit4TestGenerator(this.setup, null, suiteMembers, isNewTestClass);
                break;
            }
            default: {
                throw new IllegalStateException("junit version not set");
            }
        }
        this.doModifications(testFileObj, testGenerator);
        return testGenerator.getProcessedClassNames();
    }

    private void doModifications(FileObject testFileObj, final AbstractTestGenerator testGenerator) throws IOException {
        final JavaSource javaSource = JavaSource.forFileObject((FileObject)testFileObj);
        javaSource.runUserActionTask((Task)new Task<CompilationController>(){

            public void run(CompilationController parameter) throws Exception {
                ModificationResult result = javaSource.runModificationTask((Task)testGenerator);
                result.commit();
            }
        }, true);
    }

    @Override
    public TestabilityResult isClassTestable(CompilationInfo compInfo, TypeElement classElem, long skipTestabilityResultMask) {
        return this.setup.isClassTestable(compInfo, classElem, skipTestabilityResultMask);
    }

    @Override
    public boolean isMethodTestable(ExecutableElement method) {
        return this.setup.isMethodTestable(method);
    }
}

