/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.junit;

import java.awt.EventQueue;
import java.util.ArrayList;
import java.util.Map;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.modules.gsf.testrunner.api.TestCreatorProvider;
import org.netbeans.modules.gsf.testrunner.plugin.CommonPlugin;
import org.netbeans.modules.junit.JUnitPluginTrampoline;
import org.netbeans.modules.junit.TestUtil;
import org.netbeans.modules.junit.plugin.JUnitPlugin;
import org.netbeans.spi.java.classpath.support.ClassPathSupport;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.cookies.EditorCookie;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.nodes.Node;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;

public class JUnitTestCreatorProvider
extends TestCreatorProvider {
    public boolean enable(Node[] activatedNodes) {
        if (activatedNodes.length == 0) {
            return false;
        }
        if (activatedNodes.length == 1) {
            Project project;
            FileObject fileObj;
            Node node = activatedNodes[0];
            DataObject dataObj = (DataObject)node.getLookup().lookup(DataObject.class);
            if (dataObj != null && (fileObj = dataObj.getPrimaryFile()) != null && fileObj.isValid() && (project = FileOwnerQuery.getOwner((FileObject)fileObj)) != null && JUnitTestCreatorProvider.getSourceGroup((FileObject)fileObj, (Project)project) != null && (TestUtil.isJavaFile((FileObject)fileObj) || node.getLookup().lookup(DataFolder.class) != null)) {
                JUnitPlugin plugin = TestUtil.getPluginForProject(project);
                return JUnitPluginTrampoline.DEFAULT.canCreateTests(plugin, fileObj);
            }
            return false;
        }
        ArrayList<FileObject> fileObjs = new ArrayList<FileObject>(activatedNodes.length);
        Project theProject = null;
        boolean result = false;
        for (Node node : activatedNodes) {
            FileObject fileObj;
            DataObject dataObj = (DataObject)node.getLookup().lookup(DataObject.class);
            if (dataObj == null || (fileObj = dataObj.getPrimaryFile()) == null || !fileObj.isValid()) continue;
            fileObjs.add(fileObj);
            Project prj = FileOwnerQuery.getOwner((FileObject)fileObj);
            if (prj == null) continue;
            if (theProject == null) {
                theProject = prj;
            }
            if (prj != theProject) {
                return false;
            }
            if (JUnitTestCreatorProvider.getSourceGroup((FileObject)fileObj, (Project)prj) == null || !TestUtil.isJavaFile((FileObject)fileObj) && node.getLookup().lookup(DataFolder.class) == null) continue;
            result = true;
        }
        if (theProject != null) {
            JUnitPlugin plugin = TestUtil.getPluginForProject(theProject);
            result &= JUnitPluginTrampoline.DEFAULT.canCreateTests(plugin, fileObjs.toArray(new FileObject[fileObjs.size()]));
        }
        return result;
    }

    public void createTests(TestCreatorProvider.Context context) {
        String problem = JUnitTestCreatorProvider.checkNodesValidity(context.getActivatedNodes());
        if (problem != null) {
            NotifyDescriptor.Message msg = new NotifyDescriptor.Message((Object)problem, 2);
            DialogDisplayer.getDefault().notify((NotifyDescriptor)msg);
            return;
        }
        final FileObject[] filesToTest = JUnitTestCreatorProvider.getFileObjectsFromNodes(context.getActivatedNodes());
        if (filesToTest == null) {
            return;
        }
        final JUnitPlugin plugin = TestUtil.getPluginForProject(FileOwnerQuery.getOwner((FileObject)filesToTest[0]));
        if (!JUnitPluginTrampoline.DEFAULT.createTestActionCalled(plugin, filesToTest)) {
            return;
        }
        boolean singleClass = context.isSingleClass();
        final Map params = TestUtil.getSettingsMap((!singleClass ? 1 : 0) != 0);
        if (singleClass) {
            params.put(CommonPlugin.CreateTestParam.CLASS_NAME, context.getTestClassName());
        }
        final FileObject targetFolder = context.getTargetFolder();
        RequestProcessor.getDefault().post(new Runnable(){

            @Override
            public void run() {
                FileObject[] testFileObjects = JUnitPluginTrampoline.DEFAULT.createTests(plugin, filesToTest, targetFolder, params);
                if (testFileObjects.length == 1) {
                    try {
                        DataObject dobj = DataObject.find((FileObject)testFileObjects[0]);
                        final EditorCookie ec = (EditorCookie)dobj.getLookup().lookup(EditorCookie.class);
                        if (ec != null) {
                            EventQueue.invokeLater(new Runnable(){

                                @Override
                                public void run() {
                                    ec.open();
                                }
                            });
                        }
                    }
                    catch (DataObjectNotFoundException ex) {
                        ex.printStackTrace();
                    }
                }
            }
        });
    }

    private static String checkNodesValidity(Node[] nodes) {
        FileObject[] files = JUnitTestCreatorProvider.getFiles(nodes);
        Project project = JUnitTestCreatorProvider.getProject(files);
        if (project == null) {
            return NbBundle.getMessage(JUnitTestCreatorProvider.class, (String)"MSG_multiproject_selection");
        }
        if (!JUnitTestCreatorProvider.checkPackages(files)) {
            return NbBundle.getMessage(JUnitTestCreatorProvider.class, (String)"MSG_invalid_packages");
        }
        return null;
    }

    private static FileObject[] getFileObjectsFromNodes(Node[] nodes) {
        FileObject[] fileObjects = new FileObject[nodes.length];
        ArrayList<FileObject> fileObjectsList = null;
        for (int i = 0; i < nodes.length; ++i) {
            FileObject fo;
            Node node = nodes[i];
            if (!JUnitTestCreatorProvider.hasParentAmongNodes(nodes, i) && (fo = JUnitTestCreatorProvider.getTestFileObject(node)) != null) {
                if (fileObjects != null) {
                    fileObjects[i] = fo;
                    continue;
                }
                if (fileObjectsList == null) {
                    fileObjectsList = new ArrayList<FileObject>(nodes.length - i);
                }
                fileObjectsList.add(fo);
                continue;
            }
            fileObjects = null;
        }
        if (fileObjects == null && fileObjectsList != null) {
            fileObjects = fileObjectsList.toArray(new FileObject[fileObjectsList.size()]);
            fileObjectsList = null;
        }
        return fileObjects;
    }

    private static boolean checkPackages(FileObject[] files) {
        if (files.length == 0) {
            return true;
        }
        Project project = FileOwnerQuery.getOwner((FileObject)files[0]);
        for (int i = 0; i < files.length; ++i) {
            String packageName = JUnitTestCreatorProvider.getPackage(project, files[i]);
            if (packageName != null && TestUtil.isValidPackageName(packageName)) continue;
            return false;
        }
        return true;
    }

    private static String getPackage(Project project, FileObject file) {
        SourceGroup srcGrp = TestUtil.findSourceGroupOwner((Project)project, (FileObject)file);
        if (srcGrp != null) {
            ClassPath cp = ClassPathSupport.createClassPath((FileObject[])new FileObject[]{srcGrp.getRootFolder()});
            return cp.getResourceName(file, '.', false);
        }
        return null;
    }

    private static FileObject[] getFiles(Node[] nodes) {
        FileObject[] ret = new FileObject[nodes.length];
        for (int i = 0; i < nodes.length; ++i) {
            ret[i] = TestUtil.getFileObjectFromNode((Node)nodes[i]);
        }
        return ret;
    }

    private static Project getProject(FileObject[] files) {
        Project project = null;
        for (int i = 0; i < files.length; ++i) {
            Project nodeProject = FileOwnerQuery.getOwner((FileObject)files[i]);
            if (project == null) {
                project = nodeProject;
                continue;
            }
            if (project == nodeProject) continue;
            return null;
        }
        return project;
    }

    private static FileObject getTestFileObject(Node node) {
        FileObject fo = TestUtil.getFileObjectFromNode((Node)node);
        if (fo == null) {
            TestUtil.notifyUser(NbBundle.getMessage(JUnitTestCreatorProvider.class, (String)"MSG_file_from_node_failed"));
            return null;
        }
        ClassPath cp = ClassPath.getClassPath((FileObject)fo, (String)"classpath/source");
        if (cp == null) {
            TestUtil.notifyUser(NbBundle.getMessage(JUnitTestCreatorProvider.class, (String)"MSG_no_project", (Object)fo));
            return null;
        }
        return fo;
    }

    private static boolean hasParentAmongNodes(Node[] nodes, int idx) {
        for (Node node = nodes[idx].getParentNode(); null != node; node = node.getParentNode()) {
            for (int i = 0; i < nodes.length; ++i) {
                if (i == idx || node != nodes[i]) continue;
                return true;
            }
        }
        return false;
    }
}

