/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.web.ha.session.management;

import com.sun.logging.LogDomains;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.ServletException;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.apache.catalina.Manager;
import org.apache.catalina.Request;
import org.apache.catalina.Response;
import org.apache.catalina.Session;
import org.apache.catalina.core.StandardContext;
import org.apache.catalina.valves.ValveBase;
import org.glassfish.ha.common.HACookieManager;
import org.glassfish.web.ha.session.management.ReplicationWebEventPersistentManager;
import org.glassfish.web.ha.session.management.WebEventPersistentManager;

public class HASessionStoreValve
extends ValveBase {
    private static final Logger _logger = LogDomains.getLogger(HASessionStoreValve.class, (String)"javax.enterprise.system.container.web");

    public int invoke(Request request, Response response) throws IOException, ServletException {
        String sessionId = null;
        HttpServletRequest httpServletrequest = (HttpServletRequest)request.getRequest();
        HttpSession session = httpServletrequest.getSession(false);
        if (session != null && (sessionId = session.getId()) != null) {
            StandardContext context = (StandardContext)request.getContext();
            ReplicationWebEventPersistentManager manager = (ReplicationWebEventPersistentManager)context.getManager();
            String oldJreplicaValue = null;
            Cookie[] cookies = httpServletrequest.getCookies();
            if (cookies != null) {
                Session sess;
                for (Cookie cookie : cookies) {
                    if (!cookie.getName().equalsIgnoreCase("JREPLICA")) continue;
                    oldJreplicaValue = cookie.getValue();
                }
                String replica = manager.getReplicaFromPredictor(sessionId, oldJreplicaValue);
                if (replica != null && (sess = request.getSessionInternal(false)) != null) {
                    sess.setNote("com.sun.enterprise.http.jreplicaLocation", (Object)replica);
                }
            }
        }
        return 1;
    }

    public void postInvoke(Request request, Response response) throws IOException, ServletException {
        this.doPostInvoke(request, response);
    }

    private void doPostInvoke(Request request, Response response) throws IOException, ServletException {
        if (_logger.isLoggable(Level.FINEST)) {
            _logger.finest("IN HASessionStoreValve>>postInvoke()");
        }
        String sessionId = null;
        HttpServletRequest hreq = (HttpServletRequest)request.getRequest();
        HttpSession hsess = hreq.getSession(false);
        if (hsess != null) {
            sessionId = hsess.getId();
            if (_logger.isLoggable(Level.FINEST)) {
                _logger.finest("IN HASessionStoreValve:postInvoke:sessionId=" + sessionId);
            }
        }
        if (sessionId != null) {
            StandardContext context = (StandardContext)request.getContext();
            Manager manager = context.getManager();
            Session session = manager.findSession(sessionId);
            if (_logger.isLoggable(Level.FINEST)) {
                _logger.finest("IN HASessionStoreValve:postInvoke:session=" + session);
            }
            if (session != null) {
                WebEventPersistentManager pMgr = (WebEventPersistentManager)manager;
                pMgr.doValveSave(session);
            }
        }
        HACookieManager.reset();
    }
}

