/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.j2seplatform.libraries;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.swing.event.ChangeListener;
import org.netbeans.api.java.queries.JavadocForBinaryQuery;
import org.netbeans.api.project.libraries.Library;
import org.netbeans.api.project.libraries.LibraryManager;
import org.netbeans.spi.java.project.support.JavadocAndSourceRootDetection;
import org.netbeans.spi.java.queries.JavadocForBinaryQueryImplementation;
import org.openide.ErrorManager;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.filesystems.FileUtil;
import org.openide.filesystems.URLMapper;
import org.openide.util.ChangeSupport;
import org.openide.util.WeakListeners;

public class JavadocForBinaryQueryLibraryImpl
implements JavadocForBinaryQueryImplementation {
    private final Map<URL, URL> normalizedURLCache = new HashMap<URL, URL>();

    public JavadocForBinaryQuery.Result findJavadoc(URL b) {
        Boolean isNormalizedURL = JavadocForBinaryQueryLibraryImpl.isNormalizedURL(b);
        if (isNormalizedURL != null) {
            for (LibraryManager mgr : LibraryManager.getOpenManagers()) {
                for (Library lib : mgr.getLibraries()) {
                    if (!lib.getType().equals("j2se")) continue;
                    for (URL entry : lib.getContent("classpath")) {
                        URL normalizedEntry = isNormalizedURL == Boolean.TRUE ? this.getNormalizedURL(entry) : entry;
                        if (!b.equals(normalizedEntry)) continue;
                        class R
                        implements JavadocForBinaryQuery.Result,
                        PropertyChangeListener {
                            private Library lib;
                            private final ChangeSupport cs = new ChangeSupport((Object)this);
                            private URL[] cachedRoots;

                            public R(Library lib) {
                                this.lib = lib;
                                this.lib.addPropertyChangeListener(WeakListeners.propertyChange((PropertyChangeListener)this, (Object)this.lib));
                            }

                            public synchronized URL[] getRoots() {
                                if (this.cachedRoots == null) {
                                    ArrayList<URL> result = new ArrayList<URL>();
                                    for (URL u : this.lib.getContent("javadoc")) {
                                        result.add(JavadocForBinaryQueryLibraryImpl.getIndexFolder(u));
                                    }
                                    this.cachedRoots = result.toArray(new URL[result.size()]);
                                }
                                return this.cachedRoots;
                            }

                            public synchronized void addChangeListener(ChangeListener l) {
                                assert (l != null) : "Listener can not be null";
                                this.cs.addChangeListener(l);
                            }

                            public synchronized void removeChangeListener(ChangeListener l) {
                                assert (l != null) : "Listener can not be null";
                                this.cs.removeChangeListener(l);
                            }

                            /*
                             * WARNING - Removed try catching itself - possible behaviour change.
                             */
                            @Override
                            public void propertyChange(PropertyChangeEvent event) {
                                if ("content".equals(event.getPropertyName())) {
                                    R r = this;
                                    synchronized (r) {
                                        this.cachedRoots = null;
                                    }
                                    this.cs.fireChange();
                                }
                            }
                        }
                        return new R(lib);
                    }
                }
            }
        }
        return null;
    }

    private URL getNormalizedURL(URL url) {
        FileObject fo;
        Boolean isNormalized = JavadocForBinaryQueryLibraryImpl.isNormalizedURL(url);
        if (isNormalized == null) {
            return null;
        }
        if (isNormalized == Boolean.TRUE) {
            return url;
        }
        URL normalizedURL = this.normalizedURLCache.get(url);
        if (normalizedURL == null && (fo = URLMapper.findFileObject((URL)url)) != null) {
            try {
                normalizedURL = fo.getURL();
                this.normalizedURLCache.put(url, normalizedURL);
            }
            catch (FileStateInvalidException e) {
                ErrorManager.getDefault().notify((Throwable)e);
            }
        }
        return normalizedURL;
    }

    private static Boolean isNormalizedURL(URL url) {
        if ("jar".equals(url.getProtocol()) && (url = FileUtil.getArchiveFile((URL)url)) == null) {
            return null;
        }
        return "file".equals(url.getProtocol());
    }

    private static URL getIndexFolder(URL url) {
        assert (url != null);
        FileObject root = URLMapper.findFileObject((URL)url);
        if (root == null) {
            return url;
        }
        FileObject index = JavadocAndSourceRootDetection.findJavadocRoot((FileObject)root);
        if (index == null) {
            return url;
        }
        try {
            return index.getURL();
        }
        catch (FileStateInvalidException e) {
            e.printStackTrace();
            return url;
        }
    }
}

