/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.j2seplatform.libraries;

import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.Customizer;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.KeyStroke;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.filechooser.FileFilter;
import org.netbeans.api.annotations.common.CheckForNull;
import org.netbeans.api.annotations.common.NonNull;
import org.netbeans.api.annotations.common.NullAllowed;
import org.netbeans.api.project.ant.FileChooser;
import org.netbeans.modules.java.j2seplatform.libraries.VolumeContentModel;
import org.netbeans.spi.java.project.support.JavadocAndSourceRootDetection;
import org.netbeans.spi.project.libraries.LibraryCustomizerContext;
import org.netbeans.spi.project.libraries.LibraryImplementation;
import org.netbeans.spi.project.libraries.LibraryStorageArea;
import org.netbeans.spi.project.libraries.support.LibrariesSupport;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.awt.Mnemonics;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;

public class J2SEVolumeCustomizer
extends JPanel
implements Customizer {
    private String volumeType;
    private LibraryImplementation impl;
    private LibraryStorageArea area;
    private VolumeContentModel model;
    private Boolean allowRelativePaths = null;
    private static File lastFolder = null;
    private JButton addButton;
    private JButton addURLButton;
    private JList content;
    private JButton downButton;
    private JScrollPane jScrollPane1;
    private JLabel message;
    private JButton removeButton;
    private JButton upButton;

    J2SEVolumeCustomizer(String volumeType) {
        this.volumeType = volumeType;
        this.initComponents();
        this.postInitComponents();
        this.setName(NbBundle.getMessage(J2SEVolumeCustomizer.class, (String)("TXT_" + volumeType)));
    }

    @Override
    public void addNotify() {
        super.addNotify();
        this.addButton.requestFocus();
    }

    @Override
    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this.addButton.setEnabled(enabled);
        this.addURLButton.setEnabled(this.volumeType.equals("javadoc"));
        int[] indices = this.content.getSelectedIndices();
        this.removeButton.setEnabled(enabled && indices.length > 0);
        this.downButton.setEnabled(enabled && indices.length > 0 && indices[indices.length - 1] < this.model.getSize() - 1);
        this.upButton.setEnabled(enabled && indices.length > 0 && indices[0] > 0);
    }

    @CheckForNull
    static String[] select(@NonNull String volumeType, @NonNull String libName, @NonNull File[] lastFolder, @NullAllowed Component owner, @NullAllowed File baseFolder) {
        assert (volumeType != null);
        assert (lastFolder != null);
        assert (lastFolder.length == 1);
        File libFolder = baseFolder == null ? null : FileUtil.normalizeFile((File)new File(baseFolder, libName));
        FileChooser chooser = new FileChooser(baseFolder, libFolder);
        chooser.setFileHidingEnabled(false);
        chooser.setAcceptAllFileFilterUsed(false);
        if (volumeType.equals("classpath")) {
            chooser.setMultiSelectionEnabled(true);
            chooser.setDialogTitle(NbBundle.getMessage(J2SEVolumeCustomizer.class, (String)"TXT_OpenClasses"));
            chooser.setFileSelectionMode(2);
            chooser.setFileFilter((FileFilter)new ArchiveFileFilter(NbBundle.getMessage(J2SEVolumeCustomizer.class, (String)"TXT_Classpath"), new String[]{"ZIP", "JAR"}));
            chooser.setApproveButtonText(NbBundle.getMessage(J2SEVolumeCustomizer.class, (String)"CTL_SelectCP"));
            chooser.setApproveButtonMnemonic(NbBundle.getMessage(J2SEVolumeCustomizer.class, (String)"MNE_SelectCP").charAt(0));
        } else if (volumeType.equals("javadoc")) {
            chooser.setMultiSelectionEnabled(true);
            chooser.setDialogTitle(NbBundle.getMessage(J2SEVolumeCustomizer.class, (String)"TXT_OpenJavadoc"));
            chooser.setFileSelectionMode(2);
            chooser.setFileFilter((FileFilter)new ArchiveFileFilter(NbBundle.getMessage(J2SEVolumeCustomizer.class, (String)"TXT_Javadoc"), new String[]{"ZIP", "JAR"}));
            chooser.setApproveButtonText(NbBundle.getMessage(J2SEVolumeCustomizer.class, (String)"CTL_SelectJD"));
            chooser.setApproveButtonMnemonic(NbBundle.getMessage(J2SEVolumeCustomizer.class, (String)"MNE_SelectJD").charAt(0));
        } else if (volumeType.equals("src")) {
            chooser.setMultiSelectionEnabled(true);
            chooser.setDialogTitle(NbBundle.getMessage(J2SEVolumeCustomizer.class, (String)"TXT_OpenSources"));
            chooser.setFileSelectionMode(2);
            chooser.setFileFilter((FileFilter)new ArchiveFileFilter(NbBundle.getMessage(J2SEVolumeCustomizer.class, (String)"TXT_Sources"), new String[]{"ZIP", "JAR"}));
            chooser.setApproveButtonText(NbBundle.getMessage(J2SEVolumeCustomizer.class, (String)"CTL_SelectSRC"));
            chooser.setApproveButtonMnemonic(NbBundle.getMessage(J2SEVolumeCustomizer.class, (String)"MNE_SelectSRC").charAt(0));
        }
        if (lastFolder[0] != null) {
            chooser.setCurrentDirectory(lastFolder[0]);
        } else if (baseFolder != null) {
            chooser.setCurrentDirectory(baseFolder);
        }
        if (chooser.showOpenDialog(owner) == 0) {
            try {
                lastFolder[0] = chooser.getCurrentDirectory();
                return chooser.getSelectedPaths();
            }
            catch (MalformedURLException mue) {
                Exceptions.printStackTrace((Throwable)mue);
            }
            catch (IOException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }
        return null;
    }

    static URI pathToURI(File baseFolder, String fileName, String volume) throws MalformedURLException, URISyntaxException {
        File f = new File(fileName);
        URI uri = LibrariesSupport.convertFilePathToURI((String)fileName);
        if (baseFolder != null) {
            File realFile = f;
            if (!f.isAbsolute()) {
                realFile = FileUtil.normalizeFile((File)new File(baseFolder, f.getPath()));
            }
            String jarPath = J2SEVolumeCustomizer.checkFile(realFile, volume);
            if (FileUtil.isArchiveFile((URL)Utilities.toURI((File)realFile).toURL())) {
                uri = LibrariesSupport.getArchiveRoot((URI)uri);
                if (jarPath != null) {
                    assert (uri.toString().endsWith("!/")) : uri.toString();
                    uri = URI.create(uri.toString() + J2SEVolumeCustomizer.encodePath(jarPath));
                }
            } else if (!uri.toString().endsWith("/")) {
                try {
                    uri = new URI(uri.toString() + "/");
                }
                catch (URISyntaxException ex) {
                    throw new AssertionError((Object)ex);
                }
            }
            return uri;
        }
        assert (f.isAbsolute()) : f.getPath();
        f = FileUtil.normalizeFile((File)f);
        String jarPath = J2SEVolumeCustomizer.checkFile(f, volume);
        uri = Utilities.toURI((File)f);
        if (FileUtil.isArchiveFile((URL)uri.toURL())) {
            uri = LibrariesSupport.getArchiveRoot((URI)uri);
            if (jarPath != null) {
                assert (uri.toString().endsWith("!/")) : uri.toString();
                uri = URI.create(uri.toString() + J2SEVolumeCustomizer.encodePath(jarPath));
            }
        } else if (!uri.toString().endsWith("/")) {
            uri = URI.create(uri.toString() + "/");
        }
        return uri;
    }

    private void postInitComponents() {
        this.content.setCellRenderer(new ContentRenderer());
        this.upButton.setEnabled(false);
        this.downButton.setEnabled(false);
        this.removeButton.setEnabled(false);
        if (this.volumeType.equals("classpath")) {
            this.addButton.setText(NbBundle.getMessage(J2SEVolumeCustomizer.class, (String)"CTL_AddClassPath"));
            this.addButton.setMnemonic(NbBundle.getMessage(J2SEVolumeCustomizer.class, (String)"MNE_AddClassPath").charAt(0));
            this.message.setText(NbBundle.getMessage(J2SEVolumeCustomizer.class, (String)"CTL_ContentClassPath"));
            this.message.setDisplayedMnemonic(NbBundle.getMessage(J2SEVolumeCustomizer.class, (String)"MNE_ContentClassPath").charAt(0));
            this.addButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(J2SEVolumeCustomizer.class, (String)"AD_AddClassPath"));
            this.message.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(J2SEVolumeCustomizer.class, (String)"AD_ContentClassPath"));
        } else if (this.volumeType.equals("javadoc")) {
            this.addButton.setText(NbBundle.getMessage(J2SEVolumeCustomizer.class, (String)"CTL_AddJavadoc"));
            this.addButton.setMnemonic(NbBundle.getMessage(J2SEVolumeCustomizer.class, (String)"MNE_AddJavadoc").charAt(0));
            this.message.setText(NbBundle.getMessage(J2SEVolumeCustomizer.class, (String)"CTL_ContentJavadoc"));
            this.message.setDisplayedMnemonic(NbBundle.getMessage(J2SEVolumeCustomizer.class, (String)"MNE_ContentJavadoc").charAt(0));
            this.addButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(J2SEVolumeCustomizer.class, (String)"AD_AddJavadoc"));
            this.message.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(J2SEVolumeCustomizer.class, (String)"AD_ContentJavadoc"));
        } else if (this.volumeType.equals("src")) {
            this.addButton.setText(NbBundle.getMessage(J2SEVolumeCustomizer.class, (String)"CTL_AddSources"));
            this.addButton.setMnemonic(NbBundle.getMessage(J2SEVolumeCustomizer.class, (String)"MNE_AddSources").charAt(0));
            this.message.setText(NbBundle.getMessage(J2SEVolumeCustomizer.class, (String)"CTL_ContentSources"));
            this.message.setDisplayedMnemonic(NbBundle.getMessage(J2SEVolumeCustomizer.class, (String)"MNE_ContentSources").charAt(0));
            this.addButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(J2SEVolumeCustomizer.class, (String)"AD_AddSources"));
            this.message.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(J2SEVolumeCustomizer.class, (String)"AD_ContentSources"));
        }
        this.content.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                if (e.getValueIsAdjusting()) {
                    return;
                }
                int[] indices = J2SEVolumeCustomizer.this.content.getSelectedIndices();
                J2SEVolumeCustomizer.this.removeButton.setEnabled(indices.length > 0);
                J2SEVolumeCustomizer.this.downButton.setEnabled(indices.length > 0 && indices[indices.length - 1] < J2SEVolumeCustomizer.this.model.getSize() - 1);
                J2SEVolumeCustomizer.this.upButton.setEnabled(indices.length > 0 && indices[0] > 0);
            }
        });
        this.content.getInputMap().put(KeyStroke.getKeyStroke(127, 0), "delete");
        this.content.getActionMap().put("delete", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                J2SEVolumeCustomizer.this.removeResource(null);
            }
        });
    }

    private void initComponents() {
        this.message = new JLabel();
        this.jScrollPane1 = new JScrollPane();
        this.content = new JList();
        this.addButton = new JButton();
        this.addURLButton = new JButton();
        this.removeButton = new JButton();
        this.upButton = new JButton();
        this.downButton = new JButton();
        this.setLayout(new GridBagLayout());
        this.message.setLabelFor(this.content);
        Mnemonics.setLocalizedText((JLabel)this.message, (String)NbBundle.getBundle(J2SEVolumeCustomizer.class).getString("CTL_ContentMessage"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(6, 6, 2, 6);
        this.add((Component)this.message, gridBagConstraints);
        this.jScrollPane1.setViewportView(this.content);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridheight = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(0, 6, 6, 6);
        this.add((Component)this.jScrollPane1, gridBagConstraints);
        Mnemonics.setLocalizedText((AbstractButton)this.addButton, (String)NbBundle.getBundle(J2SEVolumeCustomizer.class).getString("CTL_AddContent"));
        this.addButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                J2SEVolumeCustomizer.this.addResource(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(0, 6, 0, 6);
        this.add((Component)this.addButton, gridBagConstraints);
        this.addButton.getAccessibleContext().setAccessibleDescription(NbBundle.getBundle(J2SEVolumeCustomizer.class).getString("AD_addButton"));
        Mnemonics.setLocalizedText((AbstractButton)this.addURLButton, (String)NbBundle.getMessage(J2SEVolumeCustomizer.class, (String)"J2SEVolumeCustomizer.addURLButton.text"));
        this.addURLButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                J2SEVolumeCustomizer.this.addURLButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(5, 6, 6, 6);
        this.add((Component)this.addURLButton, gridBagConstraints);
        Mnemonics.setLocalizedText((AbstractButton)this.removeButton, (String)NbBundle.getBundle(J2SEVolumeCustomizer.class).getString("CTL_RemoveContent"));
        this.removeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                J2SEVolumeCustomizer.this.removeResource(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(5, 6, 6, 6);
        this.add((Component)this.removeButton, gridBagConstraints);
        this.removeButton.getAccessibleContext().setAccessibleDescription(NbBundle.getBundle(J2SEVolumeCustomizer.class).getString("AD_RemoveContent"));
        Mnemonics.setLocalizedText((AbstractButton)this.upButton, (String)NbBundle.getBundle(J2SEVolumeCustomizer.class).getString("CTL_UpContent"));
        this.upButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                J2SEVolumeCustomizer.this.upResource(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(5, 6, 0, 6);
        this.add((Component)this.upButton, gridBagConstraints);
        this.upButton.getAccessibleContext().setAccessibleDescription(NbBundle.getBundle(J2SEVolumeCustomizer.class).getString("AD_UpContent"));
        Mnemonics.setLocalizedText((AbstractButton)this.downButton, (String)NbBundle.getBundle(J2SEVolumeCustomizer.class).getString("CTL_DownContent"));
        this.downButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                J2SEVolumeCustomizer.this.downResource(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(5, 6, 6, 6);
        this.add((Component)this.downButton, gridBagConstraints);
        this.downButton.getAccessibleContext().setAccessibleDescription(NbBundle.getBundle(J2SEVolumeCustomizer.class).getString("AD_DownContent"));
        this.getAccessibleContext().setAccessibleDescription(NbBundle.getBundle(J2SEVolumeCustomizer.class).getString("AD_J2SEVolumeCustomizer"));
    }

    private void downResource(ActionEvent evt) {
        int[] indices = this.content.getSelectedIndices();
        if (indices.length == 0 || indices[0] < 0 || indices[indices.length - 1] >= this.model.getSize() - 1) {
            return;
        }
        this.model.moveDown(indices);
        for (int i = 0; i < indices.length; ++i) {
            indices[i] = indices[i] + 1;
        }
        this.content.setSelectedIndices(indices);
    }

    private void upResource(ActionEvent evt) {
        int[] indices = this.content.getSelectedIndices();
        if (indices.length == 0 || indices[0] <= 0) {
            return;
        }
        this.model.moveUp(indices);
        for (int i = 0; i < indices.length; ++i) {
            indices[i] = indices[i] - 1;
        }
        this.content.setSelectedIndices(indices);
    }

    private void removeResource(ActionEvent evt) {
        int[] indices = this.content.getSelectedIndices();
        if (indices.length == 0) {
            return;
        }
        this.model.removeResources(indices);
        if (indices[indices.length - 1] - indices.length + 1 < this.model.getSize()) {
            this.content.setSelectedIndex(indices[indices.length - 1] - indices.length + 1);
        } else if (indices[0] >= 1) {
            this.content.setSelectedIndex(indices[0] - 1);
        }
        if (this.volumeType.equals("classpath")) {
            this.impl.setContent("maven-pom", Collections.emptyList());
        }
    }

    private void addResource(ActionEvent evt) {
        boolean arp = this.allowRelativePaths != null && this.allowRelativePaths != false;
        File baseFolder = arp ? FileUtil.normalizeFile((File)Utilities.toFile((URI)URI.create(this.area.getLocation().toExternalForm())).getParentFile()) : null;
        File[] cwd = new File[]{lastFolder};
        String[] paths = J2SEVolumeCustomizer.select(this.volumeType, this.impl.getName(), cwd, this, baseFolder);
        if (paths != null) {
            try {
                lastFolder = cwd[0];
                this.addFiles(J2SEVolumeCustomizer.pathsToURIs(paths, this.volumeType, baseFolder), arp);
            }
            catch (MalformedURLException mue) {
                Exceptions.printStackTrace((Throwable)mue);
            }
            catch (URISyntaxException ue) {
                Exceptions.printStackTrace((Throwable)ue);
            }
            catch (IOException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }
    }

    private void addURLButtonActionPerformed(ActionEvent evt) {
        NotifyDescriptor.InputLine input = new NotifyDescriptor.InputLine(NbBundle.getMessage(J2SEVolumeCustomizer.class, (String)"CTL_AddJavadocURLMessage"), NbBundle.getMessage(J2SEVolumeCustomizer.class, (String)"CTL_AddJavadocURLTitle"));
        if (DialogDisplayer.getDefault().notify((NotifyDescriptor)input) == DialogDescriptor.OK_OPTION) {
            String value = input.getInputText();
            if (this.allowRelativePaths != null && this.allowRelativePaths.booleanValue()) {
                try {
                    URI uri = new URI(value);
                    this.model.addResource(uri);
                    this.content.setSelectedIndex(this.model.getSize() - 1);
                }
                catch (URISyntaxException use) {
                    DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)NbBundle.getMessage(J2SEVolumeCustomizer.class, (String)"CTL_InvalidURLFormat"), 0));
                }
            } else {
                try {
                    URL url = new URL(value);
                    this.model.addResource(url);
                    this.content.setSelectedIndex(this.model.getSize() - 1);
                }
                catch (MalformedURLException mue) {
                    DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)NbBundle.getMessage(J2SEVolumeCustomizer.class, (String)"CTL_InvalidURLFormat"), 0));
                }
            }
        }
    }

    private void addFiles(URI[] toAdd, boolean allowRelativePaths) throws MalformedURLException, URISyntaxException {
        int firstIndex = this.model.getSize();
        for (URI uri : toAdd) {
            if (allowRelativePaths) {
                this.model.addResource(uri);
                continue;
            }
            this.model.addResource(uri.toURL());
        }
        int lastIndex = this.model.getSize() - 1;
        if (firstIndex <= lastIndex) {
            int[] toSelect = new int[lastIndex - firstIndex + 1];
            for (int i = 0; i < toSelect.length; ++i) {
                toSelect[i] = firstIndex + i;
            }
            this.content.setSelectedIndices(toSelect);
        }
        if (this.volumeType.equals("classpath") && this.impl != null) {
            this.impl.setContent("maven-pom", Collections.emptyList());
        }
    }

    static String encodePath(String path) throws URISyntaxException {
        return new URI(null, null, path, null).getRawPath();
    }

    @NonNull
    private static URI[] pathsToURIs(@NonNull String[] fileNames, @NonNull String volume, @NullAllowed File baseFolder) throws MalformedURLException, URISyntaxException {
        ArrayList<URI> result = new ArrayList<URI>(fileNames.length);
        for (String fileName : fileNames) {
            result.add(J2SEVolumeCustomizer.pathToURI(baseFolder, fileName, volume));
        }
        return result.toArray(new URI[result.size()]);
    }

    private static String checkFile(File f, String volume) {
        FileObject fo = FileUtil.toFileObject((File)f);
        if (volume.equals("javadoc")) {
            if (fo != null) {
                FileObject root;
                if (fo.isData()) {
                    fo = FileUtil.getArchiveRoot((FileObject)fo);
                }
                FileObject fileObject = root = fo == null ? null : JavadocAndSourceRootDetection.findJavadocRoot((FileObject)fo);
                if (root == null) {
                    DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)NbBundle.getMessage(J2SEVolumeCustomizer.class, (String)"TXT_InvalidJavadocRoot", (Object)f.getPath()), 0));
                    return null;
                }
                if (root.getFileObject("index-files") == null && root.getFileObject("index-all.html") == null) {
                    DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)NbBundle.getMessage(J2SEVolumeCustomizer.class, (String)"TXT_InvalidJavadocRoot2", (Object)f.getPath()), 0));
                }
                return FileUtil.getRelativePath((FileObject)fo, (FileObject)root) + "/";
            }
        } else if (volume.equals("src") && fo != null) {
            FileObject root;
            if (fo.isData()) {
                fo = FileUtil.getArchiveRoot((FileObject)fo);
            }
            FileObject fileObject = root = fo == null ? null : JavadocAndSourceRootDetection.findSourceRoot((FileObject)fo);
            if (root == null) {
                return null;
            }
            if (FileUtil.isParentOf((FileObject)root, (FileObject)fo)) {
                return null;
            }
            assert (fo.equals(root) || FileUtil.isParentOf((FileObject)fo, (FileObject)root)) : fo.toString() + " is not parent of " + root;
            return FileUtil.getRelativePath((FileObject)fo, (FileObject)root) + "/";
        }
        return null;
    }

    @Override
    public void setObject(Object bean) {
        assert (bean instanceof LibraryCustomizerContext) : bean.getClass();
        LibraryCustomizerContext context = (LibraryCustomizerContext)bean;
        this.area = context.getLibraryStorageArea();
        this.impl = context.getLibraryImplementation();
        this.allowRelativePaths = context.getLibraryImplementation2() != null;
        this.model = new VolumeContentModel(this.impl, this.area, this.volumeType);
        this.content.setModel(this.model);
        if (this.model.getSize() > 0) {
            this.content.setSelectedIndex(0);
        }
    }

    private static class ArchiveFileFilter
    extends FileFilter {
        private String description;
        private Collection extensions;

        public ArchiveFileFilter(String description, String[] extensions) {
            this.description = description;
            this.extensions = Arrays.asList(extensions);
        }

        @Override
        public boolean accept(File f) {
            if (f.isDirectory()) {
                return true;
            }
            String name = f.getName();
            int index = name.lastIndexOf(46);
            if (index <= 0 || index == name.length() - 1) {
                return false;
            }
            String extension = name.substring(index + 1).toUpperCase();
            if (!this.extensions.contains(extension)) {
                return false;
            }
            try {
                return FileUtil.isArchiveFile((URL)Utilities.toURI((File)f).toURL());
            }
            catch (MalformedURLException e) {
                Exceptions.printStackTrace((Throwable)e);
                return false;
            }
        }

        @Override
        public String getDescription() {
            return this.description;
        }
    }

    private static class ContentRenderer
    extends DefaultListCellRenderer {
        private ContentRenderer() {
        }

        @Override
        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            String displayName = null;
            Color color = null;
            String toolTip = null;
            URI uri = null;
            if (value instanceof URI) {
                uri = (URI)value;
            } else if (value instanceof URL) {
                try {
                    uri = ((URL)value).toURI();
                }
                catch (URISyntaxException ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
            }
            if (uri != null && uri.toString().startsWith("http")) {
                displayName = uri.toString();
            } else if (uri != null) {
                if (uri.toString().contains("!/")) {
                    uri = LibrariesSupport.getArchiveFile((URI)uri);
                }
                boolean broken = false;
                VolumeContentModel model = (VolumeContentModel)list.getModel();
                LibraryStorageArea area = model.getArea();
                FileObject fo = LibrariesSupport.resolveLibraryEntryFileObject((URL)(area != null ? area.getLocation() : null), (URI)uri);
                if (fo == null) {
                    broken = true;
                    if ("file".equals(uri.getScheme())) {
                        displayName = LibrariesSupport.convertURIToFilePath((URI)uri);
                        if (displayName.startsWith("${")) {
                            broken = false;
                        }
                    } else {
                        displayName = uri.toString();
                    }
                } else if (uri.isAbsolute()) {
                    displayName = FileUtil.getFileDisplayName((FileObject)fo);
                } else {
                    displayName = LibrariesSupport.convertURIToFilePath((URI)uri);
                    toolTip = FileUtil.getFileDisplayName((FileObject)fo);
                }
                if (broken) {
                    color = new Color(164, 0, 0);
                    toolTip = NbBundle.getMessage(J2SEVolumeCustomizer.class, (String)"TXT_BrokenFile");
                }
            }
            Component c = super.getListCellRendererComponent((JList<?>)list, displayName, index, isSelected, cellHasFocus);
            if (c instanceof JComponent) {
                if (color != null) {
                    ((JComponent)c).setForeground(color);
                }
                if (toolTip != null) {
                    ((JComponent)c).setToolTipText(toolTip);
                } else {
                    ((JComponent)c).setToolTipText(null);
                }
            }
            return c;
        }
    }
}

