/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.profiler.attach.panels;

import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.Iterator;
import java.util.List;
import java.util.ResourceBundle;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListModel;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.LayoutStyle;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import org.netbeans.modules.profiler.attach.panels.ManualIntegrationPanel;
import org.netbeans.modules.profiler.attach.panels.components.StepsPanelComponent;
import org.netbeans.modules.profiler.attach.providers.TargetPlatformEnum;
import org.netbeans.modules.profiler.attach.spi.IntegrationProvider;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.awt.Mnemonics;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;

public class ManualIntegrationPanelUI
extends JPanel
implements ListDataListener {
    private ManualIntegrationPanel.Model model;
    private DefaultListModel listModel = null;
    private JComboBox comboJvms;
    private JButton generateRemotePack;
    private JTextArea label;
    private StepsPanelComponent stepsPanel;

    ManualIntegrationPanelUI(ManualIntegrationPanel.Model aModel) {
        this.model = aModel;
        this.initComponents();
    }

    private void initComponents() {
        this.generateRemotePack = new JButton();
        this.stepsPanel = new StepsPanelComponent();
        this.label = new JTextArea();
        this.comboJvms = new JComboBox();
        this.setBorder(BorderFactory.createEmptyBorder(2, 2, 2, 2));
        this.setMaximumSize(new Dimension(800, 600));
        this.setMinimumSize(new Dimension(200, 300));
        this.setPreferredSize(new Dimension(500, 400));
        Mnemonics.setLocalizedText((AbstractButton)this.generateRemotePack, (String)NbBundle.getMessage(ManualIntegrationPanelUI.class, (String)"ManualIntegrationPanelUI.generateRemotePack.text"));
        this.generateRemotePack.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ManualIntegrationPanelUI.this.generateRemotePackActionPerformed(evt);
            }
        });
        this.stepsPanel.setTitle(NbBundle.getMessage(ManualIntegrationPanelUI.class, (String)"ManualIntegrationStepsWizardPanelUI_ManualIntegrationHintMsg"));
        this.label.setEditable(false);
        this.label.setLineWrap(true);
        this.label.setText(NbBundle.getMessage(ManualIntegrationPanelUI.class, (String)"TargetJVMWizardPanelUI_SelectJvmString"));
        this.label.setWrapStyleWord(true);
        this.label.setDisabledTextColor(UIManager.getDefaults().getColor("Label.foreground"));
        this.label.setEnabled(false);
        this.label.setMinimumSize(new Dimension(0, 0));
        this.label.setOpaque(false);
        this.comboJvms.setModel(new DefaultComboBoxModel<String>(new String[]{"Java"}));
        this.comboJvms.setMaximumSize(new Dimension(470, 24));
        this.comboJvms.setMinimumSize(new Dimension(200, 24));
        this.comboJvms.setPreferredSize(new Dimension(466, 24));
        this.comboJvms.getModel().addListDataListener(this);
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.label, -1, -1, Short.MAX_VALUE).addComponent(this.comboJvms, 0, 456, Short.MAX_VALUE).addComponent(this.stepsPanel, -1, 456, Short.MAX_VALUE).addComponent(this.generateRemotePack, GroupLayout.Alignment.TRAILING)).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addContainerGap().addComponent(this.label, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.comboJvms, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.stepsPanel, -1, 263, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.generateRemotePack).addContainerGap()));
        this.comboJvms.getAccessibleContext().setAccessibleName(NbBundle.getMessage(ManualIntegrationPanelUI.class, (String)"ManualIntegrationPanelUI.comboJvms.AccessibleContext.accessibleName"));
        this.comboJvms.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ManualIntegrationPanelUI.class, (String)"ManualIntegrationPanelUI.comboJvms.AccessibleContext.accessibleDescription"));
    }

    private void generateRemotePackActionPerformed(ActionEvent evt) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                JFileChooser chooser = new JFileChooser();
                File tmpDir = new File(System.getProperty("java.io.tmpdir"));
                chooser.setDialogTitle(ResourceBundle.getBundle("org/netbeans/modules/profiler/attach/panels/Bundle").getString("ManualIntegrationPanelUI_ChooseRemotePackDestination"));
                chooser.setAcceptAllFileFilterUsed(false);
                chooser.setFileSelectionMode(1);
                chooser.setSelectedFile(tmpDir);
                chooser.setCurrentDirectory(tmpDir);
                chooser.setMultiSelectionEnabled(false);
                if ((1 & chooser.showSaveDialog(ManualIntegrationPanelUI.this)) == 0) {
                    final String selectedFile = chooser.getSelectedFile().getAbsolutePath();
                    RequestProcessor.getDefault().post(new Runnable(){

                        @Override
                        public void run() {
                            try {
                                String packPath = ManualIntegrationPanelUI.this.model.exportRemotePack(selectedFile);
                                DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)(ResourceBundle.getBundle("org/netbeans/modules/profiler/attach/panels/Bundle").getString("ManualIntegrationPanelUI_RemotePackSavedAs") + packPath), 1));
                            }
                            catch (IOException ex) {
                                Exceptions.printStackTrace((Throwable)ex);
                            }
                        }
                    });
                }
            }
        });
    }

    public ComboBoxModel getJvmListModel() {
        return new DefaultComboBoxModel(){

            @Override
            public Object getElementAt(int index) {
                return ManualIntegrationPanelUI.this.model.getSupportedJvms() != null ? ManualIntegrationPanelUI.this.model.getSupportedJvms().get(index) : null;
            }

            @Override
            public Object getSelectedItem() {
                return ManualIntegrationPanelUI.this.model.getJvm();
            }

            @Override
            public int getSize() {
                return ManualIntegrationPanelUI.this.model.getSupportedJvms() != null ? ManualIntegrationPanelUI.this.model.getSupportedJvms().size() : 0;
            }

            @Override
            public void setSelectedItem(Object anItem) {
                ManualIntegrationPanelUI.this.model.setJvm((TargetPlatformEnum)anItem);
                ManualIntegrationPanelUI.this.showIntegrationHints();
            }
        };
    }

    public void refresh() {
        List supportedJvms = this.model.getSupportedJvms();
        TargetPlatformEnum defaultPlatform = TargetPlatformEnum.JDK5;
        if (this.model.getJvm() == null || !supportedJvms.contains(this.model.getJvm())) {
            if (!supportedJvms.contains(defaultPlatform)) {
                defaultPlatform = (TargetPlatformEnum)supportedJvms.get(0);
            }
        } else {
            defaultPlatform = this.model.getJvm();
        }
        ((DefaultComboBoxModel)this.comboJvms.getModel()).removeAllElements();
        Iterator it = this.model.getSupportedJvms().iterator();
        while (it.hasNext()) {
            ((DefaultComboBoxModel)this.comboJvms.getModel()).addElement(it.next());
        }
        this.comboJvms.setSelectedItem(defaultPlatform);
        this.showIntegrationHints();
        this.label.setText(MessageFormat.format(NbBundle.getMessage(ManualIntegrationPanel.class, (String)"TargetJVMWizardPanelUI_SelectJvmString"), this.model.getApplication()));
        this.generateRemotePack.setVisible(this.model.isAvailable());
    }

    private void showIntegrationHints() {
        IntegrationProvider.IntegrationHints hints = this.model.getIntegrationHints();
        this.stepsPanel.setTitle(MessageFormat.format(NbBundle.getMessage(ManualIntegrationPanel.class, (String)"ManualIntegrationStepsWizardPanelUI_ManualIntegrationHintMsg"), this.model.getApplication()));
        this.stepsPanel.setSteps(this.model.getIntegrationHints());
    }

    @Override
    public void contentsChanged(ListDataEvent e) {
        this.model.setJvm((TargetPlatformEnum)this.comboJvms.getSelectedItem());
        this.showIntegrationHints();
    }

    @Override
    public void intervalAdded(ListDataEvent e) {
    }

    @Override
    public void intervalRemoved(ListDataEvent e) {
    }
}

