/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.profiler.attach.panels;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.swing.JPanel;
import javax.swing.event.ChangeEvent;
import org.netbeans.lib.profiler.common.AttachSettings;
import org.netbeans.modules.profiler.attach.panels.AttachSettingsPanelUI;
import org.netbeans.modules.profiler.attach.panels.AttachWizardPanel;
import org.netbeans.modules.profiler.attach.panels.Bundle;
import org.netbeans.modules.profiler.attach.providers.IntegrationCategorizer;
import org.netbeans.modules.profiler.attach.providers.WizardIntegrationProvider;
import org.netbeans.modules.profiler.attach.spi.IntegrationProvider;
import org.netbeans.modules.profiler.attach.wizard.AttachWizardContext;
import org.openide.util.HelpCtx;
import org.openide.util.Lookup;

public class AttachSettingsPanel
extends AttachWizardPanel {
    private static final String HELP_CTX_KEY = "AttachSettingsPanel.HelpCtx";
    private static final HelpCtx HELP_CTX = new HelpCtx("AttachSettingsPanel.HelpCtx");
    private AttachSettingsPanelUI panel = null;
    private PanelModel model = new PanelModel();
    private WizardIntegrationProvider nullProvider = new WizardIntegrationProvider.NullIntegrationProvider();

    public HelpCtx getHelp() {
        return HELP_CTX;
    }

    public boolean isValid() {
        return this.model.getTargetGroup() != null && !this.model.getTargetGroup().isNull() && this.model.getTarget() != null && (this.model.isRemote() || this.model.isLocal() && (this.model.isDirectAttach() || this.model.isDynamicAttach16()));
    }

    @Override
    public boolean canBack(AttachWizardContext context) {
        return true;
    }

    @Override
    public boolean canFinish(AttachWizardContext context) {
        return false;
    }

    @Override
    public boolean canNext(AttachWizardContext context) {
        return this.isValid();
    }

    @Override
    public boolean onCancel(AttachWizardContext context) {
        return true;
    }

    @Override
    public void onEnter(AttachWizardContext context) {
        this.getContext().setHideIntegration(true);
        this.setTrackUpdates(false);
        String preselectedGroupName = context.getAttachSettings().getTargetType();
        String preselectedTargetName = context.getAttachSettings().getServerType();
        TargetGroup preselectedGroup = null;
        Target preselectedTarget = null;
        TargetGroup[] groups = this.model.getTargetGroups();
        block0: for (int i = 0; i < groups.length; ++i) {
            if (groups[i].getName().equals(preselectedGroupName)) {
                preselectedGroup = groups[i];
                preselectedGroupName = preselectedGroup.getName();
                if (preselectedGroup.isSingular()) {
                    preselectedTarget = preselectedGroup.getTargets()[0];
                    preselectedTargetName = preselectedTarget.getName();
                    break;
                }
            }
            for (int j = 0; j < groups[i].getTargets().length; ++j) {
                if (groups[i].getTargets()[j].getProvider().equals(context.getIntegrationProvider())) {
                    preselectedGroup = groups[i];
                    preselectedTarget = groups[i].getTargets()[j];
                    break block0;
                }
                if (!groups[i].getTargets()[j].getName().equals(preselectedTargetName)) continue;
                preselectedTarget = groups[i].getTargets()[j];
            }
        }
        this.model.setTargetGroup(preselectedGroup);
        this.model.setTarget(preselectedTarget);
        this.model.setAutomaticIntegration(context.isAutomatic());
        this.model.setManualIntegration(context.isManual());
        if (context.getAttachSettings().isDirect()) {
            this.model.setDirectAttach(true);
        } else if (context.getAttachSettings().isDynamic16()) {
            this.model.setDynamicAttach16(true);
        } else {
            throw new IllegalArgumentException("invalid attach settings " + context.getAttachSettings());
        }
        this.model.setRemote(context.getAttachSettings().isRemote());
        ((AttachSettingsPanelUI)this.getRenderPanel()).loadModel();
        this.setTrackUpdates(true);
    }

    @Override
    public void onExit(AttachWizardContext context) {
        this.storeSettings();
    }

    @Override
    public void onFinish(AttachWizardContext context) {
    }

    @Override
    public void onPanelShow() {
        ((AttachSettingsPanelUI)this.getRenderPanel()).applyCombos();
        ((AttachSettingsPanelUI)this.getRenderPanel()).loadModel();
    }

    @Override
    protected JPanel getRenderPanel() {
        if (this.panel == null) {
            this.panel = new AttachSettingsPanelUI(this.model);
        }
        return this.panel;
    }

    private void publishUpdate() {
        if (!this.isTrackUpdates()) {
            return;
        }
        if (this.storeSettings()) {
            this.publishUpdate(new ChangeEvent(this));
        }
    }

    private boolean storeSettings() {
        AttachWizardContext context = this.getContext();
        if (context == null) {
            return false;
        }
        if (this.model.getTarget() == null) {
            return true;
        }
        AttachSettings settings = context.getAttachSettings();
        if (this.model.isLocal() || this.model.isRemote()) {
            settings.setRemote(this.model.isRemote());
        }
        settings.setDirect(this.model.isDirectAttach());
        settings.setDynamic16(this.model.isDynamicAttach16());
        settings.setTargetType(this.model.getTargetGroup().getName());
        settings.setServerType(this.model.getTarget().getName());
        context.setIntegrationProvider(this.model.getTarget().getProvider());
        context.setAutomatic(context.getIntegrationProvider().supportsAutomation() && !context.getIntegrationProvider().supportsManual());
        context.setManual(context.getIntegrationProvider().supportsManual() && !context.getIntegrationProvider().supportsAutomation());
        context.setProviderSingular(this.model.getTargetGroup().isSingular());
        settings.setHostOS(null);
        return true;
    }

    public class PanelModel {
        private Target target = null;
        private TargetGroup targetGroup = null;
        private WizardIntegrationProvider dummyProvider = new WizardIntegrationProvider.NullIntegrationProvider();
        private TargetGroup[] targets = null;
        private boolean automaticIntegration;
        private boolean directAttach;
        private boolean dynamicAttach16;
        private boolean local;
        private boolean manualIntegration;
        private boolean remote;

        public PanelModel() {
            Collection instances = Lookup.getDefault().lookupAll(IntegrationProvider.class);
            final TargetGroup application = new TargetGroup(Bundle.AttachWizard_GroupApplication(), true);
            final TargetGroup applet = new TargetGroup(Bundle.AttachWizard_GroupApplet(), true);
            final TargetGroup server = new TargetGroup(Bundle.AttachWizard_GroupJ2EE(), false);
            IntegrationCategorizer myCategorizer = new IntegrationCategorizer(){

                @Override
                public void addApplet(IntegrationProvider provider, int priority) {
                    applet.addTarget(new Target(provider.getTitle(), (WizardIntegrationProvider)provider, priority));
                }

                @Override
                public void addApplication(IntegrationProvider provider, int priority) {
                    application.addTarget(new Target(provider.getTitle(), (WizardIntegrationProvider)provider, priority));
                }

                @Override
                public void addAppserver(IntegrationProvider provider, int priority) {
                    server.addTarget(new Target(provider.getTitle(), (WizardIntegrationProvider)provider, priority));
                }
            };
            for (WizardIntegrationProvider provider : instances) {
                provider.categorize(myCategorizer);
                provider.getSettingsPersistor().loadSettings();
            }
            if (application.getTargets().length == 0) {
                application.addTarget(new Target(this.dummyProvider.getTitle(), this.dummyProvider, 0));
                application.setNull(true);
            }
            if (applet.getTargets().length == 0) {
                applet.addTarget(new Target(this.dummyProvider.getTitle(), this.dummyProvider, 0));
                applet.setNull(true);
            }
            if (server.getTargets().length == 0) {
                server.addTarget(new Target(this.dummyProvider.getTitle(), this.dummyProvider, 0));
                server.setNull(true);
            }
            this.targets = new TargetGroup[]{application, applet, server};
        }

        public void setAutomaticIntegration(boolean value) {
            this.automaticIntegration = value;
            this.manualIntegration = !value;
            AttachSettingsPanel.this.publishUpdate();
        }

        public boolean isAutomaticIntegration() {
            return this.automaticIntegration;
        }

        public void setDirectAttach(boolean value) {
            this.directAttach = value;
            this.dynamicAttach16 = !value;
            AttachSettingsPanel.this.publishUpdate();
        }

        public boolean isDirectAttach() {
            return this.directAttach;
        }

        public boolean isDynamicAttach16() {
            return this.dynamicAttach16;
        }

        public String getHints() {
            StringBuilder hintBuffer = new StringBuilder();
            if (!this.targetGroup.isNull()) {
                if (this.isLocal()) {
                    hintBuffer.append(this.getLocalHint()).append("<br>");
                }
                if (this.isRemote()) {
                    hintBuffer.append(this.getRemoteHint()).append("<br>");
                }
                if (this.isDirectAttach()) {
                    hintBuffer.append(this.getDirectHint()).append("<br>");
                }
                if (this.isDynamicAttach16()) {
                    hintBuffer.append(this.getDynamicHint()).append("<br>");
                }
            } else {
                hintBuffer.append("No provider registered!");
            }
            return hintBuffer.toString();
        }

        public void setLocal(boolean value) {
            this.local = value;
            this.remote = !value;
            AttachSettingsPanel.this.publishUpdate();
        }

        public boolean isLocal() {
            return this.local;
        }

        public void setManualIntegration(boolean value) {
            this.manualIntegration = value;
            this.automaticIntegration = !value;
            AttachSettingsPanel.this.publishUpdate();
        }

        public boolean isManualIntegration() {
            return this.manualIntegration;
        }

        public void setRemote(boolean value) {
            this.remote = value;
            this.local = !value;
            AttachSettingsPanel.this.publishUpdate();
        }

        public boolean isRemote() {
            return this.remote;
        }

        public void setTarget(Target target) {
            this.target = target;
            AttachSettingsPanel.this.publishUpdate();
        }

        public Target getTarget() {
            return this.target;
        }

        public void setTargetGroup(TargetGroup group) {
            this.targetGroup = group;
            AttachSettingsPanel.this.publishUpdate();
        }

        public TargetGroup getTargetGroup() {
            return this.targetGroup;
        }

        public TargetGroup[] getTargetGroups() {
            return this.targets;
        }

        void setDynamicAttach16(boolean value) {
            this.dynamicAttach16 = value;
            this.directAttach = !value;
            AttachSettingsPanel.this.publishUpdate();
        }

        private String getDirectHint() {
            StringBuilder hint = new StringBuilder();
            if (AttachSettingsPanel.this.model.isLocal()) {
                if (AttachSettingsPanel.this.getContext().getIntegrationProvider().supportsDirect()) {
                    hint.append(Bundle.TargetSettingsWizardPanelUI_DirectHelpString(this.getTargetGroup().getName()));
                }
                if (hint.length() > 0) {
                    hint.append(' ');
                }
                if (AttachSettingsPanel.this.getContext().getIntegrationProvider().supportsDynamic()) {
                    hint.append(Bundle.TargetSettingsWizardPanelUI_DynamicHelpString(this.getTargetGroup().getName()));
                } else {
                    hint.append(Bundle.TargetSettingsWizardPanelUI_DynamicNosuppHelpString(this.getTarget().getName()));
                }
            }
            return hint.toString();
        }

        private String getDynamicHint() {
            return new StringBuffer(this.getDirectHint()).append(' ').append(Bundle.TargetSettingsWizardPanelUI_DynamicJvmHelpString("JDK 6.0/7.0/8.0")).toString();
        }

        private String getLocalHint() {
            StringBuilder hint = new StringBuilder();
            if (AttachSettingsPanel.this.getContext().getIntegrationProvider().supportsLocal()) {
                hint.append(Bundle.TargetSettingsWizardPanelUI_LocalHelpString(this.getTargetGroup().getName()));
            }
            if (hint.length() > 0) {
                hint.append(' ');
            }
            if (AttachSettingsPanel.this.getContext().getIntegrationProvider().supportsRemote()) {
                hint.append(Bundle.TargetSettingsWizardPanelUI_RemoteHelpString(this.getTargetGroup().getName()));
            } else {
                hint.append(Bundle.TargetSettingsWizardPanelUI_RemoteNosuppHelpString(this.getTarget().getName()));
            }
            return hint.toString();
        }

        private String getRemoteHint() {
            return new StringBuffer(this.getLocalHint()).append(' ').append(Bundle.TargetSettingsWizardPanelUI_RemotePacksHelpString()).toString();
        }
    }

    public class Target
    implements Comparable {
        private String name;
        private WizardIntegrationProvider provider;
        private int priority;

        public Target(String name, WizardIntegrationProvider provider, int priority) {
            this.name = name;
            this.provider = provider;
            this.priority = priority;
        }

        public String getName() {
            return this.name;
        }

        public int getPriority() {
            return this.priority;
        }

        public WizardIntegrationProvider getProvider() {
            return this.provider;
        }

        public int compareTo(Object o) {
            if (o == null) {
                return 0;
            }
            if (!(o instanceof Target)) {
                return 0;
            }
            int priorityA = this.priority;
            int priorityB = ((Target)o).getPriority();
            if (priorityA > priorityB) {
                return 1;
            }
            if (priorityA < priorityB) {
                return -1;
            }
            return 0;
        }

        public boolean supportsAutomation() {
            return this.provider.supportsAutomation();
        }

        public boolean supportsDirectAttach() {
            return this.provider.supportsDirect();
        }

        public boolean supportsDynamicAttach() {
            return this.provider.supportsDynamic();
        }

        public boolean supportsLocalProfiling() {
            return this.provider.supportsLocal();
        }

        public boolean supportsRemoteProfiling() {
            return this.provider.supportsRemote();
        }

        public String toString() {
            return this.name;
        }
    }

    public class TargetGroup {
        private List<Target> targetList;
        private String name;
        private boolean dirty;
        private boolean nullGroup;
        private boolean singular;

        public TargetGroup(String name, boolean singular) {
            this(name, new Target[0], singular);
        }

        public TargetGroup(String name, Target[] targets, boolean singular) {
            this.name = name;
            this.singular = singular;
            this.targetList = new ArrayList<Target>(Arrays.asList(targets));
            Collections.sort(this.targetList);
            this.nullGroup = false;
            this.dirty = true;
        }

        public String getName() {
            return this.name;
        }

        public void setNull(boolean value) {
            this.nullGroup = value;
        }

        public boolean isNull() {
            return this.nullGroup;
        }

        public boolean isSingular() {
            return this.singular;
        }

        public Target[] getTargets() {
            if (this.dirty) {
                Collections.sort(this.targetList);
                this.dirty = false;
            }
            return this.targetList.toArray(new Target[0]);
        }

        public void addTarget(Target target) {
            this.targetList.add(target);
            this.dirty = true;
        }

        public String toString() {
            return this.name;
        }
    }
}

