/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.project.ui.groups;

import java.awt.EventQueue;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.net.URL;
import java.text.Collator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import java.util.prefs.BackingStoreException;
import java.util.prefs.Preferences;
import org.netbeans.api.progress.ProgressHandle;
import org.netbeans.api.progress.ProgressHandleFactory;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.project.ui.OpenProjects;
import org.netbeans.modules.project.indexingbridge.IndexingBridge;
import org.netbeans.modules.project.ui.OpenProjectList;
import org.netbeans.modules.project.ui.OpenProjectListSettings;
import org.netbeans.modules.project.ui.ProjectTab;
import org.netbeans.modules.project.ui.ProjectUtilities;
import org.netbeans.modules.project.ui.groups.AdHocGroup;
import org.netbeans.modules.project.ui.groups.Bundle;
import org.netbeans.modules.project.ui.groups.DirectoryGroup;
import org.netbeans.modules.project.ui.groups.GroupEditPanel;
import org.netbeans.modules.project.ui.groups.SubprojectsGroup;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.URLMapper;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;
import org.openide.util.NbPreferences;

public abstract class Group {
    private static final Logger LOG = Logger.getLogger(Group.class.getName());
    private static final Logger UILOG = Logger.getLogger("org.netbeans.ui.project.groups");
    protected static final Preferences NODE = NbPreferences.forModule(Group.class).node("groups");
    private static final String KEY_ACTIVE = "active";
    protected static final String KEY_NAME = "name";
    protected static final String KEY_KIND = "kind";
    protected static final String KEY_PATH = "path";
    protected static final String KEY_MAIN = "main";
    private static boolean projectsLoaded;
    private static final ThreadLocal<Boolean> switchingGroup;
    protected final String id;

    private static Group load(String id) {
        if (id == null) {
            return null;
        }
        String kind = NODE.node(id).get(KEY_KIND, null);
        if ("adHoc".equals(kind)) {
            return new AdHocGroup(id);
        }
        if ("subprojects".equals(kind)) {
            return new SubprojectsGroup(id);
        }
        if ("directory".equals(kind)) {
            return new DirectoryGroup(id);
        }
        LOG.log(Level.WARNING, "Cannot find project group kind for id={0}", id);
        return null;
    }

    public static SortedSet<Group> allGroups() {
        TreeSet<Group> groups = new TreeSet<Group>(Group.displayNameComparator());
        try {
            for (String groupId : NODE.childrenNames()) {
                LOG.log(Level.FINER, "Considering project group id={0}", groupId);
                Group g = Group.load(groupId);
                if (g == null) continue;
                groups.add(g);
            }
        }
        catch (BackingStoreException x) {
            Exceptions.printStackTrace((Throwable)x);
        }
        return groups;
    }

    public static Group getActiveGroup() {
        return Group.load(NODE.get(KEY_ACTIVE, null));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setActiveGroup(Group nue) {
        LOG.log(Level.FINE, "set active group: {0}", nue);
        Group old = Group.getActiveGroup();
        if (nue != null) {
            NODE.put(KEY_ACTIVE, nue.id);
        } else {
            if (old == null) {
                return;
            }
            NODE.remove(KEY_ACTIVE);
        }
        if (projectsLoaded) {
            switchingGroup.set(true);
            try {
                Group.open(nue);
            }
            finally {
                switchingGroup.set(false);
            }
        } else {
            OpenProjectListSettings settings = OpenProjectListSettings.getInstance();
            settings.setOpenProjectsURLsAsStrings(nue != null ? nue.projectPaths() : Collections.emptyList());
            settings.setMainProjectURL(nue != null ? nue.prefs().get(KEY_MAIN, null) : null);
        }
        if (UILOG.isLoggable(Level.FINER)) {
            LogRecord rec = new LogRecord(Level.FINER, "Group.UI.setActiveGroup");
            rec.setParameters(new Object[]{nue != null ? nue.toString(true) : null});
            rec.setResourceBundle(NbBundle.getBundle(Group.class));
            rec.setLoggerName(UILOG.getName());
            UILOG.log(rec);
        }
    }

    public static void projectsLoaded() {
        projectsLoaded = true;
    }

    protected static String sanitizeNameAndUniquifyForId(String name) {
        HashSet<String> existing;
        String sanitizedId = name.replaceAll("[^a-zA-Z0-9_.-]+", "_");
        try {
            existing = new HashSet<String>(Arrays.asList(NODE.childrenNames()));
        }
        catch (BackingStoreException x) {
            Exceptions.printStackTrace((Throwable)x);
            return sanitizedId;
        }
        if (existing.contains(sanitizedId)) {
            int i = 2;
            while (true) {
                String candidate;
                if (!existing.contains(candidate = sanitizedId + "_" + i)) {
                    return candidate;
                }
                ++i;
            }
        }
        return sanitizedId;
    }

    protected Group(String id) {
        this.id = id;
        assert (id.indexOf(47) == -1);
    }

    protected Preferences prefs() {
        return NODE.node(this.id);
    }

    public String getName() {
        String n = this.getNameOrNull();
        if (n == null) {
            n = this.id;
        }
        return n;
    }

    protected String getNameOrNull() {
        return this.prefs().get(KEY_NAME, null);
    }

    public void setName(String n) {
        this.prefs().put(KEY_NAME, n);
        if (this.equals(Group.getActiveGroup())) {
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    ProjectTab.findDefault("projectTabLogical_tc").setGroup(Group.this);
                }
            });
        }
    }

    protected static Project projectForPath(String path) {
        if (path != null) {
            try {
                FileObject fo = URLMapper.findFileObject((URL)new URL(path));
                if (fo != null && fo.isFolder()) {
                    return ProjectManager.getDefault().findProject(fo);
                }
            }
            catch (IOException x) {
                Exceptions.printStackTrace((Throwable)x);
            }
        }
        return null;
    }

    public Set<Project> getProjects() {
        return this.getProjects(null, 0, 0);
    }

    private Set<Project> getProjects(ProgressHandle h, int start, int end) {
        if (h != null) {
            h.progress("", start);
        }
        HashSet<Project> projects = new HashSet<Project>();
        this.findProjects(projects, h, start, end);
        if (h != null) {
            h.progress("", end);
        }
        assert (!projects.contains(null)) : "Found null in " + projects + " from " + this;
        return projects;
    }

    protected abstract void findProjects(Set<Project> var1, ProgressHandle var2, int var3, int var4);

    protected List<String> projectPaths() {
        ArrayList<String> urls = new ArrayList<String>();
        for (Project p : this.getProjects()) {
            urls.add(p.getProjectDirectory().toURL().toString());
        }
        return urls;
    }

    protected static String progressMessage(Project p) {
        return Bundle.Group_progress_project(ProjectUtils.getInformation((Project)p).getDisplayName());
    }

    public Project getMainProject() {
        return Group.projectForPath(this.prefs().get(KEY_MAIN, null));
    }

    public void setMainProject(Project mainProject) throws IllegalArgumentException {
        LOG.log(Level.FINE, "updating main project for {0} to {1}", new Object[]{this.id, mainProject});
        URL f = null;
        if (mainProject != null && this.getProjects().contains(mainProject)) {
            f = mainProject.getProjectDirectory().toURL();
        }
        if (f != null) {
            this.prefs().put(KEY_MAIN, f.toExternalForm());
        } else {
            if (mainProject != null) {
                LOG.log(Level.WARNING, "...but not an open project or disk path not found");
            }
            this.prefs().remove(KEY_MAIN);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void open(final Group g) {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                ProjectTab.findDefault("projectTabLogical_tc").setGroup(g);
            }
        });
        String handleLabel = g != null ? Bundle.Group_open_handle(g.getName()) : Bundle.Group_close_handle();
        ProgressHandle h = ProgressHandleFactory.createHandle((String)handleLabel);
        try {
            h.start(200);
            ProjectUtilities.WaitCursor.show();
            OpenProjectList opl = OpenProjectList.getDefault();
            HashSet<Project> oldOpen = new HashSet<Project>(Arrays.asList(opl.getOpenProjects()));
            Set newOpen = g != null ? g.getProjects(h, 10, 100) : Collections.emptySet();
            HashSet<Project> toClose = new HashSet<Project>(oldOpen);
            toClose.removeAll(newOpen);
            HashSet<Project> toOpen = new HashSet<Project>(newOpen);
            toOpen.removeAll(oldOpen);
            assert (!toClose.contains(null)) : toClose;
            assert (!toOpen.contains(null)) : toOpen;
            IndexingBridge.Lock lock = IndexingBridge.getDefault().protectedMode();
            try {
                h.progress(Bundle.Group_progress_closing(toClose.size()), 110);
                opl.close(toClose.toArray(new Project[toClose.size()]), false);
                h.switchToIndeterminate();
                h.progress(Bundle.Group_progress_opening(toOpen.size()));
                opl.open(toOpen.toArray(new Project[toOpen.size()]), false, h, null);
                if (g != null) {
                    opl.setMainProject(g.getMainProject());
                }
            }
            finally {
                lock.release();
            }
        }
        finally {
            ProjectUtilities.WaitCursor.hide();
            h.finish();
        }
    }

    protected void openProjectsEvent(String propertyName) {
        if (propertyName.equals("MainProject")) {
            this.setMainProject(OpenProjects.getDefault().getMainProject());
        }
    }

    public void destroy() {
        LOG.log(Level.FINE, "destroying: {0}", this.id);
        if (this.equals(Group.getActiveGroup())) {
            Group.setActiveGroup(null);
        }
        try {
            Preferences p = this.prefs();
            p.removeNode();
            assert (!p.nodeExists("")) : "failed to destroy " + this.id;
        }
        catch (BackingStoreException x) {
            Exceptions.printStackTrace((Throwable)x);
        }
    }

    public abstract GroupEditPanel createPropertiesPanel();

    public static Comparator<Group> displayNameComparator() {
        return new Comparator<Group>(){
            Collator COLLATOR = Collator.getInstance();

            @Override
            public int compare(Group g1, Group g2) {
                return this.COLLATOR.compare(g1.getName(), g2.getName());
            }
        };
    }

    public int hashCode() {
        return this.id.hashCode();
    }

    public boolean equals(Object obj) {
        return obj instanceof Group && this.id.equals(((Group)obj).id);
    }

    public String toString() {
        return this.toString(false);
    }

    protected String toString(boolean scrubPersonalInfo) {
        return this.getClass().getName().replaceFirst("^.+\\.", "") + "[id=" + (scrubPersonalInfo ? "#" + this.id.hashCode() : this.id) + ",|projects|=" + this.getProjects().size() + "]";
    }

    public boolean isPristine() {
        return ((Object)this.getProjects()).equals(new HashSet<Project>(Arrays.asList(OpenProjects.getDefault().getOpenProjects())));
    }

    static {
        switchingGroup = new ThreadLocal<Boolean>(){

            @Override
            protected Boolean initialValue() {
                return false;
            }
        };
        LOG.fine("initializing open projects listener");
        OpenProjects.getDefault().addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                Group g;
                if (!projectsLoaded || ((Boolean)switchingGroup.get()).booleanValue()) {
                    return;
                }
                String propertyName = evt.getPropertyName();
                if (propertyName != null && (g = Group.getActiveGroup()) != null) {
                    LOG.log(Level.FINE, "received {0} on {1}", new Object[]{propertyName, g.id});
                    g.openProjectsEvent(propertyName);
                }
            }
        });
    }
}

