/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.project.ui;

import java.awt.Component;
import java.io.IOException;
import javax.swing.JPanel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.modules.project.ui.Bundle;
import org.netbeans.modules.project.ui.ProjectUtilities;
import org.netbeans.modules.project.ui.SimpleTargetChooserPanelGUI;
import org.netbeans.spi.project.ui.templates.support.Templates;
import org.openide.WizardDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.ChangeSupport;
import org.openide.util.HelpCtx;

final class SimpleTargetChooserPanel
implements WizardDescriptor.Panel<WizardDescriptor>,
ChangeListener {
    private final ChangeSupport changeSupport = new ChangeSupport((Object)this);
    private SimpleTargetChooserPanelGUI gui;
    private Project project;
    private SourceGroup[] folders;
    private WizardDescriptor.Panel<WizardDescriptor> bottomPanel;
    private WizardDescriptor wizard;
    private boolean isFolder;
    private boolean freeFileExtension;

    SimpleTargetChooserPanel(Project project, SourceGroup[] folders, WizardDescriptor.Panel<WizardDescriptor> bottomPanel, boolean isFolder, boolean freeFileExtension) {
        this.folders = folders;
        this.project = project;
        this.bottomPanel = bottomPanel;
        if (bottomPanel != null) {
            bottomPanel.addChangeListener((ChangeListener)this);
        }
        this.isFolder = isFolder;
        this.freeFileExtension = freeFileExtension;
        this.gui = null;
    }

    public Component getComponent() {
        if (this.noFolders()) {
            return new JPanel();
        }
        if (this.gui == null) {
            this.gui = new SimpleTargetChooserPanelGUI(this.project, this.folders, this.bottomPanel == null ? null : this.bottomPanel.getComponent(), this.isFolder, this.freeFileExtension);
            this.gui.addChangeListener(this);
        }
        return this.gui;
    }

    private boolean noFolders() {
        return this.folders != null && this.folders.length == 0;
    }

    public HelpCtx getHelp() {
        HelpCtx bottomHelp;
        if (this.bottomPanel != null && (bottomHelp = this.bottomPanel.getHelp()) != null) {
            return bottomHelp;
        }
        return null;
    }

    public boolean isValid() {
        boolean ok;
        if (this.noFolders()) {
            return false;
        }
        boolean bl = ok = this.gui != null && this.gui.getTargetName() != null && this.gui.getTargetGroup() != null && (this.bottomPanel == null || this.bottomPanel.isValid());
        if (!ok) {
            return false;
        }
        FileObject template = Templates.getTemplate((WizardDescriptor)this.wizard);
        String errorMessage = ProjectUtilities.canUseFileName(this.gui.getTargetGroup().getRootFolder(), this.gui.getTargetFolder(), this.gui.getTargetName(), template.getExt(), this.isFolder, this.freeFileExtension);
        this.wizard.putProperty("WizardPanel_errorMessage", (Object)errorMessage);
        return errorMessage == null;
    }

    public void addChangeListener(ChangeListener l) {
        this.changeSupport.addChangeListener(l);
    }

    public void removeChangeListener(ChangeListener l) {
        this.changeSupport.removeChangeListener(l);
    }

    public void readSettings(WizardDescriptor settings) {
        FileObject preselectedTarget;
        this.wizard = settings;
        if (this.noFolders()) {
            this.wizard.putProperty("WizardPanel_errorMessage", (Object)Bundle.SimpleTargetChooserPanelGUI_no_source_folders());
            return;
        }
        if (this.gui == null) {
            this.getComponent();
        }
        if ((preselectedTarget = Templates.getTargetFolder((WizardDescriptor)this.wizard)) == null) {
            preselectedTarget = this.project.getProjectDirectory();
        }
        String targetName = this.isFolder ? null : Templates.getTargetName((WizardDescriptor)this.wizard);
        this.gui.initValues(Templates.getTemplate((WizardDescriptor)this.wizard), preselectedTarget, targetName);
        Object substitute = this.gui.getClientProperty("NewFileWizard_Title");
        if (substitute != null) {
            this.wizard.putProperty("NewFileWizard_Title", substitute);
        }
        this.wizard.putProperty("WizardPanel_contentData", (Object)new String[]{Bundle.LBL_TemplatesPanel_Name(), Bundle.LBL_SimpleTargetChooserPanel_Name()});
        if (this.bottomPanel != null) {
            this.bottomPanel.readSettings((Object)settings);
        }
    }

    public void storeSettings(WizardDescriptor settings) {
        if (this.noFolders()) {
            return;
        }
        if (WizardDescriptor.PREVIOUS_OPTION.equals(settings.getValue())) {
            return;
        }
        if (!settings.getValue().equals(WizardDescriptor.CANCEL_OPTION) && this.isValid()) {
            String name;
            if (this.bottomPanel != null) {
                this.bottomPanel.storeSettings((Object)settings);
            }
            if ((name = this.gui.getTargetName()).indexOf(47) > 0) {
                name = name.substring(name.lastIndexOf(47) + 1);
            }
            Templates.setTargetFolder((WizardDescriptor)settings, (FileObject)this.getTargetFolderFromGUI());
            Templates.setTargetName((WizardDescriptor)settings, (String)name);
        }
        settings.putProperty("NewFileWizard_Title", null);
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        this.changeSupport.fireChange();
    }

    private FileObject getTargetFolderFromGUI() {
        FileObject targetFolder;
        FileObject rootFolder = this.gui.getTargetGroup().getRootFolder();
        String folderName = this.gui.getTargetFolder();
        String newObject = this.gui.getTargetName();
        if (newObject.indexOf(47) > 0) {
            String path = newObject.substring(0, newObject.lastIndexOf(47));
            folderName = folderName == null || "".equals(folderName) ? path : folderName + '/' + path;
        }
        if ((targetFolder = folderName == null ? rootFolder : rootFolder.getFileObject(folderName)) == null) {
            try {
                targetFolder = FileUtil.createFolder((FileObject)rootFolder, (String)folderName);
            }
            catch (IOException ioe) {
                throw new IllegalArgumentException(ioe);
            }
        }
        return targetFolder;
    }
}

