/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.tasks.core;

import java.util.Calendar;
import org.eclipse.mylyn.internal.provisional.commons.core.CommonMessages;
import org.eclipse.mylyn.internal.tasks.core.DateRange;
import org.eclipse.mylyn.internal.tasks.core.Messages;
import org.eclipse.mylyn.internal.tasks.core.TaskActivityUtil;

public class DayDateRange
extends DateRange {
    public DayDateRange(Calendar startDate, Calendar endDate) {
        super(startDate, endDate);
    }

    public DayDateRange next() {
        return this.create(6, 1);
    }

    public DayDateRange previous() {
        return this.create(6, -1);
    }

    protected DayDateRange create(int field, int multiplier) {
        Calendar previousStart = (Calendar)this.getStartDate().clone();
        Calendar previousEnd = (Calendar)this.getEndDate().clone();
        previousStart.add(field, 1 * multiplier);
        previousEnd.add(field, 1 * multiplier);
        return new DayDateRange(previousStart, previousEnd);
    }

    public String toString(boolean useDayOfWeekForNextWeek) {
        boolean isNextWeek;
        boolean isThisWeek = TaskActivityUtil.getCurrentWeek().includes(this);
        Calendar endNextWeek = TaskActivityUtil.getCalendar();
        endNextWeek.add(6, 7);
        boolean bl = isNextWeek = TaskActivityUtil.getNextWeek().includes(this) && this.before(endNextWeek);
        if (isThisWeek || useDayOfWeekForNextWeek && isNextWeek) {
            String day = this.getDayOfWeek();
            if (this.isPresent()) {
                return String.valueOf(day) + Messages.DayDateRange___Today;
            }
            return day;
        }
        return super.toString(useDayOfWeekForNextWeek);
    }

    public String getDayOfWeek() {
        String day = "";
        switch (this.getStartDate().get(7)) {
            case 2: {
                day = CommonMessages.Monday;
                break;
            }
            case 3: {
                day = CommonMessages.Tuesday;
                break;
            }
            case 4: {
                day = CommonMessages.Wednesday;
                break;
            }
            case 5: {
                day = CommonMessages.Thursday;
                break;
            }
            case 6: {
                day = CommonMessages.Friday;
                break;
            }
            case 7: {
                day = CommonMessages.Saturday;
                break;
            }
            case 1: {
                day = CommonMessages.Sunday;
            }
        }
        return day;
    }

    public static boolean isDayRange(Calendar calStart, Calendar calEnd) {
        long diff = calEnd.getTimeInMillis() - calStart.getTimeInMillis() - 86399999L;
        return Math.abs(diff) <= 3600000L;
    }
}

