/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jersey.api.container.grizzly;

import com.sun.grizzly.http.SelectorThread;
import com.sun.grizzly.standalone.StaticStreamAlgorithm;
import com.sun.grizzly.tcp.Adapter;
import com.sun.grizzly.tcp.http11.GrizzlyAdapter;
import com.sun.jersey.api.container.ContainerFactory;
import com.sun.jersey.api.core.ResourceConfig;
import com.sun.jersey.core.spi.component.ioc.IoCComponentProviderFactory;
import java.io.IOException;
import java.net.URI;

public final class GrizzlyServerFactory {
    public static final String FEATURE_ALLOW_ENCODED_SLASH = "com.sun.jersey.api.container.grizzly.AllowEncodedSlashFeature";

    private GrizzlyServerFactory() {
    }

    public static SelectorThread create(String u) throws IOException, IllegalArgumentException {
        if (u == null) {
            throw new IllegalArgumentException("The URI must not be null");
        }
        return GrizzlyServerFactory.create(URI.create(u));
    }

    public static SelectorThread create(URI u) throws IOException, IllegalArgumentException {
        return GrizzlyServerFactory.create(u, (Adapter)ContainerFactory.createContainer(Adapter.class));
    }

    public static SelectorThread create(String u, ResourceConfig rc) throws IOException, IllegalArgumentException {
        if (u == null) {
            throw new IllegalArgumentException("The URI must not be null");
        }
        return GrizzlyServerFactory.create(URI.create(u), rc);
    }

    public static SelectorThread create(URI u, ResourceConfig rc) throws IOException, IllegalArgumentException {
        return GrizzlyServerFactory.create(u, (Adapter)ContainerFactory.createContainer(Adapter.class, (ResourceConfig)rc));
    }

    public static SelectorThread create(String u, ResourceConfig rc, IoCComponentProviderFactory factory) throws IOException, IllegalArgumentException {
        if (u == null) {
            throw new IllegalArgumentException("The URI must not be null");
        }
        return GrizzlyServerFactory.create(URI.create(u), rc, factory);
    }

    public static SelectorThread create(URI u, ResourceConfig rc, IoCComponentProviderFactory factory) throws IOException, IllegalArgumentException {
        return GrizzlyServerFactory.create(u, (Adapter)ContainerFactory.createContainer(Adapter.class, (ResourceConfig)rc, (IoCComponentProviderFactory)factory));
    }

    public static SelectorThread create(String u, Adapter adapter) throws IOException, IllegalArgumentException {
        if (u == null) {
            throw new IllegalArgumentException("The URI must not be null");
        }
        return GrizzlyServerFactory.create(URI.create(u), adapter);
    }

    public static SelectorThread create(URI u, Adapter adapter) throws IOException, IllegalArgumentException {
        if (u == null) {
            throw new IllegalArgumentException("The URI must not be null");
        }
        String scheme = u.getScheme();
        if (!scheme.equalsIgnoreCase("http")) {
            throw new IllegalArgumentException("The URI scheme, of the URI " + u + ", must be equal (ignoring case) to 'http'");
        }
        if (adapter instanceof GrizzlyAdapter) {
            GrizzlyAdapter ga = (GrizzlyAdapter)adapter;
            ga.setResourcesContextPath(u.getRawPath());
        }
        SelectorThread selectorThread = new SelectorThread();
        selectorThread.setAlgorithmClassName(StaticStreamAlgorithm.class.getName());
        int port = u.getPort() == -1 ? 80 : u.getPort();
        selectorThread.setPort(port);
        selectorThread.setAdapter(adapter);
        try {
            selectorThread.listen();
        }
        catch (InstantiationException e) {
            IOException _e = new IOException();
            _e.initCause(e);
            throw _e;
        }
        return selectorThread;
    }
}

