/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.v3.services.impl;

import com.sun.enterprise.v3.services.impl.ServiceInitializerThread;
import com.sun.enterprise.v3.services.impl.monitor.GrizzlyMonitoring;
import com.sun.enterprise.v3.services.impl.monitor.MonitorableServiceListener;
import com.sun.grizzly.Controller;
import com.sun.grizzly.ProtocolChain;
import com.sun.grizzly.ProtocolChainInstanceHandler;
import com.sun.grizzly.arp.AsyncFilter;
import com.sun.grizzly.arp.AsyncHandler;
import com.sun.grizzly.arp.DefaultAsyncHandler;
import com.sun.grizzly.config.GrizzlyEmbeddedHttp;
import com.sun.grizzly.config.dom.NetworkListener;
import java.beans.PropertyChangeEvent;
import java.io.IOException;
import org.jvnet.hk2.component.Habitat;

public class GrizzlyListener
extends MonitorableServiceListener {
    private boolean isGenericListener = false;
    private ServiceInitializerThread serviceInitializer;
    private NetworkListener listener;

    public GrizzlyListener(GrizzlyMonitoring monitoring, Controller controller, String listenerName) {
        super(monitoring, controller, listenerName);
    }

    public void configure(NetworkListener networkListener, Habitat habitat) {
        this.listener = networkListener;
        if ("light-weight-listener".equals(networkListener.getProtocol())) {
            this.isGenericListener = true;
        }
        if (!this.isGenericListener) {
            super.configure(networkListener, habitat);
        } else {
            this.initializeListener(networkListener, habitat);
            this.setName(networkListener.getName());
        }
    }

    private void initializeListener(NetworkListener networkListener, Habitat habitat) {
        this.serviceInitializer = new ServiceInitializerThread(this, habitat);
        this.serviceInitializer.setController(this.getController());
        this.serviceInitializer.configure(networkListener);
    }

    public NetworkListener getListener() {
        return this.listener;
    }

    public void start() throws IOException, InstantiationException {
        if (this.isGenericListener) {
            this.serviceInitializer.initController();
            this.serviceInitializer.startEndpoint();
        } else {
            this.getEmbeddedHttp().initEndpoint();
            this.getEmbeddedHttp().startEndpoint();
        }
    }

    public void stop() {
        if (this.isGenericListener) {
            this.serviceInitializer.stopEndpoint();
        } else {
            this.getEmbeddedHttp().stopEndpoint();
        }
    }

    public void initEndpoint() throws IOException, InstantiationException {
        if (this.isGenericListener) {
            this.serviceInitializer.initEndpoint();
        } else {
            this.getEmbeddedHttp().initEndpoint();
        }
    }

    public Controller getController() {
        if (this.isGenericListener) {
            return this.serviceInitializer.getController();
        }
        return this.getEmbeddedHttp().getController();
    }

    public void startEndpoint() throws IOException, InstantiationException {
        if (this.isGenericListener) {
            this.serviceInitializer.startEndpoint();
        } else {
            this.getEmbeddedHttp().startEndpoint();
        }
    }

    public boolean isGenericListener() {
        return this.isGenericListener;
    }

    public int getPort() {
        if (this.isGenericListener) {
            return this.serviceInitializer.getPort();
        }
        return this.getEmbeddedHttp().getPort();
    }

    public void processDynamicConfigurationChange(Habitat habitat, PropertyChangeEvent[] events) {
        for (PropertyChangeEvent event : events) {
            if (!"comet-support-enabled".equals(event.getPropertyName())) continue;
            this.processDynamicCometConfiguration(habitat, event);
            break;
        }
    }

    private void processDynamicCometConfiguration(Habitat habitat, PropertyChangeEvent event) {
        boolean enableComet = Boolean.valueOf(event.getNewValue().toString());
        if (enableComet) {
            this.enableComet(habitat);
        } else {
            this.disableComet();
        }
    }

    private void enableComet(Habitat habitat) {
        AsyncFilter cometFilter = GrizzlyEmbeddedHttp.loadCometAsyncFilter((Habitat)habitat);
        if (cometFilter == null) {
            return;
        }
        if (this.getEmbeddedHttp().getAsyncHandler() == null) {
            DefaultAsyncHandler asyncHandler = new DefaultAsyncHandler();
            this.getEmbeddedHttp().setAsyncHandler((AsyncHandler)asyncHandler);
        }
        this.getEmbeddedHttp().getAsyncHandler().addAsyncFilter(cometFilter);
        ProtocolChainInstanceHandler pcih = this.getEmbeddedHttp().getController().getProtocolChainInstanceHandler();
        if (!(pcih instanceof NonCachingInstanceHandler)) {
            NonCachingInstanceHandler nonCaching = new NonCachingInstanceHandler(pcih);
            this.getEmbeddedHttp().getController().setProtocolChainInstanceHandler((ProtocolChainInstanceHandler)nonCaching);
        }
        this.getEmbeddedHttp().setEnableAsyncExecution(true);
    }

    private void disableComet() {
        this.getEmbeddedHttp().setAsyncHandler(null);
        ProtocolChainInstanceHandler pcih = this.getEmbeddedHttp().getController().getProtocolChainInstanceHandler();
        if (!(pcih instanceof NonCachingInstanceHandler)) {
            NonCachingInstanceHandler nonCaching = new NonCachingInstanceHandler(pcih);
            this.getEmbeddedHttp().getController().setProtocolChainInstanceHandler((ProtocolChainInstanceHandler)nonCaching);
        }
        this.getEmbeddedHttp().setEnableAsyncExecution(false);
    }

    private static final class NonCachingInstanceHandler
    implements ProtocolChainInstanceHandler {
        private final ProtocolChainInstanceHandler wrapped;

        private NonCachingInstanceHandler(ProtocolChainInstanceHandler wrapped) {
            this.wrapped = wrapped;
        }

        public ProtocolChain poll() {
            return this.wrapped.poll();
        }

        public boolean offer(ProtocolChain protocolChain) {
            return true;
        }
    }
}

