/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.v3.server;

import com.sun.enterprise.util.LocalStringManagerImpl;
import com.sun.enterprise.util.io.FileUtils;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.locks.Lock;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.glassfish.common.util.admin.ManagedFile;
import org.glassfish.config.support.ConfigurationAccess;
import org.glassfish.config.support.ConfigurationPersistence;
import org.glassfish.server.ServerEnvironmentImpl;
import org.jvnet.hk2.annotations.Inject;
import org.jvnet.hk2.annotations.Scoped;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.component.Singleton;
import org.jvnet.hk2.config.DomDocument;
import org.jvnet.hk2.config.IndentingXMLStreamWriter;

@Service
@Scoped(value=Singleton.class)
public class DomainXmlPersistence
implements ConfigurationPersistence,
ConfigurationAccess {
    @Inject
    ServerEnvironmentImpl env;
    @Inject
    protected Logger logger;
    final XMLOutputFactory xmlFactory = XMLOutputFactory.newInstance();
    static final LocalStringManagerImpl localStrings = new LocalStringManagerImpl(DomainXmlPersistence.class);

    private synchronized ManagedFile getPidFile() throws IOException {
        File location = null;
        try {
            location = new File(this.env.getConfigDirPath(), "lockfile");
            if (!(location.exists() || location.createNewFile() || location.exists())) {
                String message = localStrings.getLocalString("cannotCreateLockfile", "Cannot create lock file at {0}, configuration changes will not be persisted", new Object[]{location});
                this.logger.log(Level.SEVERE, message);
                throw new IOException(message);
            }
            return new ManagedFile(location, 2000, -1);
        }
        catch (IOException e) {
            this.logger.log(Level.SEVERE, localStrings.getLocalString("InvalidLocation", "Cannot obtain lockfile location {0}, configuration changes will not be persisted", new Object[]{location}), e);
            throw e;
        }
    }

    public Lock accessRead() throws IOException, TimeoutException {
        return this.getPidFile().accessRead();
    }

    public Lock accessWrite() throws IOException, TimeoutException {
        return this.getPidFile().accessWrite();
    }

    public void save(DomDocument doc) throws IOException {
        File destination = this.getDestination();
        if (destination == null) {
            String msg = localStrings.getLocalString("NoLocation", "domain.xml cannot be persisted, null destination");
            this.logger.severe(msg);
            throw new IOException(msg);
        }
        Lock writeLock = null;
        try {
            try {
                writeLock = this.accessWrite();
            }
            catch (TimeoutException e) {
                String msg = localStrings.getLocalString("Timeout", "Timed out when waiting for write lock on configuration file");
                this.logger.log(Level.SEVERE, msg);
                throw new IOException(msg, e);
            }
            File f = File.createTempFile("domain", ".xml", destination.getParentFile());
            if (f == null) {
                throw new IOException(localStrings.getLocalString("NoTmpFile", "Cannot create temporary file when saving domain.xml"));
            }
            XMLStreamWriter writer = null;
            OutputStream fos = this.getOutputStream(f);
            try {
                writer = this.xmlFactory.createXMLStreamWriter(new BufferedOutputStream(fos));
                IndentingXMLStreamWriter indentingXMLStreamWriter = new IndentingXMLStreamWriter(writer);
                doc.writeTo((XMLStreamWriter)indentingXMLStreamWriter);
                indentingXMLStreamWriter.close();
            }
            catch (XMLStreamException e) {
                String msg = localStrings.getLocalString("TmpFileNotSaved", "Configuration could not be saved to temporary file");
                this.logger.log(Level.SEVERE, msg, e);
                throw new IOException(e.getMessage(), e);
            }
            finally {
                if (writer != null) {
                    try {
                        writer.close();
                    }
                    catch (XMLStreamException e) {
                        this.logger.log(Level.SEVERE, localStrings.getLocalString("CloseFailed", "Cannot close configuration writer stream"), e);
                        throw new IOException(e.getMessage(), e);
                    }
                }
                fos.close();
            }
            File backup = new File(this.env.getConfigDirPath(), "domain.xml.bak");
            if (destination.exists() && backup.exists() && !backup.delete()) {
                String msg = localStrings.getLocalString("BackupDeleteFailed", "Could not delete previous backup file at {0}", new Object[]{backup.getAbsolutePath()});
                this.logger.severe(msg);
                throw new IOException(msg);
            }
            if (destination != null) {
                if (destination.exists() && !FileUtils.renameFile((File)destination, (File)backup)) {
                    String msg = localStrings.getLocalString("TmpRenameFailed", "Could not rename {0} to {1}", new Object[]{destination.getAbsolutePath(), backup.getAbsolutePath()});
                    this.logger.severe(msg);
                    throw new IOException(msg);
                }
                if (!FileUtils.renameFile((File)f, (File)destination)) {
                    String msg = localStrings.getLocalString("TmpRenameFailed", "Could not rename {0} to {1}", new Object[]{f.getAbsolutePath(), destination.getAbsolutePath()});
                    if (!FileUtils.renameFile((File)backup, (File)destination)) {
                        msg = msg + "\n" + localStrings.getLocalString("RenameFailed", "Could not rename backup to {0}", new Object[]{destination.getAbsolutePath()});
                    }
                    this.logger.severe(msg);
                    throw new IOException(msg);
                }
            }
        }
        catch (IOException e) {
            this.logger.log(Level.SEVERE, localStrings.getLocalString("ioexception", "IOException while saving the configuration, changes not persisted"), e);
            throw e;
        }
        finally {
            if (writeLock != null) {
                writeLock.unlock();
            }
        }
        this.saved(destination);
    }

    public void touch() throws IOException {
        this.getDestination().setLastModified(System.currentTimeMillis());
    }

    protected void saved(File destination) {
        this.logger.fine("Configuration saved at " + destination);
    }

    protected File getDestination() throws IOException {
        return new File(this.env.getConfigDirPath(), "domain.xml");
    }

    protected OutputStream getOutputStream(File destination) throws IOException {
        return new FileOutputStream(destination);
    }
}

