/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.v3.admin;

import com.sun.enterprise.config.serverbeans.Config;
import com.sun.enterprise.config.serverbeans.Configs;
import com.sun.enterprise.config.serverbeans.MessageSecurityConfig;
import com.sun.enterprise.config.serverbeans.ProviderConfig;
import com.sun.enterprise.config.serverbeans.RequestPolicy;
import com.sun.enterprise.config.serverbeans.ResponsePolicy;
import com.sun.enterprise.config.serverbeans.SecurityService;
import com.sun.enterprise.module.bootstrap.EarlyLogHandler;
import com.sun.grizzly.config.dom.NetworkListener;
import java.beans.PropertyVetoException;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import org.glassfish.api.admin.config.ConfigurationUpgrade;
import org.jvnet.hk2.annotations.Inject;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.component.PostConstruct;
import org.jvnet.hk2.config.ConfigBeanProxy;
import org.jvnet.hk2.config.ConfigSupport;
import org.jvnet.hk2.config.SingleConfigCode;
import org.jvnet.hk2.config.TransactionFailure;
import org.jvnet.hk2.config.types.Property;

@Service
public class AdminConsoleConfigUpgrade
implements ConfigurationUpgrade,
PostConstruct {
    private static final String AUTH_LAYER = "HttpServlet";
    private static final String PROVIDER_TYPE = "server";
    private static final String PROVIDER_ID = "GFConsoleAuthModule";
    private static final String CLASS_NAME = "org.glassfish.admingui.common.security.AdminConsoleAuthModule";
    private static final String AUTH_SOURCE = "sender";
    private static final String AUTH_URL_PROP = "restAuthURL";
    private static final String AUTH_URL_VAL_TEMPLATE = "http://localhost:%s/management/sessions";
    public static final String DEFAULT_ADMIN_PORT = "4848";
    private static final String LOGIN_PAGE_PROP = "loginPage";
    private static final String LOGIN_PAGE_VAL = "/login.jsf";
    private static final String LOGIN_ERR_PAGE_PROP = "loginErrorPage";
    private static final String LOGIN_ERR_PAGE_VAL = "/loginError.jsf";
    @Inject
    Configs configs;
    @Inject(name="grizzlyconfigupgrade", optional=true)
    ConfigurationUpgrade precondition = null;

    public void postConstruct() {
        SecurityService s;
        Config config = this.configs.getConfigByName("server-config");
        if (config != null && (s = config.getSecurityService()) != null) {
            try {
                ConfigSupport.apply((SingleConfigCode)new AdminConsoleConfigCode(), (ConfigBeanProxy)s);
            }
            catch (TransactionFailure tf) {
                LogRecord lr = new LogRecord(Level.SEVERE, "Could not upgrade security service for admin console: " + (Object)((Object)tf));
                lr.setLoggerName(this.getClass().getName());
                EarlyLogHandler.earlyMessages.add(lr);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class AdminConsoleConfigCode
    implements SingleConfigCode<SecurityService> {
        private AdminConsoleConfigCode() {
        }

        public Object run(SecurityService service) throws PropertyVetoException, TransactionFailure {
            for (MessageSecurityConfig msc : service.getMessageSecurityConfig()) {
                if (!AdminConsoleConfigUpgrade.AUTH_LAYER.equals(msc.getAuthLayer())) continue;
                return null;
            }
            MessageSecurityConfig msConfig = (MessageSecurityConfig)service.createChild(MessageSecurityConfig.class);
            msConfig.setAuthLayer(AdminConsoleConfigUpgrade.AUTH_LAYER);
            service.getMessageSecurityConfig().add(msConfig);
            ProviderConfig pConfig = (ProviderConfig)msConfig.createChild(ProviderConfig.class);
            pConfig.setProviderType(AdminConsoleConfigUpgrade.PROVIDER_TYPE);
            pConfig.setProviderId(AdminConsoleConfigUpgrade.PROVIDER_ID);
            pConfig.setClassName(AdminConsoleConfigUpgrade.CLASS_NAME);
            msConfig.getProviderConfig().add(pConfig);
            RequestPolicy reqPol = (RequestPolicy)pConfig.createChild(RequestPolicy.class);
            reqPol.setAuthSource(AdminConsoleConfigUpgrade.AUTH_SOURCE);
            pConfig.setRequestPolicy(reqPol);
            ResponsePolicy resPol = (ResponsePolicy)pConfig.createChild(ResponsePolicy.class);
            pConfig.setResponsePolicy(resPol);
            String adminPort = AdminConsoleConfigUpgrade.DEFAULT_ADMIN_PORT;
            Config parent = (Config)service.getParent(Config.class);
            NetworkListener nl = parent.getAdminListener();
            if (nl != null) {
                adminPort = nl.getPort();
            } else {
                LogRecord lr = new LogRecord(Level.WARNING, String.format("Couldn't get admin port from config '%s'. Using default %s", parent.getName(), AdminConsoleConfigUpgrade.DEFAULT_ADMIN_PORT));
                lr.setLoggerName(this.getClass().getName());
                EarlyLogHandler.earlyMessages.add(lr);
            }
            Property urlProp = (Property)pConfig.createChild(Property.class);
            urlProp.setName(AdminConsoleConfigUpgrade.AUTH_URL_PROP);
            urlProp.setValue(String.format(AdminConsoleConfigUpgrade.AUTH_URL_VAL_TEMPLATE, adminPort));
            Property logPageProp = (Property)pConfig.createChild(Property.class);
            logPageProp.setName(AdminConsoleConfigUpgrade.LOGIN_PAGE_PROP);
            logPageProp.setValue(AdminConsoleConfigUpgrade.LOGIN_PAGE_VAL);
            Property logErrPage = (Property)pConfig.createChild(Property.class);
            logErrPage.setName(AdminConsoleConfigUpgrade.LOGIN_ERR_PAGE_PROP);
            logErrPage.setValue(AdminConsoleConfigUpgrade.LOGIN_ERR_PAGE_VAL);
            List props = pConfig.getProperty();
            props.add(urlProp);
            props.add(logPageProp);
            props.add(logErrPage);
            return null;
        }
    }
}

