/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.config.support;

import com.sun.enterprise.config.serverbeans.Config;
import com.sun.enterprise.config.serverbeans.Configs;
import com.sun.enterprise.config.serverbeans.ConnectionPool;
import com.sun.enterprise.config.serverbeans.HttpFileCache;
import com.sun.enterprise.config.serverbeans.HttpListener;
import com.sun.enterprise.config.serverbeans.HttpProtocol;
import com.sun.enterprise.config.serverbeans.HttpService;
import com.sun.enterprise.config.serverbeans.JavaConfig;
import com.sun.enterprise.config.serverbeans.KeepAlive;
import com.sun.enterprise.config.serverbeans.RequestProcessing;
import com.sun.enterprise.config.serverbeans.ThreadPools;
import com.sun.enterprise.config.serverbeans.VirtualServer;
import com.sun.grizzly.config.dom.FileCache;
import com.sun.grizzly.config.dom.Http;
import com.sun.grizzly.config.dom.NetworkConfig;
import com.sun.grizzly.config.dom.NetworkListener;
import com.sun.grizzly.config.dom.NetworkListeners;
import com.sun.grizzly.config.dom.PortUnification;
import com.sun.grizzly.config.dom.Protocol;
import com.sun.grizzly.config.dom.ProtocolChain;
import com.sun.grizzly.config.dom.ProtocolChainInstanceHandler;
import com.sun.grizzly.config.dom.ProtocolFilter;
import com.sun.grizzly.config.dom.ProtocolFinder;
import com.sun.grizzly.config.dom.Protocols;
import com.sun.grizzly.config.dom.Ssl;
import com.sun.grizzly.config.dom.ThreadPool;
import com.sun.grizzly.config.dom.Transport;
import com.sun.grizzly.config.dom.Transports;
import com.sun.logging.LogDomains;
import java.beans.PropertyVetoException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.api.admin.config.ConfigurationUpgrade;
import org.jvnet.hk2.annotations.Inject;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.component.Habitat;
import org.jvnet.hk2.component.PostConstruct;
import org.jvnet.hk2.config.ConfigBeanProxy;
import org.jvnet.hk2.config.ConfigSupport;
import org.jvnet.hk2.config.SingleConfigCode;
import org.jvnet.hk2.config.TransactionFailure;
import org.jvnet.hk2.config.types.Property;

@Service(name="grizzlyconfigupgrade")
public class GrizzlyConfigSchemaMigrator
implements ConfigurationUpgrade,
PostConstruct {
    private static final String SSL_CONFIGURATION_WANTAUTH = "com.sun.grizzly.ssl.auth";
    private static final String SSL_CONFIGURATION_SSLIMPL = "com.sun.grizzly.ssl.sslImplementation";
    @Inject
    private Configs configs;
    private Config currentConfig;
    @Inject
    private Habitat habitat;
    private static final String HTTP_THREAD_POOL = "http-thread-pool";
    private static final String ASADMIN_LISTENER = "admin-listener";
    private static final String ASADMIN_VIRTUAL_SERVER = "__asadmin";
    static final Logger logger = LogDomains.getLogger(GrizzlyConfigSchemaMigrator.class, (String)"javax.enterprise.system.tools.admin");

    public void postConstruct() {
        Iterator<Config> i$ = this.configs.getConfig().iterator();
        while (i$.hasNext()) {
            Config config;
            this.currentConfig = config = i$.next();
            try {
                NetworkConfig networkConfig = this.currentConfig.getNetworkConfig();
                if (networkConfig == null) {
                    this.createFromScratch();
                }
                this.normalizeThreadPools();
                if (this.currentConfig.getHttpService() != null) {
                    this.processHttpListeners();
                    this.promoteHttpServiceProperties(this.currentConfig.getHttpService());
                    this.promoteVirtualServerProperties(this.currentConfig.getHttpService());
                } else {
                    logger.log(Level.WARNING, "GrizzlyConfigSchemaMigrator.nullHttpService", new String[]{this.currentConfig.getName()});
                }
                this.promoteSystemProperties();
                this.addAsadminProtocol(this.currentConfig.getNetworkConfig());
            }
            catch (TransactionFailure tf) {
                logger.log(Level.SEVERE, "GrizzlyConfigSchemaMigrator.failUpgradeDomain", tf);
                throw new RuntimeException(tf);
            }
        }
    }

    private void addAsadminProtocol(NetworkConfig config) throws TransactionFailure {
        this.ensureAdminThreadPool();
        Protocols protocols = GrizzlyConfigSchemaMigrator.getProtocols(config);
        Protocol adminProtocol = protocols.findProtocol(ASADMIN_LISTENER);
        if (adminProtocol == null) {
            adminProtocol = (Protocol)ConfigSupport.apply((SingleConfigCode)new SingleConfigCode<Protocols>(){

                public Object run(Protocols param) throws TransactionFailure {
                    Protocol protocol = (Protocol)param.createChild(Protocol.class);
                    param.getProtocol().add(protocol);
                    protocol.setName(GrizzlyConfigSchemaMigrator.ASADMIN_LISTENER);
                    Http http = (Http)protocol.createChild(Http.class);
                    http.setFileCache((FileCache)http.createChild(FileCache.class));
                    protocol.setHttp(http);
                    http.setDefaultVirtualServer(GrizzlyConfigSchemaMigrator.ASADMIN_VIRTUAL_SERVER);
                    http.setMaxConnections("250");
                    return protocol;
                }
            }, (ConfigBeanProxy)protocols);
        }
        for (NetworkListener listener : adminProtocol.findNetworkListeners()) {
            ConfigSupport.apply((SingleConfigCode)new SingleConfigCode<NetworkListener>(){

                public Object run(NetworkListener param) {
                    param.setThreadPool("admin-thread-pool");
                    return null;
                }
            }, (ConfigBeanProxy)listener);
        }
    }

    private void ensureAdminThreadPool() throws TransactionFailure {
        ThreadPools threadPools = this.currentConfig.getThreadPools();
        boolean adminThreadPoolFound = false;
        for (ThreadPool pool : threadPools.getThreadPool()) {
            adminThreadPoolFound |= "admin-thread-pool".equals(pool.getName());
        }
        if (!adminThreadPoolFound) {
            ConfigSupport.apply((SingleConfigCode)new SingleConfigCode<ThreadPools>(){

                public Object run(ThreadPools param) throws PropertyVetoException, TransactionFailure {
                    ThreadPool pool = (ThreadPool)param.createChild(ThreadPool.class);
                    param.getThreadPool().add(pool);
                    pool.setName("admin-thread-pool");
                    pool.setMaxThreadPoolSize("50");
                    pool.setMaxQueueSize("256");
                    return null;
                }
            }, (ConfigBeanProxy)threadPools);
        }
    }

    private void createFromScratch() throws TransactionFailure {
        this.normalizeThreadPools();
        this.getNetworkConfig();
    }

    private void createHttp(Protocol protocol, HttpListener listener) throws TransactionFailure {
        Http http = (Http)protocol.createChild(Http.class);
        http.setFileCache((FileCache)http.createChild(FileCache.class));
        protocol.setHttp(http);
        http.setDefaultVirtualServer(listener.getDefaultVirtualServer());
        http.setServerName(listener.getServerName());
        http.setRedirectPort(listener.getRedirectPort());
        http.setXpoweredBy(listener.getXpoweredBy());
    }

    private NetworkListener createNetworkListener(Config baseConfig, final HttpListener listener, final Protocol protocol) throws TransactionFailure {
        final NetworkListener networkListener = (NetworkListener)ConfigSupport.apply((SingleConfigCode)new SingleConfigCode<NetworkListeners>(){

            public Object run(NetworkListeners param) throws TransactionFailure {
                Iterator it = param.getNetworkListener().iterator();
                NetworkListener netListener = null;
                while (it.hasNext() && netListener == null) {
                    NetworkListener next = (NetworkListener)it.next();
                    if (!next.getName().equals(listener.getId())) continue;
                    netListener = next;
                    ConfigSupport.apply((SingleConfigCode)new SingleConfigCode<NetworkListener>(){

                        public Object run(NetworkListener netParam) {
                            GrizzlyConfigSchemaMigrator.this.updateListener(netParam, listener, protocol);
                            return null;
                        }
                    }, (ConfigBeanProxy)netListener);
                }
                if (netListener == null) {
                    netListener = (NetworkListener)param.createChild(NetworkListener.class);
                    netListener.setName(listener.getId());
                    GrizzlyConfigSchemaMigrator.this.updateListener(netListener, listener, protocol);
                    param.getNetworkListener().add(netListener);
                }
                return netListener;
            }
        }, (ConfigBeanProxy)this.getNetworkListeners(baseConfig.getNetworkConfig()));
        Transport transport = networkListener.findTransport();
        if (transport == null) {
            transport = (Transport)ConfigSupport.apply((SingleConfigCode)new SingleConfigCode<Transports>(){

                public Object run(Transports param) throws TransactionFailure {
                    Transport child = (Transport)param.createChild(Transport.class);
                    child.setName(networkListener.getTransport());
                    param.getTransport().add(child);
                    return child;
                }
            }, (ConfigBeanProxy)this.getTransports(networkListener.getParent().getParent()));
        }
        ConfigSupport.apply((SingleConfigCode)new SingleConfigCode<Transport>(){

            public Object run(Transport param) {
                param.setAcceptorThreads(listener.getAcceptorThreads());
                return null;
            }
        }, (ConfigBeanProxy)transport);
        return networkListener;
    }

    private void createNewProtocols(final HttpService httpService, Protocols protocols) throws TransactionFailure {
        ConfigSupport.apply((SingleConfigCode)new SingleConfigCode<Protocols>(){

            public Object run(Protocols param) throws TransactionFailure {
                for (HttpListener httpListener : httpService.getHttpListener()) {
                    Protocol protocol = (Protocol)param.createChild(Protocol.class);
                    param.getProtocol().add(protocol);
                    protocol.setName(httpListener.getId());
                    Http http = (Http)protocol.createChild(Http.class);
                    http.setFileCache((FileCache)http.createChild(FileCache.class));
                    http.setDefaultVirtualServer(httpListener.getId().equals(GrizzlyConfigSchemaMigrator.ASADMIN_LISTENER) ? GrizzlyConfigSchemaMigrator.ASADMIN_VIRTUAL_SERVER : "server");
                    protocol.setHttp(http);
                }
                return null;
            }
        }, (ConfigBeanProxy)protocols);
    }

    private void createPortUnification(final NetworkListener listener) throws TransactionFailure {
        ConfigSupport.apply((SingleConfigCode)new SingleConfigCode<Protocols>(){

            public Object run(Protocols protocols) throws TransactionFailure {
                Protocol puProtocol = GrizzlyConfigSchemaMigrator.this.createProtocol(protocols, "pu-" + listener.getName());
                PortUnification pu = (PortUnification)puProtocol.createChild(PortUnification.class);
                puProtocol.setPortUnification(pu);
                GrizzlyConfigSchemaMigrator.this.createProtocolFinder(pu, listener.getProtocol(), listener.getProtocol(), "com.sun.grizzly.http.portunif.HttpProtocolFinder");
                GrizzlyConfigSchemaMigrator.this.createProtocolFinder(pu, "soap-tcp", "soap-tcp-finder", "org.glassfish.webservices.transport.tcp.WSTCPProtocolFinder");
                Protocol soap = GrizzlyConfigSchemaMigrator.this.createProtocol(protocols, "soap-tcp");
                ProtocolChainInstanceHandler handler = (ProtocolChainInstanceHandler)soap.createChild(ProtocolChainInstanceHandler.class);
                soap.setProtocolChainInstanceHandler(handler);
                ProtocolChain chain = (ProtocolChain)handler.createChild(ProtocolChain.class);
                handler.setProtocolChain(chain);
                GrizzlyConfigSchemaMigrator.this.createProtocolFilter(chain, "soap-tcp-filter", "org.glassfish.webservices.transport.tcp.WSTCPProtocolFilter");
                return null;
            }
        }, (ConfigBeanProxy)this.getNetworkConfig().getProtocols());
    }

    private Protocol createProtocol(Protocols protocols, String name) throws TransactionFailure {
        Protocol puProtocol = (Protocol)protocols.createChild(Protocol.class);
        protocols.getProtocol().add(puProtocol);
        puProtocol.setName(name);
        return puProtocol;
    }

    private void createProtocolFinder(PortUnification pu, String protocolName, String name, String className) throws TransactionFailure {
        ProtocolFinder finder = (ProtocolFinder)pu.createChild(ProtocolFinder.class);
        pu.getProtocolFinder().add(finder);
        finder.setProtocol(protocolName);
        finder.setName(name);
        finder.setClassname(className);
    }

    private void createProtocolFilter(ProtocolChain chain, String name, String className) throws TransactionFailure {
        ProtocolFilter filter = (ProtocolFilter)chain.createChild(ProtocolFilter.class);
        chain.getProtocolFilter().add(filter);
        filter.setName(name);
        filter.setClassname(className);
    }

    private ThreadPools createThreadPools() throws TransactionFailure {
        return (ThreadPools)ConfigSupport.apply((SingleConfigCode)new SingleConfigCode<Config>(){

            public Object run(Config param) throws PropertyVetoException, TransactionFailure {
                ThreadPools threadPools = (ThreadPools)param.createChild(ThreadPools.class);
                param.setThreadPools(threadPools);
                return threadPools;
            }
        }, (ConfigBeanProxy)this.currentConfig);
    }

    private NetworkConfig getNetworkConfig() throws TransactionFailure {
        NetworkConfig config = this.currentConfig.getNetworkConfig();
        if (config == null) {
            config = (NetworkConfig)ConfigSupport.apply((SingleConfigCode)new SingleConfigCode<Config>(){

                public Object run(Config param) throws PropertyVetoException, TransactionFailure {
                    NetworkConfig netConfig = (NetworkConfig)param.createChild(NetworkConfig.class);
                    netConfig.setProtocols((Protocols)netConfig.createChild(Protocols.class));
                    netConfig.setNetworkListeners((NetworkListeners)netConfig.createChild(NetworkListeners.class));
                    netConfig.setTransports((Transports)netConfig.createChild(Transports.class));
                    param.setNetworkConfig(netConfig);
                    return netConfig;
                }
            }, (ConfigBeanProxy)this.currentConfig);
        }
        return config;
    }

    private NetworkListeners getNetworkListeners(NetworkConfig config) throws TransactionFailure {
        NetworkListeners listeners = config.getNetworkListeners();
        if (listeners == null) {
            listeners = (NetworkListeners)ConfigSupport.apply((SingleConfigCode)new SingleConfigCode<NetworkConfig>(){

                public Object run(NetworkConfig param) throws TransactionFailure {
                    NetworkListeners child = (NetworkListeners)param.createChild(NetworkListeners.class);
                    param.setNetworkListeners(child);
                    return child;
                }
            }, (ConfigBeanProxy)config);
        }
        return listeners;
    }

    public static Protocols getProtocols(NetworkConfig config) throws TransactionFailure {
        Protocols protocols = config.getProtocols();
        if (protocols == null) {
            protocols = (Protocols)ConfigSupport.apply((SingleConfigCode)new SingleConfigCode<NetworkConfig>(){

                public Object run(NetworkConfig param) throws TransactionFailure {
                    Protocols child = (Protocols)param.createChild(Protocols.class);
                    param.setProtocols(child);
                    return child;
                }
            }, (ConfigBeanProxy)config);
        }
        return protocols;
    }

    private Transports getTransports(NetworkConfig config) throws TransactionFailure {
        Transports transports = config.getTransports();
        if (transports == null) {
            transports = (Transports)ConfigSupport.apply((SingleConfigCode)new SingleConfigCode<NetworkConfig>(){

                public Object run(NetworkConfig param) throws TransactionFailure {
                    Transports child = (Transports)param.createChild(Transports.class);
                    param.setTransports(child);
                    return child;
                }
            }, (ConfigBeanProxy)config);
        }
        return transports;
    }

    private void migrateConnectionPool(NetworkConfig config, HttpService httpService) throws TransactionFailure {
        ConnectionPool pool = httpService.getConnectionPool();
        if (pool == null) {
            return;
        }
        this.updateHttp(config, pool);
        this.updateThreadPool(config, pool);
        ConfigSupport.apply((SingleConfigCode)new SingleConfigCode<HttpService>(){

            public Object run(HttpService param) throws PropertyVetoException {
                param.setConnectionPool(null);
                return null;
            }
        }, (ConfigBeanProxy)httpService);
    }

    private void migrateHttpFileCache(NetworkConfig config, HttpService httpService) throws TransactionFailure {
        final HttpFileCache httpFileCache = httpService.getHttpFileCache();
        if (httpFileCache == null) {
            return;
        }
        ConfigSupport.apply((SingleConfigCode)new SingleConfigCode<NetworkConfig>(){

            public Object run(NetworkConfig param) throws TransactionFailure {
                for (Protocol protocol : param.getProtocols().getProtocol()) {
                    Http http = protocol.getHttp();
                    if (http == null) continue;
                    ConfigSupport.apply((SingleConfigCode)new SingleConfigCode<Http>(){

                        public Object run(Http http) throws TransactionFailure {
                            FileCache cache = (FileCache)http.createChild(FileCache.class);
                            http.setFileCache(cache);
                            cache.setEnabled(httpFileCache.getFileCachingEnabled());
                            cache.setMaxAgeSeconds(httpFileCache.getMaxAgeInSeconds());
                            cache.setMaxCacheSizeBytes(httpFileCache.getMediumFileSpaceInBytes());
                            cache.setMaxFilesCount(httpFileCache.getMaxFilesCount());
                            return null;
                        }
                    }, (ConfigBeanProxy)http);
                }
                return null;
            }
        }, (ConfigBeanProxy)config);
        ConfigSupport.apply((SingleConfigCode)new SingleConfigCode<HttpService>(){

            public Object run(HttpService param) throws PropertyVetoException {
                param.setHttpFileCache(null);
                return null;
            }
        }, (ConfigBeanProxy)httpService);
    }

    private void migrateHttpListeners(NetworkConfig config) throws TransactionFailure {
        for (final HttpListener listener : this.currentConfig.getHttpService().getHttpListener()) {
            Protocol protocol = this.migrateToProtocols(config, listener);
            final NetworkListener networkListener = this.createNetworkListener(this.currentConfig, listener, protocol);
            if ("ws/tcp".equals(listener.getPropertyValue("proxiedProtocols"))) {
                this.createPortUnification(networkListener);
                ConfigSupport.apply((SingleConfigCode)new SingleConfigCode<NetworkListener>(){

                    public Object run(NetworkListener param) {
                        param.setProtocol("pu-" + networkListener.getName());
                        return null;
                    }
                }, (ConfigBeanProxy)networkListener);
            }
            ConfigSupport.apply((SingleConfigCode)new SingleConfigCode<HttpService>(){

                public Object run(HttpService param) {
                    param.getHttpListener().remove(param.getHttpListenerById(listener.getId()));
                    return null;
                }
            }, (ConfigBeanProxy)this.currentConfig.getHttpService());
        }
    }

    private void migrateHttpProtocol(NetworkConfig config, final HttpService httpService) throws TransactionFailure {
        final HttpProtocol httpProtocol = httpService.getHttpProtocol();
        if (httpProtocol == null) {
            return;
        }
        ConfigSupport.apply((SingleConfigCode)new SingleConfigCode<NetworkConfig>(){

            public Object run(NetworkConfig networkConfig) throws TransactionFailure {
                Protocols protocols = networkConfig.getProtocols();
                if (protocols.getProtocol().isEmpty()) {
                    GrizzlyConfigSchemaMigrator.this.createNewProtocols(httpService, protocols);
                }
                for (Protocol protocol : protocols.getProtocol()) {
                    Http http = protocol.getHttp();
                    if (http == null) continue;
                    ConfigSupport.apply((SingleConfigCode)new SingleConfigCode<Http>(){

                        public Object run(Http http) {
                            http.setVersion(httpProtocol.getVersion());
                            http.setDnsLookupEnabled(httpProtocol.getDnsLookupEnabled());
                            http.setForcedResponseType(null);
                            http.setDefaultResponseType(null);
                            return null;
                        }
                    }, (ConfigBeanProxy)http);
                }
                return null;
            }
        }, (ConfigBeanProxy)config);
        ConfigSupport.apply((SingleConfigCode)new SingleConfigCode<HttpService>(){

            public Object run(HttpService param) throws PropertyVetoException {
                param.setHttpProtocol(null);
                return null;
            }
        }, (ConfigBeanProxy)httpService);
    }

    private void migrateKeepAlive(NetworkConfig config, HttpService httpService) throws TransactionFailure {
        final KeepAlive keepAlive = httpService.getKeepAlive();
        if (keepAlive == null) {
            return;
        }
        for (Protocol protocol : config.getProtocols().getProtocol()) {
            Http http = protocol.getHttp();
            if (http == null) continue;
            ConfigSupport.apply((SingleConfigCode)new SingleConfigCode<Http>(){

                public Object run(Http param) {
                    param.setMaxConnections(keepAlive.getMaxConnections());
                    param.setTimeoutSeconds(keepAlive.getTimeoutInSeconds());
                    return null;
                }
            }, (ConfigBeanProxy)http);
        }
        ConfigSupport.apply((SingleConfigCode)new SingleConfigCode<HttpService>(){

            public Object run(HttpService param) throws PropertyVetoException {
                param.setKeepAlive(null);
                return null;
            }
        }, (ConfigBeanProxy)httpService);
    }

    private void migrateRequestProcessing(NetworkConfig config, HttpService httpService) throws TransactionFailure {
        final RequestProcessing request = httpService.getRequestProcessing();
        if (request == null) {
            return;
        }
        ConfigSupport.apply((SingleConfigCode)new SingleConfigCode<ThreadPool>(){

            public Object run(ThreadPool pool) throws PropertyVetoException {
                pool.setMaxThreadPoolSize(request.getThreadCount());
                pool.setMinThreadPoolSize(request.getInitialThreadCount());
                if (pool.getMinThreadPoolSize() == null || Integer.parseInt(pool.getMinThreadPoolSize()) < 2) {
                    pool.setMinThreadPoolSize("2");
                }
                return null;
            }
        }, (ConfigBeanProxy)((ConfigBeanProxy)this.habitat.getComponent(ThreadPool.class, HTTP_THREAD_POOL)));
        for (NetworkListener listener : config.getNetworkListeners().getNetworkListener()) {
            ConfigSupport.apply((SingleConfigCode)new SingleConfigCode<NetworkListener>(){

                public Object run(NetworkListener param) {
                    param.setThreadPool(GrizzlyConfigSchemaMigrator.HTTP_THREAD_POOL);
                    return null;
                }
            }, (ConfigBeanProxy)listener);
        }
        for (Protocol protocol : config.getProtocols().getProtocol()) {
            Http http = protocol.getHttp();
            if (http == null) continue;
            ConfigSupport.apply((SingleConfigCode)new SingleConfigCode<Http>(){

                public Object run(Http param) {
                    param.setHeaderBufferLengthBytes(request.getHeaderBufferLengthInBytes());
                    return null;
                }
            }, (ConfigBeanProxy)http);
        }
        ConfigSupport.apply((SingleConfigCode)new SingleConfigCode<HttpService>(){

            public Object run(HttpService param) throws PropertyVetoException {
                param.setRequestProcessing(null);
                return null;
            }
        }, (ConfigBeanProxy)httpService);
    }

    private void migrateSettings() throws TransactionFailure {
        HttpService service = this.currentConfig.getHttpService();
        NetworkConfig networkConfig = this.getNetworkConfig();
        this.migrateHttpListeners(networkConfig);
        this.migrateHttpProtocol(networkConfig, service);
        this.migrateHttpFileCache(networkConfig, service);
        this.migrateRequestProcessing(networkConfig, service);
        this.migrateKeepAlive(networkConfig, service);
        this.migrateConnectionPool(networkConfig, service);
    }

    private void migrateThreadPools(ThreadPools threadPools) throws TransactionFailure {
        Config config = (Config)threadPools.getParent(Config.class);
        NetworkListeners networkListeners = config.getNetworkConfig().getNetworkListeners();
        threadPools.getThreadPool().addAll(networkListeners.getThreadPool());
        ConfigSupport.apply((SingleConfigCode)new SingleConfigCode<NetworkListeners>(){

            public Object run(NetworkListeners param) {
                param.getThreadPool().clear();
                return null;
            }
        }, (ConfigBeanProxy)networkListeners);
    }

    private Protocol migrateToProtocols(NetworkConfig config, final HttpListener listener) throws TransactionFailure {
        Protocols protocols = GrizzlyConfigSchemaMigrator.getProtocols(config);
        return (Protocol)ConfigSupport.apply((SingleConfigCode)new SingleConfigCode<Protocols>(){

            public Object run(Protocols param) throws TransactionFailure {
                Protocol protocol = (Protocol)param.createChild(Protocol.class);
                Ssl ssl = listener.getSsl();
                if (ssl != null && ssl.getClassname() == null) {
                    ConfigSupport.apply((SingleConfigCode)new SingleConfigCode<Ssl>(){

                        public Object run(Ssl param) {
                            param.setClassname("com.sun.enterprise.security.ssl.GlassfishSSLImpl");
                            return null;
                        }
                    }, (ConfigBeanProxy)ssl);
                }
                param.getProtocol().add(protocol);
                protocol.setName(listener.getId());
                protocol.setSsl(ssl);
                protocol.setSecurityEnabled(listener.getSecurityEnabled());
                GrizzlyConfigSchemaMigrator.this.createHttp(protocol, listener);
                return protocol;
            }
        }, (ConfigBeanProxy)protocols);
    }

    private void normalizeThreadPools() throws TransactionFailure {
        NetworkListeners networkListeners;
        ThreadPools threadPools = this.currentConfig.getThreadPools();
        if (threadPools == null) {
            threadPools = this.createThreadPools();
        } else {
            List<ThreadPool> list = threadPools.getThreadPool();
            boolean httpListenerFound = false;
            for (ThreadPool pool : list) {
                httpListenerFound |= HTTP_THREAD_POOL.equals(pool.getThreadPoolId()) || HTTP_THREAD_POOL.equals(pool.getName());
                if (pool.getName() != null) continue;
                ConfigSupport.apply((SingleConfigCode)new SingleConfigCode<ThreadPool>(){

                    public Object run(ThreadPool param) {
                        param.setName(param.getThreadPoolId());
                        param.setThreadPoolId(null);
                        if (param.getMinThreadPoolSize() == null || Integer.parseInt(param.getMinThreadPoolSize()) < 2) {
                            param.setMinThreadPoolSize("2");
                        }
                        return null;
                    }
                }, (ConfigBeanProxy)pool);
            }
            if (!httpListenerFound) {
                ConfigSupport.apply((SingleConfigCode)new SingleConfigCode<ThreadPools>(){

                    public Object run(ThreadPools param) throws TransactionFailure {
                        ThreadPool pool = (ThreadPool)param.createChild(ThreadPool.class);
                        pool.setName(GrizzlyConfigSchemaMigrator.HTTP_THREAD_POOL);
                        param.getThreadPool().add(pool);
                        return null;
                    }
                }, (ConfigBeanProxy)threadPools);
            }
        }
        NetworkConfig networkConfig = this.currentConfig.getNetworkConfig();
        if (networkConfig != null && (networkListeners = networkConfig.getNetworkListeners()) != null && networkListeners.getThreadPool() != null && !networkListeners.getThreadPool().isEmpty()) {
            ConfigSupport.apply((SingleConfigCode)new SingleConfigCode<ThreadPools>(){

                public Object run(ThreadPools param) throws TransactionFailure {
                    GrizzlyConfigSchemaMigrator.this.migrateThreadPools(param);
                    return null;
                }
            }, (ConfigBeanProxy)threadPools);
        }
    }

    private void processHttpListeners() throws TransactionFailure {
        if (!this.currentConfig.getHttpService().getHttpListener().isEmpty()) {
            this.migrateSettings();
        }
    }

    private void promoteHttpServiceProperties(HttpService service) throws TransactionFailure {
        ConfigSupport.apply((SingleConfigCode)new SingleConfigCode<HttpService>(){

            public Object run(HttpService param) {
                ArrayList<Property> propertyList = new ArrayList<Property>(param.getProperty());
                Iterator it = propertyList.iterator();
                while (it.hasNext()) {
                    Property property = (Property)it.next();
                    if ("accessLoggingEnabled".equals(property.getName())) {
                        param.setAccessLoggingEnabled(property.getValue());
                        it.remove();
                        continue;
                    }
                    if ("accessLogBufferSize".equals(property.getName())) {
                        param.getAccessLog().setBufferSizeBytes(property.getValue());
                        it.remove();
                        continue;
                    }
                    if ("accessLogWriterInterval".equals(property.getName())) {
                        param.getAccessLog().setWriteIntervalSeconds(property.getValue());
                        it.remove();
                        continue;
                    }
                    if (!"sso-enabled".equals(property.getName())) continue;
                    param.setSsoEnabled(property.getValue());
                    it.remove();
                }
                param.getProperty().clear();
                param.getProperty().addAll(propertyList);
                return null;
            }
        }, (ConfigBeanProxy)service);
    }

    private void promoteSystemProperties() throws TransactionFailure {
        ConfigSupport.apply((SingleConfigCode)new SingleConfigCode<JavaConfig>(){

            public Object run(JavaConfig param) throws PropertyVetoException, TransactionFailure {
                ArrayList props = new ArrayList(param.getJvmOptions());
                Iterator iterator = props.iterator();
                while (iterator.hasNext()) {
                    String prop = (String)iterator.next();
                    if (!prop.startsWith("-D")) continue;
                    String[] parts = prop.split("=");
                    String name = parts[0].substring(2);
                    if (GrizzlyConfigSchemaMigrator.SSL_CONFIGURATION_WANTAUTH.equals(name) || GrizzlyConfigSchemaMigrator.SSL_CONFIGURATION_SSLIMPL.equals(name)) {
                        iterator.remove();
                        GrizzlyConfigSchemaMigrator.this.updateSsl(name, parts[1]);
                    }
                    if (!"com.sun.grizzly.maxTransactionTimeout".equals(name)) continue;
                    iterator.remove();
                    GrizzlyConfigSchemaMigrator.this.updateHttp(parts[1]);
                }
                param.setJvmOptions(props);
                return param;
            }
        }, (ConfigBeanProxy)((ConfigBeanProxy)this.habitat.getByType(JavaConfig.class)));
    }

    private void promoteVirtualServerProperties(HttpService service) throws TransactionFailure {
        for (VirtualServer virtualServer : service.getVirtualServer()) {
            ConfigSupport.apply((SingleConfigCode)new SingleConfigCode<VirtualServer>(){

                public Object run(VirtualServer param) throws PropertyVetoException {
                    if (param.getHttpListeners() != null && !"".equals(param.getHttpListeners())) {
                        param.setNetworkListeners(param.getHttpListeners());
                    }
                    param.setHttpListeners(null);
                    ArrayList<Property> propertyList = new ArrayList<Property>(param.getProperty());
                    Iterator it = propertyList.iterator();
                    while (it.hasNext()) {
                        Property property = (Property)it.next();
                        if ("docroot".equals(property.getName())) {
                            param.setDocroot(property.getValue());
                            it.remove();
                            continue;
                        }
                        if ("accesslog".equals(property.getName())) {
                            param.setAccessLog(property.getValue());
                            it.remove();
                            continue;
                        }
                        if (!"sso-enabled".equals(property.getName())) continue;
                        param.setSsoEnabled(property.getValue());
                        it.remove();
                    }
                    param.getProperty().clear();
                    param.getProperty().addAll(propertyList);
                    return null;
                }
            }, (ConfigBeanProxy)virtualServer);
        }
    }

    private void updateHttp(NetworkConfig config, final ConnectionPool pool) throws TransactionFailure {
        for (Protocol protocol : config.getProtocols().getProtocol()) {
            Http http = protocol.getHttp();
            if (http == null) continue;
            ConfigSupport.apply((SingleConfigCode)new SingleConfigCode<Http>(){

                public Object run(Http param) {
                    param.setSendBufferSizeBytes(pool.getSendBufferSizeInBytes());
                    return null;
                }
            }, (ConfigBeanProxy)http);
        }
    }

    private void updateHttp(final String maxTransactionTimeout) throws TransactionFailure {
        for (Protocol protocol : this.currentConfig.getNetworkConfig().getProtocols().getProtocol()) {
            Http http = protocol.getHttp();
            if (http == null) continue;
            ConfigSupport.apply((SingleConfigCode)new SingleConfigCode<Http>(){

                public Object run(Http param) {
                    if (param != null) {
                        param.setRequestTimeoutSeconds(maxTransactionTimeout);
                    }
                    return null;
                }
            }, (ConfigBeanProxy)http);
        }
    }

    private void updateListener(NetworkListener netListener, HttpListener listener, Protocol protocol) {
        netListener.setEnabled(listener.getEnabled());
        netListener.setAddress(listener.getAddress());
        netListener.setPort(listener.getPort());
        netListener.setProtocol(protocol.getName());
        netListener.setTransport("tcp");
    }

    private void updateSsl(final String propName, final String value) throws TransactionFailure {
        Collection protocols = this.habitat.getAllByContract(Protocol.class);
        for (Protocol protocol : protocols) {
            Ssl ssl = protocol.getSsl();
            if (ssl == null) continue;
            ConfigSupport.apply((SingleConfigCode)new SingleConfigCode<Ssl>(){

                public Object run(Ssl param) {
                    if (GrizzlyConfigSchemaMigrator.SSL_CONFIGURATION_WANTAUTH.equals(propName)) {
                        param.setClientAuth(value);
                    } else if (GrizzlyConfigSchemaMigrator.SSL_CONFIGURATION_SSLIMPL.equals(propName)) {
                        param.setClassname(value);
                    }
                    return param;
                }
            }, (ConfigBeanProxy)ssl);
        }
    }

    private void updateThreadPool(NetworkConfig config, final ConnectionPool pool) throws TransactionFailure {
        Config parent = (Config)config.getParent(Config.class);
        for (ThreadPool threadPool : parent.getThreadPools().getThreadPool()) {
            ConfigSupport.apply((SingleConfigCode)new SingleConfigCode<ThreadPool>(){

                public Object run(ThreadPool param) {
                    param.setMaxQueueSize(pool.getQueueSizeInBytes());
                    if (param.getMinThreadPoolSize() == null || Integer.parseInt(param.getMinThreadPoolSize()) < 2) {
                        param.setMinThreadPoolSize("2");
                    }
                    return null;
                }
            }, (ConfigBeanProxy)threadPool);
        }
    }
}

