/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ejb.containers.util;

import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public final class MethodMap
extends HashMap {
    private static final int DEFAULT_BUCKET_MULTIPLIER = 20;
    private int numBuckets_;
    private MethodInfo[] methodInfo_;

    public MethodMap(Map methodMap) {
        super(methodMap);
        this.numBuckets_ = methodMap.size() * 20;
        this.buildLookupTable(methodMap);
    }

    public MethodMap(Map methodMap, int numBuckets) {
        super(methodMap);
        if (numBuckets <= 0) {
            throw new IllegalArgumentException("Invalid value of numBuckets = " + numBuckets);
        }
        this.numBuckets_ = numBuckets;
        this.buildLookupTable(methodMap);
    }

    public Object put(Object key, Object value) {
        throw new UnsupportedOperationException();
    }

    public void putAll(Map t) {
        throw new UnsupportedOperationException();
    }

    public Object remove(Object key) {
        throw new UnsupportedOperationException();
    }

    public Object get(Object key) {
        if (key instanceof Method) {
            Method m = (Method)key;
            Class<?>[] paramTypes = m.getParameterTypes();
            return this.get(m, paramTypes.length);
        }
        return null;
    }

    public Object get(Method m, int numParams) {
        if (this.methodInfo_ == null) {
            return null;
        }
        if (numParams < 0) {
            throw new IllegalStateException("invalid numParams = " + numParams);
        }
        Object value = null;
        MethodInfo methodInfo = this.methodInfo_[this.getBucket(m, numParams)];
        if (methodInfo != null && methodInfo.declaringClass == m.getDeclaringClass()) {
            value = methodInfo.value;
        }
        return value != null ? value : (Object)super.get(m);
    }

    public void clear() {
        if (this.methodInfo_ != null) {
            this.methodInfo_ = null;
            super.clear();
        }
    }

    private void buildLookupTable(Map methodMap) {
        this.methodInfo_ = new MethodInfo[this.numBuckets_];
        Set methods = methodMap.keySet();
        HashSet<Integer> occupied = new HashSet<Integer>();
        for (Object nextObj : methods) {
            Method next = null;
            if (nextObj == null) {
                throw new IllegalStateException("null keys not supported");
            }
            if (!(nextObj instanceof Method)) {
                throw new IllegalStateException("invalid key type = " + nextObj.getClass() + " key must be of type java.lang.reflect.Method");
            }
            next = (Method)nextObj;
            int bucket = this.getBucket(next);
            if (!occupied.contains(bucket)) {
                MethodInfo methodInfo = new MethodInfo();
                methodInfo.key = next;
                methodInfo.value = methodMap.get(next);
                methodInfo.declaringClass = next.getDeclaringClass();
                this.methodInfo_[bucket] = methodInfo;
                occupied.add(bucket);
                continue;
            }
            this.methodInfo_[bucket] = null;
        }
    }

    private final int getBucket(Method m) {
        Class<?>[] paramTypes = m.getParameterTypes();
        return this.getBucket(m, paramTypes.length);
    }

    private final int getBucket(Method m, int numParams) {
        String methodName = m.getName();
        int hashCode = methodName.hashCode();
        hashCode = hashCode >= 0 ? hashCode : hashCode * -1;
        hashCode = hashCode > numParams ? hashCode - numParams : hashCode + numParams;
        return hashCode % this.numBuckets_;
    }

    private class MethodInfo {
        public Class declaringClass;
        public Method key;
        public Object value;

        private MethodInfo() {
        }
    }
}

