/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.common.project.ui;

import java.io.File;
import java.util.prefs.Preferences;
import org.openide.filesystems.FileUtil;
import org.openide.util.NbBundle;
import org.openide.util.NbPreferences;

public final class UserProjectSettings {
    private static final UserProjectSettings INSTANCE = new UserProjectSettings();
    private static final String NEW_PROJECT_COUNT = "newProjectCount";
    private static final String NEW_APP_COUNT = "newApplicationCount";
    private static final String LAST_USED_CP_FOLDER = "lastUsedClassPathFolder";
    private static final String LAST_USED_ARTIFACT_FOLDER = "lastUsedArtifactFolder";
    private static final String SHOW_AGAIN_BROKEN_REF_ALERT = "showAgainBrokenRefAlert";
    private static final String SHOW_AGAIN_BROKEN_SERVER_ALERT = "showAgainBrokenServerAlert";
    public static final String LAST_USED_CHOOSER_LOCATIONS = "lastUsedChooserLocations";
    private static final String AGREED_SET_JDK_14 = "agreeSetJdk14";
    private static final String AGREED_SET_SOURCE_LEVEL_14 = "agreeSetSourceLevel14";
    private static final String AGREED_SET_JDK_15 = "agreeSetJdk15";
    private static final String AGREED_SET_SOURCE_LEVEL_15 = "agreeSetSourceLevel15";
    private static final String LAST_USED_SERVER = "lastUsedServer";
    private static final String LAST_USED_IMPORT_LOCATION = "lastUsedImportLocation";

    public static UserProjectSettings getDefault() {
        return INSTANCE;
    }

    public static Preferences getPreferences() {
        return NbPreferences.forModule(UserProjectSettings.class);
    }

    public String displayName() {
        return NbBundle.getMessage(UserProjectSettings.class, (String)"TXT_ProjectFolderList");
    }

    public int getNewProjectCount() {
        return UserProjectSettings.getPreferences().getInt(NEW_PROJECT_COUNT, 0);
    }

    public void setNewProjectCount(int count) {
        UserProjectSettings.getPreferences().putInt(NEW_PROJECT_COUNT, count);
    }

    public int getNewApplicationCount() {
        return UserProjectSettings.getPreferences().getInt(NEW_APP_COUNT, 0);
    }

    public void setNewApplicationCount(int count) {
        UserProjectSettings.getPreferences().putInt(NEW_APP_COUNT, count);
    }

    public File getLastUsedClassPathFolder() {
        return new File(UserProjectSettings.getPreferences().get(LAST_USED_CP_FOLDER, System.getProperty("user.home")));
    }

    public void setLastUsedClassPathFolder(File folder) {
        assert (folder != null) : "ClassPath root can not be null";
        String path = folder.getAbsolutePath();
        UserProjectSettings.getPreferences().put(LAST_USED_CP_FOLDER, path);
    }

    public File getLastUsedArtifactFolder(File defaultValue) {
        String val = UserProjectSettings.getPreferences().get(LAST_USED_ARTIFACT_FOLDER, null);
        if (val != null) {
            return FileUtil.normalizeFile((File)new File(val));
        }
        if (defaultValue != null) {
            return defaultValue;
        }
        return FileUtil.normalizeFile((File)new File(System.getProperty("user.home")));
    }

    public void setLastUsedArtifactFolder(File folder) {
        assert (folder != null) : "Folder can not be null";
        String path = folder.getAbsolutePath();
        UserProjectSettings.getPreferences().put(LAST_USED_ARTIFACT_FOLDER, path);
    }

    public boolean isShowAgainBrokenRefAlert() {
        return UserProjectSettings.getPreferences().getBoolean(SHOW_AGAIN_BROKEN_REF_ALERT, true);
    }

    public void setShowAgainBrokenRefAlert(boolean again) {
        UserProjectSettings.getPreferences().putBoolean(SHOW_AGAIN_BROKEN_REF_ALERT, again);
    }

    public boolean isShowAgainBrokenServerAlert() {
        return UserProjectSettings.getPreferences().getBoolean(SHOW_AGAIN_BROKEN_SERVER_ALERT, true);
    }

    public void setShowAgainBrokenServerAlert(boolean again) {
        UserProjectSettings.getPreferences().putBoolean(SHOW_AGAIN_BROKEN_SERVER_ALERT, again);
    }

    public boolean isAgreedSetJdk14() {
        return UserProjectSettings.getPreferences().getBoolean(AGREED_SET_JDK_14, true);
    }

    public void setAgreedSetJdk14(boolean agreed) {
        UserProjectSettings.getPreferences().putBoolean(AGREED_SET_JDK_14, agreed);
    }

    public boolean isAgreedSetSourceLevel14() {
        return UserProjectSettings.getPreferences().getBoolean(AGREED_SET_SOURCE_LEVEL_14, true);
    }

    public void setAgreedSetSourceLevel14(boolean agreed) {
        UserProjectSettings.getPreferences().putBoolean(AGREED_SET_SOURCE_LEVEL_14, agreed);
    }

    public boolean isAgreedSetJdk15() {
        return UserProjectSettings.getPreferences().getBoolean(AGREED_SET_JDK_15, true);
    }

    public void setAgreedSetJdk15(boolean agreed) {
        UserProjectSettings.getPreferences().putBoolean(AGREED_SET_JDK_15, agreed);
    }

    public boolean isAgreedSetSourceLevel15() {
        return UserProjectSettings.getPreferences().getBoolean(AGREED_SET_SOURCE_LEVEL_15, true);
    }

    public void setAgreedSetSourceLevel15(boolean agreed) {
        UserProjectSettings.getPreferences().putBoolean(AGREED_SET_SOURCE_LEVEL_15, agreed);
    }

    public void setLastUsedServer(String serverID) {
        UserProjectSettings.getPreferences().put(LAST_USED_SERVER, serverID);
    }

    public String getLastUsedServer() {
        return UserProjectSettings.getPreferences().get(LAST_USED_SERVER, null);
    }

    public void setLastUsedImportLocation(File importLocation) {
        String path = importLocation.getAbsolutePath();
        UserProjectSettings.getPreferences().put(LAST_USED_IMPORT_LOCATION, path);
    }

    public File getLastUsedImportLocation() {
        String path = UserProjectSettings.getPreferences().get(LAST_USED_IMPORT_LOCATION, null);
        if (path == null) {
            return null;
        }
        return new File(path);
    }
}

