/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.common.project.ui;

import java.util.ArrayList;
import java.util.TreeSet;
import javax.swing.AbstractListModel;
import javax.swing.ComboBoxModel;
import org.netbeans.api.j2ee.core.Profile;
import org.netbeans.modules.j2ee.deployment.devmodules.api.Deployment;
import org.netbeans.modules.j2ee.deployment.devmodules.api.J2eeModule;
import org.netbeans.modules.j2ee.deployment.devmodules.api.J2eePlatform;

public class J2eePlatformUiSupport {
    private J2eePlatformUiSupport() {
    }

    @Deprecated
    public static ComboBoxModel createPlatformComboBoxModel(String serverInstanceId, String j2eeLevel, Object moduleType) {
        return new J2eePlatformComboBoxModel(serverInstanceId, Profile.fromPropertiesString((String)j2eeLevel), J2eeModule.Type.fromJsrType((Object)moduleType));
    }

    public static ComboBoxModel createPlatformComboBoxModel(String serverInstanceId, Profile j2eeProfile, J2eeModule.Type moduleType) {
        return new J2eePlatformComboBoxModel(serverInstanceId, j2eeProfile, moduleType);
    }

    @Deprecated
    public static ComboBoxModel createSpecVersionComboBoxModel(String j2eeSpecVersion) {
        return new J2eeSpecVersionComboBoxModel(Profile.fromPropertiesString((String)j2eeSpecVersion));
    }

    public static ComboBoxModel createSpecVersionComboBoxModel(Profile profile) {
        return new J2eeSpecVersionComboBoxModel(profile);
    }

    @Deprecated
    public static boolean getJ2eePlatformAndSpecVersionMatch(Object j2eePlatformModelObject, Object j2eeSpecVersionModelObject, Object moduleType) {
        return J2eePlatformUiSupport.getJ2eePlatformAndSpecVersionMatch(j2eePlatformModelObject, j2eeSpecVersionModelObject, J2eeModule.Type.fromJsrType((Object)moduleType));
    }

    public static boolean getJ2eePlatformAndSpecVersionMatch(Object j2eePlatformModelObject, Object j2eeSpecVersionModelObject, J2eeModule.Type moduleType) {
        if (!(j2eePlatformModelObject instanceof J2eePlatformAdapter) || !(j2eeSpecVersionModelObject instanceof String) && !(j2eeSpecVersionModelObject instanceof Profile)) {
            return false;
        }
        J2eePlatform j2eePlatform = ((J2eePlatformAdapter)j2eePlatformModelObject).getJ2eePlatform();
        Profile profile = null;
        profile = j2eeSpecVersionModelObject instanceof Profile ? (Profile)j2eeSpecVersionModelObject : Profile.fromPropertiesString((String)((String)j2eeSpecVersionModelObject));
        return j2eePlatform.getSupportedProfiles(moduleType).contains(profile);
    }

    @Deprecated
    public static String getSpecVersion(Object j2eeSpecVersionModelObject) {
        return ((J2eePlatformComboBoxItem)j2eeSpecVersionModelObject).getProfile().toPropertiesString();
    }

    public static Profile getJavaEEProfile(Object j2eeSpecVersionModelObject) {
        return ((J2eePlatformComboBoxItem)j2eeSpecVersionModelObject).getProfile();
    }

    public static String getServerInstanceID(Object j2eePlatformModelObject) {
        if (j2eePlatformModelObject == null) {
            return null;
        }
        J2eePlatform j2eePlatform = ((J2eePlatformAdapter)j2eePlatformModelObject).getJ2eePlatform();
        String[] serverInstanceIDs = Deployment.getDefault().getServerInstanceIDs();
        for (int i = 0; i < serverInstanceIDs.length; ++i) {
            J2eePlatform platform = Deployment.getDefault().getJ2eePlatform(serverInstanceIDs[i]);
            if (platform == null || !platform.equals((Object)j2eePlatform)) continue;
            return serverInstanceIDs[i];
        }
        return null;
    }

    public static void setSelectedPlatform(ComboBoxModel model, String serverInstanceID) {
        if (!(model instanceof J2eePlatformComboBoxModel)) {
            return;
        }
        ((J2eePlatformComboBoxModel)model).setSelectedItem(serverInstanceID);
    }

    private static final class J2eePlatformAdapter
    implements Comparable {
        private J2eePlatform platform;
        private String serverInstanceID;

        public J2eePlatformAdapter(J2eePlatform platform, String serverInstanceID) {
            this.platform = platform;
            this.serverInstanceID = serverInstanceID;
        }

        public J2eePlatform getJ2eePlatform() {
            return this.platform;
        }

        public String getServerInstanceID() {
            return this.serverInstanceID;
        }

        public String toString() {
            String s = this.platform.getDisplayName();
            if (s == null) {
                s = "";
            }
            return s;
        }

        public int compareTo(Object o) {
            J2eePlatformAdapter oa = (J2eePlatformAdapter)o;
            return this.toString().compareTo(oa.toString());
        }
    }

    private static final class J2eePlatformComboBoxItem {
        private final Profile profile;

        public J2eePlatformComboBoxItem(Profile profile) {
            this.profile = profile;
        }

        public Profile getProfile() {
            return this.profile;
        }

        public String toString() {
            return this.profile.getDisplayName();
        }
    }

    private static final class J2eePlatformComboBoxModel
    extends AbstractListModel
    implements ComboBoxModel {
        private J2eePlatformAdapter[] j2eePlatforms;
        private final String initialJ2eePlatform;
        private J2eePlatformAdapter selectedJ2eePlatform;
        private final Profile j2eeProfile;
        private final J2eeModule.Type moduleType;

        public J2eePlatformComboBoxModel(String serverInstanceID, Profile j2eeProfile, J2eeModule.Type moduleType) {
            this.initialJ2eePlatform = serverInstanceID;
            this.j2eeProfile = j2eeProfile;
            this.moduleType = moduleType;
            this.getJ2eePlatforms(moduleType);
        }

        @Override
        public Object getElementAt(int index) {
            return this.getJ2eePlatforms(this.moduleType)[index];
        }

        @Override
        public int getSize() {
            return this.getJ2eePlatforms(this.moduleType).length;
        }

        @Override
        public Object getSelectedItem() {
            return this.selectedJ2eePlatform;
        }

        @Override
        public void setSelectedItem(Object obj) {
            this.selectedJ2eePlatform = (J2eePlatformAdapter)obj;
        }

        public void setSelectedItem(String serverInstanceID) {
            for (int i = 0; i < this.j2eePlatforms.length; ++i) {
                if (!this.j2eePlatforms[i].getServerInstanceID().equals(serverInstanceID)) continue;
                this.selectedJ2eePlatform = this.j2eePlatforms[i];
                return;
            }
        }

        private synchronized J2eePlatformAdapter[] getJ2eePlatforms(J2eeModule.Type moduleType) {
            if (this.j2eePlatforms == null) {
                String[] serverInstanceIDs = Deployment.getDefault().getServerInstanceIDs();
                TreeSet<J2eePlatformAdapter> orderedNames = new TreeSet<J2eePlatformAdapter>();
                boolean activeFound = false;
                for (int i = 0; i < serverInstanceIDs.length; ++i) {
                    J2eePlatform j2eePlatform = Deployment.getDefault().getJ2eePlatform(serverInstanceIDs[i]);
                    if (j2eePlatform == null || !j2eePlatform.getSupportedTypes().contains(moduleType) || !j2eePlatform.getSupportedProfiles(moduleType).contains(this.j2eeProfile)) continue;
                    J2eePlatformAdapter adapter = new J2eePlatformAdapter(j2eePlatform, serverInstanceIDs[i]);
                    orderedNames.add(adapter);
                    if (this.selectedJ2eePlatform != null || activeFound || this.initialJ2eePlatform == null || !serverInstanceIDs[i].equals(this.initialJ2eePlatform)) continue;
                    this.selectedJ2eePlatform = adapter;
                    activeFound = true;
                }
                this.j2eePlatforms = orderedNames.toArray(new J2eePlatformAdapter[orderedNames.size()]);
            }
            return this.j2eePlatforms;
        }
    }

    private static final class J2eeSpecVersionComboBoxModel
    extends AbstractListModel
    implements ComboBoxModel {
        private static final long serialVersionUID = 20366133932230984L;
        private J2eePlatformComboBoxItem[] j2eeSpecVersions;
        private J2eePlatformComboBoxItem initialJ2eeSpecVersion;
        private J2eePlatformComboBoxItem selectedJ2eeSpecVersion;

        public J2eeSpecVersionComboBoxModel(Profile j2eeProfile) {
            this.initialJ2eeSpecVersion = j2eeProfile != null ? new J2eePlatformComboBoxItem(j2eeProfile) : null;
            ArrayList<J2eePlatformComboBoxItem> orderedListItems = new ArrayList<J2eePlatformComboBoxItem>();
            orderedListItems.add(new J2eePlatformComboBoxItem(Profile.JAVA_EE_5));
            orderedListItems.add(new J2eePlatformComboBoxItem(Profile.J2EE_14));
            if (Profile.JAVA_EE_5 != j2eeProfile && Profile.J2EE_14 != j2eeProfile) {
                orderedListItems.add(0, new J2eePlatformComboBoxItem(Profile.J2EE_13));
            }
            this.j2eeSpecVersions = orderedListItems.toArray(new J2eePlatformComboBoxItem[orderedListItems.size()]);
            this.selectedJ2eeSpecVersion = this.initialJ2eeSpecVersion;
        }

        @Override
        public Object getElementAt(int index) {
            return this.j2eeSpecVersions[index];
        }

        @Override
        public int getSize() {
            return this.j2eeSpecVersions.length;
        }

        @Override
        public Object getSelectedItem() {
            return this.selectedJ2eeSpecVersion;
        }

        @Override
        public void setSelectedItem(Object obj) {
            this.selectedJ2eeSpecVersion = (J2eePlatformComboBoxItem)obj;
        }
    }
}

