/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.common.project;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.jar.JarOutputStream;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.ZipEntry;
import org.netbeans.modules.j2ee.common.project.FileChangeSupport;
import org.netbeans.modules.j2ee.common.project.FileChangeSupportEvent;
import org.netbeans.modules.j2ee.common.project.FileChangeSupportListener;
import org.netbeans.modules.j2ee.deployment.devmodules.spi.ArtifactListener;
import org.netbeans.modules.j2ee.deployment.devmodules.spi.J2eeModuleProvider;
import org.netbeans.modules.java.api.common.classpath.ClassPathSupport;
import org.netbeans.spi.project.support.ant.AntProjectEvent;
import org.netbeans.spi.project.support.ant.AntProjectHelper;
import org.netbeans.spi.project.support.ant.AntProjectListener;
import org.netbeans.spi.project.support.ant.PropertyEvaluator;
import org.openide.filesystems.FileLock;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.filesystems.URLMapper;

public abstract class ArtifactCopyOnSaveSupport
implements FileChangeSupportListener,
PropertyChangeListener,
AntProjectListener {
    private static final Logger LOGGER = Logger.getLogger(ArtifactCopyOnSaveSupport.class.getName());
    private final List<ArtifactListener> listeners = new ArrayList<ArtifactListener>();
    private final Map<File, ItemDescription> listeningTo = new HashMap<File, ItemDescription>();
    private final String destDirProperty;
    private final PropertyEvaluator evaluator;
    private final AntProjectHelper antHelper;
    private boolean synchronize;
    private volatile String destDir;

    public ArtifactCopyOnSaveSupport(String destDirProperty, PropertyEvaluator evaluator, AntProjectHelper antHelper) {
        this.destDirProperty = destDirProperty;
        this.evaluator = evaluator;
        this.antHelper = antHelper;
    }

    public synchronized void enableArtifactSynchronization(boolean synchronize) {
        this.synchronize = synchronize;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void addArtifactListener(ArtifactListener listener) {
        if (listener == null) {
            return;
        }
        ArtifactCopyOnSaveSupport artifactCopyOnSaveSupport = this;
        synchronized (artifactCopyOnSaveSupport) {
            boolean init = this.listeners.isEmpty();
            this.listeners.add(listener);
            if (init) {
                this.initialize();
                this.reload();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void removeArtifactListener(ArtifactListener listener) {
        if (listener == null) {
            return;
        }
        ArtifactCopyOnSaveSupport artifactCopyOnSaveSupport = this;
        synchronized (artifactCopyOnSaveSupport) {
            this.listeners.remove(listener);
            if (this.listeners.isEmpty()) {
                this.close();
            }
        }
    }

    public final void initialize() {
        this.close();
        this.destDir = this.evaluator.getProperty(this.destDirProperty);
        this.evaluator.addPropertyChangeListener((PropertyChangeListener)this);
        this.antHelper.addAntProjectListener((AntProjectListener)this);
    }

    protected abstract List<Item> getArtifacts();

    protected ArtifactListener.Artifact filterArtifact(ArtifactListener.Artifact artifact, RelocationType type) {
        return artifact;
    }

    public final synchronized void reload() {
        HashMap<File, ItemDescription> toRemove = new HashMap<File, ItemDescription>(this.listeningTo);
        for (Item item : this.getArtifacts()) {
            ClassPathSupport.Item item2 = item.getItem();
            String path = null;
            ArrayList<File> files = new ArrayList<File>();
            if (!item2.isBroken()) {
                File file;
                if (item2.getType() == 1) {
                    path = item.getDescription().getPathInDeployment();
                    if (path != null) {
                        for (URL url : item2.getLibrary().getContent("classpath")) {
                            File file2;
                            FileObject fo;
                            URL norm = FileUtil.getArchiveFile((URL)url);
                            if (norm == null) {
                                norm = url;
                            }
                            if ((fo = URLMapper.findFileObject((URL)norm)) == null || (file2 = FileUtil.toFile((FileObject)fo)) == null) continue;
                            files.add(file2);
                        }
                    }
                } else if (item2.getType() == 2) {
                    if (item2.getArtifact().getProject().getLookup().lookup(J2eeModuleProvider.class) != null) continue;
                    File scriptLocation = item2.getArtifact().getScriptLocation().getAbsoluteFile();
                    if (!scriptLocation.isDirectory()) {
                        scriptLocation = scriptLocation.getParentFile();
                    }
                    if ((path = item.getDescription().getPathInDeployment()) != null) {
                        for (URI artifactURI : item2.getArtifact().getArtifactLocations()) {
                            File file3 = null;
                            file3 = artifactURI.isAbsolute() ? new File(artifactURI) : new File(scriptLocation, artifactURI.getPath());
                            if ((file3 = FileUtil.normalizeFile((File)file3)) == null) continue;
                            files.add(file3);
                        }
                    }
                } else if (item2.getType() == 0 && (path = item.getDescription().getPathInDeployment()) != null && (file = item2.getResolvedFile()) != null) {
                    files.add(file);
                }
            }
            for (File file : files) {
                if (!this.listeningTo.containsKey(file)) {
                    FileChangeSupport.DEFAULT.addListener(this, file);
                    this.listeningTo.put(file, item.getDescription());
                    if (this.synchronize) {
                        try {
                            this.updateFile(file, item.getDescription().getPathInDeployment(), item.getDescription().getRelocationType());
                        }
                        catch (IOException ex) {
                            LOGGER.log(Level.FINE, "Initial copy failed", ex);
                        }
                    }
                }
                toRemove.remove(file);
            }
        }
        for (Map.Entry entry : toRemove.entrySet()) {
            FileChangeSupport.DEFAULT.removeListener(this, (File)entry.getKey());
            this.listeningTo.remove(entry.getKey());
            if (!this.synchronize) continue;
            this.deleteFile((File)entry.getKey(), ((ItemDescription)entry.getValue()).getPathInDeployment(), ((ItemDescription)entry.getValue()).getRelocationType());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void close() {
        ArtifactCopyOnSaveSupport artifactCopyOnSaveSupport = this;
        synchronized (artifactCopyOnSaveSupport) {
            for (Map.Entry<File, ItemDescription> entry : this.listeningTo.entrySet()) {
                FileChangeSupport.DEFAULT.removeListener(this, entry.getKey());
            }
            this.listeningTo.clear();
        }
        this.antHelper.removeAntProjectListener((AntProjectListener)this);
        this.evaluator.removePropertyChangeListener((PropertyChangeListener)this);
    }

    @Override
    public final void propertyChange(PropertyChangeEvent evt) {
        if ("javac.classpath".equals(evt.getPropertyName())) {
            LOGGER.log(Level.FINEST, "Classpath changed");
            this.reload();
        } else if (this.destDirProperty.equals(evt.getPropertyName())) {
            this.destDir = this.evaluator.getProperty(this.destDirProperty);
        }
    }

    public final void configurationXmlChanged(AntProjectEvent ev) {
        if ("nbproject/project.xml".equals(ev.getPath())) {
            LOGGER.log(Level.FINEST, "Project XML changed");
            this.reload();
        }
    }

    public final void propertiesChanged(AntProjectEvent ev) {
    }

    @Override
    public final void fileCreated(FileChangeSupportEvent event) {
        this.updateFile(event);
    }

    @Override
    public final void fileModified(FileChangeSupportEvent event) {
        this.updateFile(event);
    }

    @Override
    public final void fileDeleted(FileChangeSupportEvent event) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireArtifactChange(File file, RelocationType type) {
        ArrayList<ArtifactListener> toFire = null;
        ArtifactCopyOnSaveSupport artifactCopyOnSaveSupport = this;
        synchronized (artifactCopyOnSaveSupport) {
            toFire = new ArrayList<ArtifactListener>(this.listeners);
        }
        Set<ArtifactListener.Artifact> iterable = Collections.singleton(this.filterArtifact(ArtifactListener.Artifact.forFile((File)file).referencedLibrary(), type));
        for (ArtifactListener listener : toFire) {
            listener.artifactsUpdated(iterable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateFile(FileChangeSupportEvent event) {
        File sourceFile = null;
        ItemDescription desc = null;
        ArtifactCopyOnSaveSupport artifactCopyOnSaveSupport = this;
        synchronized (artifactCopyOnSaveSupport) {
            sourceFile = FileUtil.normalizeFile((File)event.getPath());
            desc = this.listeningTo.get(event.getPath());
            if (desc == null || desc.getPathInDeployment() == null) {
                return;
            }
        }
        try {
            this.updateFile(sourceFile, desc.getPathInDeployment(), desc.getRelocationType());
        }
        catch (IOException ex) {
            LOGGER.log(Level.INFO, null, ex);
        }
    }

    private void updateFile(File sourceFile, String destPath, RelocationType type) throws IOException {
        FileObject webBuildBase;
        assert (sourceFile != null);
        assert (destPath != null);
        FileObject fileObject = webBuildBase = this.destDir == null ? null : this.antHelper.resolveFileObject(this.destDir);
        if (webBuildBase == null) {
            return;
        }
        FileObject sourceObject = FileUtil.toFileObject((File)sourceFile);
        if (sourceObject == null) {
            LOGGER.log(Level.FINE, "Source file does not exist");
            return;
        }
        FileObject destFile = FileUtil.createData((FileObject)webBuildBase, (String)(destPath + "/" + sourceObject.getNameExt()));
        this.copy(sourceObject, destFile);
        File dest = FileUtil.toFile((FileObject)destFile);
        if (dest != null) {
            this.fireArtifactChange(dest, type);
        }
        LOGGER.log(Level.FINE, "Artifact jar successfully copied " + sourceFile.getAbsolutePath() + " " + sourceFile.length());
    }

    private void deleteFile(File sourceFile, String destPath, RelocationType type) {
        File dest;
        FileObject destFile;
        block9: {
            FileObject webBuildBase;
            assert (sourceFile != null);
            assert (destPath != null);
            FileObject fileObject = webBuildBase = this.destDir == null ? null : this.antHelper.resolveFileObject(this.destDir);
            if (webBuildBase == null) {
                return;
            }
            destFile = null;
            try {
                destFile = FileUtil.createData((FileObject)webBuildBase, (String)(destPath + "/" + sourceFile.getName()));
                if (destFile == null) {
                    return;
                }
                destFile.delete();
                LOGGER.log(Level.FINE, "Artifact jar successfully deleted");
            }
            catch (IOException ex) {
                LOGGER.log(Level.INFO, null, ex);
                if (!"jar".equals(destFile.getExt())) break block9;
                try {
                    this.zeroOutArchive(destFile);
                    LOGGER.log(Level.FINE, "Artifact jar successfully zeroed out");
                }
                catch (IOException ioe) {
                    LOGGER.log(Level.INFO, "Could not zero out archive", ioe);
                }
            }
        }
        if (destFile != null && (dest = FileUtil.toFile((FileObject)destFile)) != null) {
            this.fireArtifactChange(dest, type);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void copy(FileObject sourceFile, FileObject destFile) throws IOException {
        InputStream is = null;
        OutputStream os = null;
        FileLock fl = null;
        try {
            is = sourceFile.getInputStream();
            fl = destFile.lock();
            os = destFile.getOutputStream(fl);
            FileUtil.copy((InputStream)is, (OutputStream)os);
        }
        finally {
            if (is != null) {
                is.close();
            }
            if (os != null) {
                os.close();
            }
            if (fl != null) {
                fl.releaseLock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void zeroOutArchive(FileObject garbage) throws IOException {
        OutputStream fileToOverwrite = garbage.getOutputStream();
        try {
            JarOutputStream jos = new JarOutputStream(fileToOverwrite);
            try {
                jos.putNextEntry(new ZipEntry("META-INF/MANIFEST.MF"));
                jos.write("Manifest-Version: 1.0\n".getBytes("UTF-8"));
            }
            finally {
                jos.close();
            }
        }
        finally {
            fileToOverwrite.close();
        }
    }

    public static final class Item {
        private final ClassPathSupport.Item item;
        private final ItemDescription description;

        public Item(ClassPathSupport.Item item, ItemDescription description) {
            this.item = item;
            this.description = description;
        }

        public ClassPathSupport.Item getItem() {
            return this.item;
        }

        public ItemDescription getDescription() {
            return this.description;
        }
    }

    public static final class ItemDescription {
        private final String pathInDeployment;
        private final RelocationType type;

        public ItemDescription(String pathInDeployment, RelocationType type) {
            this.pathInDeployment = pathInDeployment;
            this.type = type;
        }

        public String getPathInDeployment() {
            return this.pathInDeployment;
        }

        public RelocationType getRelocationType() {
            return this.type;
        }
    }

    public static enum RelocationType {
        NONE,
        LIB,
        ROOT;


        public static RelocationType fromString(String type) {
            if (type == null) {
                return ROOT;
            }
            if ("200".equals(type)) {
                return LIB;
            }
            if ("100".equals(type)) {
                return ROOT;
            }
            return NONE;
        }
    }
}

