/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.common;

import java.util.Set;
import org.netbeans.api.annotations.common.CheckForNull;
import org.netbeans.api.annotations.common.NonNull;
import org.netbeans.api.j2ee.core.Profile;
import org.netbeans.api.project.Project;
import org.netbeans.modules.j2ee.api.ejbjar.EjbJar;
import org.netbeans.modules.j2ee.common.Util;
import org.netbeans.modules.j2ee.deployment.devmodules.api.J2eeModule;
import org.netbeans.modules.j2ee.deployment.devmodules.api.J2eePlatform;
import org.netbeans.modules.j2ee.deployment.devmodules.spi.J2eeModuleProvider;
import org.netbeans.modules.javaee.specs.support.api.EjbSupport;
import org.netbeans.modules.javaee.specs.support.api.JpaSupport;
import org.netbeans.modules.web.api.webmodule.WebModule;
import org.openide.filesystems.FileObject;

public final class J2eeProjectCapabilities {
    private final Project project;
    private final J2eeModuleProvider provider;
    private final Profile ejbJarProfile;
    private final Profile webProfile;

    private J2eeProjectCapabilities(Project project, J2eeModuleProvider provider, Profile ejbJarProfile, Profile webProfile) {
        this.project = project;
        this.provider = provider;
        this.ejbJarProfile = ejbJarProfile;
        this.webProfile = webProfile;
    }

    @CheckForNull
    public static J2eeProjectCapabilities forProject(@NonNull Project project) {
        J2eeModuleProvider provider = (J2eeModuleProvider)project.getLookup().lookup(J2eeModuleProvider.class);
        if (provider == null) {
            return null;
        }
        Profile ejbJarProfile = null;
        Profile webProfile = null;
        if (provider.getJ2eeModule().getType() == J2eeModule.Type.EJB || provider.getJ2eeModule().getType() == J2eeModule.Type.WAR) {
            WebModule module;
            EjbJar[] ejbJars = EjbJar.getEjbJars((Project)project);
            if (ejbJars.length > 0) {
                ejbJarProfile = ejbJars[0].getJ2eeProfile();
            }
            if (provider.getJ2eeModule().getType() == J2eeModule.Type.WAR && (module = WebModule.getWebModule((FileObject)project.getProjectDirectory())) != null) {
                webProfile = module.getJ2eeProfile();
            }
        }
        return new J2eeProjectCapabilities(project, provider, ejbJarProfile, webProfile);
    }

    public boolean isEjb30Supported() {
        J2eeModule.Type moduleType = this.provider.getJ2eeModule().getType();
        boolean eeOk = this.ejbJarProfile != null && (this.ejbJarProfile.equals(Profile.JAVA_EE_5) || this.ejbJarProfile.equals(Profile.JAVA_EE_6_FULL));
        return J2eeModule.Type.EJB.equals(moduleType) && eeOk;
    }

    public boolean isEjb31Supported() {
        J2eeModule.Type moduleType = this.provider.getJ2eeModule().getType();
        boolean ee6 = this.ejbJarProfile != null && this.ejbJarProfile.equals(Profile.JAVA_EE_6_FULL);
        return ee6 && (J2eeModule.Type.EJB.equals(moduleType) || J2eeModule.Type.WAR.equals(moduleType));
    }

    public boolean isEjb31LiteSupported() {
        J2eeModule.Type moduleType = this.provider.getJ2eeModule().getType();
        boolean ee6Web = this.ejbJarProfile != null && this.ejbJarProfile.equals(Profile.JAVA_EE_6_WEB);
        return this.isEjb31Supported() || J2eeModule.Type.WAR.equals(moduleType) && ee6Web;
    }

    @Deprecated
    public boolean isEjbLiteIncluded() {
        J2eePlatform platform = Util.getPlatform(this.project);
        if (platform == null) {
            return false;
        }
        return EjbSupport.getInstance((J2eePlatform)platform).isEjb31LiteSupported(platform);
    }

    public boolean hasDefaultPersistenceProvider() {
        J2eePlatform platform = Util.getPlatform(this.project);
        if (platform == null) {
            return false;
        }
        Set profiles = platform.getSupportedProfiles(this.provider.getJ2eeModule().getType());
        if (!profiles.contains(Profile.JAVA_EE_5) && !profiles.contains(Profile.JAVA_EE_6_FULL)) {
            return false;
        }
        JpaSupport support = JpaSupport.getInstance((J2eePlatform)platform);
        return support != null && support.getDefaultProvider() != null;
    }
}

