/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.common;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractListModel;
import javax.swing.ComboBoxEditor;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JComboBox;
import javax.swing.JList;
import javax.swing.JSeparator;
import javax.swing.ListCellRenderer;
import javax.swing.MutableComboBoxModel;
import javax.swing.SwingUtilities;
import javax.swing.text.JTextComponent;
import org.netbeans.api.project.Project;
import org.netbeans.modules.j2ee.common.DatasourceCustomizer;
import org.netbeans.modules.j2ee.core.api.support.progress.ProgressSupport;
import org.netbeans.modules.j2ee.deployment.common.api.ConfigurationException;
import org.netbeans.modules.j2ee.deployment.common.api.Datasource;
import org.netbeans.modules.j2ee.deployment.common.api.DatasourceAlreadyExistsException;
import org.netbeans.modules.j2ee.deployment.devmodules.spi.J2eeModuleProvider;
import org.netbeans.modules.j2ee.persistence.dd.common.PersistenceUnit;
import org.netbeans.modules.j2ee.persistence.spi.provider.PersistenceProviderSupplier;
import org.netbeans.modules.j2ee.persistence.spi.server.ServerStatusProvider2;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;

public final class DatasourceUIHelper {
    static final Separator SEPARATOR_ITEM = new Separator();
    static final Object NEW_ITEM = new Object(){

        public String toString() {
            return NbBundle.getMessage(DatasourceUIHelper.class, (String)"LBL_NEW_DATASOURCE");
        }
    };
    static final Object SELECT_SERVER_ITEM = new Object(){

        public String toString() {
            return NbBundle.getMessage(DatasourceUIHelper.class, (String)"LBL_SELECT_SERVER");
        }
    };

    public static ListCellRenderer createDatasourceListCellRenderer() {
        return new DatasourceListCellRenderer();
    }

    public static Comparator<Datasource> createDatasourceComparator() {
        return new DatasourceComparator();
    }

    private DatasourceUIHelper() {
    }

    public static void connect(J2eeModuleProvider provider, JComboBox combo) {
        DatasourceUIHelper.connect(null, provider, combo, null, false);
    }

    public static void connect(Project project, J2eeModuleProvider provider, JComboBox combo) {
        boolean canServerBeSelected = false;
        ServerStatusProvider2 serverStatusProvider = (ServerStatusProvider2)project.getLookup().lookup(ServerStatusProvider2.class);
        if (serverStatusProvider != null && !serverStatusProvider.validServerInstancePresent()) {
            canServerBeSelected = true;
        }
        DatasourceUIHelper.connect(project, provider, combo, null, canServerBeSelected);
    }

    private static List<Datasource> fetchDataSources(final J2eeModuleProvider provider) {
        ArrayList<3> actions = new ArrayList<3>();
        final ArrayList<Datasource> datasources = new ArrayList<Datasource>();
        actions.add(new ProgressSupport.BackgroundAction(){

            public void run(ProgressSupport.Context actionContext) {
                String msg = NbBundle.getMessage(DatasourceUIHelper.class, (String)"MSG_retrievingDS");
                actionContext.progress(msg);
                try {
                    datasources.addAll(DatasourceUIHelper.getDatasources(provider));
                }
                catch (ConfigurationException configurationException) {
                    // empty catch block
                }
            }
        });
        ProgressSupport.invoke(actions);
        return datasources;
    }

    private static final void connect(final Project project, final J2eeModuleProvider provider, final JComboBox combo, Datasource selectedDatasource, boolean canServerBeSelected) {
        assert (provider != null);
        combo.setEditor(new DatasourceComboBoxEditor(combo.getEditor()));
        combo.setRenderer(new DatasourceListCellRenderer());
        List<Datasource> datasources = DatasourceUIHelper.fetchDataSources(provider);
        DatasourceUIHelper.populate(datasources, provider.isDatasourceCreationSupported(), combo, selectedDatasource, false, canServerBeSelected);
        JComboBox toListenOn = combo.isEditable() ? combo.getEditor().getEditorComponent() : combo;
        toListenOn.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                int keyCode = e.getKeyCode();
                if (10 == keyCode) {
                    Object selectedItem = combo.getSelectedItem();
                    if (selectedItem == NEW_ITEM) {
                        DatasourceUIHelper.performCreateDatasource(provider, combo, false);
                        e.consume();
                    } else if (selectedItem == SELECT_SERVER_ITEM) {
                        DatasourceUIHelper.performServerSelection(project, provider, combo);
                        e.consume();
                    }
                }
            }
        });
        combo.addActionListener(new ActionListener(){
            Object previousItem;
            int previousIndex;
            {
                this.previousIndex = combo.getSelectedIndex();
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                Object selectedItem = combo.getSelectedItem();
                if (selectedItem == SEPARATOR_ITEM) {
                    int selectedIndex = combo.getSelectedIndex();
                    if (selectedIndex > this.previousIndex) {
                        this.previousIndex = selectedIndex + 1;
                        this.previousItem = combo.getItemAt(this.previousIndex);
                    } else {
                        this.previousIndex = selectedIndex - 1;
                        this.previousItem = combo.getItemAt(this.previousIndex);
                    }
                    combo.setSelectedItem(this.previousItem);
                } else if ((e.getModifiers() & 0x10) != 0) {
                    if (selectedItem == NEW_ITEM) {
                        DatasourceUIHelper.performCreateDatasource(provider, combo, true);
                    } else if (selectedItem == SELECT_SERVER_ITEM) {
                        DatasourceUIHelper.performServerSelection(project, provider, combo);
                    }
                }
            }
        });
    }

    private static boolean isContainerManaged(Project project) {
        PersistenceProviderSupplier providerSupplier = (PersistenceProviderSupplier)project.getLookup().lookup(PersistenceProviderSupplier.class);
        return providerSupplier != null && providerSupplier.supportsDefaultProvider();
    }

    private static void performServerSelection(Project project, J2eeModuleProvider provider, JComboBox combo) {
        ServerStatusProvider2 serverStatusProvider = (ServerStatusProvider2)project.getLookup().lookup(ServerStatusProvider2.class);
        if (serverStatusProvider.selectServer()) {
            provider = (J2eeModuleProvider)project.getLookup().lookup(J2eeModuleProvider.class);
            if (DatasourceUIHelper.isContainerManaged(project)) {
                List<Datasource> datasources = DatasourceUIHelper.fetchDataSources(provider);
                DatasourceUIHelper.populate(datasources, provider.isDatasourceCreationSupported(), combo, null, false, false);
            }
        }
    }

    private static void performCreateDatasource(final J2eeModuleProvider provider, final JComboBox combo, boolean selectItemLater) {
        final DatasourceComboBoxModel model = (DatasourceComboBoxModel)combo.getModel();
        DatasourceCustomizer dsc = new DatasourceCustomizer(model.getDatasources());
        boolean accept = dsc.showDialog();
        ArrayList<ProgressSupport.BackgroundAction> actions = new ArrayList<ProgressSupport.BackgroundAction>();
        final Datasource[] ds = new Datasource[1];
        if (accept) {
            final String password = dsc.getPassword();
            final String jndiName = dsc.getJndiName();
            final String url = dsc.getUrl();
            final String username = dsc.getUsername();
            final String driverClassName = dsc.getDriverClassName();
            actions.add(new ProgressSupport.BackgroundAction(){

                public void run(ProgressSupport.Context actionContext) {
                    String msg = NbBundle.getMessage(DatasourceUIHelper.class, (String)"MSG_creatingDS");
                    actionContext.progress(msg);
                    try {
                        ds[0] = provider.createDatasource(jndiName, url, username, password, driverClassName);
                    }
                    catch (DatasourceAlreadyExistsException daee) {
                        StringBuilder sb = new StringBuilder();
                        for (Datasource conflict : daee.getDatasources()) {
                            sb.append(conflict.toString() + "\n");
                        }
                        String message = NbBundle.getMessage(DatasourceUIHelper.class, (String)"ERR_DsConflict", (Object)sb.toString());
                        Logger.getLogger("global").log(Level.INFO, message, Exceptions.attachLocalizedMessage((Throwable)daee, (String)message));
                    }
                    catch (ConfigurationException configurationException) {
                        // empty catch block
                    }
                }

                public boolean isEnabled() {
                    return password != null;
                }
            });
        }
        final ArrayList<Datasource> datasources = new ArrayList<Datasource>();
        actions.add(new ProgressSupport.BackgroundAction(){

            public void run(ProgressSupport.Context actionContext) {
                String msg = NbBundle.getMessage(DatasourceUIHelper.class, (String)"MSG_retrievingDS");
                actionContext.progress(msg);
                try {
                    datasources.addAll(DatasourceUIHelper.getDatasources(provider));
                }
                catch (ConfigurationException configurationException) {
                    // empty catch block
                }
            }

            public boolean isEnabled() {
                return ds[0] != null;
            }
        });
        ProgressSupport.invoke(actions);
        combo.setPopupVisible(false);
        if (ds[0] == null) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    DatasourceUIHelper.setSelectedItem(combo, model.getPreviousItem());
                }
            });
        } else {
            DatasourceUIHelper.populate(datasources, provider.isDatasourceCreationSupported(), combo, ds[0], selectItemLater, false);
        }
    }

    private static List<Datasource> getDatasources(J2eeModuleProvider provider) throws ConfigurationException {
        Set moduleDatasources = provider.getModuleDatasources();
        Set serverDatasources = provider.getServerDatasources();
        int initSize = moduleDatasources.size() + serverDatasources.size();
        HashSet datasources = new HashSet(initSize);
        datasources.addAll(moduleDatasources);
        datasources.addAll(serverDatasources);
        ArrayList<Datasource> sortedDatasources = new ArrayList<Datasource>(datasources);
        Collections.sort(sortedDatasources, new DatasourceComparator());
        return sortedDatasources;
    }

    private static List populate(List<Datasource> datasources, boolean creationSupported, final JComboBox combo, final Datasource selectedDatasource, boolean selectItemLater, boolean serverSelectionSupported) {
        LinkedList<Object> items;
        LinkedList<Object> linkedList = items = datasources == null ? new LinkedList<Object>() : new LinkedList<Datasource>(datasources);
        if (items.size() > 0) {
            items.add(SEPARATOR_ITEM);
        }
        if (creationSupported) {
            items.add(NEW_ITEM);
        }
        if (serverSelectionSupported) {
            items.add(SELECT_SERVER_ITEM);
        }
        DatasourceComboBoxModel model = new DatasourceComboBoxModel(datasources, items);
        combo.setModel(model);
        if (selectedDatasource != null) {
            DatasourceUIHelper.setSelectedItem(combo, selectedDatasource);
            if (selectItemLater) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        DatasourceUIHelper.setSelectedItem(combo, selectedDatasource);
                    }
                });
            }
        }
        return datasources;
    }

    private static void setSelectedItem(JComboBox combo, Object item) {
        combo.setSelectedItem(item);
        if (combo.isEditable() && combo.getEditor() != null) {
            combo.configureEditor(combo.getEditor(), combo.getSelectedItem());
        }
    }

    private static class DatasourceComboBoxEditor
    implements ComboBoxEditor {
        private ComboBoxEditor delegate;
        private Object oldValue;

        DatasourceComboBoxEditor(ComboBoxEditor delegate) {
            this.delegate = delegate;
        }

        @Override
        public Component getEditorComponent() {
            return this.delegate.getEditorComponent();
        }

        @Override
        public void setItem(Object anObject) {
            JTextComponent editor = this.getEditor();
            if (anObject != null) {
                String text = anObject instanceof Datasource ? ((Datasource)anObject).getJndiName() : anObject.toString();
                editor.setText(text);
                this.oldValue = anObject;
            } else {
                editor.setText("");
            }
        }

        @Override
        public Object getItem() {
            JTextComponent editor = this.getEditor();
            Object newValue = editor.getText();
            if (this.oldValue != null && !(this.oldValue instanceof String)) {
                if (newValue.equals(this.oldValue.toString())) {
                    return this.oldValue;
                }
                Class<?> cls = this.oldValue.getClass();
                try {
                    Method method = cls.getMethod("valueOf", String.class);
                    newValue = method.invoke(this.oldValue, editor.getText());
                }
                catch (Exception ex) {
                    Logger.getLogger("DatasourceUIHelper").log(Level.FINE, "ignored exception", ex);
                }
            }
            return newValue;
        }

        @Override
        public void selectAll() {
            this.delegate.selectAll();
        }

        @Override
        public void addActionListener(ActionListener l) {
            this.delegate.addActionListener(l);
        }

        @Override
        public void removeActionListener(ActionListener l) {
            this.delegate.removeActionListener(l);
        }

        private JTextComponent getEditor() {
            Component comp = this.getEditorComponent();
            assert (comp instanceof JTextComponent);
            return (JTextComponent)comp;
        }
    }

    private static class DatasourceComboBoxModel
    extends AbstractListModel
    implements MutableComboBoxModel {
        private List<Object> items;
        private Object selectedItem;
        private List<Datasource> datasources;
        private Object previousItem;

        private DatasourceComboBoxModel(List<Datasource> datasources, List<Object> items) {
            this.datasources = datasources;
            this.items = items;
        }

        @Override
        public void setSelectedItem(Object anItem) {
            if (this.selectedItem == null || !this.selectedItem.equals(anItem)) {
                this.previousItem = this.selectedItem;
                this.selectedItem = anItem;
                this.fireContentsChanged(this, 0, -1);
            }
        }

        @Override
        public Object getSelectedItem() {
            return this.selectedItem;
        }

        @Override
        public Object getElementAt(int index) {
            return this.items.get(index);
        }

        @Override
        public int getSize() {
            return this.items.size();
        }

        Object getPreviousItem() {
            return this.previousItem;
        }

        List<Datasource> getDatasources() {
            return this.datasources;
        }

        public void addElement(Object elem) {
            this.items.add(elem);
        }

        @Override
        public void removeElement(Object elem) {
            this.items.remove(elem);
        }

        public void insertElementAt(Object elem, int index) {
            this.items.set(index, elem);
        }

        @Override
        public void removeElementAt(int index) {
            this.items.remove(index);
        }
    }

    private static class DatasourceComparator
    implements Comparator<Datasource> {
        private DatasourceComparator() {
        }

        @Override
        public int compare(Datasource ds1, Datasource ds2) {
            if (ds1 == null) {
                return ds2 == null ? 0 : -1;
            }
            if (ds2 == null) {
                return 1;
            }
            String dispName1 = ds1.getDisplayName();
            String dispName2 = ds2.getDisplayName();
            if (dispName1 == null) {
                return dispName2 == null ? 0 : -1;
            }
            return dispName2 == null ? 1 : dispName1.compareToIgnoreCase(dispName2);
        }
    }

    private static class DatasourceListCellRenderer
    extends DefaultListCellRenderer {
        private DatasourceListCellRenderer() {
        }

        @Override
        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            if (isSelected) {
                this.setBackground(list.getSelectionBackground());
                this.setForeground(list.getSelectionForeground());
            } else {
                this.setBackground(list.getBackground());
                this.setForeground(list.getForeground());
            }
            if (value instanceof Datasource) {
                Datasource ds = (Datasource)value;
                this.setText(ds != null ? ds.getDisplayName() : "");
                this.setToolTipText(ds.toString());
            } else {
                if (value == SEPARATOR_ITEM) {
                    return SEPARATOR_ITEM;
                }
                this.setText(value != null ? value.toString() : "");
                this.setToolTipText("");
            }
            return this;
        }
    }

    private static class DatasourcePUComboBoxModel
    extends AbstractListModel
    implements MutableComboBoxModel {
        private List<Object> items;
        private Object selectedItem;
        private List<Datasource> datasources;
        private Object previousItem;
        private final List<PersistenceUnit> pUnits;

        private DatasourcePUComboBoxModel(List<Datasource> datasources, List<PersistenceUnit> pUnits, List<Object> items) {
            this.datasources = datasources;
            this.pUnits = pUnits;
            this.items = items;
        }

        @Override
        public void setSelectedItem(Object anItem) {
            if (this.selectedItem == null || !this.selectedItem.equals(anItem)) {
                this.previousItem = this.selectedItem;
                this.selectedItem = anItem;
                this.fireContentsChanged(this, 0, -1);
            }
        }

        @Override
        public Object getSelectedItem() {
            return this.selectedItem;
        }

        @Override
        public Object getElementAt(int index) {
            return this.items.get(index);
        }

        @Override
        public int getSize() {
            return this.items.size();
        }

        Object getPreviousItem() {
            return this.previousItem;
        }

        List<Datasource> getDatasources() {
            return this.datasources;
        }

        public void addElement(Object elem) {
            this.items.add(elem);
        }

        @Override
        public void removeElement(Object elem) {
            this.items.remove(elem);
        }

        public void insertElementAt(Object elem, int index) {
            this.items.set(index, elem);
        }

        @Override
        public void removeElementAt(int index) {
            this.items.remove(index);
        }
    }

    private class DatasourcePuPair
    implements Comparable<DatasourcePuPair> {
        private Datasource datasource;
        private PersistenceUnit pu;

        public DatasourcePuPair(Datasource datasource, PersistenceUnit pu) {
            this.datasource = datasource;
            this.pu = pu;
        }

        public boolean equals(Object obj) {
            if (obj instanceof DatasourcePuPair) {
                DatasourcePuPair pa = (DatasourcePuPair)obj;
                return this.datasource.equals(pa.datasource) && (this.pu == null && pa.pu == null || this.pu != null && this.pu.equals(pa.pu));
            }
            return false;
        }

        public int hashCode() {
            int hash = 7;
            hash = 17 * hash + (this.datasource != null ? this.datasource.hashCode() : 0);
            hash = 17 * hash + (this.pu != null ? this.pu.hashCode() : 0);
            return hash;
        }

        @Override
        public int compareTo(DatasourcePuPair o) {
            String s1 = this.datasource.getDisplayName() + "( " + this.pu.getName() + " )";
            String s2 = o.datasource.getDisplayName() + "( " + o.pu.getName() + " )";
            return s1.compareTo(s2);
        }

        public String toString() {
            return this.datasource.getDisplayName() + "( " + this.pu.getName() + " )";
        }
    }

    private static final class Separator
    extends JSeparator {
        Separator() {
            this.setPreferredSize(new Dimension(this.getWidth(), 1));
            this.setForeground(Color.BLACK);
        }
    }
}

