/*
 * Decompiled with CFR 0.152.
 */
package com.sun.corba.ee.impl.resolver;

import com.sun.corba.ee.impl.orbutil.CorbaResourceUtil;
import com.sun.corba.ee.spi.orb.ORB;
import com.sun.corba.ee.spi.resolver.Resolver;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Properties;
import java.util.Set;
import org.omg.CORBA.Object;

public class FileResolverImpl
implements Resolver {
    private ORB orb;
    private File file;
    private Properties savedProps;
    private long fileModified = 0L;

    public FileResolverImpl(ORB orb, File file) {
        this.orb = orb;
        this.file = file;
        this.savedProps = new Properties();
    }

    @Override
    public Object resolve(String name) {
        this.check();
        String stringifiedObject = this.savedProps.getProperty(name);
        if (stringifiedObject == null) {
            return null;
        }
        return this.orb.string_to_object(stringifiedObject);
    }

    public Set list() {
        this.check();
        HashSet result = new HashSet();
        Enumeration<?> theKeys = this.savedProps.propertyNames();
        while (theKeys.hasMoreElements()) {
            result.add(theKeys.nextElement());
        }
        return result;
    }

    private void check() {
        if (this.file == null) {
            return;
        }
        long lastMod = this.file.lastModified();
        if (lastMod > this.fileModified) {
            try {
                FileInputStream fileIS = new FileInputStream(this.file);
                this.savedProps.clear();
                this.savedProps.load(fileIS);
                fileIS.close();
                this.fileModified = lastMod;
            }
            catch (FileNotFoundException e) {
                System.err.println(CorbaResourceUtil.getText("bootstrap.filenotfound", this.file.getAbsolutePath()));
            }
            catch (IOException e) {
                System.err.println(CorbaResourceUtil.getText("bootstrap.exception", this.file.getAbsolutePath(), e.toString()));
            }
        }
    }
}

