/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.html.parser;

import java.io.IOException;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import nu.validator.htmlparser.impl.ErrorReportingTokenizer;
import nu.validator.htmlparser.io.Driver;
import org.netbeans.modules.html.editor.lib.api.DefaultHtmlParseResult;
import org.netbeans.modules.html.editor.lib.api.HtmlParseResult;
import org.netbeans.modules.html.editor.lib.api.HtmlParser;
import org.netbeans.modules.html.editor.lib.api.HtmlSource;
import org.netbeans.modules.html.editor.lib.api.HtmlVersion;
import org.netbeans.modules.html.editor.lib.api.MaskedAreas;
import org.netbeans.modules.html.editor.lib.api.ParseException;
import org.netbeans.modules.html.editor.lib.api.ProblemDescription;
import org.netbeans.modules.html.editor.lib.api.elements.Element;
import org.netbeans.modules.html.editor.lib.api.elements.ElementUtils;
import org.netbeans.modules.html.editor.lib.api.elements.Node;
import org.netbeans.modules.html.editor.lib.api.elements.OpenTag;
import org.netbeans.modules.html.editor.lib.api.model.HtmlModel;
import org.netbeans.modules.html.editor.lib.api.model.HtmlModelFactory;
import org.netbeans.modules.html.editor.lib.api.model.HtmlTag;
import org.netbeans.modules.html.parser.ElementsFactory;
import org.netbeans.modules.html.parser.MaskingChSReader;
import org.netbeans.modules.html.parser.ParseTreeBuilder;
import org.openide.util.Lookup;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class Html5Parser
implements HtmlParser {
    public HtmlParseResult parse(HtmlSource source, HtmlVersion preferedVersion, Lookup lookup) throws ParseException {
        try {
            CharSequence sourceCode = source.getSourceCode();
            MaskedAreas maskedAreas = (MaskedAreas)lookup.lookup(MaskedAreas.class);
            InputSource is = maskedAreas == null ? new InputSource(new StringReader(((Object)sourceCode).toString())) : new InputSource(new MaskingChSReader(sourceCode, maskedAreas.positions(), maskedAreas.lens()));
            final ParseTreeBuilder treeBuilder = new ParseTreeBuilder(sourceCode);
            ErrorReportingTokenizer tokenizer = new ErrorReportingTokenizer(treeBuilder);
            Driver driver = new Driver(tokenizer);
            driver.setTransitionHandler(treeBuilder);
            final ArrayList<ProblemDescription> problems = new ArrayList<ProblemDescription>();
            driver.setErrorHandler(new ErrorHandler(){

                @Override
                public void warning(SAXParseException saxpe) throws SAXException {
                    this.reportProblem(saxpe.getLocalizedMessage(), 1);
                }

                @Override
                public void error(SAXParseException saxpe) throws SAXException {
                    this.reportProblem(saxpe.getLocalizedMessage(), 2);
                }

                @Override
                public void fatalError(SAXParseException saxpe) throws SAXException {
                    this.reportProblem(saxpe.getLocalizedMessage(), 3);
                }

                private void reportProblem(String message, int type) {
                    problems.add(ProblemDescription.create((String)"html5.parser", (String)message, (int)type, (int)treeBuilder.getOffset(), (int)treeBuilder.getOffset()));
                }
            });
            driver.tokenize(is);
            Node root = treeBuilder.getRoot();
            return new Html5ParserResult(source, root, problems, preferedVersion);
        }
        catch (SAXException ex) {
            throw new ParseException((Throwable)ex);
        }
        catch (IOException ex) {
            throw new ParseException((Throwable)ex);
        }
        catch (AssertionError e) {
            StringBuilder msg = new StringBuilder();
            msg.append("An internal parser error occured");
            if (source.getSourceFileObject() != null) {
                msg.append(" when parsing ");
                msg.append(source.getSourceFileObject().getPath());
            }
            Logger.getAnonymousLogger().log(Level.INFO, msg.toString(), (Throwable)((Object)e));
            ElementsFactory factory = new ElementsFactory(source.getSourceCode());
            return new Html5ParserResult(source, (Node)factory.createRoot(), Collections.<ProblemDescription>emptyList(), preferedVersion);
        }
    }

    public boolean canParse(HtmlVersion version) {
        return version == HtmlVersion.HTML5 || version == HtmlVersion.HTML32 || version == HtmlVersion.HTML41_STRICT || version == HtmlVersion.HTML41_TRANSATIONAL || version == HtmlVersion.HTML41_FRAMESET || version == HtmlVersion.HTML40_STRICT || version == HtmlVersion.HTML40_TRANSATIONAL || version == HtmlVersion.HTML40_FRAMESET;
    }

    public HtmlModel getModel(HtmlVersion version) {
        return null;
    }

    public String getName() {
        return null;
    }

    private static class Html5ParserResult
    extends DefaultHtmlParseResult {
        public Html5ParserResult(HtmlSource source, Node root, Collection<ProblemDescription> problems, HtmlVersion version) {
            super(source, root, problems, version);
        }

        public HtmlModel model() {
            return HtmlModelFactory.getModel((HtmlVersion)this.version());
        }

        public Collection<HtmlTag> getPossibleOpenTags(Element afterNode) {
            return ElementUtils.getPossibleOpenTags((HtmlModel)this.model(), (Element)afterNode);
        }

        public Map<HtmlTag, OpenTag> getPossibleCloseTags(Element node) {
            return ElementUtils.getPossibleCloseTags((HtmlModel)this.model(), (Element)node);
        }
    }
}

