/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.spi.viewmodel;

import java.util.Arrays;
import java.util.EventObject;

public class ModelEvent
extends EventObject {
    private ModelEvent(Object source) {
        super(source);
    }

    public static class NodeChanged
    extends ModelEvent {
        public static final int DISPLAY_NAME_MASK = 1;
        public static final int ICON_MASK = 2;
        public static final int SHORT_DESCRIPTION_MASK = 4;
        public static final int CHILDREN_MASK = 8;
        public static final int EXPANSION_MASK = 16;
        private Object node;
        private int change;

        public NodeChanged(Object source, Object node) {
            this(source, node, -1);
        }

        public NodeChanged(Object source, Object node, int change) {
            super(source);
            this.node = node;
            this.change = change;
        }

        public Object getNode() {
            return this.node;
        }

        public int getChange() {
            return this.change;
        }

        @Override
        public String toString() {
            return super.toString() + "(node = " + this.node + ", change = " + NodeChanged.getChangeString(this.change) + ")";
        }

        private static String getChangeString(int change) {
            StringBuilder sb = new StringBuilder();
            if ((change & 1) != 0) {
                sb.append("DISPLAY_NAME, ");
            }
            if ((change & 2) != 0) {
                sb.append("ICON, ");
            }
            if ((change & 4) != 0) {
                sb.append("SHORT_DESCRIPTION, ");
            }
            if ((change & 8) != 0) {
                sb.append("CHILDREN, ");
            }
            if ((change & 0x10) != 0) {
                sb.append("EXPANSION, ");
            }
            if (sb.length() > 0) {
                sb.delete(sb.length() - 2, sb.length());
            }
            return sb.toString();
        }
    }

    public static class SelectionChanged
    extends ModelEvent {
        private Object[] nodes;

        public SelectionChanged(Object source, Object ... nodes) {
            super(source);
            this.nodes = nodes;
        }

        public Object[] getNodes() {
            return this.nodes;
        }

        @Override
        public String toString() {
            return super.toString() + "(nodes = " + Arrays.toString(this.nodes) + ")";
        }
    }

    public static class TableValueChanged
    extends ModelEvent {
        private Object node;
        private String columnID;

        public TableValueChanged(Object source, Object node, String columnID) {
            super(source);
            this.node = node;
            this.columnID = columnID;
        }

        public Object getNode() {
            return this.node;
        }

        public String getColumnID() {
            return this.columnID;
        }
    }

    public static class TreeChanged
    extends ModelEvent {
        public TreeChanged(Object source) {
            super(source);
        }
    }
}

