/*
 * Decompiled with CFR 0.152.
 */
package org.nbheaven.sqe.codedefects.dashboard.controlcenter.panels;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Paint;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Collection;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.AxisLocation;
import org.jfree.chart.axis.CategoryAxis;
import org.jfree.chart.axis.LogarithmicAxis;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.plot.CategoryPlot;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.renderer.category.CategoryItemRenderer;
import org.jfree.chart.renderer.category.StackedBarRenderer;
import org.jfree.data.category.CategoryDataset;
import org.jfree.data.category.DefaultCategoryDataset;
import org.nbheaven.sqe.codedefects.core.api.CodeDefectSeverity;
import org.nbheaven.sqe.codedefects.core.api.QualityProvider;
import org.nbheaven.sqe.codedefects.core.api.QualityResultStatistic;
import org.nbheaven.sqe.codedefects.core.api.QualitySession;
import org.nbheaven.sqe.codedefects.core.spi.SQEUtilities;
import org.nbheaven.sqe.core.api.SQEManager;
import org.netbeans.api.project.Project;

public class Statistics
extends JPanel
implements PropertyChangeListener {
    private Project activeProject;
    private final DefaultCategoryDataset perProjectDataSet = new DefaultCategoryDataset();
    private ChartPanel perProjectOverviewPanel;

    public Statistics() {
        this.initComponents();
        this.initComponentsManual();
        this.updateView();
    }

    private void initComponentsManual() {
        JFreeChart perProjectOverview = Statistics.createOverviewPanel(this.perProjectDataSet);
        this.perProjectOverviewPanel = new ChartPanel(perProjectOverview);
        this.perProjectOverviewPanel.setPreferredSize(new Dimension(0, 150));
        this.add((Component)this.perProjectOverviewPanel, "Center");
    }

    private static JFreeChart createOverviewPanel(DefaultCategoryDataset dataSet) {
        JFreeChart overview = ChartFactory.createStackedBarChart(null, null, (String)"CodeDefects", (CategoryDataset)dataSet, (PlotOrientation)PlotOrientation.HORIZONTAL, (boolean)false, (boolean)true, (boolean)false);
        overview.setBorderVisible(false);
        overview.setBackgroundPaint((Paint)Color.WHITE);
        overview.setAntiAlias(true);
        overview.setNotify(true);
        CategoryPlot overviewPlot = overview.getCategoryPlot();
        overviewPlot.setRangeGridlinePaint((Paint)Color.BLACK);
        overviewPlot.setDomainGridlinePaint((Paint)Color.BLACK);
        overviewPlot.setBackgroundPaint((Paint)Color.WHITE);
        overviewPlot.setForegroundAlpha(0.7f);
        overviewPlot.setRangeAxisLocation(AxisLocation.getOpposite((AxisLocation)overviewPlot.getRangeAxisLocation()));
        CategoryAxis domainAxis = overviewPlot.getDomainAxis();
        domainAxis.setVisible(true);
        LogarithmicAxis rangeAxis = new LogarithmicAxis("CodeDefects");
        rangeAxis.setLabel(null);
        rangeAxis.setStrictValuesFlag(false);
        rangeAxis.setStandardTickUnits(NumberAxis.createIntegerTickUnits());
        overviewPlot.setRangeAxis((ValueAxis)rangeAxis);
        StackedBarRenderer categoryItemRenderer = new StackedBarRenderer();
        categoryItemRenderer.setSeriesPaint(0, (Paint)Color.RED);
        categoryItemRenderer.setSeriesPaint(1, (Paint)Color.ORANGE);
        categoryItemRenderer.setSeriesPaint(2, (Paint)Color.YELLOW);
        categoryItemRenderer.setBaseItemLabelsVisible(true);
        overviewPlot.setRenderer((CategoryItemRenderer)categoryItemRenderer);
        return overview;
    }

    private void updateView() {
        if (!SwingUtilities.isEventDispatchThread()) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    Statistics.this.updateView();
                }
            });
            return;
        }
        assert (SwingUtilities.isEventDispatchThread());
        this.perProjectDataSet.clear();
        for (QualityProvider qualityProvider : SQEUtilities.getProviders()) {
            String providerName = qualityProvider.getDisplayName();
            this.perProjectDataSet.addValue(0.0, (Comparable)CodeDefectSeverity.ERROR, (Comparable)((Object)providerName));
            this.perProjectDataSet.addValue(0.0, (Comparable)CodeDefectSeverity.WARNING, (Comparable)((Object)providerName));
            this.perProjectDataSet.addValue(0.0, (Comparable)CodeDefectSeverity.INFO, (Comparable)((Object)providerName));
        }
        if (null != this.activeProject) {
            Collection sessions = this.activeProject.getLookup().lookupAll(QualitySession.class);
            for (QualitySession session : sessions) {
                QualityResultStatistic statistic;
                if (null == session.getResult() || null == (statistic = (QualityResultStatistic)session.getResult().getLookup().lookup(QualityResultStatistic.class))) continue;
                String providerName = session.getProvider().getDisplayName();
                this.perProjectDataSet.addValue((double)statistic.getCodeDefectCount(CodeDefectSeverity.ERROR), (Comparable)CodeDefectSeverity.ERROR, (Comparable)((Object)providerName));
                this.perProjectDataSet.addValue((double)statistic.getCodeDefectCount(CodeDefectSeverity.WARNING), (Comparable)CodeDefectSeverity.WARNING, (Comparable)((Object)providerName));
                this.perProjectDataSet.addValue((double)statistic.getCodeDefectCount(CodeDefectSeverity.INFO), (Comparable)CodeDefectSeverity.INFO, (Comparable)((Object)providerName));
            }
        }
        this.invalidate();
        this.revalidate();
        this.repaint();
    }

    private void setActiveProject(Project project) {
        if (null != this.activeProject) {
            for (QualitySession session : this.activeProject.getLookup().lookupAll(QualitySession.class)) {
                session.removePropertyChangeListener("Result", (PropertyChangeListener)this);
            }
        }
        if (null != project) {
            for (QualitySession session : project.getLookup().lookupAll(QualitySession.class)) {
                session.addPropertyChangeListener("Result", (PropertyChangeListener)this);
            }
        }
        this.activeProject = project;
    }

    public void propertyChange(PropertyChangeEvent evt) {
        if ("PropActiveProject".equals(evt.getPropertyName())) {
            this.setActiveProject((Project)evt.getNewValue());
        }
        this.updateView();
    }

    public void addNotify() {
        super.addNotify();
        this.setActiveProject(SQEManager.getDefault().getActiveProject());
        SQEManager.getDefault().addPropertyChangeListener("PropActiveProject", (PropertyChangeListener)this);
        this.updateView();
    }

    public void removeNotify() {
        SQEManager.getDefault().removePropertyChangeListener("PropActiveProject", (PropertyChangeListener)this);
        super.removeNotify();
    }

    private void initComponents() {
        this.setLayout(new BorderLayout());
    }
}

