/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.cli;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import org.apache.commons.cli.AlreadySelectedException;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.MissingArgumentException;
import org.apache.commons.cli.MissingOptionException;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.OptionGroup;
import org.apache.commons.cli.UnrecognizedOptionException;

public class Options {
    private List _options = new ArrayList();
    private Map _shortOpts = new HashMap();
    private Map _longOpts = new HashMap();
    private Map _requiredOpts = new HashMap();
    private Map _optionGroups = new HashMap();

    public Options addOptionGroup(OptionGroup group) {
        Iterator options = group.getOptions().iterator();
        while (options.hasNext()) {
            Option option = (Option)options.next();
            this.addOption(option);
            this._optionGroups.put(option, group);
        }
        return this;
    }

    public Options addOption(char opt, boolean hasArg, String description) {
        this.addOption(opt, null, hasArg, description, false);
        return this;
    }

    public Options addOption(char opt, String longOpt, boolean hasArg, String description) {
        this.addOption(opt, longOpt, hasArg, description, false);
        return this;
    }

    public Options addOption(char opt, String longOpt, boolean hasArg, String description, boolean required) {
        this.addOption(new Option(opt, longOpt, hasArg, description, required));
        return this;
    }

    public Options addOption(char opt, String longOpt, boolean hasArg, String description, boolean required, boolean multipleArgs) {
        this.addOption(new Option(opt, longOpt, hasArg, description, required, multipleArgs));
        return this;
    }

    public CommandLine parse(String[] args) throws MissingArgumentException, UnrecognizedOptionException, MissingOptionException, AlreadySelectedException {
        return this.parse(args, 0, args.length, false);
    }

    public CommandLine parse(String[] args, boolean stopAtNonOption) throws MissingArgumentException, UnrecognizedOptionException, MissingOptionException, AlreadySelectedException {
        return this.parse(args, 0, args.length, stopAtNonOption);
    }

    public CommandLine parse(String[] args, int fromIndex, int toIndex) throws MissingArgumentException, UnrecognizedOptionException, MissingOptionException, AlreadySelectedException {
        return this.parse(args, fromIndex, toIndex, false);
    }

    public CommandLine parse(String[] args, int fromIndex, int toIndex, boolean stopAtNonOption) throws MissingArgumentException, UnrecognizedOptionException, MissingOptionException, AlreadySelectedException {
        List<String> argList = Arrays.asList(args);
        return this.parse(argList, stopAtNonOption);
    }

    public CommandLine parse(List args) throws MissingArgumentException, UnrecognizedOptionException, MissingOptionException, AlreadySelectedException {
        return this.parse(args, false);
    }

    public CommandLine parse(List inArgs, boolean stopAtNonOption) throws MissingArgumentException, UnrecognizedOptionException, MissingOptionException, AlreadySelectedException {
        CommandLine cl = new CommandLine();
        List args = this.burst(inArgs, stopAtNonOption);
        ListIterator argIter = args.listIterator();
        String eachArg = null;
        Option eachOpt = null;
        boolean eatTheRest = false;
        while (argIter.hasNext()) {
            eachArg = (String)argIter.next();
            if (eachArg.equals("--")) {
                eatTheRest = true;
            } else if (eachArg.startsWith("--")) {
                eachOpt = (Option)this._longOpts.get(eachArg);
                this.processOption(eachArg, eachOpt, argIter, cl);
            } else if (eachArg.equals("-")) {
                if (stopAtNonOption) {
                    eatTheRest = true;
                } else {
                    cl.addArg(eachArg);
                }
            } else if (eachArg.startsWith("-")) {
                eachOpt = (Option)this._shortOpts.get(eachArg);
                this.processOption(eachArg, eachOpt, argIter, cl);
            } else {
                cl.addArg(eachArg);
                if (stopAtNonOption) {
                    eatTheRest = true;
                }
            }
            if (!eatTheRest) continue;
            while (argIter.hasNext()) {
                eachArg = (String)argIter.next();
                cl.addArg(eachArg);
            }
        }
        this.checkRequiredOptions();
        return cl;
    }

    private void checkRequiredOptions() throws MissingOptionException {
        if (this._requiredOpts.size() > 0) {
            Set optKeys = this._requiredOpts.keySet();
            Iterator iter = optKeys.iterator();
            StringBuffer buff = new StringBuffer();
            while (iter.hasNext()) {
                Option missing = (Option)this._requiredOpts.get(iter.next());
                buff.append("-");
                buff.append(missing.getOpt());
                buff.append(" ");
                buff.append(missing.getDescription());
            }
            throw new MissingOptionException(buff.toString());
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void processOption(String eachArg, Option option, ListIterator argIter, CommandLine cl) throws UnrecognizedOptionException, AlreadySelectedException, MissingArgumentException {
        if (option == null) {
            throw new UnrecognizedOptionException("Unrecognized option: " + eachArg);
        }
        if (this._optionGroups.get(option) != null) {
            ((OptionGroup)this._optionGroups.get(option)).setSelected(option);
        }
        if (option.isRequired()) {
            this._requiredOpts.remove("-" + option.getOpt());
        }
        if (option.hasArg()) {
            if (!argIter.hasNext()) throw new MissingArgumentException(eachArg + " requires an argument.");
            eachArg = (String)argIter.next();
            option.addValue(eachArg);
            if (option.hasMultipleArgs()) {
                while (argIter.hasNext()) {
                    eachArg = (String)argIter.next();
                    if (eachArg.startsWith("-")) {
                        argIter.previous();
                        cl.setOpt(option);
                        break;
                    }
                    option.addValue(eachArg);
                }
            } else {
                cl.setOpt(option);
                return;
            }
            if (argIter.hasNext()) return;
            cl.setOpt(option);
            return;
        }
        cl.setOpt(option);
    }

    private List burst(List inArgs, boolean stopAtNonOption) {
        LinkedList<String> args = new LinkedList<String>();
        Iterator argIter = inArgs.iterator();
        String eachArg = null;
        boolean eatTheRest = false;
        while (argIter.hasNext()) {
            eachArg = (String)argIter.next();
            if (eachArg.equals("--")) {
                args.add(eachArg);
                eatTheRest = true;
            } else if (eachArg.startsWith("--")) {
                args.add(eachArg);
            } else if (eachArg.startsWith("-")) {
                if (eachArg.length() == 1) {
                    if (stopAtNonOption) {
                        eatTheRest = true;
                    } else {
                        args.add(eachArg);
                    }
                } else if (eachArg.length() == 2) {
                    args.add(eachArg);
                } else {
                    int i = 1;
                    while (i < eachArg.length()) {
                        String optStr = "-" + eachArg.charAt(i);
                        Option opt = (Option)this._shortOpts.get(optStr);
                        if (opt != null && opt.hasArg()) {
                            args.add(optStr);
                            if (i + 1 < eachArg.length()) {
                                String optArg = eachArg.substring(i + 1);
                                args.add(optArg);
                            }
                            break;
                        }
                        args.add(optStr);
                        ++i;
                    }
                }
            } else {
                args.add(eachArg);
                if (stopAtNonOption) {
                    eatTheRest = true;
                }
            }
            if (!eatTheRest) continue;
            while (argIter.hasNext()) {
                args.add((String)argIter.next());
            }
        }
        return args;
    }

    private void addOption(Option opt) {
        String shortOptStr = "-" + opt.getOpt();
        if (opt.hasLongOpt()) {
            this._longOpts.put("--" + opt.getLongOpt(), opt);
        }
        if (opt.isRequired()) {
            this._requiredOpts.put("-" + opt.getOpt(), opt);
        }
        this._shortOpts.put("-" + opt.getOpt(), opt);
        this._options.add(opt);
    }

    public List getOptions() {
        return Collections.unmodifiableList(this._options);
    }

    public Option getOption(char opt) {
        return (Option)this._shortOpts.get("-" + opt);
    }

    public Option getOption(String longOpt) {
        return (Option)this._longOpts.get(longOpt);
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append("[ Options: [ short ");
        buf.append(this._shortOpts.toString());
        buf.append(" ] [ long ");
        buf.append(this._longOpts);
        buf.append(" ]");
        return buf.toString();
    }
}

