/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.debugger.jpda.visual.models;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.util.LinkedList;
import java.util.List;
import javax.swing.GroupLayout;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.LayoutStyle;
import javax.swing.event.TreeModelListener;
import javax.swing.table.TableModel;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;
import org.netbeans.swing.outline.CheckRenderDataProvider;
import org.netbeans.swing.outline.DefaultOutlineModel;
import org.netbeans.swing.outline.Outline;
import org.netbeans.swing.outline.OutlineModel;
import org.netbeans.swing.outline.RenderDataProvider;
import org.netbeans.swing.outline.RowModel;
import org.openide.util.NbBundle;

public class SelectEventsPanel
extends JPanel {
    private final List<Event> events = new LinkedList<Event>();
    private JScrollPane jScrollPane1;
    private JLabel selectLabel;
    private JTable table;

    public SelectEventsPanel() {
        this.initComponents();
    }

    public void setData(String[] names, boolean[] logging) {
        int n = names.length;
        for (int i = 0; i < n; ++i) {
            Event e = new Event(names[i], logging[i]);
            this.events.add(e);
        }
        OutlineModel om = DefaultOutlineModel.createOutlineModel((TreeModel)new EventsTreeModel(this.events), (RowModel)new EventsRowModel(this.events));
        this.table.setModel((TableModel)om);
        ((Outline)this.table).setRenderDataProvider((RenderDataProvider)new EventsDataProvider(this.events));
        this.table.setShowHorizontalLines(false);
        this.table.setTableHeader(null);
        ((Outline)this.table).setRootVisible(false);
    }

    public boolean[] getLoggingData() {
        int n = this.events.size();
        boolean[] logging = new boolean[n];
        int i = 0;
        for (Event e : this.events) {
            logging[i++] = e.isLogging;
        }
        return logging;
    }

    private void initComponents() {
        this.selectLabel = new JLabel();
        this.jScrollPane1 = new JScrollPane();
        this.table = new Outline();
        this.selectLabel.setText(NbBundle.getMessage(SelectEventsPanel.class, (String)"SelectEventsPanel.selectLabel.text"));
        this.jScrollPane1.setViewportView(this.table);
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jScrollPane1, -1, 376, Short.MAX_VALUE).addComponent(this.selectLabel)).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.selectLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jScrollPane1, -1, 267, Short.MAX_VALUE)));
    }

    private static final class EmptyIcon
    implements Icon {
        @Override
        public int getIconHeight() {
            return 0;
        }

        @Override
        public int getIconWidth() {
            return 0;
        }

        @Override
        public void paintIcon(Component c, Graphics g, int x, int y) {
        }
    }

    private static class Event {
        private String clazz;
        private boolean isLogging;

        private Event(String clazz, boolean isLogging) {
            this.clazz = clazz;
            this.isLogging = isLogging;
        }
    }

    private static final class EventsDataProvider
    implements CheckRenderDataProvider {
        private static final Icon EMPTY_ICON = new EmptyIcon();
        private List<Event> events;

        public EventsDataProvider(List<Event> events) {
            this.events = events;
        }

        public boolean isCheckable(Object o) {
            return true;
        }

        public boolean isCheckEnabled(Object o) {
            return true;
        }

        public Boolean isSelected(Object o) {
            return ((Event)o).isLogging;
        }

        public void setSelected(Object o, Boolean selected) {
            ((Event)o).isLogging = selected;
        }

        public String getDisplayName(Object o) {
            return ((Event)o).clazz;
        }

        public boolean isHtmlDisplayName(Object o) {
            return false;
        }

        public Color getBackground(Object o) {
            return null;
        }

        public Color getForeground(Object o) {
            return null;
        }

        public String getTooltipText(Object o) {
            return null;
        }

        public Icon getIcon(Object o) {
            return EMPTY_ICON;
        }
    }

    private static final class EventsRowModel
    implements RowModel {
        private final List<Event> events;

        private EventsRowModel(List<Event> events) {
            this.events = events;
        }

        public int getColumnCount() {
            return 0;
        }

        public Object getValueFor(Object node, int column) {
            return null;
        }

        public Class getColumnClass(int column) {
            return null;
        }

        public boolean isCellEditable(Object node, int column) {
            return false;
        }

        public void setValueFor(Object node, int column, Object value) {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        public String getColumnName(int column) {
            return "";
        }
    }

    private static final class EventsTreeModel
    implements TreeModel {
        private List<Event> events;

        public EventsTreeModel(List<Event> events) {
            this.events = events;
        }

        @Override
        public Object getRoot() {
            return "ROOT";
        }

        @Override
        public Object getChild(Object parent, int index) {
            return this.events.get(index);
        }

        @Override
        public int getChildCount(Object parent) {
            if (parent == "ROOT") {
                return this.events.size();
            }
            return 0;
        }

        @Override
        public boolean isLeaf(Object node) {
            return !"ROOT".equals(node);
        }

        @Override
        public void valueForPathChanged(TreePath path, Object newValue) {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        @Override
        public int getIndexOfChild(Object parent, Object child) {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        @Override
        public void addTreeModelListener(TreeModelListener l) {
        }

        @Override
        public void removeTreeModelListener(TreeModelListener l) {
        }
    }
}

