/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.debugger.jpda.visual.models;

import com.sun.jdi.AbsentInformationException;
import com.sun.jdi.ClassObjectReference;
import com.sun.jdi.ObjectReference;
import com.sun.jdi.ReferenceType;
import com.sun.jdi.VirtualMachine;
import java.awt.event.ActionEvent;
import java.beans.PropertyVetoException;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JList;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import org.netbeans.api.debugger.jpda.JPDADebugger;
import org.netbeans.modules.debugger.jpda.EditorContextBridge;
import org.netbeans.modules.debugger.jpda.JPDADebuggerImpl;
import org.netbeans.modules.debugger.jpda.jdi.InternalExceptionWrapper;
import org.netbeans.modules.debugger.jpda.jdi.ObjectCollectedExceptionWrapper;
import org.netbeans.modules.debugger.jpda.jdi.ObjectReferenceWrapper;
import org.netbeans.modules.debugger.jpda.jdi.ReferenceTypeWrapper;
import org.netbeans.modules.debugger.jpda.jdi.UnsupportedOperationExceptionWrapper;
import org.netbeans.modules.debugger.jpda.jdi.VMDisconnectedExceptionWrapper;
import org.netbeans.modules.debugger.jpda.jdi.VirtualMachineWrapper;
import org.netbeans.modules.debugger.jpda.visual.JavaComponentInfo;
import org.netbeans.modules.debugger.jpda.visual.RemoteServices;
import org.netbeans.modules.debugger.jpda.visual.actions.GoToSourceAction;
import org.netbeans.modules.debugger.jpda.visual.models.SelectEventsPanel;
import org.netbeans.modules.debugger.jpda.visual.spi.ComponentInfo;
import org.netbeans.modules.debugger.jpda.visual.spi.ScreenshotUIManager;
import org.netbeans.spi.debugger.ContextProvider;
import org.netbeans.spi.viewmodel.ModelEvent;
import org.netbeans.spi.viewmodel.ModelListener;
import org.netbeans.spi.viewmodel.NodeActionsProvider;
import org.netbeans.spi.viewmodel.NodeModel;
import org.netbeans.spi.viewmodel.TableModel;
import org.netbeans.spi.viewmodel.TreeExpansionModel;
import org.netbeans.spi.viewmodel.TreeExpansionModelFilter;
import org.netbeans.spi.viewmodel.TreeModel;
import org.netbeans.spi.viewmodel.UnknownTypeException;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.nodes.Node;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;
import org.openide.util.LookupEvent;
import org.openide.util.LookupListener;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;

public class EventsModel
implements TreeModel,
NodeModel,
TableModel,
NodeActionsProvider,
TreeExpansionModelFilter {
    private static final String customListeners = "customListeners";
    private static final String swingListeners = "swingListeners";
    private static final String eventsLog = "eventsLog";
    private Set<ModelListener> listeners = new CopyOnWriteArraySet<ModelListener>();
    private JavaComponentInfo selectedCI = null;
    private final List<RemoteEvent> events = new ArrayList<RemoteEvent>();
    private volatile List<RemoteServices.RemoteListener> customListenersList;
    private volatile List<RemoteServices.RemoteListener> swingListenersList;
    private JPDADebugger debugger;
    private final Map<ObjectReference, Set<LoggingEventListener>> loggingListeners = new HashMap<ObjectReference, Set<LoggingEventListener>>();
    private boolean customListenersExpanded = true;
    private boolean eventsExpanded = true;

    public EventsModel(ContextProvider contextProvider) {
        ComponentInfo ci;
        this.debugger = (JPDADebugger)contextProvider.lookupFirst(null, JPDADebugger.class);
        ScreenshotUIManager uiManager = ScreenshotUIManager.getActive();
        if (uiManager != null && (ci = uiManager.getSelectedComponent()) instanceof JavaComponentInfo) {
            this.selectedCI = (JavaComponentInfo)ci;
        }
        final Lookup.Result nodeLookupResult = Utilities.actionsGlobalContext().lookupResult(Node.class);
        LookupListener ll = new LookupListener(){

            public void resultChanged(LookupEvent ev) {
                Collection nodeInstances = nodeLookupResult.allInstances();
                for (Node n : nodeInstances) {
                    JavaComponentInfo ci = (JavaComponentInfo)n.getLookup().lookup(JavaComponentInfo.class);
                    if (ci == null) continue;
                    if (ci.equals(EventsModel.this.selectedCI)) break;
                    EventsModel.this.selectedCI = ci;
                    if (ev == null) break;
                    EventsModel.this.fireModelChanged();
                    break;
                }
            }
        };
        nodeLookupResult.addLookupListener(ll);
        ll.resultChanged(null);
    }

    public Object getRoot() {
        return "Root";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object[] getChildren(Object parent, int from, int to) throws UnknownTypeException {
        if (parent == "Root") {
            JavaComponentInfo ci = this.selectedCI;
            if (ci != null) {
                List<RemoteServices.RemoteListener> componentListeners;
                String componentName = ci.getDisplayName();
                try {
                    componentListeners = RemoteServices.getAttachedListeners(ci, true);
                }
                catch (PropertyVetoException pvex) {
                    Exceptions.printStackTrace((Throwable)pvex);
                    return new Object[0];
                }
                Set<LoggingEventListener> lls = null;
                Map<ObjectReference, Set<LoggingEventListener>> map = this.loggingListeners;
                synchronized (map) {
                    lls = this.loggingListeners.get(ci.getComponent());
                    if (lls != null) {
                        lls = new HashSet<LoggingEventListener>(lls);
                    }
                }
                ArrayList<RemoteServices.RemoteListener> cll = new ArrayList<RemoteServices.RemoteListener>(componentListeners.size());
                ArrayList<RemoteServices.RemoteListener> sll = new ArrayList<RemoteServices.RemoteListener>(componentListeners.size());
                for (RemoteServices.RemoteListener rl : componentListeners) {
                    ObjectReference listener = rl.getListener();
                    if (lls != null) {
                        boolean isLogging = false;
                        for (LoggingEventListener ll : lls) {
                            if (!((Object)listener).equals(ll.getListenerObject())) continue;
                            isLogging = true;
                            break;
                        }
                        if (isLogging) continue;
                    }
                    try {
                        String type = ReferenceTypeWrapper.name((ReferenceType)ObjectReferenceWrapper.referenceType((ObjectReference)listener));
                        if (JavaComponentInfo.isCustomType(type)) {
                            cll.add(rl);
                            continue;
                        }
                        sll.add(rl);
                    }
                    catch (InternalExceptionWrapper iex) {
                    }
                    catch (ObjectCollectedExceptionWrapper ocex) {
                    }
                    catch (VMDisconnectedExceptionWrapper vmdex) {}
                }
                this.customListenersList = cll;
                this.swingListenersList = sll;
                return new Object[]{componentName, customListeners, swingListeners, eventsLog};
            }
            this.customListenersList = null;
            this.swingListenersList = null;
            return new Object[0];
        }
        if (parent == customListeners) {
            return this.customListenersList.toArray();
        }
        if (parent == swingListeners) {
            return this.swingListenersList.toArray();
        }
        if (parent instanceof ListenerCategory) {
            return ((ListenerCategory)parent).getListeners().toArray();
        }
        if (parent == eventsLog) {
            List<RemoteEvent> list = this.events;
            synchronized (list) {
                return this.events.toArray();
            }
        }
        if (parent instanceof RemoteEvent) {
            return ((RemoteEvent)parent).getPropertiesWithStackNode();
        }
        if (parent instanceof Stack) {
            return ((Stack)parent).getStackElements();
        }
        return new Object[0];
    }

    public boolean isLeaf(Object node) throws UnknownTypeException {
        if (node == "Root" || node == eventsLog) {
            return false;
        }
        if (node == customListeners) {
            return false;
        }
        if (node == swingListeners) {
            return false;
        }
        if (node instanceof RemoteServices.RemoteListener) {
            return true;
        }
        if (node instanceof Stack.Element) {
            return true;
        }
        return node instanceof String;
    }

    public int getChildrenCount(Object node) throws UnknownTypeException {
        return Integer.MAX_VALUE;
    }

    public void addModelListener(ModelListener l) {
        this.listeners.add(l);
    }

    public void removeModelListener(ModelListener l) {
        this.listeners.remove(l);
    }

    private void fireModelChanged() {
        ModelEvent.TreeChanged me = new ModelEvent.TreeChanged((Object)this);
        for (ModelListener l : this.listeners) {
            l.modelChanged((ModelEvent)me);
        }
    }

    private void fireNodeChanged(Object node) {
        ModelEvent.NodeChanged me = new ModelEvent.NodeChanged((Object)this, node);
        for (ModelListener l : this.listeners) {
            l.modelChanged((ModelEvent)me);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addEvent(RemoteEvent re) {
        List<RemoteEvent> list = this.events;
        synchronized (list) {
            this.events.add(re);
        }
        this.fireNodeChanged(eventsLog);
    }

    public String getDisplayName(Object node) throws UnknownTypeException {
        if (node == "Root") {
            return "Events";
        }
        if (node == customListeners) {
            return NbBundle.getMessage(EventsModel.class, (String)"CTL_CustomListeners");
        }
        if (node == swingListeners) {
            return NbBundle.getMessage(EventsModel.class, (String)"CTL_InternalListeners");
        }
        if (node == eventsLog) {
            return NbBundle.getMessage(EventsModel.class, (String)"CTL_EventLog");
        }
        if (node instanceof ListenerCategory) {
            return ((ListenerCategory)node).getType();
        }
        if (node instanceof RemoteServices.RemoteListener) {
            return ((RemoteServices.RemoteListener)node).getListener().referenceType().name();
        }
        if (node instanceof RemoteEvent) {
            RemoteEvent re = (RemoteEvent)node;
            String toString = re.getEventToString();
            int end = toString.indexOf(91);
            if (end < 0) {
                end = toString.length();
            }
            return re.getListenerMethod() + " (" + toString.substring(0, end) + ')';
        }
        if (node instanceof Stack) {
            return NbBundle.getMessage(EventsModel.class, (String)"CTL_CalledFrom");
        }
        if (node instanceof Stack.Element) {
            Stack.Element e = (Stack.Element)node;
            return "<html>" + e.getClassName() + ".<b>" + e.getMethodName() + "</b>(<font color=\"#0000FF\">" + e.getFileName() + ":" + e.getLineNumber() + "</font>)</html>";
        }
        return String.valueOf(node);
    }

    public String getIconBase(Object node) throws UnknownTypeException {
        return null;
    }

    public String getShortDescription(Object node) throws UnknownTypeException {
        if (node instanceof RemoteServices.RemoteListener) {
            try {
                return ReferenceTypeWrapper.sourceName((ReferenceType)ObjectReferenceWrapper.referenceType((ObjectReference)((RemoteServices.RemoteListener)node).getListener()));
            }
            catch (InternalExceptionWrapper ex) {
                return ex.getLocalizedMessage();
            }
            catch (VMDisconnectedExceptionWrapper ex) {
                return "";
            }
            catch (ObjectCollectedExceptionWrapper ex) {
                return ex.getLocalizedMessage();
            }
            catch (AbsentInformationException ex) {
                return "";
            }
        }
        if (node instanceof RemoteEvent) {
            RemoteEvent re = (RemoteEvent)node;
            return re.getEventToString();
        }
        return "";
    }

    public void performDefaultAction(Object node) throws UnknownTypeException {
        if (node == eventsLog) {
            new SetLoggingEvents().actionPerformed(null);
        }
        if (node instanceof Stack.Element) {
            final Stack.Element e = (Stack.Element)node;
            String type = e.getClassName();
            type = EditorContextBridge.getRelativePath((String)type);
            final String url = ((JPDADebuggerImpl)this.debugger).getEngineContext().getURL(type, true);
            if (url != null) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        EditorContextBridge.getContext().showSource(url, e.getLineNumber(), null);
                    }
                });
            }
        }
    }

    public Action[] getActions(Object node) throws UnknownTypeException {
        if (this.selectedCI != null) {
            if (node == customListeners) {
                return new Action[]{new SetLoggingEvents()};
            }
            if (node == eventsLog) {
                return new Action[]{new SetLoggingEvents(), null, new ClearEventsAction()};
            }
            if (node instanceof ListenerCategory) {
                return new Action[]{new AddLoggingListenerAction((ListenerCategory)node)};
            }
            if (node instanceof RemoteServices.RemoteListener) {
                return new Action[]{GoToSourceAction.get(GoToSourceAction.class)};
            }
        }
        return new Action[0];
    }

    public boolean isExpanded(TreeExpansionModel original, Object node) throws UnknownTypeException {
        if (node == customListeners) {
            return this.customListenersExpanded;
        }
        if (node == eventsLog) {
            return this.eventsExpanded;
        }
        return original.isExpanded(node);
    }

    public void nodeExpanded(Object node) {
        if (node == customListeners) {
            this.customListenersExpanded = true;
        } else if (node == eventsLog) {
            this.eventsExpanded = true;
        }
    }

    public void nodeCollapsed(Object node) {
        if (node == customListeners) {
            this.customListenersExpanded = false;
        } else if (node == eventsLog) {
            this.eventsExpanded = false;
        }
    }

    public Object getValueAt(Object node, String columnID) throws UnknownTypeException {
        if ("EventsViewTypeColumn".equals(columnID)) {
            if (node instanceof RemoteServices.RemoteListener) {
                String[] types = ((RemoteServices.RemoteListener)node).getTypes();
                if (types.length == 1) {
                    return types[0];
                }
                StringBuilder sb = new StringBuilder(types[0]);
                for (int i = 1; i < types.length; ++i) {
                    sb.append(", ");
                    sb.append(types[i]);
                }
                return sb.toString();
            }
            return "";
        }
        throw new UnknownTypeException((Object)("Unknown column: " + columnID));
    }

    public boolean isReadOnly(Object node, String columnID) throws UnknownTypeException {
        return true;
    }

    public void setValueAt(Object node, String columnID, Object value) throws UnknownTypeException {
        throw new IllegalStateException("Is read only.");
    }

    private class AddLoggingListenerAction
    extends AbstractAction {
        private ListenerCategory lc;

        public AddLoggingListenerAction(ListenerCategory lc) {
            this.lc = lc;
        }

        @Override
        public Object getValue(String key) {
            if ("Name".equals(key)) {
                return "Add Logging Listener" + (this.lc == null ? "..." : "");
            }
            return super.getValue(key);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            String listenerClass;
            final JavaComponentInfo ci = EventsModel.this.selectedCI;
            if (ci == null) {
                return;
            }
            if (this.lc != null) {
                listenerClass = this.lc.getType();
            } else {
                listenerClass = this.selectListenerClass(ci);
                if (listenerClass == null) {
                    return;
                }
            }
            final ReferenceType rt = this.getReferenceType(ci.getComponent().virtualMachine(), listenerClass);
            if (rt == null) {
                System.err.println("No class " + listenerClass);
                return;
            }
            ci.getThread().getDebugger().getRequestProcessor().post(new Runnable(){

                @Override
                public void run() {
                    ObjectReference l;
                    try {
                        ClassObjectReference cor = ReferenceTypeWrapper.classObject((ReferenceType)rt);
                        l = RemoteServices.attachLoggingListener(ci, cor, new LoggingEventListener(EventsModel.this));
                    }
                    catch (PropertyVetoException pvex) {
                        Exceptions.printStackTrace((Throwable)pvex);
                        return;
                    }
                    catch (InternalExceptionWrapper iex) {
                        return;
                    }
                    catch (ObjectCollectedExceptionWrapper ocex) {
                        Exceptions.printStackTrace((Throwable)ocex);
                        return;
                    }
                    catch (UnsupportedOperationExceptionWrapper uex) {
                        Exceptions.printStackTrace((Throwable)uex);
                        return;
                    }
                    catch (VMDisconnectedExceptionWrapper vmdex) {
                        return;
                    }
                    if (l != null) {
                        if (AddLoggingListenerAction.this.lc != null) {
                            String name;
                            try {
                                name = ReferenceTypeWrapper.name((ReferenceType)ObjectReferenceWrapper.referenceType((ObjectReference)l));
                            }
                            catch (InternalExceptionWrapper ex) {
                                return;
                            }
                            catch (VMDisconnectedExceptionWrapper ex) {
                                return;
                            }
                            catch (ObjectCollectedExceptionWrapper ex) {
                                Exceptions.printStackTrace((Throwable)ex);
                                return;
                            }
                            AddLoggingListenerAction.this.lc.addListener(new RemoteServices.RemoteListener(name, l));
                            EventsModel.this.fireNodeChanged(AddLoggingListenerAction.this.lc);
                        } else {
                            EventsModel.this.fireNodeChanged(EventsModel.customListeners);
                        }
                    }
                }
            });
        }

        private ReferenceType getReferenceType(VirtualMachine vm, String name) {
            ReferenceType clazz = null;
            try {
                List classList = VirtualMachineWrapper.classesByName((VirtualMachine)vm, (String)name);
                Iterator i$ = classList.iterator();
                while (i$.hasNext()) {
                    ReferenceType c;
                    clazz = c = (ReferenceType)i$.next();
                    if (ReferenceTypeWrapper.classLoader((ReferenceType)c) != null) continue;
                    break;
                }
            }
            catch (ObjectCollectedExceptionWrapper ocex) {
            }
            catch (InternalExceptionWrapper ex) {
            }
            catch (VMDisconnectedExceptionWrapper ex) {
                // empty catch block
            }
            return clazz;
        }

        private String selectListenerClass(JavaComponentInfo ci) {
            List<ReferenceType> attachableListeners = RemoteServices.getAttachableListeners(ci);
            String[] listData = new String[attachableListeners.size()];
            for (int i = 0; i < listData.length; ++i) {
                listData[i] = attachableListeners.get(i).name();
            }
            JList<String> jl = new JList<String>(listData);
            JScrollPane jsp = new JScrollPane(jl);
            DialogDescriptor nd = new DialogDescriptor((Object)jsp, NbBundle.getMessage(EventsModel.class, (String)"TTL_SelectListener"), true, null);
            Object res = DialogDisplayer.getDefault().notify((NotifyDescriptor)nd);
            if (DialogDescriptor.OK_OPTION.equals(res)) {
                String clazz = jl.getSelectedValue();
                return clazz;
            }
            return null;
        }
    }

    private class ClearEventsAction
    extends AbstractAction {
        private ClearEventsAction() {
        }

        @Override
        public Object getValue(String key) {
            if ("Name".equals(key)) {
                return NbBundle.getMessage(EventsModel.class, (String)"CTL_ClearEvents");
            }
            return super.getValue(key);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void actionPerformed(ActionEvent e) {
            List list = EventsModel.this.events;
            synchronized (list) {
                EventsModel.this.events.clear();
            }
            EventsModel.this.fireNodeChanged(EventsModel.eventsLog);
        }
    }

    private static class ListenerCategory {
        private String type;
        private List<RemoteServices.RemoteListener> listeners = new ArrayList<RemoteServices.RemoteListener>();

        public ListenerCategory(String type) {
            this.type = type;
        }

        public String getType() {
            return this.type;
        }

        public void addListener(RemoteServices.RemoteListener l) {
            this.listeners.add(l);
        }

        public List<RemoteServices.RemoteListener> getListeners() {
            return this.listeners;
        }
    }

    private static class LoggingEventListener
    implements RemoteServices.LoggingListenerCallBack {
        private ObjectReference listener;
        private ClassObjectReference listenerClass;
        private final Reference<EventsModel> modelRef;

        public LoggingEventListener(EventsModel model) {
            this.modelRef = new WeakReference<EventsModel>(model);
        }

        @Override
        public void eventsData(String[] data, String[] stack) {
            RemoteEvent re = new RemoteEvent(data, stack);
            EventsModel model = this.modelRef.get();
            if (model != null) {
                model.addEvent(re);
            }
        }

        private void setListenerObject(ObjectReference listener, ClassObjectReference listenerClass) {
            this.listener = listener;
            this.listenerClass = listenerClass;
        }

        public ObjectReference getListenerObject() {
            return this.listener;
        }

        public ClassObjectReference getListenerClass() {
            return this.listenerClass;
        }
    }

    private static class RemoteEvent {
        private String[] data;
        private Stack stack;

        public RemoteEvent(String[] data, String[] stack) {
            this.data = data;
            this.stack = new Stack(stack);
        }

        public String getListenerMethod() {
            return this.data[0];
        }

        public String getEventToString() {
            return this.data[1];
        }

        public Object[] getPropertiesWithStackNode() {
            int propertiesLength = this.data.length / 2 - 1;
            Object[] properties = new Object[propertiesLength + 1];
            for (int i = 0; i < propertiesLength; ++i) {
                properties[i + 1] = this.data[2 + 2 * i] + " = " + this.data[3 + 2 * i];
            }
            properties[0] = this.stack;
            return properties;
        }

        public Stack getStack() {
            return this.stack;
        }
    }

    private class SetLoggingEvents
    extends AbstractAction {
        @Override
        public Object getValue(String key) {
            if ("Name".equals(key)) {
                return NbBundle.getMessage(EventsModel.class, (String)"CTL_SetLoggingEvents");
            }
            return super.getValue(key);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            final JavaComponentInfo ci = EventsModel.this.selectedCI;
            if (ci == null) {
                return;
            }
            final ArrayList<LoggingEventListener> listenersToRemove = new ArrayList<LoggingEventListener>();
            final ReferenceType[] listenerClasses = this.selectListenerClass(ci, listenersToRemove);
            if (listenerClasses == null) {
                return;
            }
            ci.getThread().getDebugger().getRequestProcessor().post(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    boolean fire = false;
                    for (ReferenceType rt : listenerClasses) {
                        ObjectReference l;
                        try {
                            LoggingEventListener listener = new LoggingEventListener(EventsModel.this);
                            ClassObjectReference cor = ReferenceTypeWrapper.classObject((ReferenceType)rt);
                            l = RemoteServices.attachLoggingListener(ci, cor, listener);
                            listener.setListenerObject(l, cor);
                            Map map = EventsModel.this.loggingListeners;
                            synchronized (map) {
                                HashSet<LoggingEventListener> listeners = (HashSet<LoggingEventListener>)EventsModel.this.loggingListeners.get(ci.getComponent());
                                if (listeners == null) {
                                    listeners = new HashSet<LoggingEventListener>();
                                    EventsModel.this.loggingListeners.put(ci.getComponent(), listeners);
                                }
                                listeners.add(listener);
                            }
                        }
                        catch (PropertyVetoException pvex) {
                            Exceptions.printStackTrace((Throwable)pvex);
                            return;
                        }
                        catch (InternalExceptionWrapper iex) {
                            return;
                        }
                        catch (ObjectCollectedExceptionWrapper ocex) {
                            Exceptions.printStackTrace((Throwable)ocex);
                            return;
                        }
                        catch (UnsupportedOperationExceptionWrapper uex) {
                            Exceptions.printStackTrace((Throwable)uex);
                            return;
                        }
                        catch (VMDisconnectedExceptionWrapper vmdex) {
                            return;
                        }
                        if (l == null) continue;
                        fire = true;
                    }
                    for (LoggingEventListener ll : listenersToRemove) {
                        try {
                            boolean detached = RemoteServices.detachLoggingListener(ci, ll.getListenerClass(), ll.getListenerObject());
                            Map map = EventsModel.this.loggingListeners;
                            synchronized (map) {
                                Set listeners = (Set)EventsModel.this.loggingListeners.get(ci.getComponent());
                                if (listeners != null) {
                                    listeners.remove(ll);
                                    if (listeners.isEmpty()) {
                                        EventsModel.this.loggingListeners.remove(ci.getComponent());
                                    }
                                }
                            }
                        }
                        catch (PropertyVetoException ex) {
                            Exceptions.printStackTrace((Throwable)ex);
                            return;
                        }
                    }
                    if (fire) {
                        EventsModel.this.fireNodeChanged(EventsModel.customListeners);
                    }
                }
            });
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private ReferenceType[] selectListenerClass(JavaComponentInfo ci, Collection<LoggingEventListener> listenersToRemove) {
            List<ReferenceType> attachableListeners = RemoteServices.getAttachableListeners(ci);
            HashSet currentLoggingListeners = null;
            Map map = EventsModel.this.loggingListeners;
            synchronized (map) {
                Set listeners = (Set)EventsModel.this.loggingListeners.get(ci.getComponent());
                if (listeners != null) {
                    currentLoggingListeners = new HashSet(listeners);
                }
            }
            String[] listData = new String[attachableListeners.size()];
            boolean[] logging = new boolean[listData.length];
            LoggingEventListener[] loggingListeners = null;
            if (currentLoggingListeners != null) {
                loggingListeners = new LoggingEventListener[listData.length];
            }
            for (int i = 0; i < listData.length; ++i) {
                ReferenceType rt = attachableListeners.get(i);
                listData[i] = rt.name();
                if (currentLoggingListeners == null) continue;
                for (LoggingEventListener ll : currentLoggingListeners) {
                    if (!((Object)rt).equals(ll.getListenerClass().reflectedType())) continue;
                    logging[i] = true;
                    loggingListeners[i] = ll;
                }
            }
            SelectEventsPanel sep = new SelectEventsPanel();
            sep.setData(listData, logging);
            DialogDescriptor nd = new DialogDescriptor((Object)sep, NbBundle.getMessage(EventsModel.class, (String)"TTL_SelectListener"), true, null);
            Object res = DialogDisplayer.getDefault().notify((NotifyDescriptor)nd);
            if (DialogDescriptor.OK_OPTION.equals(res)) {
                boolean[] loggingData = sep.getLoggingData();
                int na = 0;
                for (int i = 0; i < loggingData.length; ++i) {
                    if (!loggingData[i] || logging[i]) continue;
                    ++na;
                }
                ReferenceType[] listenersToAdd = new ReferenceType[na];
                int lai = 0;
                for (int i = 0; i < listData.length; ++i) {
                    if (loggingData[i] && !logging[i]) {
                        listenersToAdd[lai++] = attachableListeners.get(i);
                    }
                    if (loggingData[i] || !logging[i]) continue;
                    listenersToRemove.add(loggingListeners[i]);
                }
                return listenersToAdd;
            }
            return null;
        }
    }

    private static class Stack {
        private String[] stack;
        private String listener = null;
        private Element[] elements = null;

        public Stack(String[] stack) {
            this.stack = stack;
        }

        public synchronized Element[] getStackElements() {
            if (this.elements == null) {
                this.elements = new Element[this.stack.length - 1];
                for (int i = 1; i < this.stack.length; ++i) {
                    this.elements[i - 1] = new Element(this.stack[i]);
                }
            }
            return this.elements;
        }

        static class Element {
            private String line;
            private boolean parsed = false;
            private String className;
            private String methodName;
            private String fileName;
            private int lineNumber;

            public Element(String line) {
                this.line = line;
            }

            private synchronized void parse() {
                if (this.parsed) {
                    return;
                }
                int i = this.line.indexOf(40);
                int mi = this.line.substring(0, i).lastIndexOf(46);
                int ci = this.line.lastIndexOf(58);
                this.className = this.line.substring(0, mi);
                this.methodName = this.line.substring(mi + 1, i);
                this.fileName = this.line.substring(i + 1, ci);
                String lineStr = this.line.substring(ci + 1, this.line.length() - 1);
                this.lineNumber = Integer.parseInt(lineStr);
            }

            public String getClassName() {
                this.parse();
                return this.className;
            }

            public String getMethodName() {
                this.parse();
                return this.methodName;
            }

            public String getFileName() {
                this.parse();
                return this.fileName;
            }

            public int getLineNumber() {
                this.parse();
                return this.lineNumber;
            }
        }
    }
}

