/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.debugger.jpda.visual.actions;

import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.concurrent.Future;
import javax.swing.SwingUtilities;
import org.netbeans.api.debugger.DebuggerEngine;
import org.netbeans.api.debugger.DebuggerManager;
import org.netbeans.api.debugger.jpda.JPDADebugger;
import org.netbeans.modules.debugger.jpda.EditorContextBridge;
import org.netbeans.modules.debugger.jpda.JPDADebuggerImpl;
import org.netbeans.modules.debugger.jpda.visual.JavaComponentInfo;
import org.netbeans.modules.debugger.jpda.visual.RemoteServices;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.URLMapper;
import org.openide.nodes.Node;
import org.openide.util.Exceptions;
import org.openide.util.HelpCtx;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.util.actions.NodeAction;

public class GoToSourceAction
extends NodeAction {
    static RequestProcessor RP = new RequestProcessor("Go to Source");

    protected void performAction(Node[] activatedNodes) {
        for (Node n : activatedNodes) {
            RemoteServices.RemoteListener rl;
            JavaComponentInfo ci = (JavaComponentInfo)n.getLookup().lookup(JavaComponentInfo.class);
            if (ci != null) {
                final String type = ci.getType();
                RP.post(new Runnable(){

                    @Override
                    public void run() {
                        GoToSourceAction.this.showSource(type);
                    }
                });
            }
            if ((rl = (RemoteServices.RemoteListener)n.getLookup().lookup(RemoteServices.RemoteListener.class)) == null) continue;
            final String clazz = rl.getListener().referenceType().name();
            RP.post(new Runnable(){

                @Override
                public void run() {
                    GoToSourceAction.this.showSource(clazz);
                }
            });
        }
    }

    private void showSource(final String type) {
        DebuggerEngine engine = DebuggerManager.getDebuggerManager().getCurrentEngine();
        if (engine != null) {
            JPDADebugger debugger = (JPDADebugger)engine.lookupFirst(null, JPDADebugger.class);
            final String typePath = EditorContextBridge.getRelativePath((String)type);
            final String url = ((JPDADebuggerImpl)debugger).getEngineContext().getURL(typePath, true);
            final int lineNumber = GoToSourceAction.findClassLine(url, type);
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    boolean success = EditorContextBridge.getContext().showSource(url, lineNumber, null);
                    if (!success) {
                        NotifyDescriptor.Message d = new NotifyDescriptor.Message((Object)NbBundle.getMessage(GoToSourceAction.class, (String)"MSG_NoSourceFile", (Object)typePath, (Object)type), 2);
                        DialogDisplayer.getDefault().notifyLater((NotifyDescriptor)d);
                    }
                }
            });
        }
    }

    private static int findClassLine(String url, String clazz) {
        Class<?> editorContextImpl;
        FileObject fo;
        try {
            fo = URLMapper.findFileObject((URL)new URL(url));
        }
        catch (MalformedURLException ex) {
            return 1;
        }
        String editorContextImplName = "org.netbeans.modules.debugger.jpda.projects.EditorContextImpl";
        try {
            editorContextImpl = Thread.currentThread().getContextClassLoader().loadClass(editorContextImplName);
        }
        catch (ClassNotFoundException cnfex) {
            ClassLoader cl = (ClassLoader)Lookup.getDefault().lookup(ClassLoader.class);
            if (cl == null) {
                return 1;
            }
            try {
                editorContextImpl = cl.loadClass(editorContextImplName);
            }
            catch (ClassNotFoundException ex) {
                Exceptions.printStackTrace((Throwable)ex);
                return 1;
            }
        }
        try {
            Method getClassLineNumber = editorContextImpl.getDeclaredMethod("getClassLineNumber", FileObject.class, String.class, String[].class);
            getClassLineNumber.setAccessible(true);
            Future lineNumberFuture = (Future)getClassLineNumber.invoke(null, fo, clazz, new String[0]);
            if (lineNumberFuture == null) {
                return 1;
            }
            Integer line = (Integer)lineNumberFuture.get();
            if (line == null) {
                return 1;
            }
            return line;
        }
        catch (Exception ex) {
            Exceptions.printStackTrace((Throwable)ex);
            return 1;
        }
    }

    protected boolean enable(Node[] activatedNodes) {
        boolean enabled = false;
        for (Node n : activatedNodes) {
            JavaComponentInfo ci = (JavaComponentInfo)n.getLookup().lookup(JavaComponentInfo.class);
            if (ci != null) {
                enabled = true;
                break;
            }
            RemoteServices.RemoteListener rl = (RemoteServices.RemoteListener)n.getLookup().lookup(RemoteServices.RemoteListener.class);
            if (rl == null) continue;
            enabled = true;
            break;
        }
        return enabled;
    }

    public String getName() {
        return NbBundle.getMessage(GoToSourceAction.class, (String)"CTL_GoToSource");
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx(GoToSourceAction.class);
    }
}

