/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.profiler.ppoints.ui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import org.netbeans.lib.profiler.ui.UIConstants;
import org.netbeans.lib.profiler.ui.UIUtils;
import org.netbeans.lib.profiler.ui.components.JExtendedTable;
import org.netbeans.lib.profiler.ui.components.ProfilerToolbar;
import org.netbeans.lib.profiler.ui.components.table.EnhancedTableCellRenderer;
import org.netbeans.lib.profiler.ui.components.table.ExtendedTableModel;
import org.netbeans.lib.profiler.ui.components.table.JExtendedTablePanel;
import org.netbeans.lib.profiler.ui.components.table.SortableTableModel;
import org.netbeans.modules.profiler.api.ProfilerDialogs;
import org.netbeans.modules.profiler.api.ProfilerIDESettings;
import org.netbeans.modules.profiler.api.ProjectUtilities;
import org.netbeans.modules.profiler.api.icons.Icons;
import org.netbeans.modules.profiler.ppoints.CodeProfilingPoint;
import org.netbeans.modules.profiler.ppoints.ProfilingPoint;
import org.netbeans.modules.profiler.ppoints.ProfilingPointsManager;
import org.netbeans.modules.profiler.ppoints.Utils;
import org.netbeans.modules.profiler.ppoints.ui.Bundle;
import org.netbeans.modules.profiler.ppoints.ui.InsertProfilingPointAction;
import org.netbeans.modules.profiler.ppoints.ui.ProfilingPointsUIHelper;
import org.openide.awt.Mnemonics;
import org.openide.util.Lookup;
import org.openide.util.actions.SystemAction;

public class ProfilingPointsWindowUI
extends JPanel
implements ActionListener,
ListSelectionListener,
PropertyChangeListener,
MouseListener,
MouseMotionListener,
KeyListener {
    private static final Icon PPOINT_ADD_ICON = Icons.getIcon((String)"ProfilingPointsIcons.Add");
    private static final Icon PPOINT_REMOVE_ICON = Icons.getIcon((String)"ProfilingPointsIcons.Remove");
    private static final Icon PPOINT_EDIT_ICON = Icons.getIcon((String)"ProfilingPointsIcons.Edit");
    private static final Icon PPOINT_ENABLE_DISABLE_ICON = Icons.getIcon((String)"ProfilingPointsIcons.EnableDisable");
    protected String[] columnNames;
    protected TableCellRenderer[] columnRenderers;
    protected String[] columnToolTips;
    protected Class[] columnTypes;
    protected int[] columnWidths;
    protected boolean sortOrder;
    protected int sortBy;
    private ExtendedTableModel profilingPointsTableModel;
    private JButton addButton;
    private JButton disableButton;
    private JButton editButton;
    private JButton removeButton;
    private JCheckBox dependenciesCheckbox;
    private JComboBox projectsCombo;
    private JExtendedTable profilingPointsTable;
    private JLabel projectLabel;
    private JMenuItem disableItem;
    private JMenuItem editItem;
    private JMenuItem enableDisableItem;
    private JMenuItem enableItem;
    private JMenuItem removeItem;
    private JMenuItem showEndInSourceItem;
    private JMenuItem showInSourceItem;
    private JMenuItem showReportItem;
    private JMenuItem showStartInSourceItem;
    private JPopupMenu profilingPointsPopup;
    private ProfilingPoint[] profilingPoints = new ProfilingPoint[0];
    private boolean profilingInProgress = false;
    private int initialSortingColumn;
    private int minProfilingPointColumnWidth;
    private boolean internalComboChange;

    public ProfilingPointsWindowUI() {
        this.setDefaultSorting();
        this.initColumnsData();
        this.initComponents();
        this.updateProjectsCombo();
        this.updateButtons();
        ProfilingPointsManager.getDefault().addPropertyChangeListener(this);
    }

    public void setDefaultSorting() {
        this.setSorting(1, true);
    }

    public Lookup.Provider getSelectedProject() {
        return this.projectsCombo.getSelectedItem() instanceof Lookup.Provider ? (Lookup.Provider)this.projectsCombo.getSelectedItem() : null;
    }

    public void setSorting(int sColumn, boolean sOrder) {
        if (sColumn == -1) {
            this.setDefaultSorting();
        } else {
            this.initialSortingColumn = sColumn;
            this.sortBy = this.getSortBy(this.initialSortingColumn);
            this.sortOrder = sOrder;
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.projectsCombo) {
            if (!this.internalComboChange) {
                this.refreshProfilingPoints();
            }
        } else if (e.getSource() == this.addButton) {
            ((InsertProfilingPointAction)SystemAction.get(InsertProfilingPointAction.class)).performAction(this.getSelectedProject());
        } else if (e.getSource() == this.removeButton) {
            int[] selectedRows = this.profilingPointsTable.getSelectedRows();
            ProfilingPoint[] selectedProfilingPoints = new ProfilingPoint[selectedRows.length];
            for (int i = 0; i < selectedRows.length; ++i) {
                selectedProfilingPoints[i] = this.getProfilingPointAt(selectedRows[i]);
            }
            ProfilingPointsManager.getDefault().removeProfilingPoints(selectedProfilingPoints);
        } else if (e.getSource() == this.editButton) {
            ProfilingPoint selectedProfilingPoint = this.getProfilingPointAt(this.profilingPointsTable.getSelectedRow());
            selectedProfilingPoint.customize(false, false);
        } else if (e.getSource() == this.disableButton) {
            int[] selectedRows;
            for (int i : selectedRows = this.profilingPointsTable.getSelectedRows()) {
                ProfilingPoint selectedProfilingPoint;
                selectedProfilingPoint.setEnabled(!(selectedProfilingPoint = this.getProfilingPointAt(i)).isEnabled());
                this.repaint();
            }
        } else if (e.getSource() == this.showInSourceItem) {
            CodeProfilingPoint selectedProfilingPoint = (CodeProfilingPoint)this.getProfilingPointAt(this.profilingPointsTable.getSelectedRow());
            Utils.openLocation(selectedProfilingPoint.getLocation());
        } else if (e.getSource() == this.showStartInSourceItem) {
            CodeProfilingPoint.Paired selectedProfilingPoint = (CodeProfilingPoint.Paired)this.getProfilingPointAt(this.profilingPointsTable.getSelectedRow());
            CodeProfilingPoint.Location location = selectedProfilingPoint.getStartLocation();
            if (location == null) {
                ProfilerDialogs.displayWarning((String)Bundle.ProfilingPointsWindowUI_NoStartDefinedMsg());
            } else {
                Utils.openLocation(location);
            }
        } else if (e.getSource() == this.showEndInSourceItem) {
            CodeProfilingPoint.Paired selectedProfilingPoint = (CodeProfilingPoint.Paired)this.getProfilingPointAt(this.profilingPointsTable.getSelectedRow());
            CodeProfilingPoint.Location location = selectedProfilingPoint.getEndLocation();
            if (location == null) {
                ProfilerDialogs.displayWarning((String)Bundle.ProfilingPointsWindowUI_NoEndDefinedMsg());
            } else {
                Utils.openLocation(location);
            }
        } else if (e.getSource() == this.showReportItem) {
            int[] selectedRows = this.profilingPointsTable.getSelectedRows();
            if (selectedRows.length == 0) {
                return;
            }
            for (int selectedRow : selectedRows) {
                ProfilingPoint selectedProfilingPoint = this.getProfilingPointAt(selectedRow);
                selectedProfilingPoint.showResults(null);
            }
        } else if (e.getSource() == this.enableItem) {
            int selectedRow = this.profilingPointsTable.getSelectedRow();
            if (selectedRow == -1) {
                return;
            }
            ProfilingPoint selectedProfilingPoint = this.getProfilingPointAt(selectedRow);
            selectedProfilingPoint.setEnabled(true);
        } else if (e.getSource() == this.disableItem) {
            int selectedRow = this.profilingPointsTable.getSelectedRow();
            if (selectedRow == -1) {
                return;
            }
            ProfilingPoint selectedProfilingPoint = this.getProfilingPointAt(selectedRow);
            selectedProfilingPoint.setEnabled(false);
        } else if (e.getSource() == this.enableDisableItem) {
            int[] selectedRows = this.profilingPointsTable.getSelectedRows();
            if (selectedRows.length == 0) {
                return;
            }
            for (int selectedRow : selectedRows) {
                ProfilingPoint selectedProfilingPoint;
                selectedProfilingPoint.setEnabled(!(selectedProfilingPoint = this.getProfilingPointAt(selectedRow)).isEnabled());
            }
        } else if (e.getSource() == this.editItem) {
            int selectedRow = this.profilingPointsTable.getSelectedRow();
            if (selectedRow == -1) {
                return;
            }
            ProfilingPoint selectedProfilingPoint = this.getProfilingPointAt(selectedRow);
            selectedProfilingPoint.customize(false, false);
        } else if (e.getSource() == this.removeItem) {
            this.deletePPs();
        }
    }

    @Override
    public void keyPressed(KeyEvent e) {
        if (e.getKeyCode() == 525 || e.getKeyCode() == 121 && e.getModifiers() == 1) {
            int[] selectedRows = this.profilingPointsTable.getSelectedRows();
            if (selectedRows.length != 0) {
                Rectangle rowBounds = this.profilingPointsTable.getCellRect(selectedRows[0], 1, true);
                this.showProfilingPointsPopup(e.getComponent(), rowBounds.x + 20, rowBounds.y + this.profilingPointsTable.getRowHeight() / 2);
            }
        } else if (e.getKeyCode() == 127) {
            this.deletePPs();
        }
    }

    @Override
    public void keyReleased(KeyEvent e) {
    }

    @Override
    public void keyTyped(KeyEvent e) {
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        if (e.getModifiers() == 16) {
            ProfilingPoint profilingPoint;
            int clickedRow = this.profilingPointsTable.rowAtPoint(e.getPoint());
            if (clickedRow != -1 && e.getClickCount() == 2 && (profilingPoint = this.getProfilingPointAt(clickedRow)) instanceof CodeProfilingPoint) {
                Utils.openLocation(((CodeProfilingPoint)profilingPoint).getLocation());
            }
        } else if (e.getModifiers() == 4) {
            int clickedRow = this.profilingPointsTable.rowAtPoint(e.getPoint());
            int selectedRowCount = this.profilingPointsTable.getSelectedRowCount();
            if (clickedRow != -1 && selectedRowCount != 0) {
                if (selectedRowCount == 1) {
                    this.profilingPointsTable.setRowSelectionInterval(clickedRow, clickedRow);
                }
                this.showProfilingPointsPopup(e.getComponent(), e.getX(), e.getY());
                return;
            }
        }
        this.dispatchResultsRendererEvent(e);
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        this.dispatchResultsRendererEvent(e);
    }

    @Override
    public void mouseEntered(MouseEvent e) {
        this.dispatchResultsRendererEvent(e);
    }

    @Override
    public void mouseExited(MouseEvent e) {
        this.dispatchResultsRendererEvent(e);
    }

    @Override
    public void mouseMoved(MouseEvent e) {
        this.dispatchResultsRendererEvent(e);
    }

    @Override
    public void mousePressed(MouseEvent e) {
        int clickedRow;
        if (e.getModifiers() == 4 && (clickedRow = this.profilingPointsTable.rowAtPoint(e.getPoint())) != -1) {
            int[] selectedRows = this.profilingPointsTable.getSelectedRows();
            if (selectedRows.length == 0) {
                this.profilingPointsTable.setRowSelectionInterval(clickedRow, clickedRow);
            } else {
                boolean changeSelection = true;
                for (int selectedRow : selectedRows) {
                    if (selectedRow != clickedRow) continue;
                    changeSelection = false;
                }
                if (changeSelection) {
                    this.profilingPointsTable.setRowSelectionInterval(clickedRow, clickedRow);
                }
            }
        }
        this.dispatchResultsRendererEvent(e);
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        this.dispatchResultsRendererEvent(e);
    }

    public void notifyProfilingStateChanged() {
        this.profilingInProgress = ProfilingPointsManager.getDefault().isProfilingSessionInProgress();
        this.updateButtons();
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if (evt.getPropertyName() == "p_projects_changed") {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    ProfilingPointsWindowUI.this.updateProjectsCombo();
                }
            });
        } else if (evt.getPropertyName() == "p_profiling_points_changed") {
            this.refreshProfilingPoints();
        }
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        this.updateButtons();
    }

    protected void initColumnsData() {
        this.minProfilingPointColumnWidth = this.getFontMetrics(this.getFont()).charWidth('W') * 30;
        EnhancedTableCellRenderer scopeRenderer = Utils.getScopeRenderer();
        EnhancedTableCellRenderer projectRenderer = Utils.getProjectRenderer();
        EnhancedTableCellRenderer profilingPointRenderer = Utils.getPresenterRenderer();
        this.columnNames = new String[]{Bundle.ProfilingPointsWindowUI_ScopeColumnName(), Bundle.ProfilingPointsWindowUI_ProjectColumnName(), Bundle.ProfilingPointsWindowUI_PpColumnName(), Bundle.ProfilingPointsWindowUI_ResultsColumnName()};
        this.columnToolTips = new String[]{Bundle.ProfilingPointsWindowUI_ScopeColumnToolTip(), Bundle.ProfilingPointsWindowUI_ProjectColumnToolTip(), Bundle.ProfilingPointsWindowUI_PpColumnToolTip(), Bundle.ProfilingPointsWindowUI_ResultsColumnToolTip()};
        this.columnTypes = new Class[]{Integer.class, Lookup.Provider.class, ProfilingPoint.class, ProfilingPoint.ResultsRenderer.class};
        this.columnRenderers = new TableCellRenderer[]{scopeRenderer, projectRenderer, profilingPointRenderer, null};
        this.columnWidths = new int[]{50, 165, -1, 200};
    }

    private void setColumnsData() {
        TableColumnModel colModel = this.profilingPointsTable.getColumnModel();
        colModel.getColumn(2).setPreferredWidth(this.minProfilingPointColumnWidth);
        for (int i = 0; i < colModel.getColumnCount(); ++i) {
            int index = this.profilingPointsTableModel.getRealColumn(i);
            colModel.getColumn(i).setPreferredWidth(index == 2 ? this.minProfilingPointColumnWidth : this.columnWidths[index]);
            colModel.getColumn(i).setCellRenderer(this.columnRenderers[index]);
        }
    }

    private ProfilingPoint getProfilingPointAt(int row) {
        return (ProfilingPoint)this.profilingPointsTable.getValueAt(row, 0);
    }

    private int getSortBy(int column) {
        switch (column) {
            case 0: {
                return 2;
            }
            case 1: {
                return 1;
            }
            case 2: {
                return 3;
            }
            case 3: {
                return 4;
            }
        }
        return -1;
    }

    private void createProfilingPointsTable() {
        this.profilingPointsTableModel = new ExtendedTableModel(new SortableTableModel(){

            public String getColumnName(int col) {
                return ProfilingPointsWindowUI.this.columnNames[col];
            }

            public int getRowCount() {
                return ProfilingPointsWindowUI.this.profilingPoints.length;
            }

            public int getColumnCount() {
                return ProfilingPointsWindowUI.this.columnNames.length;
            }

            public Class getColumnClass(int col) {
                return ProfilingPointsWindowUI.this.columnTypes[col];
            }

            public Object getValueAt(int row, int col) {
                return ProfilingPointsWindowUI.this.profilingPoints[row];
            }

            public String getColumnToolTipText(int col) {
                return ProfilingPointsWindowUI.this.columnToolTips[col];
            }

            public void sortByColumn(int column, boolean order) {
                ProfilingPointsWindowUI.this.sortBy = ProfilingPointsWindowUI.this.getSortBy(column);
                ProfilingPointsWindowUI.this.sortOrder = order;
                ProfilingPointsWindowUI.this.refreshProfilingPoints();
            }

            public boolean getInitialSorting(int column) {
                return true;
            }
        });
        this.profilingPointsTable = new JExtendedTable((TableModel)this.profilingPointsTableModel){

            public TableCellRenderer getCellRenderer(int row, int column) {
                if (this.getColumnClass(column) == ProfilingPoint.ResultsRenderer.class) {
                    return ProfilingPointsWindowUI.this.getProfilingPointAt(row).getResultsRenderer();
                }
                return super.getCellRenderer(row, column);
            }

            public void doLayout() {
                int columnsWidthsSum = 0;
                int realFirstColumn = -1;
                for (int i = 0; i < ProfilingPointsWindowUI.this.profilingPointsTableModel.getColumnCount(); ++i) {
                    int index = ProfilingPointsWindowUI.this.profilingPointsTableModel.getRealColumn(i);
                    if (index == 2) {
                        realFirstColumn = i;
                        continue;
                    }
                    columnsWidthsSum += this.getColumnModel().getColumn(i).getPreferredWidth();
                }
                if (realFirstColumn != -1) {
                    this.getColumnModel().getColumn(realFirstColumn).setPreferredWidth(Math.max(this.getWidth() - columnsWidthsSum, ProfilingPointsWindowUI.this.minProfilingPointColumnWidth));
                }
                super.doLayout();
            }
        };
        this.profilingPointsTableModel.setTable((JTable)this.profilingPointsTable);
        this.profilingPointsTableModel.setInitialSorting(this.initialSortingColumn, this.sortOrder);
        this.profilingPointsTable.setRowSelectionAllowed(true);
        this.profilingPointsTable.setSelectionMode(2);
        this.profilingPointsTable.setGridColor(UIConstants.TABLE_VERTICAL_GRID_COLOR);
        this.profilingPointsTable.setSelectionBackground(UIConstants.TABLE_SELECTION_BACKGROUND_COLOR);
        this.profilingPointsTable.setSelectionForeground(UIConstants.TABLE_SELECTION_FOREGROUND_COLOR);
        this.profilingPointsTable.setShowHorizontalLines(false);
        this.profilingPointsTable.setShowVerticalLines(true);
        this.profilingPointsTable.setRowMargin(0);
        this.profilingPointsTable.setRowHeight(UIUtils.getDefaultRowHeight() + 2);
        this.profilingPointsTable.getSelectionModel().addListSelectionListener(this);
        this.profilingPointsTable.addMouseListener((MouseListener)this);
        this.profilingPointsTable.addMouseMotionListener((MouseMotionListener)this);
        this.profilingPointsTable.addKeyListener((KeyListener)this);
        this.setColumnsData();
    }

    private void deletePPs() {
        int[] selectedRows = this.profilingPointsTable.getSelectedRows();
        if (selectedRows.length == 0) {
            return;
        }
        ArrayList<ProfilingPoint> pointsToRemove = new ArrayList<ProfilingPoint>();
        for (int selectedRow : selectedRows) {
            ProfilingPoint selectedProfilingPoint = this.getProfilingPointAt(selectedRow);
            pointsToRemove.add(selectedProfilingPoint);
        }
        for (ProfilingPoint pointToRemove : pointsToRemove) {
            ProfilingPointsManager.getDefault().removeProfilingPoint(pointToRemove);
        }
    }

    private void dispatchResultsRendererEvent(MouseEvent e) {
        int column = this.profilingPointsTable.columnAtPoint(e.getPoint());
        if (column != 3) {
            this.profilingPointsTable.setCursor(Cursor.getDefaultCursor());
            return;
        }
        int row = this.profilingPointsTable.rowAtPoint(e.getPoint());
        if (row == -1) {
            return;
        }
        ProfilingPoint profilingPoint = this.getProfilingPointAt(row);
        ProfilingPoint.ResultsRenderer resultsRenderer = profilingPoint.getResultsRenderer();
        Rectangle cellRect = this.profilingPointsTable.getCellRect(row, column, true);
        MouseEvent mouseEvent = new MouseEvent((Component)this.profilingPointsTable, e.getID(), e.getWhen(), e.getModifiers(), e.getX() - cellRect.x, e.getY() - cellRect.y, e.getClickCount(), e.isPopupTrigger(), e.getButton());
        resultsRenderer.dispatchMouseEvent(mouseEvent);
    }

    private void initComponents() {
        this.setLayout(new BorderLayout());
        ProfilerToolbar toolbar = ProfilerToolbar.create((boolean)true);
        this.projectLabel = new JLabel();
        Mnemonics.setLocalizedText((JLabel)this.projectLabel, (String)Bundle.ProfilingPointsWindowUI_ProjectLabelText());
        this.projectLabel.setBorder(BorderFactory.createEmptyBorder(0, 5, 0, 5));
        this.projectsCombo = new JComboBox(new Object[]{Bundle.ProfilingPointsWindowUI_AllProjectsString()}){

            @Override
            public Dimension getMaximumSize() {
                return this.getPreferredSize();
            }

            @Override
            public Dimension getPreferredSize() {
                return new Dimension(200, super.getPreferredSize().height);
            }

            @Override
            public Dimension getMinimumSize() {
                return this.getPreferredSize();
            }
        };
        this.projectLabel.setLabelFor(this.projectsCombo);
        this.projectsCombo.addActionListener(this);
        this.projectsCombo.setRenderer(Utils.getProjectListRenderer());
        toolbar.add((Component)this.projectLabel);
        toolbar.add((Component)this.projectsCombo);
        if (ProfilingPointsUIHelper.get().displaySubprojectsOption()) {
            this.dependenciesCheckbox = new JCheckBox();
            this.dependenciesCheckbox.setOpaque(false);
            UIUtils.addBorder((JComponent)this.dependenciesCheckbox, (Border)BorderFactory.createEmptyBorder(0, 4, 0, 3));
            Mnemonics.setLocalizedText((AbstractButton)this.dependenciesCheckbox, (String)Bundle.ProfilingPointsWindowUI_InclSubprojCheckboxText());
            this.dependenciesCheckbox.setSelected(ProfilerIDESettings.getInstance().getIncludeProfilingPointsDependencies());
            toolbar.add((Component)this.dependenciesCheckbox);
            this.dependenciesCheckbox.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ProfilerIDESettings.getInstance().setIncludeProfilingPointsDependencies(ProfilingPointsWindowUI.this.dependenciesCheckbox.isSelected());
                    ProfilingPointsWindowUI.this.refreshProfilingPoints();
                }
            });
        }
        toolbar.addSeparator();
        this.addButton = new JButton(PPOINT_ADD_ICON);
        this.addButton.setToolTipText(Bundle.ProfilingPointsWindowUI_AddButtonToolTip());
        this.addButton.addActionListener(this);
        toolbar.add((Component)this.addButton);
        this.removeButton = new JButton(PPOINT_REMOVE_ICON);
        this.removeButton.setToolTipText(Bundle.ProfilingPointsWindowUI_RemoveButtonToolTip());
        this.removeButton.addActionListener(this);
        toolbar.add((Component)this.removeButton);
        toolbar.addSeparator();
        this.editButton = new JButton(PPOINT_EDIT_ICON);
        this.editButton.setToolTipText(Bundle.ProfilingPointsWindowUI_EditButtonToolTip());
        this.editButton.addActionListener(this);
        toolbar.add((Component)this.editButton);
        this.disableButton = new JButton(PPOINT_ENABLE_DISABLE_ICON);
        this.disableButton.setToolTipText(Bundle.ProfilingPointsWindowUI_DisableButtonToolTip());
        this.disableButton.addActionListener(this);
        toolbar.add((Component)this.disableButton);
        this.createProfilingPointsTable();
        JExtendedTablePanel tablePanel = new JExtendedTablePanel(this.profilingPointsTable);
        tablePanel.clearBorders();
        this.showInSourceItem = new JMenuItem(Bundle.ProfilingPointsWindowUI_ShowSourceItemText());
        this.showInSourceItem.setFont(this.showInSourceItem.getFont().deriveFont(1));
        this.showInSourceItem.addActionListener(this);
        this.showStartInSourceItem = new JMenuItem(Bundle.ProfilingPointsWindowUI_ShowStartItemText());
        this.showStartInSourceItem.setFont(this.showInSourceItem.getFont().deriveFont(1));
        this.showStartInSourceItem.addActionListener(this);
        this.showEndInSourceItem = new JMenuItem(Bundle.ProfilingPointsWindowUI_ShowEndItemText());
        this.showEndInSourceItem.addActionListener(this);
        this.showReportItem = new JMenuItem(Bundle.ProfilingPointsWindowUI_ShowReportItemText());
        this.showReportItem.addActionListener(this);
        this.enableItem = new JMenuItem(Bundle.ProfilingPointsWindowUI_EnableItemText());
        this.enableItem.addActionListener(this);
        this.disableItem = new JMenuItem(Bundle.ProfilingPointsWindowUI_DisableItemText());
        this.disableItem.addActionListener(this);
        this.enableDisableItem = new JMenuItem(Bundle.ProfilingPointsWindowUI_EnableDisableItemText());
        this.enableDisableItem.addActionListener(this);
        this.editItem = new JMenuItem(Bundle.ProfilingPointsWindowUI_EditItemText());
        this.editItem.addActionListener(this);
        this.removeItem = new JMenuItem(Bundle.ProfilingPointsWindowUI_RemoveItemText());
        this.removeItem.addActionListener(this);
        this.profilingPointsPopup = new JPopupMenu();
        this.profilingPointsPopup.add(this.showInSourceItem);
        this.profilingPointsPopup.add(this.showStartInSourceItem);
        this.profilingPointsPopup.add(this.showEndInSourceItem);
        this.profilingPointsPopup.add(this.showReportItem);
        this.profilingPointsPopup.addSeparator();
        this.profilingPointsPopup.add(this.editItem);
        this.profilingPointsPopup.add(this.enableItem);
        this.profilingPointsPopup.add(this.disableItem);
        this.profilingPointsPopup.add(this.enableDisableItem);
        this.profilingPointsPopup.addSeparator();
        this.profilingPointsPopup.add(this.removeItem);
        this.add((Component)toolbar.getComponent(), "North");
        this.add((Component)tablePanel, "Center");
    }

    private void refreshProfilingPoints() {
        int[] selectedRows = this.profilingPointsTable.getSelectedRows();
        Object[] selectedProfilingPoints = new ProfilingPoint[selectedRows.length];
        for (int i = 0; i < selectedRows.length; ++i) {
            selectedProfilingPoints[i] = this.getProfilingPointAt(selectedRows[i]);
        }
        List<ProfilingPoint> sortedProfilingPoints = ProfilingPointsManager.getDefault().getSortedProfilingPoints(this.getSelectedProject(), this.sortBy, this.sortOrder);
        this.profilingPoints = sortedProfilingPoints.toArray(new ProfilingPoint[sortedProfilingPoints.size()]);
        this.profilingPointsTableModel.fireTableDataChanged();
        if (selectedProfilingPoints.length > 0) {
            this.profilingPointsTable.selectRowsByInstances(selectedProfilingPoints, 0, true);
        }
        this.repaint();
    }

    private void showProfilingPointsPopup(Component source, int x, int y) {
        int[] selectedRows = this.profilingPointsTable.getSelectedRows();
        if (selectedRows.length == 0) {
            return;
        }
        boolean singleSelection = selectedRows.length == 1;
        ProfilingPoint selectedProfilingPoint = this.getProfilingPointAt(selectedRows[0]);
        this.showInSourceItem.setVisible(!singleSelection || selectedProfilingPoint instanceof CodeProfilingPoint.Single);
        this.showInSourceItem.setEnabled(singleSelection);
        this.showStartInSourceItem.setVisible(singleSelection && selectedProfilingPoint instanceof CodeProfilingPoint.Paired);
        this.showEndInSourceItem.setVisible(singleSelection && selectedProfilingPoint instanceof CodeProfilingPoint.Paired);
        this.showReportItem.setEnabled(true);
        this.enableItem.setVisible(singleSelection && !selectedProfilingPoint.isEnabled());
        this.enableItem.setEnabled(!this.profilingInProgress);
        this.disableItem.setVisible(singleSelection && selectedProfilingPoint.isEnabled());
        this.disableItem.setEnabled(!this.profilingInProgress);
        this.enableDisableItem.setVisible(!singleSelection);
        this.enableDisableItem.setEnabled(!this.profilingInProgress);
        this.editItem.setEnabled(singleSelection && !this.profilingInProgress);
        this.removeItem.setEnabled(!this.profilingInProgress);
        this.profilingPointsPopup.show(source, x, y);
    }

    private void updateButtons() {
        int[] selectedRows = this.profilingPointsTable.getSelectedRows();
        this.addButton.setEnabled(!this.profilingInProgress);
        if (selectedRows.length == 0) {
            this.editButton.setEnabled(false);
            this.removeButton.setEnabled(false);
            this.disableButton.setEnabled(false);
        } else if (selectedRows.length == 1) {
            this.editButton.setEnabled(!this.profilingInProgress);
            this.removeButton.setEnabled(!this.profilingInProgress);
            this.disableButton.setEnabled(!this.profilingInProgress);
        } else {
            this.editButton.setEnabled(false);
            this.removeButton.setEnabled(!this.profilingInProgress);
            this.disableButton.setEnabled(!this.profilingInProgress);
        }
    }

    private void updateProjectsCombo() {
        Lookup.Provider[] projects = ProjectUtilities.getSortedProjects((Lookup.Provider[])ProjectUtilities.getOpenedProjects());
        ArrayList<Object> items = new ArrayList<Object>(projects.length + 1);
        items.addAll(Arrays.asList(projects));
        items.add(0, Bundle.ProfilingPointsWindowUI_AllProjectsString());
        DefaultComboBoxModel comboModel = (DefaultComboBoxModel)this.projectsCombo.getModel();
        Object selectedItem = this.projectsCombo.getSelectedItem();
        this.internalComboChange = true;
        comboModel.removeAllElements();
        for (int i = 0; i < items.size(); ++i) {
            comboModel.addElement(items.get(i));
        }
        if (selectedItem != null && comboModel.getIndexOf(selectedItem) != -1) {
            this.projectsCombo.setSelectedItem(selectedItem);
        } else {
            this.projectsCombo.setSelectedItem(Bundle.ProfilingPointsWindowUI_AllProjectsString());
        }
        this.internalComboChange = false;
        this.refreshProfilingPoints();
    }
}

